/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.channelfw.internal;

import com.ibm.websphere.channelfw.ChainData;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.wsspi.channelfw.ChainEventListener;
import com.ibm.wsspi.channelfw.ChannelFramework;
import com.ibm.wsspi.channelfw.ChannelFrameworkFactory;

public class UtilsChainListener
implements ChainEventListener {
    private static final TraceComponent tc = Tr.register(UtilsChainListener.class, (String)"ChannelFramework", (String)"com.ibm.ws.channelfw.internal.resources.ChannelfwMessages");
    private int numChainsWaiting = 0;
    private final Object lock = new Object(){};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void watchChain(ChainData chain) {
        block6: {
            ChannelFramework cf = ChannelFrameworkFactory.getChannelFramework();
            try {
                Object object = this.lock;
                synchronized (object) {
                    ++this.numChainsWaiting;
                }
                cf.addChainEventListener(this, chain.getName());
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event((Object)this, (TraceComponent)tc, (String)("Watching chain; " + chain.getName()), (Object[])new Object[0]);
                }
            }
            catch (Exception e) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block6;
                Tr.event((Object)this, (TraceComponent)tc, (String)("Unable to watch chain; " + chain.getName() + "; " + e), (Object[])new Object[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitOnChains(long quiesceTimeout) {
        Object object = this.lock;
        synchronized (object) {
            if (0 < this.numChainsWaiting) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event((Object)this, (TraceComponent)tc, (String)("Waiting on " + this.numChainsWaiting + " chain(s) to stop"), (Object[])new Object[0]);
                }
                try {
                    this.lock.wait(quiesceTimeout + 2345L);
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public void chainDestroyed(ChainData chainData) {
    }

    @Override
    public void chainInitialized(ChainData chainData) {
    }

    @Override
    public void chainQuiesced(ChainData chainData) {
    }

    @Override
    public void chainStarted(ChainData chainData) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void chainStopped(ChainData chainData) {
        block7: {
            ChannelFramework cf = ChannelFrameworkFactory.getChannelFramework();
            Object object = this.lock;
            synchronized (object) {
                --this.numChainsWaiting;
                if (0 == this.numChainsWaiting) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event((Object)this, (TraceComponent)tc, (String)"Last chain has stopped", (Object[])new Object[0]);
                    }
                    this.lock.notifyAll();
                }
            }
            try {
                cf.removeChainEventListener(this, chainData.getName());
            }
            catch (Exception e) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block7;
                Tr.event((Object)this, (TraceComponent)tc, (String)("Unable to disconnect listener from chain; " + chainData.getName()), (Object[])new Object[0]);
            }
        }
    }

    @Override
    public void chainUpdated(ChainData chainData) {
    }
}

