/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.channelfw.internal;

import com.ibm.websphere.channelfw.ChainData;
import com.ibm.websphere.channelfw.FlowType;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.channelfw.internal.ChannelFrameworkImpl;
import com.ibm.ws.channelfw.internal.OutboundVirtualConnectionImpl;
import com.ibm.ws.channelfw.internal.RuntimeState;
import com.ibm.ws.channelfw.internal.chains.Chain;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.wsspi.channelfw.Channel;
import com.ibm.wsspi.channelfw.ConnectionLink;
import com.ibm.wsspi.channelfw.OutboundConnectionLink;
import com.ibm.wsspi.channelfw.VirtualConnection;
import com.ibm.wsspi.channelfw.VirtualConnectionFactory;
import com.ibm.wsspi.channelfw.exception.ChainException;
import com.ibm.wsspi.channelfw.exception.ChannelException;
import com.ibm.wsspi.channelfw.exception.InvalidChainNameException;

public class OutboundVirtualConnectionFactoryImpl
implements VirtualConnectionFactory {
    private static final TraceComponent tc = Tr.register(OutboundVirtualConnectionFactoryImpl.class, (String)"ChannelFramework", (String)"com.ibm.ws.channelfw.internal.resources.ChannelfwMessages");
    private ChannelFrameworkImpl cf = null;
    private int refCount = 0;
    private String name = null;
    private Chain outboundChain = null;
    private Channel[] chans = null;

    public OutboundVirtualConnectionFactoryImpl(ChainData chainData, ChannelFrameworkImpl framework) throws ChannelException, ChainException {
        this.name = chainData.getName();
        this.refCount = 1;
        this.cf = framework;
        this.cf.initChainInternal(chainData);
        this.outboundChain = this.cf.getRunningChain(this.getName());
        if (this.getChain() == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Failed to create factory; name=" + this.getName()), (Object[])new Object[0]);
            }
            throw new InvalidChainNameException("Invalid chain when trying to access via the channel framework");
        }
        this.chans = this.getChain().getChannels();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Created factory; " + this), (Object[])new Object[0]);
        }
    }

    @Override
    public VirtualConnection createConnection() throws ChannelException, ChainException {
        OutboundVirtualConnectionImpl vc = new OutboundVirtualConnectionImpl();
        if (this.getChain().getState() != RuntimeState.STARTED) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Starting outbound chain, " + this.getName()), (Object[])new Object[0]);
            }
            this.cf.startChainInternal(this.getChain().getChainData());
            this.outboundChain = this.cf.getRunningChain(this.getName());
            if (this.getRefCount() <= 0) {
                this.refCount = 1;
            }
        }
        ConnectionLink[] links = new ConnectionLink[this.chans.length];
        links[0] = this.chans[0].getConnectionLink(vc);
        for (int i = 1; i < this.chans.length; ++i) {
            try {
                links[i] = this.chans[i].getConnectionLink(vc);
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)(this.getClass().getName() + ".createConnection"), (String)"125", (Object[])new Object[]{this, this.chans[i]});
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Error getting conn link from " + this.chans[i].getName() + ", " + e.getMessage()), (Object[])new Object[0]);
                }
                throw new ChannelException(e.getMessage());
            }
            links[i - 1].setDeviceLink(links[i]);
            links[i].setApplicationCallback(links[i - 1]);
        }
        vc.setConnectionLink((OutboundConnectionLink)links[0]);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Putting name of chain into vc statemap: " + this.getName()), (Object[])new Object[0]);
        }
        vc.getStateMap().put("ChainName", this.getName());
        return vc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementRefCount() {
        ChannelFrameworkImpl channelFrameworkImpl = this.cf;
        synchronized (channelFrameworkImpl) {
            ++this.refCount;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Increased refcount; " + this), (Object[])new Object[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decrementRefCount() {
        ChannelFrameworkImpl channelFrameworkImpl = this.cf;
        synchronized (channelFrameworkImpl) {
            --this.refCount;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Decreased refcount; " + this), (Object[])new Object[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() throws ChainException, ChannelException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("destroy; " + this), (Object[])new Object[0]);
        }
        ChannelFrameworkImpl channelFrameworkImpl = this.cf;
        synchronized (channelFrameworkImpl) {
            if (0 == this.getRefCount()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Virtual connection factory already destroyed", (Object[])new Object[0]);
                }
                throw new ChainException("Virtual connection factory already destroyed");
            }
            this.decrementRefCount();
            if (0 == this.getRefCount()) {
                if (this.getChain().getState() == RuntimeState.STARTED) {
                    this.cf.stopChainInternal(this.getChain(), 0L);
                }
                this.cf.destroyChainInternal(this.getChain());
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"destroy");
        }
    }

    public void destroyInternal() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("destroyInternal; " + this), (Object[])new Object[0]);
        }
        try {
            this.cf.stopChainInternal(this.getChain(), 0L);
            this.cf.destroyChainInternal(this.getChain());
        }
        catch (ChannelException e) {
        }
        catch (ChainException chainException) {
            // empty catch block
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"destroyInternal");
        }
    }

    @Override
    public FlowType getType() {
        return FlowType.OUTBOUND;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public int getRefCount() {
        return this.refCount;
    }

    public Chain getChain() {
        return this.outboundChain;
    }

    public String toString() {
        return "Outbound VCF: chain = " + this.getName() + ", refCount = " + this.getRefCount();
    }
}

