/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.bytebuffer.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.bytebuffer.internal.WsBBConfigException;
import com.ibm.ws.bytebuffer.internal.WsByteBufferImpl;
import com.ibm.ws.bytebuffer.internal.WsByteBufferPoolManagerImpl;
import com.ibm.ws.kernel.zos.NativeMethodManager;
import java.nio.ByteBuffer;
import java.util.Map;

public class ZOSWsByteBufferPoolManagerImpl
extends WsByteBufferPoolManagerImpl {
    private static final TraceComponent tc = Tr.register(ZOSWsByteBufferPoolManagerImpl.class, (String)"WsByteBuffer", (String)"com.ibm.ws.bytebuffer.internal.resources.ByteBufferMessages");

    protected static native ByteBuffer allocateDirectByteBuffer(long var0);

    protected static native void releaseDirectByteBuffer(ByteBuffer var0);

    public ZOSWsByteBufferPoolManagerImpl(Map<String, Object> properties, NativeMethodManager nativeMethodManager) throws WsBBConfigException {
        super(properties);
        nativeMethodManager.registerNatives(ZOSWsByteBufferPoolManagerImpl.class);
    }

    public ZOSWsByteBufferPoolManagerImpl() throws WsBBConfigException {
    }

    public ZOSWsByteBufferPoolManagerImpl(Map<String, Object> properties) throws WsBBConfigException {
        super(properties);
    }

    @Override
    protected WsByteBufferImpl allocateBufferDirect(WsByteBufferImpl buffer, int size, boolean overrideRefCount) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("allocateBufferDirect: " + size), (Object[])new Object[0]);
        }
        buffer.setByteBufferNonSafe(ZOSWsByteBufferPoolManagerImpl.allocateDirectByteBuffer(size));
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"allocateBufferDirect");
        }
        return buffer;
    }

    @Override
    protected void releasing(ByteBuffer buffer) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("releasing: " + buffer), (Object[])new Object[0]);
        }
        if (buffer != null && buffer.isDirect()) {
            ZOSWsByteBufferPoolManagerImpl.releaseDirectByteBuffer(buffer);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"releasing");
        }
    }
}

