/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.bytebuffer.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.bytebuffer.internal.PooledWsByteBufferImpl;
import com.ibm.ws.bytebuffer.internal.WsByteBufferImpl;
import com.ibm.ws.bytebuffer.internal.WsByteBufferPoolManagerImpl;
import com.ibm.wsspi.channelfw.objectpool.ObjectDestroyer;
import com.ibm.wsspi.channelfw.objectpool.ObjectFactory;
import com.ibm.wsspi.channelfw.objectpool.TwoTierObjectPool;

public class WsByteBufferPool {
    private int intEntrySize;
    private int globalPoolSize;
    private int localThreadPoolSize;
    private TwoTierObjectPool pool = null;
    private WsByteBufferFactory wsbbFactory = null;
    int intUniqueCounter = 0;
    private static final TraceComponent tc = Tr.register(WsByteBufferPool.class, (String)"WsByteBuffer", (String)"com.ibm.ws.bytebuffer.internal.resources.ByteBufferMessages");

    public WsByteBufferPool(int entrySizeIn, int _localPoolSize, int _globalPoolSize, boolean tracking, boolean isDirectPool, boolean cleanUpOld) {
        this.intEntrySize = entrySizeIn;
        this.globalPoolSize = _globalPoolSize;
        this.localThreadPoolSize = _localPoolSize;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("Creating : " + this.toString() + " direct=" + isDirectPool + " backing pool size: " + this.globalPoolSize + " local thread pool size: " + this.localThreadPoolSize), (Object[])new Object[0]);
        }
        this.wsbbFactory = new WsByteBufferFactory();
        this.pool = isDirectPool ? new TwoTierObjectPool(this.localThreadPoolSize, this.globalPoolSize, this.wsbbFactory, this.wsbbFactory, tracking) : new TwoTierObjectPool(this.localThreadPoolSize, this.globalPoolSize, this.wsbbFactory, null, tracking);
        if (!cleanUpOld) {
            this.pool.doNotCleanUpOld();
        }
    }

    public PooledWsByteBufferImpl getEntry() {
        return (PooledWsByteBufferImpl)this.pool.get();
    }

    public void release(Object buffer, Object entryID) {
        this.pool.put(buffer);
    }

    public Object[] getInUse() {
        return this.pool.getInUseTable();
    }

    public void removeFromInUse(Object buffer) {
        this.pool.removeFromInUse(buffer);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(64);
        sb.append('[');
        sb.append(this.getClass().getSimpleName());
        sb.append('@');
        sb.append(Integer.toHexString(this.hashCode()));
        sb.append('/').append(this.intEntrySize);
        sb.append(']');
        return sb.toString();
    }

    public void purgeThreadLocal() {
        this.pool.purgeThreadLocal();
    }

    public class WsByteBufferFactory
    implements ObjectFactory,
    ObjectDestroyer {
        private WsByteBufferPoolManagerImpl wsbbPoolManager = null;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object create() {
            int intUniqueId;
            PooledWsByteBufferImpl pooledWSBB = new PooledWsByteBufferImpl();
            WsByteBufferFactory wsByteBufferFactory = this;
            synchronized (wsByteBufferFactory) {
                intUniqueId = WsByteBufferPool.this.intUniqueCounter++;
                if (WsByteBufferPool.this.intUniqueCounter == -1) {
                    ++WsByteBufferPool.this.intUniqueCounter;
                }
            }
            pooledWSBB.setID(intUniqueId);
            return pooledWSBB;
        }

        @Override
        public void destroy(Object obj) {
            if (this.wsbbPoolManager == null) {
                this.wsbbPoolManager = (WsByteBufferPoolManagerImpl)WsByteBufferPoolManagerImpl.getRef();
            }
            if (this.wsbbPoolManager != null) {
                this.wsbbPoolManager.releasing(((WsByteBufferImpl)obj).oByteBuffer);
            }
        }
    }
}

