/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.io.async;

import com.ibm.io.async.AbstractAsyncChannel;
import com.ibm.io.async.AsyncException;
import com.ibm.io.async.AsyncLibrary;
import com.ibm.io.async.AsyncProperties;
import com.ibm.io.async.CompletionKey;
import com.ibm.websphere.channelfw.osgi.CHFWBundle;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.wsspi.bytebuffer.WsByteBuffer;
import com.ibm.wsspi.bytebuffer.WsByteBufferPoolManager;
import com.ibm.wsspi.channelfw.ChannelFrameworkFactory;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.atomic.AtomicInteger;
import org.osgi.service.component.annotations.Reference;

final class ResultHandler {
    private static final TraceComponent tc = Tr.register(ResultHandler.class, (String)"TCPChannel", (String)"com.ibm.ws.tcpchannel.internal.resources.TCPChannelMessages");
    private final AtomicNumHandlersInFlight numHandlersInFlight;
    private long numItemsFromNative = 0L;
    private final int maxHandlers;
    private final AtomicInteger handlersWaiting = new AtomicInteger(0);
    private final long completionPort;
    private String myGroupID = null;
    private int batchSize = 1;
    private volatile CHFWBundle chfwBundle;

    public ResultHandler(String groupID, long port) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"ResultHandler", (Object[])new Object[0]);
        }
        this.maxHandlers = AsyncProperties.maxThreadsWaitingForEvents;
        if (AsyncLibrary.getInstance().hasCapability(8)) {
            this.batchSize = AsyncProperties.maximumBatchedEvents;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Batch size set to: " + this.batchSize), (Object[])new Object[0]);
            }
        } else {
            this.batchSize = 1;
        }
        this.completionPort = port;
        this.myGroupID = groupID;
        this.numHandlersInFlight = new AtomicNumHandlersInFlight(this.maxHandlers);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("completionPort=" + port + " group=" + groupID + " maxHandlers=" + this.maxHandlers), (Object[])new Object[0]);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"ResultHandler");
        }
    }

    public void activate() {
        if (this.numHandlersInFlight.getInt() == 0) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Activating result handler: " + this.completionPort), (Object[])new Object[0]);
            }
            this.startHandler();
        }
    }

    @Reference(name="chfwBundle")
    protected void setChfwBundle(CHFWBundle bundle) {
        this.chfwBundle = bundle;
    }

    protected void unsetChfwBundle(CHFWBundle bundle) {
        if (bundle == this.chfwBundle) {
            this.chfwBundle = null;
        }
    }

    protected WsByteBufferPoolManager getBufferManager() {
        if (null == this.chfwBundle) {
            return ChannelFrameworkFactory.getBufferManager();
        }
        return this.chfwBundle.getBufferManager();
    }

    protected String getGroupID() {
        return this.myGroupID;
    }

    private final void startHandler() {
        int updatedInFlightNum = this.numHandlersInFlight.incNumIfNotMax();
        if (updatedInFlightNum > 0) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("starting another handler for completion port: " + this.completionPort), (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)("numHandlersInFlight = " + this.numHandlersInFlight.getInt() + ", handlersWaiting = " + this.handlersWaiting.get()), (Object[])new Object[0]);
            }
            AccessController.doPrivileged(new PrivilegedThreadStarter2());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void runEventProcessingLoop() {
        block54: {
            port = this.completionPort;
            if (TraceComponent.isAnyTracingEnabled() && ResultHandler.tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)ResultHandler.tc, (String)("runEventProcessingLoop: " + port + " " + Thread.currentThread()), (Object[])new Object[0]);
            }
            provider = AsyncLibrary.getInstance();
            size = this.batchSize;
            jitSize = 8192;
            timeout = AsyncProperties.completionTimeout;
            wsByteBufferManager = this.getBufferManager();
            jitCapable = provider.hasCapability(4);
            batchCapable = 1 < size;
            compKeyAddrs = new long[size];
            jitBufferAddressBatch = new long[size];
            wsBBBatch = new WsByteBuffer[size];
            keysReady = 0;
            completionKey = null;
            rc = 0;
            numBytes = 0L;
            compKeys = new CompletionKey[size];
            for (i = 0; i < size; ++i) {
                compKeys[i] = new CompletionKey();
                compKeyAddrs[i] = compKeys[i].getAddress();
            }
            try {
                block8: while (true) {
                    if (AsyncLibrary.aioInitialized == 2) {
                        if (TraceComponent.isAnyTracingEnabled() && ResultHandler.tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)ResultHandler.tc, (String)"AIO library is shutdown, ending loop", (Object[])new Object[0]);
                        }
                        break;
                    }
                    future = null;
                    keysReady = 0;
                    this.handlersWaiting.getAndIncrement();
                    if (jitCapable) {
                        for (i = 0; i < size; ++i) {
                            if (jitBufferAddressBatch[i] != 0L) continue;
                            wsBBBatch[i] = wsByteBufferManager.allocateDirect(8192);
                            bb = wsBBBatch[i].getWrappedByteBufferNonSafe();
                            jitBufferAddressBatch[i] = AbstractAsyncChannel.getBufAddress(bb);
                            compKeys[i].setJITBufferUsed();
                            compKeys[i].setBuffer(jitBufferAddressBatch[i], 8192L, 0);
                        }
                    }
                    try {
                        if (TraceComponent.isAnyTracingEnabled() && ResultHandler.tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)ResultHandler.tc, (String)("waiting for native event port=" + port), (Object[])new Object[0]);
                        }
                        if (batchCapable) {
                            keysReady = provider.getCompletionData3(compKeyAddrs, size, timeout, port);
                            if (TraceComponent.isAnyTracingEnabled() && ResultHandler.tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)ResultHandler.tc, (String)("(batch) events: " + keysReady), (Object[])new Object[0]);
                            }
                        } else {
                            gotData = provider.getCompletionData2(compKeyAddrs[0], timeout, port);
                            if (TraceComponent.isAnyTracingEnabled() && ResultHandler.tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)ResultHandler.tc, (String)("(no batch) events: " + gotData), (Object[])new Object[0]);
                            }
                            keysReady = gotData ? 1 : 0;
                        }
                    }
                    catch (AsyncException exception) {
                        if (TraceComponent.isAnyTracingEnabled() && ResultHandler.tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)ResultHandler.tc, (String)("Error getting IO completion event: " + exception), (Object[])new Object[0]);
                        }
                        FFDCFilter.processException((Throwable)exception, (String)(this.getClass().getName() + ".runEventProcessingLoop"), (String)"331", (Object)this);
                    }
                    finally {
                        this.handlersWaiting.getAndDecrement();
                    }
                    if (keysReady == 0) {
                        if (AsyncLibrary.aioInitialized != 2) {
                            if (!provider.isCompletionPortValid(port)) {
                                if (TraceComponent.isAnyTracingEnabled() && ResultHandler.tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)ResultHandler.tc, (String)"Completion port not valid", (Object[])new Object[0]);
                                }
                                break;
                            }
                        } else {
                            if (TraceComponent.isAnyTracingEnabled() && ResultHandler.tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)ResultHandler.tc, (String)"AIO Shutdown detected, break out", (Object[])new Object[0]);
                            }
                            break;
                        }
                        Thread.sleep(1L);
                        continue;
                    }
                    if (this.handlersWaiting.get() == 0) {
                        this.startHandler();
                    }
                    this.numItemsFromNative += (long)keysReady;
                    j = keysReady - 1;
                    while (true) {
                        if (j >= 0) ** break;
                        continue block8;
                        completionKey = compKeys[j];
                        completionKey.postNativePrep();
                        callid = completionKey.getCallIdentifier();
                        if (TraceComponent.isAnyTracingEnabled() && ResultHandler.tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)ResultHandler.tc, (String)("batch index: " + j + " call id: " + Long.toHexString(callid) + " channel id: " + completionKey.getChannelIdentifier()), (Object[])new Object[0]);
                            Tr.debug((TraceComponent)ResultHandler.tc, (String)("completionKey: " + completionKey), (Object[])new Object[0]);
                        }
                        channelIndex = (int)(callid & -1L);
                        futureIndex = (int)(callid >> 32);
                        theChannel = AbstractAsyncChannel.getChannelFromIndex(channelIndex);
                        if (theChannel == null) {
                            if (TraceComponent.isAnyTracingEnabled() && ResultHandler.tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)ResultHandler.tc, (String)("Could not find channel, possibly closed " + completionKey), (Object[])new Object[0]);
                            }
                        } else {
                            future = theChannel.getFutureFromIndex(futureIndex);
                            if (future == null) {
                                if (TraceComponent.isAnyTracingEnabled() && ResultHandler.tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)ResultHandler.tc, (String)("Completion event could not find future " + completionKey), (Object[])new Object[0]);
                                }
                                exception = new AsyncException("Future not found");
                                FFDCFilter.processException((Throwable)exception, (String)(this.getClass().getName() + ".runEventProcessingLoop"), (String)"142", (Object)this);
                            } else {
                                if (jitCapable && completionKey.wasJITBufferUsed()) {
                                    future.setJITBuffer(wsBBBatch[j]);
                                    jitBufferAddressBatch[j] = 0L;
                                } else {
                                    future.setJITBuffer(null);
                                }
                                rc = completionKey.getReturnCode();
                                numBytes = completionKey.getBytesAffected();
                                if (futureIndex == -3 || futureIndex == -4) {
                                    if (TraceComponent.isAnyTracingEnabled() && ResultHandler.tc.isDebugEnabled()) {
                                        Tr.debug((TraceComponent)ResultHandler.tc, (String)("Processing Sync Request rc: " + rc), (Object[])new Object[0]);
                                    }
                                    if (rc == 0) {
                                        if (numBytes == 0L) {
                                            ioe = new IOException("Async IO operation failed, internal error");
                                            FFDCFilter.processException((Throwable)ioe, (String)(this.getClass().getName() + ".runEventProcessingLoop"), (String)"356");
                                            future.completed(ioe);
                                        } else {
                                            future.setCancelInProgress(0);
                                            future.completed(numBytes);
                                        }
                                    } else if (future.getCancelInProgress() == 1) {
                                        if (TraceComponent.isAnyTracingEnabled() && ResultHandler.tc.isDebugEnabled()) {
                                            Tr.debug((TraceComponent)ResultHandler.tc, (String)"Cancel is in progress, ignoring", (Object[])new Object[0]);
                                        }
                                        future.setCancelInProgress(0);
                                    } else {
                                        future.completed(AsyncLibrary.getIOException("Async IO operation failed (3), reason: ", rc));
                                    }
                                } else if (rc == 0) {
                                    future.setCancelInProgress(0);
                                    future.completed(numBytes);
                                } else if (future.getCancelInProgress() == 1) {
                                    if (TraceComponent.isAnyTracingEnabled() && ResultHandler.tc.isDebugEnabled()) {
                                        Tr.debug((TraceComponent)ResultHandler.tc, (String)"Cancel is in progress, ignoring", (Object[])new Object[0]);
                                    }
                                    future.setCancelInProgress(0);
                                } else {
                                    future.completed(AsyncLibrary.getIOException("Async IO operation failed (2), reason: ", rc));
                                }
                            }
                        }
                        --j;
                    }
                    break;
                }
            }
            catch (Throwable t) {
                if (AsyncLibrary.aioInitialized == 2) break block54;
                FFDCFilter.processException((Throwable)t, (String)(this.getClass().getName() + ".runEventProcessingLoop"), (String)"792", (Object)this);
                throw new RuntimeException(t);
            }
        }
        this.numHandlersInFlight.decrementInt();
        for (k = 0; k < size; ++k) {
            if (jitBufferAddressBatch[k] == 0L) continue;
            wsBBBatch[k].release();
        }
        if (TraceComponent.isAnyTracingEnabled() && ResultHandler.tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)ResultHandler.tc, (String)("runEventProcessingLoop: " + port + " " + Thread.currentThread()));
        }
    }

    protected void dumpStatistics() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("   Number of handlers: " + this.numHandlersInFlight.getInt()), (Object[])new Object[0]);
            Tr.event((TraceComponent)tc, (String)("   Number of IO events received: " + this.numItemsFromNative), (Object[])new Object[0]);
        }
    }

    Runnable getProcessCompletionEventTask() {
        return new Runnable(){

            @Override
            public void run() {
                ResultHandler.this.runEventProcessingLoop();
            }
        };
    }

    static final class AtomicNumHandlersInFlight {
        private final AtomicInteger myNumHandlersInFlight = new AtomicInteger(0);
        private final int myMaxHandlers;

        AtomicNumHandlersInFlight(int max) {
            this.myMaxHandlers = max;
        }

        int getInt() {
            return this.myNumHandlersInFlight.get();
        }

        int incNumIfNotMax() {
            int ret = 0;
            boolean succ = false;
            do {
                int val;
                if ((val = this.myNumHandlersInFlight.get()) < this.myMaxHandlers) {
                    int newval = val + 1;
                    succ = this.myNumHandlersInFlight.weakCompareAndSet(val, newval);
                    if (!succ) continue;
                    ret = newval;
                    continue;
                }
                succ = true;
            } while (!succ);
            return ret;
        }

        void decrementInt() {
            int newval;
            int val;
            boolean succ = false;
            while (!(succ = this.myNumHandlersInFlight.weakCompareAndSet(val = this.myNumHandlersInFlight.get(), newval = val - 1))) {
            }
        }
    }

    class PrivilegedThreadStarter2
    implements PrivilegedAction<Object> {
        @Override
        public Object run() {
            String threadName = "Completion Processing Thread for group: " + ResultHandler.this.getGroupID();
            Thread newThread = new Thread(ResultHandler.this.getProcessCompletionEventTask());
            newThread.setName(threadName);
            newThread.setDaemon(true);
            newThread.start();
            return null;
        }
    }
}

