/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.channel.ssl.internal;

import com.ibm.websphere.event.Event;
import com.ibm.websphere.event.EventEngine;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.channel.ssl.internal.SSLBaseServiceContext;
import com.ibm.ws.channel.ssl.internal.SSLChannelProvider;
import com.ibm.ws.channel.ssl.internal.SSLConnectionLink;
import com.ibm.ws.channel.ssl.internal.SSLEventHandler;
import com.ibm.ws.channel.ssl.internal.SSLHandshakeCompletedCallback;
import com.ibm.ws.channel.ssl.internal.SSLUtils;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.wsspi.bytebuffer.WsByteBuffer;
import com.ibm.wsspi.bytebuffer.WsByteBufferUtils;
import com.ibm.wsspi.channelfw.VirtualConnection;
import com.ibm.wsspi.tcpchannel.TCPWriteCompletedCallback;
import com.ibm.wsspi.tcpchannel.TCPWriteRequestContext;
import java.io.IOException;
import java.nio.ReadOnlyBufferException;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;

public class SSLWriteServiceContext
extends SSLBaseServiceContext
implements TCPWriteRequestContext,
TCPWriteCompletedCallback {
    protected static final TraceComponent tc = Tr.register(SSLWriteServiceContext.class, (String)"SSLChannel", (String)"com.ibm.ws.channel.ssl.internal.resources.SSLChannelMessages");
    protected TCPWriteCompletedCallback callback = null;
    private WsByteBuffer encryptedAppBuffer = null;
    private QueuedWork queuedWork = new QueuedWork();
    private MyHandshakeCompletedCallback handshakeCallback = new MyHandshakeCompletedCallback(this);
    private long asyncBytesToWrite = 0L;
    private int asyncTimeout = 0;

    public SSLWriteServiceContext(SSLConnectionLink connLink) {
        super(connLink);
    }

    public long write(long _numBytes, int timeout) throws IOException {
        int produced;
        int packetSize;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("write, numBytes=" + _numBytes + ", timeout=" + timeout + ", vc=" + this.getVCHash()), (Object[])new Object[0]);
        }
        TCPWriteRequestContext tcp = this.getConnLink().getDeviceWriteInterface();
        long numBytesLeft = _numBytes;
        if (timeout == -2 || timeout == -3) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Requested to timeout former request.  Calling device side.", (Object[])new Object[0]);
            }
            tcp.write(numBytesLeft, timeout);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"write");
            }
            return 0L;
        }
        IOException exception = this.checkForErrors(numBytesLeft, false);
        if (exception != null) {
            throw exception;
        }
        SSLEngineResult result = null;
        long maxBytes = WsByteBufferUtils.lengthOf((WsByteBuffer[])this.getBuffers());
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("App provided " + maxBytes + " bytes"), (Object[])new Object[0]);
        }
        if (numBytesLeft == -1L) {
            numBytesLeft = maxBytes;
        }
        if (SSLUtils.isHandshaking(this.getConnLink().getSSLEngine())) {
            try {
                result = this.doHandshake(null);
            }
            catch (IOException e) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Exception caught during handshake, " + e), (Object[])new Object[0]);
                }
                FFDCFilter.processException((Throwable)e, (String)this.getClass().getName(), (String)"84", (Object)this);
                throw e;
            }
            if (result.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.FINISHED) {
                e = new IOException("Unable to complete SSLhandshake");
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Unable to complete SSLhandshake, " + e), (Object[])new Object[0]);
                }
                FFDCFilter.processException((Throwable)e, (String)this.getClass().getName(), (String)"117", (Object)this);
                throw e;
            }
        }
        if (numBytesLeft > (long)(packetSize = this.getConnLink().getPacketBufferSize())) {
            this.getEncryptedAppBuffer(packetSize * 2);
        } else {
            this.getEncryptedAppBuffer(1);
        }
        int cap = this.encryptedAppBuffer.capacity();
        do {
            this.encryptedAppBuffer.clear();
            result = this.encryptMessage();
            numBytesLeft -= (long)result.bytesConsumed();
            produced = result.bytesProduced();
            if (0 >= produced) continue;
            while (0L < numBytesLeft && cap - produced >= packetSize) {
                result = this.encryptMessage();
                numBytesLeft -= (long)result.bytesConsumed();
                produced += result.bytesProduced();
            }
            this.encryptedAppBuffer.flip();
            tcp.setBuffer(this.encryptedAppBuffer);
            long wrote = tcp.write(-1L, timeout);
            if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) continue;
            Tr.event((TraceComponent)tc, (String)("wrote " + wrote), (Object[])new Object[0]);
        } while (0L < numBytesLeft && 0 < produced);
        long rc = maxBytes - numBytesLeft;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("write: " + rc));
        }
        return rc;
    }

    public VirtualConnection write(long numBytes, TCPWriteCompletedCallback userCallback, boolean forceQueue, int timeout) {
        return this.write(numBytes, userCallback, forceQueue, timeout, false);
    }

    protected VirtualConnection write(long _numBytes, TCPWriteCompletedCallback userCallback, boolean forceQueue, int timeout, boolean fromQueue) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("writeAsync, numBytes=" + _numBytes + ", timeout=" + timeout + ", fromQueue=" + fromQueue + ", vc=" + this.getVCHash()), (Object[])new Object[0]);
        }
        long numBytes = _numBytes;
        if (timeout == -2 || timeout == -3) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Requested to timeout former request.  Calling device side.", (Object[])new Object[0]);
            }
            this.getConnLink().getDeviceWriteInterface().write(numBytes, (TCPWriteCompletedCallback)this, forceQueue, timeout);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("writeAsync: " + this.getVC()));
            }
            return this.getVC();
        }
        IOException exceptionInRequest = this.checkForErrors(numBytes, true);
        if (exceptionInRequest != null) {
            boolean fireHere = true;
            if (forceQueue) {
                this.queuedWork.setErrorParameters(this.getConnLink().getVirtualConnection(), this, userCallback, exceptionInRequest);
                EventEngine events = SSLChannelProvider.getEventService();
                if (null == events) {
                    Exception e = new Exception("missing event admin");
                    FFDCFilter.processException((Throwable)e, (String)this.getClass().getName(), (String)"172", (Object)this);
                } else {
                    Event event = events.createEvent(SSLEventHandler.TOPIC_QUEUED_WORK);
                    event.setProperty("SSLWork", (Object)this.queuedWork);
                    events.postEvent(event);
                    fireHere = false;
                }
            }
            if (fireHere) {
                userCallback.error(this.getConnLink().getVirtualConnection(), (TCPWriteRequestContext)this, exceptionInRequest);
            }
            return null;
        }
        if (forceQueue) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Forcing write request to another thread, vc=" + this.getVCHash()), (Object[])new Object[0]);
            }
            this.queuedWork.setWriteParameters(numBytes, userCallback, timeout);
            EventEngine events = SSLChannelProvider.getEventService();
            if (null == events) {
                IOException e = new IOException("missing event admin");
                FFDCFilter.processException((Throwable)e, (String)this.getClass().getName(), (String)"471", (Object)this);
                userCallback.error(this.getConnLink().getVirtualConnection(), (TCPWriteRequestContext)this, e);
            } else {
                Event event = events.createEvent(SSLEventHandler.TOPIC_QUEUED_WORK);
                event.setProperty("SSLWork", (Object)this.queuedWork);
                events.postEvent(event);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"writeAsync: null");
            }
            return null;
        }
        this.callback = userCallback;
        if (numBytes == -1L) {
            numBytes = WsByteBufferUtils.lengthOf((WsByteBuffer[])this.getBuffers());
        }
        VirtualConnection vc = null;
        SSLEngineResult sslResult = null;
        if (SSLUtils.isHandshaking(this.getConnLink().getSSLEngine())) {
            this.handshakeCallback.setWriteParameters(numBytes, timeout);
            try {
                sslResult = this.doHandshake(this.handshakeCallback);
            }
            catch (IOException e) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Caught exception during SSL handshake, " + e), (Object[])new Object[0]);
                }
                FFDCFilter.processException((Throwable)e, (String)this.getClass().getName(), (String)"152", (Object)this);
                this.callback.error(this.getConnLink().getVirtualConnection(), (TCPWriteRequestContext)this, e);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"writeAsynch: null");
                }
                return null;
            }
            if (sslResult != null) {
                if (sslResult.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.FINISHED) {
                    e = new IOException("Unable to complete SSLhandshake");
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Unable to complete SSLhandshake, " + e), (Object[])new Object[0]);
                    }
                    FFDCFilter.processException((Throwable)e, (String)this.getClass().getName(), (String)"157", (Object)this);
                    this.callback.error(this.getConnLink().getVirtualConnection(), (TCPWriteRequestContext)this, e);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"writeAsynch: null");
                    }
                    return null;
                }
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"writeAsynch: null");
                }
                return null;
            }
        }
        if ((vc = this.encryptAndWriteAsync(numBytes, false, timeout)) != null && fromQueue) {
            this.callback.complete(vc, (TCPWriteRequestContext)this);
            vc = null;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("writeAsynch: " + vc));
        }
        return vc;
    }

    private IOException checkForErrors(long numBytes, boolean async) {
        WsByteBuffer[] callerBuffers;
        IOException exception = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("checkForErrors: numBytes=" + numBytes + " buffers=" + SSLUtils.getBufferTraceInfo(this.getBuffers())), (Object[])new Object[0]);
        }
        if ((callerBuffers = this.getBuffers()) == null || callerBuffers.length == 0) {
            exception = new IOException("No buffer(s) provided for writing data.");
        } else if (numBytes < -1L || numBytes == 0L && async) {
            exception = new IOException("Number of bytes requested, " + numBytes + " is not valid.");
        } else {
            int bytesAvail = WsByteBufferUtils.lengthOf((WsByteBuffer[])callerBuffers);
            if ((long)bytesAvail < numBytes) {
                exception = new IOException("Number of bytes requested, " + numBytes + " exceeds space remaining in the buffers provided: " + bytesAvail);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled() && exception != null) {
            Tr.debug((TraceComponent)tc, (String)("Found error, exception generated: " + exception), (Object[])new Object[0]);
        }
        return exception;
    }

    public VirtualConnection encryptAndWriteAsync(long numBytes, boolean forceQueue, int timeout) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("encryptAndWriteAsync: " + numBytes), (Object[])new Object[0]);
        }
        this.asyncBytesToWrite = 0L;
        this.asyncTimeout = timeout;
        VirtualConnection vc = null;
        try {
            int produced;
            long numBytesLeft = numBytes;
            int packetSize = this.getConnLink().getPacketBufferSize();
            if (numBytesLeft > (long)packetSize) {
                this.getEncryptedAppBuffer(packetSize * 2);
            } else {
                this.getEncryptedAppBuffer(1);
            }
            int cap = this.encryptedAppBuffer.capacity();
            TCPWriteRequestContext tcp = this.getConnLink().getDeviceWriteInterface();
            do {
                this.encryptedAppBuffer.clear();
                SSLEngineResult result = this.encryptMessage();
                numBytesLeft -= (long)result.bytesConsumed();
                produced = result.bytesProduced();
                if (0 >= produced) continue;
                while (0L < numBytesLeft && cap - produced >= packetSize) {
                    result = this.encryptMessage();
                    numBytesLeft -= (long)result.bytesConsumed();
                    produced += result.bytesProduced();
                }
                this.asyncBytesToWrite = numBytesLeft;
                this.encryptedAppBuffer.flip();
                tcp.setBuffer(this.encryptedAppBuffer);
                vc = tcp.write(-1L, (TCPWriteCompletedCallback)this, forceQueue, timeout);
            } while (null != vc && 0L < numBytesLeft && 0 < produced);
        }
        catch (IOException exception) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Caught exception during encryption, " + exception), (Object[])new Object[0]);
            }
            this.callback.error(this.getConnLink().getVirtualConnection(), (TCPWriteRequestContext)this, exception);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("encryptAndWriteAsync: " + vc));
        }
        return vc;
    }

    private SSLEngineResult doHandshake(MyHandshakeCompletedCallback hsCallback) throws IOException {
        SSLEngineResult sslResult;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"doHandshake", (Object[])new Object[0]);
        }
        SSLEngine sslEngine = this.getConnLink().getSSLEngine();
        WsByteBuffer netBuffer = SSLUtils.allocateByteBuffer(sslEngine.getSession().getPacketBufferSize(), true);
        WsByteBuffer decryptedNetBuffer = SSLUtils.allocateByteBuffer(sslEngine.getSession().getApplicationBufferSize(), false);
        this.getEncryptedAppBuffer(1);
        hsCallback.setNetBuffer(netBuffer);
        hsCallback.setDecryptedNetBuffer(decryptedNetBuffer);
        try {
            sslResult = SSLUtils.handleHandshake(this.getConnLink(), netBuffer, decryptedNetBuffer, this.encryptedAppBuffer, null, hsCallback, false);
        }
        catch (IOException e) {
            netBuffer.release();
            decryptedNetBuffer.release();
            throw e;
        }
        catch (ReadOnlyBufferException robe) {
            netBuffer.release();
            decryptedNetBuffer.release();
            throw new IOException("Caught exception during handshake: " + robe.getMessage(), robe);
        }
        if (sslResult != null) {
            netBuffer.release();
            decryptedNetBuffer.release();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("doHandshake: " + sslResult));
        }
        return sslResult;
    }

    private SSLEngineResult encryptMessage() throws IOException {
        SSLEngineResult result;
        block6: {
            SSLEngineResult.Status status;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"encryptMessage", (Object[])new Object[0]);
            }
            WsByteBuffer[] appBuffers = this.getBuffers();
            while (true) {
                int[] appLimitInfo = SSLUtils.adjustBuffersForJSSE(appBuffers, this.getConnLink().getAppBufferSize());
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)("before wrap: appBuffers: " + SSLUtils.getBufferTraceInfo(appBuffers) + "\r\n\tencAppBuf: " + SSLUtils.getBufferTraceInfo(this.encryptedAppBuffer)), (Object[])new Object[0]);
                }
                result = this.getConnLink().getSSLEngine().wrap(SSLUtils.getWrappedByteBuffers(appBuffers), this.encryptedAppBuffer.getWrappedByteBuffer());
                status = result.getStatus();
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)("after wrap: appBuffers: " + SSLUtils.getBufferTraceInfo(appBuffers) + "\r\n\tencAppBuf: " + SSLUtils.getBufferTraceInfo(this.encryptedAppBuffer) + "\r\n\tstatus=" + (Object)((Object)status) + " consumed=" + result.bytesConsumed() + " produced=" + result.bytesProduced()), (Object[])new Object[0]);
                }
                if (appLimitInfo != null) {
                    SSLUtils.resetBuffersAfterJSSE(appBuffers, appLimitInfo);
                }
                if (status == SSLEngineResult.Status.OK) break block6;
                if (status != SSLEngineResult.Status.BUFFER_OVERFLOW) break;
                this.increaseEncryptedBuffer();
            }
            throw new IOException("Unable to encrypt data, status=" + (Object)((Object)status));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("encryptMessage: " + (Object)((Object)result.getStatus())));
        }
        return result;
    }

    protected void increaseEncryptedBuffer() throws IOException {
        int packetSize = this.getConnLink().getPacketBufferSize();
        if (null == this.encryptedAppBuffer) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("Allocating encryptedAppBuffer, size=" + packetSize), (Object[])new Object[0]);
            }
            this.encryptedAppBuffer = SSLUtils.allocateByteBuffer(packetSize, this.getConfig().getEncryptBuffersDirect());
        } else {
            int cap = this.encryptedAppBuffer.capacity();
            int newsize = cap + packetSize;
            if (0 > newsize) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)("Unable to increase encrypted buffer beyond " + cap), (Object[])new Object[0]);
                }
                throw new IOException("Unable to increase buffer beyond " + cap);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Increasing encryptedAppBuffer to " + newsize), (Object[])new Object[0]);
            }
            WsByteBuffer temp = SSLUtils.allocateByteBuffer(newsize, this.encryptedAppBuffer.isDirect());
            this.encryptedAppBuffer.flip();
            SSLUtils.copyBuffer(this.encryptedAppBuffer, temp, this.encryptedAppBuffer.remaining());
            this.encryptedAppBuffer.release();
            this.encryptedAppBuffer = temp;
        }
    }

    private void getEncryptedAppBuffer(int requested_size) {
        int size = Math.max(this.getConnLink().getPacketBufferSize(), requested_size);
        if (null != this.encryptedAppBuffer) {
            if (size <= this.encryptedAppBuffer.capacity()) {
                this.encryptedAppBuffer.clear();
                return;
            }
            this.encryptedAppBuffer.release();
            this.encryptedAppBuffer = null;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("Allocating encryptedAppBuffer, size=" + size), (Object[])new Object[0]);
        }
        this.encryptedAppBuffer = SSLUtils.allocateByteBuffer(size, this.getConfig().getEncryptBuffersDirect());
    }

    public void close() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"close", (Object[])new Object[0]);
        }
        if (null != this.encryptedAppBuffer) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("Releasing ssl output buffer during close. " + SSLUtils.getBufferTraceInfo(this.encryptedAppBuffer)), (Object[])new Object[0]);
            }
            this.encryptedAppBuffer.release();
            this.encryptedAppBuffer = null;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"close");
        }
    }

    public void complete(VirtualConnection vc, TCPWriteRequestContext wsc) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("complete, vc=" + this.getVCHash()), (Object[])new Object[0]);
        }
        VirtualConnection rc = vc;
        if (0L < this.asyncBytesToWrite) {
            rc = this.encryptAndWriteAsync(this.asyncBytesToWrite, false, this.asyncTimeout);
        }
        if (null != rc) {
            this.callback.complete(rc, (TCPWriteRequestContext)this);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"complete");
        }
    }

    public void error(VirtualConnection vc, TCPWriteRequestContext wsc, IOException ioe) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("error, vc=" + this.getVCHash()), (Object[])new Object[0]);
        }
        this.asyncBytesToWrite = 0L;
        this.callback.error(vc, (TCPWriteRequestContext)this, ioe);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"error");
        }
    }

    private class QueuedWork
    implements Runnable {
        private long numBytes = 0L;
        private TCPWriteCompletedCallback userCallback = null;
        private int timeout = 0;
        private VirtualConnection vc = null;
        private TCPWriteRequestContext tcpWriteRequestContext = null;
        private IOException exception = null;
        private boolean isWrite = true;

        protected QueuedWork() {
        }

        public void setWriteParameters(long _numBytes, TCPWriteCompletedCallback _userCallback, int _timeout) {
            this.numBytes = _numBytes;
            this.userCallback = _userCallback;
            this.timeout = _timeout;
            this.isWrite = true;
        }

        public void setErrorParameters(VirtualConnection _vc, TCPWriteRequestContext _tcpWriteRequestContext, TCPWriteCompletedCallback _userCallback, IOException _exception) {
            this.vc = _vc;
            this.tcpWriteRequestContext = _tcpWriteRequestContext;
            this.userCallback = _userCallback;
            this.exception = _exception;
            this.isWrite = false;
        }

        @Override
        public void run() {
            if (this.isWrite) {
                SSLWriteServiceContext.this.write(this.numBytes, this.userCallback, false, this.timeout, true);
            } else {
                this.userCallback.error(this.vc, this.tcpWriteRequestContext, this.exception);
            }
        }
    }

    public class MyHandshakeCompletedCallback
    implements SSLHandshakeCompletedCallback {
        private TCPWriteRequestContext writeContext;
        private long numBytes;
        private int timeout;
        private WsByteBuffer netBuffer;
        private WsByteBuffer decryptedNetBuffer;

        public MyHandshakeCompletedCallback(TCPWriteRequestContext _writeContext) {
            this.writeContext = _writeContext;
        }

        public void setWriteParameters(long _numBytes, int _timeout) {
            this.numBytes = _numBytes;
            this.timeout = _timeout;
        }

        public void setNetBuffer(WsByteBuffer buffer) {
            this.netBuffer = buffer;
        }

        public void setDecryptedNetBuffer(WsByteBuffer buffer) {
            this.decryptedNetBuffer = buffer;
        }

        @Override
        public void complete(SSLEngineResult sslResult) {
            this.netBuffer.release();
            this.netBuffer = null;
            this.decryptedNetBuffer.release();
            this.decryptedNetBuffer = null;
            if (sslResult.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.FINISHED) {
                IOException e = new IOException("Unable to complete SSLhandshake");
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Unable to complete SSLhandshake, " + e), (Object[])new Object[0]);
                }
                FFDCFilter.processException((Throwable)e, (String)this.getClass().getName(), (String)"245", (Object)this);
                SSLWriteServiceContext.this.callback.error(SSLWriteServiceContext.this.getConnLink().getVirtualConnection(), this.writeContext, e);
            } else {
                VirtualConnection vc = SSLWriteServiceContext.this.encryptAndWriteAsync(this.numBytes, false, this.timeout);
                if (vc != null) {
                    SSLWriteServiceContext.this.callback.complete(vc, this.writeContext);
                }
            }
        }

        @Override
        public void error(IOException ioe) {
            FFDCFilter.processException((Throwable)ioe, (String)this.getClass().getName(), (String)"117", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Caught exception during encryption, " + ioe), (Object[])new Object[0]);
            }
            this.netBuffer.release();
            this.netBuffer = null;
            this.decryptedNetBuffer.release();
            this.decryptedNetBuffer = null;
            SSLWriteServiceContext.this.callback.error(SSLWriteServiceContext.this.getConnLink().getVirtualConnection(), this.writeContext, ioe);
        }
    }
}

