/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.channel.ssl.internal;

import com.ibm.websphere.channelfw.ChannelData;
import com.ibm.websphere.channelfw.FlowType;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.wsspi.channelfw.exception.ChannelException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class SSLChannelData {
    protected static final TraceComponent tc = Tr.register(SSLChannelData.class, (String)"SSLChannel", (String)"com.ibm.ws.channel.ssl.internal.resources.SSLChannelMessages");
    private static final String ENCRYPT_BUFFERS_DIRECT = "encryptBuffersDirect";
    private static final String DECRYPT_BUFFERS_DIRECT = "decryptBuffersDirect";
    private static final String SSLSESSION_CACHE_SIZE = "SSLSessionCacheSize";
    private static final String SSLSESSION_TIMEOUT = "SSLSessionTimeout";
    private static final String SSLSESSION_TIMEOUT_8500 = "sessionTimeout";
    private static final String DEFAULT_ENCRYPT_BUFFERS_DIRECT = "true";
    private static final String DEFAULT_DECRYPT_BUFFERS_DIRECT = "false";
    private static final int DEFAULT_SSLSESSION_CACHE_SIZE = 100;
    private static final int DEFAULT_SSLSESSION_TIMEOUT = 86400;
    static final String ALIAS_KEY = "alias";
    private String name = null;
    private final boolean encryptBuffersDirect;
    private final boolean decryptBuffersDirect;
    private final int weight;
    private final boolean isInbound;
    private boolean clientAuthentication;
    private Properties properties;
    private int sslSessionCacheSize = 0;
    private int sslSessionTimeout = 0;

    public String toString() {
        StringBuilder sb = new StringBuilder(256);
        sb.append("SSLChannelData: ").append(this.name);
        sb.append("\n\tencryptBuffersDirect = ").append(this.encryptBuffersDirect);
        sb.append("\n\tdecryptBuffersDirect = ").append(this.decryptBuffersDirect);
        sb.append("\n\tweight = ").append(this.weight);
        sb.append("\n\tisInbound = ").append(this.isInbound);
        sb.append("\n\tclientAuthentication = ").append(this.clientAuthentication);
        sb.append("\n\tsession cache size = ").append(this.sslSessionCacheSize);
        sb.append("\n\tsession timeout = ").append(this.sslSessionTimeout);
        return sb.toString();
    }

    public SSLChannelData(ChannelData inputData) throws ChannelException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"constructor: SSLChannelData", (Object[])new Object[0]);
        }
        this.name = inputData.getName();
        this.weight = inputData.getDiscriminatorWeight();
        this.isInbound = inputData.isInbound();
        this.restuffBag(inputData.getPropertyBag());
        this.properties = new Properties();
        for (Map.Entry entry : inputData.getPropertyBag().entrySet()) {
            this.properties.put(entry.getKey(), entry.getValue());
        }
        StringBuilder errors = new StringBuilder();
        this.encryptBuffersDirect = this.getBooleanProperty(ENCRYPT_BUFFERS_DIRECT, DEFAULT_ENCRYPT_BUFFERS_DIRECT, errors);
        this.decryptBuffersDirect = this.getBooleanProperty(DECRYPT_BUFFERS_DIRECT, DEFAULT_DECRYPT_BUFFERS_DIRECT, errors);
        this.sslSessionCacheSize = this.getIntProperty(SSLSESSION_CACHE_SIZE, true, 100, errors);
        this.sslSessionTimeout = this.getIntProperty(SSLSESSION_TIMEOUT, true, 86400, errors);
        if (errors.length() != 0) {
            Tr.error((TraceComponent)tc, (String)"invalid.security.properties", (Object[])new Object[]{errors.toString()});
            throw new ChannelException("Invalid property values found:\n" + errors.toString());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"constructor: SSLChannelData");
        }
    }

    public void restuffBag(Map<Object, Object> m) {
        String key = null;
        Object value = null;
        boolean realTimeoutSet = false;
        HashMap<String, Object> temp = new HashMap<String, Object>();
        for (Map.Entry<Object, Object> entry : m.entrySet()) {
            key = (String)entry.getKey();
            value = entry.getValue();
            if (key.equalsIgnoreCase(ENCRYPT_BUFFERS_DIRECT)) {
                temp.put(ENCRYPT_BUFFERS_DIRECT, value);
                continue;
            }
            if (key.equalsIgnoreCase(DECRYPT_BUFFERS_DIRECT)) {
                temp.put(DECRYPT_BUFFERS_DIRECT, value);
                continue;
            }
            if (key.equalsIgnoreCase(SSLSESSION_CACHE_SIZE)) {
                temp.put(SSLSESSION_CACHE_SIZE, value);
                continue;
            }
            if (key.equalsIgnoreCase(SSLSESSION_TIMEOUT)) {
                temp.put(SSLSESSION_TIMEOUT, value);
                realTimeoutSet = true;
                continue;
            }
            if (!realTimeoutSet && key.equalsIgnoreCase(SSLSESSION_TIMEOUT_8500)) {
                temp.put(SSLSESSION_TIMEOUT, value);
                continue;
            }
            temp.put(key, value);
        }
        m.clear();
        m.putAll(temp);
    }

    public String getName() {
        return this.name;
    }

    public boolean getEncryptBuffersDirect() {
        return this.encryptBuffersDirect;
    }

    public boolean getDecryptBuffersDirect() {
        return this.decryptBuffersDirect;
    }

    public int getWeight() {
        return this.weight;
    }

    public boolean isInbound() {
        return this.isInbound;
    }

    public int getSSLSessionCacheSize() {
        return this.sslSessionCacheSize;
    }

    public int getSSLSessionTimeout() {
        return this.sslSessionTimeout;
    }

    public FlowType getFlowType() {
        return this.isInbound() ? FlowType.INBOUND : FlowType.OUTBOUND;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties newMap) {
        this.properties = newMap;
    }

    public boolean getBooleanProperty(String propertyName) {
        boolean booleanValue = false;
        Object objectValue = this.properties.get(propertyName);
        if (objectValue != null) {
            if (objectValue instanceof Boolean) {
                booleanValue = (Boolean)objectValue;
            } else if (objectValue instanceof String) {
                booleanValue = Boolean.parseBoolean((String)objectValue);
            }
        }
        return booleanValue;
    }

    public String getStringProperty(String propertyName) {
        Object value = this.properties.get(propertyName);
        if (null != value && value instanceof String) {
            return (String)value;
        }
        return null;
    }

    public void updateChannelData(ChannelData inputData) {
    }

    private boolean getBooleanProperty(String key, String defaultValue, StringBuilder errors) {
        boolean booleanValue = false;
        String stringValue = null;
        boolean valueCorrect = false;
        Object objectValue = this.properties.get(key);
        if (objectValue != null) {
            if (objectValue instanceof Boolean) {
                booleanValue = (Boolean)objectValue;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Property " + key + " set to " + booleanValue), (Object[])new Object[0]);
                }
                return booleanValue;
            }
            if (objectValue instanceof String) {
                stringValue = (String)objectValue;
            }
        } else if (defaultValue != null) {
            stringValue = defaultValue;
        } else {
            errors.append(key);
            errors.append(':');
            errors.append(stringValue);
            errors.append('\n');
            return false;
        }
        if (stringValue != null) {
            if (stringValue.equals(DEFAULT_ENCRYPT_BUFFERS_DIRECT)) {
                booleanValue = true;
                valueCorrect = true;
            } else if (stringValue.equals(DEFAULT_DECRYPT_BUFFERS_DIRECT)) {
                booleanValue = false;
                valueCorrect = true;
            }
        }
        if (valueCorrect) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Property " + key + " set to " + booleanValue), (Object[])new Object[0]);
            }
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Property " + key + " has invalid value " + stringValue), (Object[])new Object[0]);
            }
            errors.append(key);
            errors.append(':');
            errors.append(stringValue);
            errors.append('\n');
        }
        return booleanValue;
    }

    private int getIntProperty(String key, boolean defaultProvided, int defaultValue, StringBuilder errors) {
        block7: {
            String value = this.getStringProperty(key);
            if (null != value) {
                try {
                    int realValue = Integer.parseInt(value);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Property " + key + " set to " + realValue), (Object[])new Object[0]);
                    }
                    return realValue;
                }
                catch (NumberFormatException nfe) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block7;
                    Tr.debug((TraceComponent)tc, (String)("Property " + key + ", format error in [" + value + "]"), (Object[])new Object[0]);
                }
            }
        }
        if (!defaultProvided) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Property " + key + " not found.  Error being tallied."), (Object[])new Object[0]);
            }
            errors.append(key);
            errors.append(":null \n");
            return -1;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Property " + key + " using default " + defaultValue), (Object[])new Object[0]);
        }
        return defaultValue;
    }
}

