/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.internal;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.SecurityService;
import com.ibm.ws.security.authentication.AuthenticationService;
import com.ibm.ws.security.authorization.AuthorizationService;
import com.ibm.ws.security.internal.SecurityConfiguration;
import com.ibm.ws.security.registry.UserRegistryService;
import com.ibm.wsspi.kernel.service.utils.ConcurrentServiceReferenceMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.felix.scr.ext.annotation.DSExt;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(configurationPid={"com.ibm.ws.security.service"}, property={"service.vendor=IBM"}, immediate=true)
@DSExt.ConfigurableServiceProperties
public class SecurityServiceImpl
implements SecurityService {
    private static final TraceComponent tc = Tr.register(SecurityServiceImpl.class);
    static final String KEY_CONFIGURATION = "Configuration";
    static final String KEY_AUTHENTICATION = "Authentication";
    static final String KEY_AUTHORIZATION = "Authorization";
    public static final String KEY_USERREGISTRY = "UserRegistry";
    static final String KEY_ID = "id";
    static final String KEY_SERVICE_ID = "service.id";
    static final String KEY_CONFIG_SOURCE = "config.source";
    static final String CFG_KEY_SYSTEM_DOMAIN = "systemDomain";
    static final String CFG_KEY_DEFAULT_APP_DOMAIN = "defaultAppDomain";
    private ComponentContext cc;
    final ConcurrentServiceReferenceMap<String, SecurityConfiguration> configs = new ConcurrentServiceReferenceMap("Configuration");
    final ConcurrentServiceReferenceMap<String, AuthenticationService> authentication = new ConcurrentServiceReferenceMap("Authentication");
    final ConcurrentServiceReferenceMap<String, AuthorizationService> authorization = new ConcurrentServiceReferenceMap("Authorization");
    final ConcurrentServiceReferenceMap<String, UserRegistryService> userRegistry = new ConcurrentServiceReferenceMap("UserRegistry");
    final AtomicReference<AuthenticationService> authnService = new AtomicReference();
    final AtomicReference<AuthorizationService> authzService = new AtomicReference();
    final AtomicReference<UserRegistryService> userRegistryService = new AtomicReference();
    private volatile String cfgSystemDomain = null;
    private volatile String cfgDefaultAppDomain = null;
    private Map<String, Object> props;
    static final long serialVersionUID = -6584674237519263944L;

    @Reference(policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.MULTIPLE)
    protected Map<String, Object> setConfiguration(ServiceReference<SecurityConfiguration> ref) {
        String id = (String)ref.getProperty(KEY_ID);
        if (id != null) {
            this.configs.putReference((Object)id, ref);
        } else {
            Tr.error((TraceComponent)tc, (String)"SECURITY_SERVICE_REQUIRED_SERVICE_WITHOUT_ID", (Object[])new Object[]{"securityConfiguration"});
        }
        return this.getServiceProperties();
    }

    protected Map<String, Object> unsetConfiguration(ServiceReference<SecurityConfiguration> ref) {
        this.configs.removeReference((Object)((String)ref.getProperty(KEY_ID)), ref);
        return this.getServiceProperties();
    }

    private boolean hasPropertiesFromFile(ServiceReference<?> ref) {
        return "file".equals(ref.getProperty(KEY_CONFIG_SOURCE));
    }

    @Reference(policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.MULTIPLE)
    protected Map<String, Object> setAuthentication(ServiceReference<AuthenticationService> ref) {
        if (this.hasPropertiesFromFile(ref)) {
            String id = (String)ref.getProperty(KEY_ID);
            if (id != null) {
                this.authentication.putReference((Object)id, ref);
            } else {
                Tr.error((TraceComponent)tc, (String)"SECURITY_SERVICE_REQUIRED_SERVICE_WITHOUT_ID", (Object[])new Object[]{KEY_AUTHENTICATION});
            }
        } else {
            this.authentication.putReference((Object)String.valueOf(ref.getProperty(KEY_SERVICE_ID)), ref);
        }
        this.authnService.set(null);
        return this.getServiceProperties();
    }

    protected Map<String, Object> unsetAuthentication(ServiceReference<AuthenticationService> ref) {
        this.authentication.removeReference((Object)((String)ref.getProperty(KEY_ID)), ref);
        this.authentication.removeReference((Object)String.valueOf(ref.getProperty(KEY_SERVICE_ID)), ref);
        this.authnService.set(null);
        return this.getServiceProperties();
    }

    @Reference(policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.MULTIPLE)
    protected Map<String, Object> setAuthorization(ServiceReference<AuthorizationService> ref) {
        if (this.hasPropertiesFromFile(ref)) {
            String id = (String)ref.getProperty(KEY_ID);
            if (id != null) {
                this.authorization.putReference((Object)id, ref);
            } else {
                Tr.error((TraceComponent)tc, (String)"SECURITY_SERVICE_REQUIRED_SERVICE_WITHOUT_ID", (Object[])new Object[]{KEY_AUTHORIZATION});
            }
        } else {
            this.authorization.putReference((Object)String.valueOf(ref.getProperty(KEY_SERVICE_ID)), ref);
        }
        this.authzService.set(null);
        return this.getServiceProperties();
    }

    protected Map<String, Object> unsetAuthorization(ServiceReference<AuthorizationService> ref) {
        this.authorization.removeReference((Object)((String)ref.getProperty(KEY_ID)), ref);
        this.authorization.removeReference((Object)String.valueOf(ref.getProperty(KEY_SERVICE_ID)), ref);
        this.authzService.set(null);
        return this.getServiceProperties();
    }

    @Reference(policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.MULTIPLE, target="(config.displayId=*)")
    protected Map<String, Object> setUserRegistry(ServiceReference<UserRegistryService> ref) {
        this.adjustUserRegistryServiceRef(ref);
        this.userRegistryService.set(null);
        return this.getServiceProperties();
    }

    private void adjustUserRegistryServiceRef(ServiceReference<UserRegistryService> ref) {
        if (!"com.ibm.ws.security.registry.internal.UserRegistryRefConfig".equals(ref.getProperty("config.displayId"))) {
            String id = (String)ref.getProperty(KEY_ID);
            if (id != null) {
                this.userRegistry.putReference((Object)id, ref);
                this.userRegistry.removeReference((Object)String.valueOf(ref.getProperty(KEY_SERVICE_ID)), ref);
            } else {
                Tr.error((TraceComponent)tc, (String)"SECURITY_SERVICE_REQUIRED_SERVICE_WITHOUT_ID", (Object[])new Object[]{KEY_USERREGISTRY});
            }
        } else {
            this.userRegistry.putReference((Object)String.valueOf(ref.getProperty(KEY_SERVICE_ID)), ref);
        }
    }

    protected Map<String, Object> updatedUserRegistry(ServiceReference<UserRegistryService> ref) {
        this.adjustUserRegistryServiceRef(ref);
        this.userRegistryService.set(null);
        return this.getServiceProperties();
    }

    protected Map<String, Object> unsetUserRegistry(ServiceReference<UserRegistryService> ref) {
        this.userRegistry.removeReference((Object)((String)ref.getProperty(KEY_ID)), ref);
        this.userRegistry.removeReference((Object)String.valueOf(ref.getProperty(KEY_SERVICE_ID)), ref);
        this.userRegistryService.set(null);
        return this.getServiceProperties();
    }

    @Activate
    protected Map<String, Object> activate(ComponentContext cc, Map<String, Object> props) {
        this.cc = cc;
        this.props = props;
        this.configs.activate(cc);
        this.authentication.activate(cc);
        this.authorization.activate(cc);
        this.userRegistry.activate(cc);
        this.setAndValidateProperties((String)props.get(CFG_KEY_SYSTEM_DOMAIN), (String)props.get(CFG_KEY_DEFAULT_APP_DOMAIN));
        return this.getServiceProperties();
    }

    @Modified
    protected Map<String, Object> modify(Map<String, Object> newProperties) {
        this.props = newProperties;
        this.authnService.set(null);
        this.authzService.set(null);
        this.userRegistryService.set(null);
        this.setAndValidateProperties((String)newProperties.get(CFG_KEY_SYSTEM_DOMAIN), (String)newProperties.get(CFG_KEY_DEFAULT_APP_DOMAIN));
        return this.getServiceProperties();
    }

    @Deactivate
    protected Map<String, Object> deactivate(ComponentContext cc, Map<String, Object> props) {
        this.cc = null;
        this.props = props;
        this.configs.deactivate(cc);
        this.authentication.deactivate(cc);
        this.authorization.deactivate(cc);
        this.userRegistry.deactivate(cc);
        this.cfgSystemDomain = null;
        this.cfgDefaultAppDomain = null;
        return this.getServiceProperties();
    }

    private Map<String, Object> getServiceProperties() {
        if (this.props == null) {
            return null;
        }
        HashMap<String, Object> result = new HashMap<String, Object>(this.props);
        if (!this.authentication.isEmpty()) {
            result.put(KEY_AUTHENTICATION, this.authentication.keySet().toArray(new String[this.authentication.size()]));
        }
        if (!this.authorization.isEmpty()) {
            result.put(KEY_AUTHORIZATION, this.authorization.keySet().toArray(new String[this.authorization.size()]));
        }
        if (!this.configs.isEmpty()) {
            result.put(KEY_CONFIGURATION, this.configs.keySet().toArray(new String[this.configs.size()]));
        }
        if (!this.userRegistry.isEmpty()) {
            ArrayList<String> userRegistryRealms = new ArrayList<String>();
            for (ServiceReference ref : this.userRegistry.references()) {
                if (ref.getProperty("realm") == null) continue;
                userRegistryRealms.add((String)ref.getProperty("realm"));
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("setting UserRegistry to " + userRegistryRealms), (Object[])new Object[0]);
            }
            result.put(KEY_USERREGISTRY, userRegistryRealms.toArray(new String[userRegistryRealms.size()]));
        }
        return result;
    }

    private boolean isConfigurationDefinedInFile() {
        return "file".equals(this.cc.getProperties().get(KEY_CONFIG_SOURCE));
    }

    private void setAndValidateProperties(String systemDomain, String defaultAppDomain) {
        if (this.isConfigurationDefinedInFile()) {
            if (systemDomain == null || systemDomain.isEmpty()) {
                Tr.error((TraceComponent)tc, (String)"SECURITY_SERVICE_ERROR_MISSING_ATTRIBUTE", (Object[])new Object[]{CFG_KEY_SYSTEM_DOMAIN});
                throw new IllegalArgumentException(TraceNLS.getFormattedMessage(this.getClass(), (String)"com.ibm.ws.security.internal.resources.LoggingMessages", (String)"SECURITY_SERVICE_ERROR_MISSING_ATTRIBUTE", (Object[])new Object[]{CFG_KEY_SYSTEM_DOMAIN}, (String)"CWWKS0002E: A configuration error has occurred. No {0} attribute is defined for the <security> element."));
            }
            this.cfgSystemDomain = systemDomain;
            this.cfgDefaultAppDomain = defaultAppDomain == null || defaultAppDomain.isEmpty() ? systemDomain : defaultAppDomain;
        }
    }

    private SecurityConfiguration getEffectiveSecurityConfiguration() {
        SecurityConfiguration effectiveConfig = (SecurityConfiguration)this.configs.getService((Object)this.cfgSystemDomain);
        if (effectiveConfig == null) {
            Tr.error((TraceComponent)tc, (String)"SECURITY_SERVICE_ERROR_BAD_DOMAIN", (Object[])new Object[]{this.cfgSystemDomain, CFG_KEY_SYSTEM_DOMAIN});
            throw new IllegalArgumentException(TraceNLS.getFormattedMessage(this.getClass(), (String)"com.ibm.ws.security.internal.resources.LoggingMessages", (String)"SECURITY_SERVICE_ERROR_BAD_DOMAIN", (Object[])new Object[]{this.cfgSystemDomain, CFG_KEY_SYSTEM_DOMAIN}, (String)"CWWKS0003E: A configuration error has occurred. The specified security configuration referenced by identifier {0} for attribute {1} in the <security> element is not defined."));
        }
        return effectiveConfig;
    }

    private void throwIllegalArgumentExceptionInvalidAttributeValue(String attribute, String value) {
        Tr.error((TraceComponent)tc, (String)"SECURITY_SERVICE_ERROR_BAD_REFERENCE", (Object[])new Object[]{value, attribute});
        throw new IllegalArgumentException(TraceNLS.getFormattedMessage(this.getClass(), (String)"com.ibm.ws.security.internal.resources.LoggingMessages", (String)"SECURITY_SERVICE_ERROR_BAD_REFERENCE", (Object[])new Object[]{value, attribute}, (String)"CWWKS0004E: A configuration error has occurred. The specified element referenced by identifier {0} for attribute {1} in the <securityConfiguration> element is not defined."));
    }

    private <V> V autoDetectService(String serviceName, ConcurrentServiceReferenceMap<String, V> map) {
        Iterator services = map.getServices();
        if (!services.hasNext()) {
            Tr.error((TraceComponent)tc, (String)"SECURITY_SERVICE_NO_SERVICE_AVAILABLE", (Object[])new Object[]{serviceName});
            throw new IllegalStateException(TraceNLS.getFormattedMessage(this.getClass(), (String)"com.ibm.ws.security.internal.resources.LoggingMessages", (String)"SECURITY_SERVICE_NO_SERVICE_AVAILABLE", (Object[])new Object[]{serviceName}, (String)"CWWKS0005E: A configuration error has occurred. No available {0} service."));
        }
        Object service = services.next();
        if (services.hasNext()) {
            Tr.error((TraceComponent)tc, (String)"SECURITY_SERVICE_MULTIPLE_SERVICE_AVAILABLE", (Object[])new Object[]{serviceName});
            throw new IllegalStateException(TraceNLS.getFormattedMessage(this.getClass(), (String)"com.ibm.ws.security.internal.resources.LoggingMessages", (String)"SECURITY_SERVICE_MULTIPLE_SERVICE_AVAILABLE", (Object[])new Object[]{serviceName}, (String)"CWWKS0006E: A configuration error has occurred. Multiple available {0} services, unable to determine which to use."));
        }
        return (V)service;
    }

    @Override
    public AuthenticationService getAuthenticationService() {
        AuthenticationService service = this.authnService.get();
        if (service == null) {
            if (this.isConfigurationDefinedInFile()) {
                String id = this.getEffectiveSecurityConfiguration().getAuthenticationServiceId();
                service = this.getAuthenticationService(id);
            } else {
                service = this.autoDetectService(KEY_AUTHENTICATION, this.authentication);
            }
            this.authnService.set(service);
        }
        if (!this.authorization.isEmpty()) {
            this.getAuthorizationService();
        }
        return service;
    }

    private AuthenticationService getAuthenticationService(String id) {
        AuthenticationService service = (AuthenticationService)this.authentication.getService((Object)id);
        if (service == null) {
            this.throwIllegalArgumentExceptionInvalidAttributeValue("authenticationRef", id);
        }
        return service;
    }

    @Override
    public AuthorizationService getAuthorizationService() {
        AuthorizationService service = this.authzService.get();
        if (service == null) {
            if (this.isConfigurationDefinedInFile()) {
                String id = this.getEffectiveSecurityConfiguration().getAuthorizationServiceId();
                service = this.getAuthorizationService(id);
            } else {
                service = this.autoDetectAuthorizationService();
            }
            this.authzService.set(service);
        }
        return service;
    }

    private AuthorizationService autoDetectAuthorizationService() {
        Iterator services = this.authorization.getServices();
        if (!services.hasNext()) {
            Tr.error((TraceComponent)tc, (String)"SECURITY_SERVICE_NO_SERVICE_AVAILABLE", (Object[])new Object[]{KEY_AUTHORIZATION});
            throw new IllegalStateException(TraceNLS.getFormattedMessage(this.getClass(), (String)"com.ibm.ws.security.internal.resources.LoggingMessages", (String)"SECURITY_SERVICE_NO_SERVICE_AVAILABLE", (Object[])new Object[]{KEY_AUTHORIZATION}, (String)"CWWKS0005E: A configuration error has occurred. No available {0} service."));
        }
        AuthorizationService authzService = (AuthorizationService)services.next();
        if (services.hasNext()) {
            authzService = null;
            services.next();
            if (services.hasNext()) {
                Tr.error((TraceComponent)tc, (String)"SECURITY_SERVICE_MULTIPLE_SERVICE_AVAILABLE", (Object[])new Object[]{KEY_AUTHORIZATION});
                throw new IllegalStateException(TraceNLS.getFormattedMessage(this.getClass(), (String)"com.ibm.ws.security.internal.resources.LoggingMessages", (String)"SECURITY_SERVICE_MULTIPLE_SERVICE_AVAILABLE", (Object[])new Object[]{KEY_AUTHORIZATION}, (String)"CWWKS0006E: A configuration error has occurred. Multiple available {0} services, unable to determine which to use."));
            }
            boolean builtinAuthzFound = false;
            for (String key : this.authorization.keySet()) {
                String type = (String)this.authorization.getReference((Object)key).getProperty("com.ibm.ws.security.authorization.type");
                if ("Builtin".equals(type)) {
                    builtinAuthzFound = true;
                    continue;
                }
                authzService = (AuthorizationService)this.authorization.getService((Object)key);
            }
            if (!builtinAuthzFound) {
                Tr.error((TraceComponent)tc, (String)"SECURITY_SERVICE_MULTIPLE_SERVICE_AVAILABLE", (Object[])new Object[]{KEY_AUTHORIZATION});
                throw new IllegalStateException(TraceNLS.getFormattedMessage(this.getClass(), (String)"com.ibm.ws.security.internal.resources.LoggingMessages", (String)"SECURITY_SERVICE_MULTIPLE_SERVICE_AVAILABLE", (Object[])new Object[]{KEY_AUTHORIZATION}, (String)"CWWKS0006E: A configuration error has occurred. Multiple available {0} services, unable to determine which to use."));
            }
        }
        return authzService;
    }

    private AuthorizationService getAuthorizationService(String id) {
        AuthorizationService service = (AuthorizationService)this.authorization.getService((Object)id);
        if (service == null) {
            this.throwIllegalArgumentExceptionInvalidAttributeValue("authorizationRef", id);
        }
        return service;
    }

    @Override
    public UserRegistryService getUserRegistryService() {
        UserRegistryService service = this.userRegistryService.get();
        if (service == null) {
            if (this.isConfigurationDefinedInFile()) {
                String id = this.getEffectiveSecurityConfiguration().getUserRegistryServiceId();
                service = this.getUserRegistryService(id);
            } else {
                service = this.autoDetectService(KEY_USERREGISTRY, this.userRegistry);
            }
            this.userRegistryService.set(service);
        }
        return service;
    }

    private UserRegistryService getUserRegistryService(String id) {
        UserRegistryService service = (UserRegistryService)this.userRegistry.getService((Object)id);
        if (service == null) {
            this.throwIllegalArgumentExceptionInvalidAttributeValue("userRegistryRef", id);
        }
        return service;
    }
}

