/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.anno.util.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class UtilImpl_IdentityStringSet
implements Set<String> {
    protected static final int DOUBLING_FACTOR = 2;
    protected static final int MAX_DOUBLING_SIZE = 64;
    protected final int factor;
    protected static final int PERCENTAGE_FACTOR = 5;
    protected int size = 0;
    protected String[] storage = new String[this.size];
    static final long serialVersionUID = 6966390692981111388L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public UtilImpl_IdentityStringSet() {
        this.factor = 2;
    }

    public UtilImpl_IdentityStringSet(int factor) {
        this.factor = factor;
    }

    public int getFactor() {
        return this.factor;
    }

    protected String[] getStorage() {
        return this.storage;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void clear() {
        this.size = 0;
        this.storage = new String[this.size];
    }

    protected String[] growStorage() {
        int priorLength = this.storage.length;
        int newLength = 0;
        newLength = priorLength < 64 ? (priorLength == 0 ? 1 : priorLength * this.factor) : priorLength + priorLength / 5;
        String[] newStorage = new String[newLength];
        System.arraycopy(this.storage, 0, newStorage, 0, priorLength);
        return newStorage;
    }

    @Override
    public boolean add(String i_newElement) {
        for (int offset = 0; offset < this.size; ++offset) {
            if (this.storage[offset] != i_newElement) continue;
            return false;
        }
        if (this.size == this.storage.length) {
            this.storage = this.growStorage();
        }
        this.storage[this.size++] = i_newElement;
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends String> newElements) {
        boolean didAdd = false;
        for (String string : newElements) {
            if (!this.add(string)) continue;
            didAdd = true;
        }
        return didAdd;
    }

    @Override
    public boolean contains(Object candidateElement) {
        if (this.size == 0) {
            return false;
        }
        for (String currentElement : this.storage) {
            if (currentElement != candidateElement) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        for (Object nextCandidateElement : collection) {
            if (this.contains(nextCandidateElement)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean remove(Object object) {
        for (int offset = 0; offset < this.size; ++offset) {
            if (this.storage[offset] != object) continue;
            System.arraycopy(this.storage, offset + 1, this.storage, offset, this.size - (offset + 1));
            this.storage[--this.size] = null;
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> candidateElements) {
        boolean didRemoveAny = false;
        for (Object nextCandidate : candidateElements) {
            if (!this.remove(nextCandidate)) continue;
            didRemoveAny = true;
        }
        return didRemoveAny;
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        boolean didOmitAny = false;
        for (int offset = 0; offset < this.size; ++offset) {
            if (collection.contains(this.storage[offset])) continue;
            System.arraycopy(this.storage, offset + 1, this.storage, offset, this.size - (offset + 1));
            this.storage[--this.size] = null;
            didOmitAny = true;
        }
        return didOmitAny;
    }

    @Override
    public Object[] toArray() {
        Object[] result = new Object[this.size];
        System.arraycopy(this.storage, 0, result, 0, this.size);
        return result;
    }

    @Override
    public <S> S[] toArray(S[] targetArray) {
        if (this.size > targetArray.length) {
            Class<?> componentType = this.storage.getClass().getComponentType();
            targetArray = (Object[])Array.newInstance(componentType, this.size);
        }
        System.arraycopy(this.storage, 0, targetArray, 0, this.size);
        if (this.size < targetArray.length) {
            for (int offset = this.size; offset < targetArray.length; ++offset) {
                targetArray[offset] = null;
            }
        }
        return targetArray;
    }

    @Override
    public Iterator<String> iterator() {
        return new SimpleStringIterator();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(UtilImpl_IdentityStringSet.class);
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    protected class SimpleStringIterator
    implements Iterator<String> {
        protected int offset = 0;
        static final long serialVersionUID = 116322047813645679L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        protected SimpleStringIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.offset < UtilImpl_IdentityStringSet.this.size;
        }

        @Override
        public String next() {
            if (this.offset < UtilImpl_IdentityStringSet.this.size) {
                return UtilImpl_IdentityStringSet.this.storage[this.offset++];
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            if (this.offset >= UtilImpl_IdentityStringSet.this.size) {
                throw new NoSuchElementException();
            }
            System.arraycopy(UtilImpl_IdentityStringSet.this.storage, this.offset + 1, UtilImpl_IdentityStringSet.this.storage, this.offset, UtilImpl_IdentityStringSet.this.size - (this.offset + 1));
            UtilImpl_IdentityStringSet.this.storage[--UtilImpl_IdentityStringSet.this.size] = null;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(SimpleStringIterator.class);
        }
    }
}

