/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.launch.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.kernel.boot.BootstrapConfig;
import com.ibm.ws.kernel.boot.LaunchException;
import com.ibm.ws.kernel.boot.internal.BootstrapConstants;
import com.ibm.ws.kernel.boot.internal.KernelResolver;
import com.ibm.ws.kernel.boot.internal.KernelStartLevel;
import com.ibm.ws.kernel.launch.internal.BundleInstallStatus;
import com.ibm.ws.kernel.launch.internal.BundleStartStatus;
import com.ibm.ws.kernel.launch.internal.Provisioner;
import com.ibm.ws.kernel.launch.internal.StartLevelFrameworkListener;
import com.ibm.ws.kernel.provisioning.BundleRepositoryRegistry;
import com.ibm.ws.kernel.provisioning.ContentBasedLocalBundleRepository;
import com.ibm.ws.kernel.provisioning.VersionUtility;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.File;
import java.net.URL;
import java.util.List;
import java.util.Map;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.startlevel.BundleStartLevel;
import org.osgi.framework.startlevel.FrameworkStartLevel;
import org.osgi.framework.wiring.BundleRevision;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class ProvisionerImpl
implements Provisioner {
    private static final String ME = ProvisionerImpl.class.getName();
    private static final TraceComponent tc = Tr.register(ProvisionerImpl.class);
    protected BundleContext context;
    protected FrameworkStartLevel frameworkStartLevel;
    static final long serialVersionUID = 1165193015845048467L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    public ProvisionerImpl() {
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"<init>", (Object[])new Object[0]);
        }
        this.context = null;
        this.frameworkStartLevel = null;
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"<init>", (Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    public void initialProvisioning(BundleContext systemBundleCtx, BootstrapConfig config) throws Provisioner.InvalidBundleContextException {
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"initialProvisioning", (Object[])new Object[]{systemBundleCtx, config});
        }
        this.getServices(systemBundleCtx);
        try {
            BundleInstallStatus installStatus = this.installBundles(config);
            this.checkInstallStatus(installStatus);
            String bundleDebug = config.get("kernel.debug.bundlestart.enabled");
            if (systemBundleCtx.getBundle() != null && (bundleDebug == null || "false".equals(bundleDebug))) {
                BundleStartStatus startStatus = this.startBundles(installStatus.getBundlesToStart());
                this.checkStartStatus(startStatus);
                startStatus = this.setFrameworkStartLevel(KernelStartLevel.FEATURE_PREPARE.getLevel());
                this.checkStartStatus(startStatus);
            }
        }
        finally {
            this.releaseServices();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"initialProvisioning");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    protected void checkInstallStatus(BundleInstallStatus installStatus) {
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"checkInstallStatus", (Object[])new Object[]{installStatus});
        }
        String m = "checkInstallStatus";
        if (installStatus.installExceptions()) {
            Map<String, Throwable> installExceptions = installStatus.getInstallExceptions();
            for (Map.Entry<String, Throwable> entry : installExceptions.entrySet()) {
                FFDCFilter.processException((Throwable)entry.getValue(), (String)ME, (String)"checkInstallStatus", (Object)this, (Object[])new Object[]{entry.getKey()});
            }
            throw new LaunchException("Exceptions occurred while installing platform bundles", BootstrapConstants.messages.getString("error.platformBundleException"));
        }
        if (installStatus.bundlesMissing()) {
            throw new LaunchException("Missing platform bundles: " + installStatus.listMissingBundles(), BootstrapConstants.messages.getString("error.missingBundleException"));
        }
        if (!installStatus.bundlesToStart()) {
            throw new LaunchException("No required bundles installed", BootstrapConstants.messages.getString("error.noStartedBundles"));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"checkInstallStatus");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    protected void checkStartStatus(BundleStartStatus startStatus) throws Provisioner.InvalidBundleContextException {
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"checkStartStatus", (Object[])new Object[]{startStatus});
        }
        String m = "checkInstallStatus";
        if (startStatus.startExceptions()) {
            Map<Bundle, Throwable> startExceptions = startStatus.getStartExceptions();
            for (Map.Entry<Bundle, Throwable> entry : startExceptions.entrySet()) {
                Bundle b = entry.getKey();
                FFDCFilter.processException((Throwable)entry.getValue(), (String)ME, (String)"checkInstallStatus", (Object)this, (Object[])new Object[]{b.getLocation()});
            }
            throw new LaunchException("Exceptions occurred while starting platform bundles", BootstrapConstants.messages.getString("error.platformBundleException"));
        }
        if (!startStatus.contextIsValid()) {
            throw new Provisioner.InvalidBundleContextException();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"checkStartStatus");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    protected void getServices(BundleContext bundleCtx) {
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"getServices", (Object[])new Object[]{bundleCtx});
        }
        this.context = bundleCtx;
        this.frameworkStartLevel = (FrameworkStartLevel)bundleCtx.getBundle(0L).adapt(FrameworkStartLevel.class);
        this.frameworkStartLevel.setInitialBundleStartLevel(KernelStartLevel.ACTIVE.getLevel());
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"getServices");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    protected void releaseServices() {
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"releaseServices", (Object[])new Object[0]);
        }
        this.context = null;
        this.frameworkStartLevel = null;
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"releaseServices");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    protected BundleStartStatus setFrameworkStartLevel(int level) {
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"setFrameworkStartLevel", (Object[])new Object[]{level});
        }
        BundleStartStatus startStatus = null;
        if (this.frameworkStartLevel != null) {
            StartLevelFrameworkListener slfw = new StartLevelFrameworkListener(true);
            this.frameworkStartLevel.setStartLevel(level, new FrameworkListener[]{slfw});
            slfw.waitForLevel();
            startStatus = slfw.getStatus();
        } else {
            startStatus = new BundleStartStatus();
        }
        BundleStartStatus bundleStartStatus = startStatus;
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            bundleStartStatus = bundleStartStatus;
            Tr.exit((Object)this, (TraceComponent)tc, (String)"setFrameworkStartLevel", (Object)bundleStartStatus);
        }
        return bundleStartStatus;
    }

    /*
     * WARNING - void declaration
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    protected BundleInstallStatus installBundles(BootstrapConfig config) throws Provisioner.InvalidBundleContextException {
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"installBundles", (Object[])new Object[]{config});
        }
        BundleInstallStatus installStatus = new BundleInstallStatus();
        KernelResolver resolver = config.getKernelResolver();
        ContentBasedLocalBundleRepository repo = BundleRepositoryRegistry.getInstallBundleRepository();
        List<KernelResolver.KernelBundleElement> bundleList = resolver.getKernelBundles();
        if (bundleList == null || bundleList.size() <= 0) {
            BundleInstallStatus bundleInstallStatus = installStatus;
            if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
                bundleInstallStatus = bundleInstallStatus;
                Tr.exit((Object)this, (TraceComponent)tc, (String)"installBundles", (Object)bundleInstallStatus);
            }
            return bundleInstallStatus;
        }
        for (KernelResolver.KernelBundleElement element : bundleList) {
            File bundleFile = element.getCachedBestMatch();
            if (bundleFile == null || !bundleFile.exists()) {
                bundleFile = repo.selectBundle(element.getLocation(), element.getSymbolicName(), VersionUtility.stringToVersionRange(element.getRangeString()));
                element.setBestMatch(bundleFile);
            }
            if (bundleFile == null || !bundleFile.exists()) {
                installStatus.addMissingBundle(element.toNameVersionString());
                continue;
            }
            try {
                URL resourceURL = bundleFile.toURI().toURL();
                String urlString = resourceURL.toString();
                urlString = "reference:" + urlString;
                Bundle bundle = this.context.installBundle("kernel@" + urlString, new URL(urlString).openStream());
                int startLevel = 0;
                BundleRevision bRev = (BundleRevision)bundle.adapt(BundleRevision.class);
                if ((bRev.getTypes() & 1) == 1) continue;
                installStatus.addBundleToStart(bundle);
                BundleStartLevel bStartLevel = (BundleStartLevel)bundle.adapt(BundleStartLevel.class);
                startLevel = element.getStartLevel();
                int currentLevel = bStartLevel.getStartLevel();
                if (currentLevel == startLevel) continue;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)"Changing the start level of bundle {0} from {1} to the current level of {2}", (Object[])new Object[]{bundle, currentLevel, startLevel});
                }
                bStartLevel.setStartLevel(startLevel);
            }
            catch (IllegalStateException resourceURL) {
                void e;
                FFDCFilter.processException((Throwable)resourceURL, (String)"com.ibm.ws.kernel.launch.internal.ProvisionerImpl", (String)"285", (Object)this, (Object[])new Object[]{config});
                e.getCause();
                throw new Provisioner.InvalidBundleContextException();
            }
            catch (Throwable e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.kernel.launch.internal.ProvisionerImpl", (String)"289", (Object)this, (Object[])new Object[]{config});
                installStatus.addInstallException(element.toNameVersionString(), e);
            }
        }
        BundleInstallStatus bundleInstallStatus = installStatus;
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            bundleInstallStatus = bundleInstallStatus;
            Tr.exit((Object)this, (TraceComponent)tc, (String)"installBundles", (Object)bundleInstallStatus);
        }
        return bundleInstallStatus;
    }

    /*
     * WARNING - void declaration
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    protected BundleStartStatus startBundles(List<Bundle> installedBundles) {
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"startBundles", (Object[])new Object[]{installedBundles});
        }
        BundleStartStatus startStatus = new BundleStartStatus();
        if (installedBundles == null || installedBundles.size() == 0) {
            BundleStartStatus bundleStartStatus = startStatus;
            if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
                bundleStartStatus = bundleStartStatus;
                Tr.exit((Object)this, (TraceComponent)tc, (String)"startBundles", (Object)bundleStartStatus);
            }
            return bundleStartStatus;
        }
        for (Bundle b : installedBundles) {
            int state = b.getState();
            if (state == 1 || state >= 8) continue;
            try {
                b.start(2);
            }
            catch (BundleException bundleException) {
                void e;
                FFDCFilter.processException((Throwable)bundleException, (String)"com.ibm.ws.kernel.launch.internal.ProvisionerImpl", (String)"326", (Object)this, (Object[])new Object[]{installedBundles});
                startStatus.addStartException(b, (Throwable)e);
            }
        }
        BundleStartStatus bundleStartStatus = startStatus;
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            bundleStartStatus = bundleStartStatus;
            Tr.exit((Object)this, (TraceComponent)tc, (String)"startBundles", (Object)bundleStartStatus);
        }
        return bundleStartStatus;
    }
}

