/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.launch.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.kernel.boot.internal.commands.ServerDumpUtil;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.Enumeration;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class MissingDoPrivDetectionSecurityManager
extends SecurityManager {
    public static final String lineSep = System.getProperty("line.separator");
    private static final TraceComponent tc = Tr.register(MissingDoPrivDetectionSecurityManager.class);
    static final long serialVersionUID = -3003803092588674706L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    public MissingDoPrivDetectionSecurityManager() {
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"<init>", (Object[])new Object[0]);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"<init>", (Object)this);
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    @FFDCIgnore(value={SecurityException.class})
    public void checkPermission(Permission perm) {
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"checkPermission", (Object[])new Object[]{perm});
        }
        try {
            super.checkPermission(perm);
        }
        catch (SecurityException ex) {
            this.handleSecurityException(perm, ex);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"checkPermission");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    @FFDCIgnore(value={SecurityException.class})
    public void checkPermission(Permission perm, Object context) {
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"checkPermission", (Object[])new Object[]{perm, context});
        }
        try {
            super.checkPermission(perm, context);
        }
        catch (SecurityException ex) {
            this.handleSecurityException(perm, ex);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"checkPermission");
        }
    }

    /*
     * WARNING - void declaration
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    public void handleSecurityException(Permission perm, SecurityException e) throws SecurityException {
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"handleSecurityException", (Object[])new Object[]{perm, e});
        }
        try {
            Tr.warning((TraceComponent)tc, (String)"warning.java.security.permdenied.quickmsg", (Object[])new Object[]{this.getCodeBaseLoc(perm, e)});
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            String stackStr = sw.toString();
            String[] codebaseloc = null;
            codebaseloc = this.getCodeBaseLocForPerm(perm);
            if (!ServerDumpUtil.isZos()) {
                Tr.warning((TraceComponent)tc, (String)"warning.java.security.permdenied", (Object[])new Object[]{lineSep + lineSep, lineSep + lineSep + "      " + perm.getName() + " : " + e.getMessage() + lineSep + lineSep + lineSep, codebaseloc[0], lineSep + lineSep, lineSep + lineSep + stackStr + lineSep + lineSep, lineSep + lineSep + codebaseloc[1]});
            } else {
                Tr.warning((TraceComponent)tc, (String)"warning.zOS.java.security.permdenied1", (Object[])new Object[]{lineSep + lineSep, lineSep + lineSep + "      " + perm.getName() + " : " + e.getMessage() + lineSep + lineSep + lineSep, codebaseloc[0], lineSep + lineSep + codebaseloc[1]});
                Tr.warning((TraceComponent)tc, (String)"warning.zOS.java.security.permdenied2", (Object[])new Object[]{"\nBegin SecurityException\n" + stackStr + "\nEnd SecurityException\n"});
            }
        }
        catch (Exception sw) {
            void e2;
            FFDCFilter.processException((Throwable)sw, (String)"com.ibm.ws.kernel.launch.internal.MissingDoPrivDetectionSecurityManager", (String)"98", (Object)this, (Object[])new Object[]{perm, e});
            StringWriter sw2 = new StringWriter();
            e2.printStackTrace(new PrintWriter(sw2));
            String stackStr2 = sw2.toString();
            Tr.error((TraceComponent)tc, (String)"error.java.security.exception.codebase", (Object[])new Object[]{e2.toString() + "(" + e2.getMessage() + ")" + lineSep + lineSep + stackStr2});
        }
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"handleSecurityException");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    public String getCodeBaseLoc(final Permission perm, final SecurityException e) {
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"getCodeBaseLoc", (Object[])new Object[]{perm, e});
        }
        String string = AccessController.doPrivileged(new PrivilegedAction<String>(){
            static final long serialVersionUID = -6324481826326029924L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;
            {
                if (TraceComponent.isAnyTracingEnabled() && $$$tc$$$ != null && $$$tc$$$.isEntryEnabled()) {
                    Tr.entry((TraceComponent)$$$tc$$$, (String)"<init>", (Object[])new Object[]{MissingDoPrivDetectionSecurityManager.this, securityException, permission});
                }
                if (TraceComponent.isAnyTracingEnabled() && $$$tc$$$ != null && $$$tc$$$.isEntryEnabled()) {
                    Tr.exit((Object)this, (TraceComponent)$$$tc$$$, (String)"<init>", (Object)this);
                }
            }

            @Override
            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
            public String run() {
                if (TraceComponent.isAnyTracingEnabled() && $$$tc$$$ != null && $$$tc$$$.isEntryEnabled()) {
                    Tr.entry((Object)this, (TraceComponent)$$$tc$$$, (String)"run", (Object[])new Object[0]);
                }
                Class[] classes = MissingDoPrivDetectionSecurityManager.this.getClassContext();
                StringBuffer sb = new StringBuffer(classes.length * 100);
                sb.append(lineSep);
                boolean runtimeCodeOnStack = false;
                int appCodeIndex = -1;
                for (int i = 0; i < classes.length; ++i) {
                    Class clazz = classes[i];
                    ClassLoader cl = clazz.getClassLoader();
                    boolean jvmClassLoader = MissingDoPrivDetectionSecurityManager.this.isJvmClassLoader(cl);
                    boolean rtClassLoader = MissingDoPrivDetectionSecurityManager.this.isRuntimeClassLoader(clazz, cl);
                    boolean appClassLoader = MissingDoPrivDetectionSecurityManager.this.isAppClassLoader(cl);
                    String loader = null;
                    if (cl != null) {
                        loader = cl.getClass().getName();
                    }
                    if (clazz.getName().startsWith("com.ibm._jsp.")) {
                        System.out.println(clazz.getClassLoader().getClass().getName());
                    }
                    runtimeCodeOnStack |= rtClassLoader;
                    if (!appClassLoader) continue;
                    appCodeIndex = i;
                }
                StringBuilder stack = new StringBuilder();
                StackTraceElement[] stackTrace = e.getStackTrace();
                int endIndex = stackTrace.length;
                if (appCodeIndex > -1 && runtimeCodeOnStack) {
                    endIndex = appCodeIndex;
                    stack.append("Detected a possible missing doPriv statement. There was Liberty code between the check and the application code.\r\n");
                } else if (appCodeIndex == -1 && runtimeCodeOnStack) {
                    stack.append("No app code on stack, but a permission check failed.\r\n");
                } else if (appCodeIndex > -1 && !runtimeCodeOnStack) {
                    stack.append("The application needs to have permissions added");
                } else {
                    stack.append("No app code, or Liberty code on stack, so pretty much shouldn't happen.\r\n");
                }
                stack.append("Permission: \r\n");
                stack.append(perm.toString());
                stack.append("\r\nStack: \r\n");
                stack.append(e.toString());
                for (int i = 0; i < endIndex; ++i) {
                    stack.append(stackTrace[i].toString());
                    stack.append("\r\n");
                }
                String string = stack.toString();
                if (TraceComponent.isAnyTracingEnabled() && $$$tc$$$ != null && $$$tc$$$.isEntryEnabled()) {
                    string = string;
                    Tr.exit((Object)this, (TraceComponent)$$$tc$$$, (String)"run", (Object)string);
                }
                return string;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(1.class);
            }
        });
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            string = string;
            Tr.exit((Object)this, (TraceComponent)tc, (String)"getCodeBaseLoc", (Object)string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    private boolean isAppClassLoader(ClassLoader cl) {
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"isAppClassLoader", (Object[])new Object[]{cl});
        }
        if (cl == null) {
            boolean bl = false;
            if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
                bl = bl;
                Tr.exit((Object)this, (TraceComponent)tc, (String)"isAppClassLoader", (Object)bl);
            }
            return bl;
        }
        String clName = cl.getClass().getName();
        boolean bl = clName.startsWith("com.ibm.ws.classloading") || clName.equals("com.ibm.ws.jsp.webcontainerext.JSPExtensionClassLoader");
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            bl = bl;
            Tr.exit((Object)this, (TraceComponent)tc, (String)"isAppClassLoader", (Object)bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    private boolean isRuntimeClassLoader(Class<?> c, ClassLoader cl) {
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"isRuntimeClassLoader", (Object[])new Object[]{c, cl});
        }
        if (cl == null) {
            boolean bl = false;
            if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
                bl = bl;
                Tr.exit((Object)this, (TraceComponent)tc, (String)"isRuntimeClassLoader", (Object)bl);
            }
            return bl;
        }
        if (c.getName().startsWith("com.ibm.ws.kernel.launch.internal.MissingDoPrivDetectionSecurityManager")) {
            boolean bl = false;
            if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
                bl = bl;
                Tr.exit((Object)this, (TraceComponent)tc, (String)"isRuntimeClassLoader", (Object)bl);
            }
            return bl;
        }
        boolean bl = cl.getClass().getName().equals(this.getClass().getClassLoader().getClass().getName());
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            bl = bl;
            Tr.exit((Object)this, (TraceComponent)tc, (String)"isRuntimeClassLoader", (Object)bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    private boolean isJvmClassLoader(ClassLoader cl) {
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"isJvmClassLoader", (Object[])new Object[]{cl});
        }
        boolean bl = cl == null || cl == ClassLoader.getSystemClassLoader();
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            bl = bl;
            Tr.exit((Object)this, (TraceComponent)tc, (String)"isJvmClassLoader", (Object)bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    public String[] getCodeBaseLocForPerm(Permission perm) {
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"getCodeBaseLocForPerm", (Object[])new Object[]{perm});
        }
        final Permission inPerm = perm;
        String[] stringArray = AccessController.doPrivileged(new PrivilegedAction<String[]>(){
            static final long serialVersionUID = -8121097894023200039L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;
            {
                if (TraceComponent.isAnyTracingEnabled() && $$$tc$$$ != null && $$$tc$$$.isEntryEnabled()) {
                    Tr.entry((TraceComponent)$$$tc$$$, (String)"<init>", (Object[])new Object[]{MissingDoPrivDetectionSecurityManager.this, permission});
                }
                if (TraceComponent.isAnyTracingEnabled() && $$$tc$$$ != null && $$$tc$$$.isEntryEnabled()) {
                    Tr.exit((Object)this, (TraceComponent)$$$tc$$$, (String)"<init>", (Object)this);
                }
            }

            @Override
            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
            public String[] run() {
                if (TraceComponent.isAnyTracingEnabled() && $$$tc$$$ != null && $$$tc$$$.isEntryEnabled()) {
                    Tr.entry((Object)this, (TraceComponent)$$$tc$$$, (String)"run", (Object[])new Object[0]);
                }
                Class[] classes = MissingDoPrivDetectionSecurityManager.this.getClassContext();
                StringBuffer sb = new StringBuffer(classes.length * 100);
                sb.append(lineSep);
                String[] retMsg = new String[2];
                ProtectionDomain pd2 = null;
                for (int i = 0; i < classes.length; ++i) {
                    Class clazz = classes[i];
                    ProtectionDomain pd = clazz.getProtectionDomain();
                    if (classes[i].getName().indexOf("com.ibm.ws.kernel.launch.internal.MissingDoPrivDetectionSecurityManager") != -1) {
                        for (int j = i + 1; j < classes.length; ++j) {
                            pd2 = classes[j].getProtectionDomain();
                            if (!MissingDoPrivDetectionSecurityManager.this.isOffendingClass(classes, j, pd2, inPerm)) continue;
                            retMsg[0] = lineSep + lineSep + "     " + classes[j].getName() + "  in  " + "{" + MissingDoPrivDetectionSecurityManager.this.getCodeSource(pd2) + "}" + lineSep + lineSep;
                            StringBuffer sb2 = new StringBuffer(classes.length * 100);
                            sb2.append(lineSep);
                            sb2.append(classes[j].getName()).append(" : ").append(MissingDoPrivDetectionSecurityManager.this.getCodeSource(pd2) + lineSep);
                            sb2.append("  ").append(MissingDoPrivDetectionSecurityManager.this.permissionToString(pd2.getCodeSource(), classes[j].getClassLoader(), pd2.getPermissions())).append(lineSep);
                            break;
                        }
                    }
                    CodeSource cs = pd.getCodeSource();
                    String csStr = MissingDoPrivDetectionSecurityManager.this.getCodeSource(pd);
                    sb.append(classes[i].getName()).append(" : ").append(csStr + lineSep);
                    sb.append("  ").append(MissingDoPrivDetectionSecurityManager.this.permissionToString(cs, clazz.getClassLoader(), pd.getPermissions())).append(lineSep);
                }
                Tr.info((TraceComponent)tc, (String)"java.security.permdenied.class.info", (Object[])new Object[]{retMsg[0]});
                Tr.info((TraceComponent)tc, (String)"java.security.permdenied.codebaseloc.info", (Object[])new Object[]{sb.toString()});
                retMsg[1] = MissingDoPrivDetectionSecurityManager.this.getCodeSource(pd2).concat(lineSep);
                String[] stringArray = retMsg;
                if (TraceComponent.isAnyTracingEnabled() && $$$tc$$$ != null && $$$tc$$$.isEntryEnabled()) {
                    stringArray = stringArray;
                    Tr.exit((Object)this, (TraceComponent)$$$tc$$$, (String)"run", (Object)stringArray);
                }
                return stringArray;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(2.class);
            }
        });
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            stringArray = stringArray;
            Tr.exit((Object)this, (TraceComponent)tc, (String)"getCodeBaseLocForPerm", (Object)stringArray);
        }
        return stringArray;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    public String getCodeSource(ProtectionDomain pd) {
        URL url;
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"getCodeSource", (Object[])new Object[]{pd});
        }
        CodeSource cs = pd.getCodeSource();
        String csStr = null;
        csStr = cs == null ? "null code source" : ((url = cs.getLocation()) == null ? "null code URL" : url.toString());
        String string = csStr;
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            string = string;
            Tr.exit((Object)this, (TraceComponent)tc, (String)"getCodeSource", (Object)string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    public String permissionToString(CodeSource cs, ClassLoader classloaderClass, PermissionCollection col) {
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"permissionToString", (Object[])new Object[]{cs, classloaderClass, col});
        }
        StringBuffer buf = new StringBuffer("ClassLoader: ");
        if (classloaderClass == null) {
            buf.append("Primordial Classloader");
        } else {
            buf.append(classloaderClass.getClass().getName());
        }
        buf.append(lineSep);
        buf.append("  Permissions granted to CodeSource ").append(cs).append(lineSep);
        if (col != null) {
            Enumeration<Permission> e = col.elements();
            buf.append("  {").append(lineSep);
            while (e.hasMoreElements()) {
                Permission p = e.nextElement();
                buf.append("    ").append(p.toString()).append(";").append(lineSep);
            }
            buf.append("  }");
        } else {
            buf.append("  {").append(lineSep).append("  }");
        }
        String string = buf.toString();
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            string = string;
            Tr.exit((Object)this, (TraceComponent)tc, (String)"permissionToString", (Object)string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    boolean isOffendingClass(Class<?>[] classes, int j, ProtectionDomain pd2, Permission inPerm) {
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"isOffendingClass", (Object[])new Object[]{classes, j, pd2, inPerm});
        }
        boolean bl = !classes[j].getName().startsWith("java") && classes[j].getName().indexOf("com.ibm.ws.kernel.launch.internal.MissingDoPrivDetectionSecurityManager") == -1 && classes[j].getName().indexOf("ClassLoader") == -1 && (j == classes.length - 1 || classes[j + 1].getName().indexOf("ClassLoader") == -1) && !pd2.implies(inPerm);
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            bl = bl;
            Tr.exit((Object)this, (TraceComponent)tc, (String)"isOffendingClass", (Object)bl);
        }
        return bl;
    }
}

