/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.launch.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.kernel.LibertyProcess;
import com.ibm.ws.kernel.boot.ReturnCode;
import com.ibm.ws.kernel.boot.internal.commands.JavaDumpAction;
import com.ibm.ws.kernel.boot.internal.commands.ServerDumpPackager;
import com.ibm.ws.kernel.launch.internal.FrameworkManager;
import com.ibm.ws.kernel.provisioning.VersionUtility;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class LibertyProcessImpl
implements LibertyProcess {
    private List<String> argList;
    private final FrameworkManager frameworkMgr;
    static final long serialVersionUID = 3220471380775276842L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    public LibertyProcessImpl(List<String> args, FrameworkManager frameworkMgr) {
        if (TraceComponent.isAnyTracingEnabled() && $$$tc$$$ != null && $$$tc$$$.isEntryEnabled()) {
            Tr.entry((TraceComponent)$$$tc$$$, (String)"<init>", (Object[])new Object[]{args, frameworkMgr});
        }
        this.argList = args == null ? new ArrayList<String>() : args;
        this.frameworkMgr = frameworkMgr;
        if (TraceComponent.isAnyTracingEnabled() && $$$tc$$$ != null && $$$tc$$$.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)$$$tc$$$, (String)"<init>", (Object)this);
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    public String[] getArgs() {
        if (TraceComponent.isAnyTracingEnabled() && $$$tc$$$ != null && $$$tc$$$.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)$$$tc$$$, (String)"getArgs", (Object[])new Object[0]);
        }
        String[] stringArray = this.argList.toArray(new String[this.argList.size()]);
        if (TraceComponent.isAnyTracingEnabled() && $$$tc$$$ != null && $$$tc$$$.isEntryEnabled()) {
            stringArray = stringArray;
            Tr.exit((Object)this, (TraceComponent)$$$tc$$$, (String)"getArgs", (Object)stringArray);
        }
        return stringArray;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    public void shutdown() {
        if (TraceComponent.isAnyTracingEnabled() && $$$tc$$$ != null && $$$tc$$$.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)$$$tc$$$, (String)"shutdown", (Object[])new Object[0]);
        }
        this.frameworkMgr.shutdownFramework();
        if (TraceComponent.isAnyTracingEnabled() && $$$tc$$$ != null && $$$tc$$$.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)$$$tc$$$, (String)"shutdown");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    public Dictionary<String, ?> getServiceProps() {
        if (TraceComponent.isAnyTracingEnabled() && $$$tc$$$ != null && $$$tc$$$.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)$$$tc$$$, (String)"getServiceProps", (Object[])new Object[0]);
        }
        Hashtable<String, Object> d = new Hashtable<String, Object>();
        d.put("commandline.args", this.getArgs());
        String version = System.getProperty("java.specification.version");
        if (version != null) {
            try {
                d.put("java.specification.version", VersionUtility.stringToVersion(version));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                FFDCFilter.processException((Throwable)illegalArgumentException, (String)"com.ibm.ws.kernel.launch.internal.LibertyProcessImpl", (String)"89", (Object)this, (Object[])new Object[0]);
            }
        }
        d.put("wlp.process.type", this.frameworkMgr.config.getProcessType());
        Hashtable<String, Object> hashtable = d;
        if (TraceComponent.isAnyTracingEnabled() && $$$tc$$$ != null && $$$tc$$$.isEntryEnabled()) {
            hashtable = hashtable;
            Tr.exit((Object)this, (TraceComponent)$$$tc$$$, (String)"getServiceProps", hashtable);
        }
        return hashtable;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    public void createJavaDump(Set<String> requestedDumps) {
        if (TraceComponent.isAnyTracingEnabled() && $$$tc$$$ != null && $$$tc$$$.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)$$$tc$$$, (String)"createJavaDump", (Object[])new Object[]{requestedDumps});
        }
        this.frameworkMgr.dumpJava(this.parseJavaDumpActions(requestedDumps));
        if (TraceComponent.isAnyTracingEnabled() && $$$tc$$$ != null && $$$tc$$$.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)$$$tc$$$, (String)"createJavaDump");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    public String createServerDump(Set<String> includedDumps) {
        if (TraceComponent.isAnyTracingEnabled() && $$$tc$$$ != null && $$$tc$$$.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)$$$tc$$$, (String)"createServerDump", (Object[])new Object[]{includedDumps});
        }
        ServerDumpPackager sdp = new ServerDumpPackager(this.frameworkMgr.config, null);
        sdp.initializeDumpDirectory();
        this.frameworkMgr.introspectFramework(sdp.getDumpTimestamp(), this.parseJavaDumpActions(includedDumps));
        ReturnCode rc = ReturnCode.OK;
        rc = includedDumps == null || includedDumps.isEmpty() ? sdp.packageDump(false) : sdp.packageDump(true);
        sdp.cleanupDumpDirectory();
        if (rc == ReturnCode.OK) {
            String string = sdp.getDumpFile().getAbsolutePath();
            if (TraceComponent.isAnyTracingEnabled() && $$$tc$$$ != null && $$$tc$$$.isEntryEnabled()) {
                string = string;
                Tr.exit((Object)this, (TraceComponent)$$$tc$$$, (String)"createServerDump", (Object)string);
            }
            return string;
        }
        String string = null;
        if (TraceComponent.isAnyTracingEnabled() && $$$tc$$$ != null && $$$tc$$$.isEntryEnabled()) {
            string = string;
            Tr.exit((Object)this, (TraceComponent)$$$tc$$$, (String)"createServerDump", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    private Set<JavaDumpAction> parseJavaDumpActions(Set<String> namedDumpActions) {
        if (TraceComponent.isAnyTracingEnabled() && $$$tc$$$ != null && $$$tc$$$.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)$$$tc$$$, (String)"parseJavaDumpActions", (Object[])new Object[]{namedDumpActions});
        }
        LinkedHashSet<JavaDumpAction> parsedActions = new LinkedHashSet<JavaDumpAction>();
        for (String namedDumpAction : namedDumpActions) {
            JavaDumpAction parsedAction = JavaDumpAction.forDisplayName(namedDumpAction);
            if (parsedAction == null) continue;
            parsedActions.add(parsedAction);
        }
        LinkedHashSet<JavaDumpAction> linkedHashSet = parsedActions;
        if (TraceComponent.isAnyTracingEnabled() && $$$tc$$$ != null && $$$tc$$$.isEntryEnabled()) {
            linkedHashSet = linkedHashSet;
            Tr.exit((Object)this, (TraceComponent)$$$tc$$$, (String)"parseJavaDumpActions", linkedHashSet);
        }
        return linkedHashSet;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(LibertyProcessImpl.class);
    }
}

