/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.boot.logging;

import com.ibm.ws.kernel.boot.delegated.zos.NativeMethodHelper;
import com.ibm.ws.kernel.boot.internal.BootstrapConstants;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.Iterator;

class TaggedFileOutputStream
extends FileOutputStream {
    private static final boolean initialized = TaggedFileOutputStream.registerNatives();
    private static boolean taggingFailedIssued = false;
    private static int fileEncodingCcsid = TaggedFileOutputStream.acquireFileEncodingCcsid();

    TaggedFileOutputStream(File file, boolean append) throws IOException {
        super(file, append);
        this.setFileTag(file);
    }

    void setFileTag(File file) throws IOException {
        int returnCode;
        if (initialized && fileEncodingCcsid != 0 && (returnCode = this.setFileTag(file.getAbsolutePath(), fileEncodingCcsid)) != 0) {
            this.issueTaggingFailedMessage(returnCode);
        }
    }

    int setFileTag(String file, int ccsid) {
        return this.ntv_setFileTag(file, ccsid);
    }

    private synchronized void issueTaggingFailedMessage(int returnCode) {
        if (taggingFailedIssued) {
            return;
        }
        System.err.println(MessageFormat.format(BootstrapConstants.messages.getString("warn.unableTagFile"), returnCode));
        taggingFailedIssued = true;
    }

    private static boolean registerNatives() {
        try {
            String methodDescriptor = "zJNIBOOT_" + TaggedFileOutputStream.class.getCanonicalName().replaceAll("\\.", "_");
            long dllHandle = NativeMethodHelper.registerNatives(TaggedFileOutputStream.class, methodDescriptor, null);
            if (dllHandle > 0L) {
                return true;
            }
            if (dllHandle == 0L) {
                return false;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        System.err.println(MessageFormat.format(BootstrapConstants.messages.getString("warn.registerNative"), TaggedFileOutputStream.class.getCanonicalName()));
        return false;
    }

    private static int acquireFileEncodingCcsid() {
        Charset charset = null;
        String fileEncoding = System.getProperty("file.encoding");
        try {
            charset = Charset.forName(fileEncoding);
        }
        catch (Throwable t) {
            // empty catch block
        }
        int ccsid = TaggedFileOutputStream.getCcsid(charset);
        if (ccsid == 0) {
            System.err.println(MessageFormat.format(BootstrapConstants.messages.getString("warn.fileEncodingNotFound"), fileEncoding));
        }
        return ccsid;
    }

    private static int getCcsid(Charset charset) {
        int ccsid;
        block3: {
            String encoding;
            ccsid = 0;
            if (charset == null) {
                return 0;
            }
            if (ccsid == 0) {
                ccsid = TaggedFileOutputStream.getCcsid(charset.name());
            }
            if (ccsid != 0) break block3;
            Iterator<String> i$ = charset.aliases().iterator();
            while (i$.hasNext() && (ccsid = TaggedFileOutputStream.getCcsid(encoding = i$.next())) <= 0) {
            }
        }
        return ccsid;
    }

    private static int getCcsid(String encoding) {
        if (!initialized) {
            return -1;
        }
        return TaggedFileOutputStream.ntv_getCcsid(encoding);
    }

    private native int ntv_setFileTag(String var1, int var2);

    private static native int ntv_getCcsid(String var0);
}

