/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.boot.internal;

import com.ibm.ws.kernel.boot.Debug;
import com.ibm.ws.kernel.boot.LaunchException;
import com.ibm.ws.kernel.boot.cmdline.Utils;
import com.ibm.ws.kernel.boot.internal.BootstrapConstants;
import com.ibm.ws.kernel.boot.internal.KernelStartLevel;
import com.ibm.ws.kernel.provisioning.NameBasedLocalBundleRepository;
import com.ibm.ws.kernel.provisioning.VersionUtility;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.regex.Pattern;

public class KernelResolver {
    public static final String CACHE_FILE = "platform/kernel.cache";
    private static final String LOG_PROVIDER = "WebSphere-LogProvider";
    private static final String SUBSYSTEM_CONTENT = "Subsystem-Content";
    private static final String INCLUDED_FILE = "osgi.subsystem.feature";
    private static final String MANIFEST_EXPORT_PACKAGE = "Export-Package";
    private static final String INUSE_KERNEL_FEATURES = "@=";
    private static final String TYPE = "type=";
    private static final String BOOT_JAR_TYPE = "boot.jar";
    private static final String BUNDLE_TYPE = "osgi.bundle";
    private static final String BUNDLE_LINE = "--|";
    private static final String LOCATION = "location:=";
    private static final String VERSION = "version=";
    private static final String START_PHASE = "start-phase:=";
    private static final String NL = System.getProperty("line.separator");
    private static final List<File> emptyList = Collections.emptyList();
    private static final String SPLIT_CHAR = ";";
    private static final Pattern splitPattern = Pattern.compile(";");
    private final NameBasedLocalBundleRepository repo;
    private final ResolverCache cache;
    private final String logProviderClass;
    private final File kernelMf;
    private final File logProviderMf;
    private final File osExtensionMf;
    private final boolean forceCleanStart;

    public KernelResolver(File installRoot, File cacheFile, String kernelDefName, String logProviderName, String osExtensionName) {
        boolean cacheAvailable = cacheFile != null && cacheFile.exists();
        boolean cleanStart = false;
        this.cache = new ResolverCache(cacheFile);
        this.cache.load();
        ArrayList<String> kernelFeatures = new ArrayList<String>();
        kernelFeatures.add(logProviderName);
        kernelFeatures.add(kernelDefName);
        if (osExtensionName != null) {
            kernelFeatures.add(osExtensionName);
        }
        if (this.kernelFeaturesHaveChanged(this.cache.featuresInUse, kernelFeatures)) {
            this.cache.dispose();
            cleanStart = true;
        }
        try {
            this.repo = new NameBasedLocalBundleRepository(installRoot);
            File platformDir = new File(installRoot, "lib/platform");
            if (logProviderName == null || logProviderName.trim().length() == 0) {
                this.logThrowLaunchException(new LaunchException("Log provider definition not found (Tr/FFDC)", BootstrapConstants.messages.getString("error.rasProvider")));
            }
            this.logProviderMf = new File(platformDir, logProviderName + ".mf");
            if (!this.logProviderMf.exists()) {
                this.logThrowLaunchException(new LaunchException("Kernel definition could not be found: " + this.logProviderMf.getAbsolutePath(), MessageFormat.format(BootstrapConstants.messages.getString("error.kernelDefFile"), logProviderName)));
            }
            ManifestCacheElement entry = this.cache.checkEntry(this.logProviderMf, true, this.repo);
            this.logProviderClass = entry.getLogProviderClass();
            if (this.logProviderClass == null) {
                this.logThrowLaunchException(new LaunchException("A log provider implementation was not defined", BootstrapConstants.messages.getString("error.rasProvider")));
            }
            if (kernelDefName == null || kernelDefName.trim().length() == 0) {
                this.logThrowLaunchException(new LaunchException("Could not find kernel definition", BootstrapConstants.messages.getString("error.kernelDef")));
            }
            this.kernelMf = new File(platformDir, kernelDefName + ".mf");
            if (!this.kernelMf.exists()) {
                this.logThrowLaunchException(new LaunchException("Kernel definition could not be found: " + this.kernelMf.getAbsolutePath(), MessageFormat.format(BootstrapConstants.messages.getString("error.kernelDefFile"), kernelDefName)));
            }
            this.cache.checkEntry(this.kernelMf, false, this.repo);
            if (osExtensionName != null) {
                this.osExtensionMf = new File(platformDir, osExtensionName + ".mf");
                if (!this.osExtensionMf.exists()) {
                    this.logThrowLaunchException(new LaunchException("Kernel definition could not be found: " + this.osExtensionMf.getAbsolutePath(), MessageFormat.format(BootstrapConstants.messages.getString("error.kernelDefFile"), osExtensionName)));
                }
                this.cache.checkEntry(this.osExtensionMf, true, this.repo);
            } else {
                this.osExtensionMf = null;
            }
            this.cache.featuresInUse = kernelFeatures;
        }
        catch (LaunchException e) {
            this.cache.delete();
            throw e;
        }
        this.forceCleanStart = cacheAvailable && (cleanStart |= this.cache.isDirty);
    }

    private boolean kernelFeaturesHaveChanged(List<String> featuresInUse, List<String> kernelFeatures) {
        if (featuresInUse.isEmpty()) {
            return false;
        }
        if (featuresInUse.size() == kernelFeatures.size()) {
            return !featuresInUse.containsAll(kernelFeatures);
        }
        return true;
    }

    private void logThrowLaunchException(LaunchException e) {
        Debug.printStackTrace(e);
        throw e;
    }

    public boolean getForceCleanStart() {
        return this.forceCleanStart;
    }

    public String getLogProvider() {
        return this.logProviderClass;
    }

    public void addBootJars(List<URL> urlList) {
        this.addBootJars(this.cache.getJarFiles(this.kernelMf), urlList);
        this.addBootJars(this.cache.getJarFiles(this.logProviderMf), urlList);
        if (this.osExtensionMf != null) {
            this.addBootJars(this.cache.getJarFiles(this.osExtensionMf), urlList);
        }
    }

    private void addBootJars(List<File> jarFiles, List<URL> urlList) {
        for (File jarFile : jarFiles) {
            try {
                urlList.add(jarFile.toURI().toURL());
            }
            catch (MalformedURLException e) {}
        }
    }

    public String appendExtraSystemPackages(String packages) {
        packages = this.appendExtraSystemPackages(this.cache.getJarFiles(this.kernelMf), packages);
        packages = this.appendExtraSystemPackages(this.cache.getJarFiles(this.logProviderMf), packages);
        if (this.osExtensionMf != null) {
            packages = this.appendExtraSystemPackages(this.cache.getJarFiles(this.osExtensionMf), packages);
        }
        return packages;
    }

    private String appendExtraSystemPackages(List<File> files, String packages) {
        for (File file : files) {
            JarFile jarFile;
            block5: {
                if (file.getName().contains("org.eclipse.osgi")) continue;
                jarFile = null;
                Manifest manifest = null;
                Attributes attrs = null;
                try {
                    jarFile = new JarFile(file);
                    manifest = jarFile.getManifest();
                    attrs = manifest.getMainAttributes();
                    String mPackages = attrs.getValue(MANIFEST_EXPORT_PACKAGE);
                    if (mPackages == null || mPackages.isEmpty()) break block5;
                    packages = packages == null ? mPackages : packages + "," + mPackages;
                }
                catch (IOException e) {
                    try {
                        throw new LaunchException("Exception loading log provider jar " + (jarFile != null ? jarFile.getName() : "null") + ", " + e, MessageFormat.format(BootstrapConstants.messages.getString("error.rasProviderResolve"), jarFile != null ? jarFile.getName() : "null"), e);
                    }
                    catch (Throwable throwable) {
                        Utils.tryToClose(jarFile);
                        throw throwable;
                    }
                }
            }
            Utils.tryToClose(jarFile);
        }
        return packages;
    }

    public List<KernelBundleElement> getKernelBundles() {
        ArrayList<KernelBundleElement> elements = new ArrayList<KernelBundleElement>();
        for (ManifestCacheElement mEntry : this.cache.getManifestElements()) {
            elements.addAll(mEntry.getBundleElements());
        }
        return elements;
    }

    public void dispose() {
        this.cache.store();
        this.cache.dispose();
    }

    static class SubsystemContentElement {
        final String symbolicName;
        final String type;
        final String location;
        final String vrangeString;
        final String startPhase;

        SubsystemContentElement(String line) {
            String[] parts;
            String name = null;
            String type = null;
            String version = null;
            String location = null;
            String startPhase = null;
            if (line.endsWith(",")) {
                line = line.substring(0, line.length() - 1);
            }
            if ((parts = line.split(KernelResolver.SPLIT_CHAR)).length > 1) {
                name = parts[0].trim();
                for (int i = 1; i < parts.length; ++i) {
                    String part = parts[i].trim();
                    if (part.startsWith(KernelResolver.TYPE)) {
                        type = part.substring(KernelResolver.TYPE.length());
                        continue;
                    }
                    if (part.startsWith(KernelResolver.VERSION)) {
                        version = part.substring(KernelResolver.VERSION.length());
                        continue;
                    }
                    if (part.startsWith(KernelResolver.LOCATION)) {
                        location = part.substring(KernelResolver.LOCATION.length());
                        continue;
                    }
                    if (!part.startsWith(KernelResolver.START_PHASE)) continue;
                    startPhase = part.substring(KernelResolver.START_PHASE.length());
                }
            }
            this.symbolicName = name;
            this.type = this.stripQuotes(type);
            this.location = this.stripQuotes(location);
            this.vrangeString = this.stripQuotes(version);
            this.startPhase = this.stripQuotes(startPhase);
        }

        private String stripQuotes(String in) {
            if (in != null && in.length() > 1 && in.length() > 1 && in.startsWith("\"") && in.endsWith("\"")) {
                return in.substring(1, in.length() - 1);
            }
            return in;
        }

        public String toString() {
            String result = this.symbolicName + KernelResolver.SPLIT_CHAR + (this.vrangeString == null ? "" : "version=\"" + this.vrangeString + "\";") + (this.location == null ? "" : "location:=\"" + this.location + "\";") + (this.type == null ? "" : "type=\"" + this.type + "\";") + (this.startPhase == null ? "" : "start-phase:=\"" + this.startPhase + "\";");
            return result.substring(0, result.length() - 1);
        }
    }

    private static class BundleCacheElement
    implements KernelBundleElement {
        private final SubsystemContentElement element;
        private final int startLevel;
        private final ResolverCache cache;
        private File bestMatchFile;

        public BundleCacheElement(ResolverCache cache, SubsystemContentElement element) throws IOException {
            this.cache = cache;
            this.element = element;
            this.bestMatchFile = null;
            if (element.startPhase != null) {
                try {
                    KernelStartLevel level = KernelStartLevel.valueOf(element.startPhase);
                    this.startLevel = level.getLevel();
                }
                catch (IllegalArgumentException e) {
                    throw new IOException("Invalid value for start phase " + element.startPhase);
                }
            } else {
                this.startLevel = KernelStartLevel.ACTIVE.startLevel;
            }
        }

        BundleCacheElement(ResolverCache cache, String str) throws IOException {
            this.cache = cache;
            int index = str.indexOf(124);
            this.element = new SubsystemContentElement(str.substring(0, index));
            File file = this.bestMatchFile = index + 1 < str.length() ? new File(str.substring(index + 1)) : null;
            if (this.element.startPhase != null) {
                try {
                    KernelStartLevel level = KernelStartLevel.valueOf(this.element.startPhase);
                    this.startLevel = level.startLevel;
                }
                catch (IllegalArgumentException e) {
                    throw new IOException("cache invalid or out of sync, invalid value for start phase " + this.element.startPhase);
                }
            } else {
                this.startLevel = KernelStartLevel.ACTIVE.startLevel;
            }
        }

        public void write(PrintWriter writer) {
            writer.write(this.element.toString());
            writer.write(124);
            writer.write(this.bestMatchFile == null ? "" : this.bestMatchFile.getAbsolutePath());
        }

        @Override
        public String getSymbolicName() {
            return this.element.symbolicName;
        }

        @Override
        public String getRangeString() {
            return this.element.vrangeString;
        }

        @Override
        public String getLocation() {
            return this.element.location;
        }

        @Override
        public File getCachedBestMatch() {
            return this.bestMatchFile;
        }

        @Override
        public void setBestMatch(File f) {
            this.bestMatchFile = f;
            this.cache.isDirty = true;
        }

        @Override
        public int getStartLevel() {
            return this.startLevel;
        }

        public String toString() {
            return this.element.toString() + (this.bestMatchFile == null ? "" : ";path=\"" + this.bestMatchFile.getAbsolutePath() + '\"');
        }

        @Override
        public String toNameVersionString() {
            return this.element.symbolicName + KernelResolver.SPLIT_CHAR + KernelResolver.VERSION + '\"' + this.element.vrangeString + '\"';
        }
    }

    private static final class ManifestCacheElement {
        private final Map<String, BundleCacheElement> bundleEntries;
        private final String mfSymbolicName;
        private final String location;
        private final long lastModified;
        private final long fileSize;
        private final List<File> bootJarList;
        private final List<File> includedFileList;
        private final String logProviderClass;

        ManifestCacheElement(File newFile, List<File> jarFiles, List<File> includedFiles, String lpClass, Map<String, BundleCacheElement> bundleEntries) {
            this.mfSymbolicName = newFile.getName();
            this.location = newFile.getAbsolutePath();
            this.lastModified = newFile.lastModified();
            this.fileSize = newFile.length();
            this.bootJarList = jarFiles;
            this.includedFileList = includedFiles;
            this.logProviderClass = lpClass;
            this.bundleEntries = bundleEntries;
        }

        ManifestCacheElement(String str) {
            int index = str.indexOf(61);
            this.mfSymbolicName = str.substring(0, index);
            String[] parts = splitPattern.split(str.substring(index + 1));
            this.location = parts.length > 0 ? parts[0] : null;
            this.lastModified = parts.length > 1 ? Long.parseLong(parts[1]) : -1L;
            this.fileSize = parts.length > 2 ? Long.parseLong(parts[2]) : -1L;
            this.bootJarList = parts.length > 3 ? this.toFileList(parts[3]) : emptyList;
            this.includedFileList = parts.length > 4 ? this.toFileList(parts[4]) : emptyList;
            this.logProviderClass = parts.length > 5 ? parts[5] : null;
            this.bundleEntries = new LinkedHashMap<String, BundleCacheElement>();
        }

        void addBundleEntry(String symbolicName, BundleCacheElement value) {
            this.bundleEntries.put(symbolicName, value);
        }

        void write(PrintWriter writer) {
            writer.write(this.mfSymbolicName);
            writer.write(61);
            writer.write(this.location);
            writer.write(KernelResolver.SPLIT_CHAR);
            writer.write(String.valueOf(this.lastModified));
            writer.write(KernelResolver.SPLIT_CHAR);
            writer.write(String.valueOf(this.fileSize));
            writer.write(KernelResolver.SPLIT_CHAR);
            writer.write(this.fileListToString(this.bootJarList));
            writer.write(KernelResolver.SPLIT_CHAR);
            writer.write(this.fileListToString(this.includedFileList));
            writer.write(KernelResolver.SPLIT_CHAR);
            writer.write(this.logProviderClass == null ? "" : this.logProviderClass);
        }

        public String getLogProviderClass() {
            return this.logProviderClass;
        }

        public boolean isUsable(File compareFile, ResolverCache cache) {
            return this.location.equals(compareFile.getAbsolutePath()) && this.lastModified == compareFile.lastModified() && this.fileSize == compareFile.length() && this.usableIncludes(cache);
        }

        private boolean usableIncludes(ResolverCache cache) {
            boolean usable = true;
            for (File f : this.includedFileList) {
                ManifestCacheElement entry = cache.get(f);
                if (!f.exists() || entry == null) {
                    return false;
                }
                usable |= entry.isUsable(f, cache);
            }
            return usable;
        }

        private String fileListToString(List<File> files) {
            if (files == null || files.isEmpty()) {
                return "";
            }
            StringBuilder s = new StringBuilder();
            for (File f : files) {
                s.append(f.getAbsolutePath()).append(",");
            }
            return s.substring(0, s.length() - 1);
        }

        private List<File> toFileList(String str) {
            String[] parts;
            if (str != null && !str.isEmpty() && (parts = str.split(",")).length > 0) {
                ArrayList<File> list = new ArrayList<File>(parts.length);
                for (String s : parts) {
                    if (s.isEmpty()) continue;
                    list.add(new File(s));
                }
                return list;
            }
            return Collections.emptyList();
        }

        public Collection<BundleCacheElement> getBundleElements() {
            return this.bundleEntries.values();
        }

        public void dispose() {
            this.bundleEntries.clear();
        }
    }

    private static class ResolverCache {
        private final Map<String, ManifestCacheElement> cacheEntries = new LinkedHashMap<String, ManifestCacheElement>();
        private final File cacheFile;
        private List<String> featuresInUse = Collections.emptyList();
        private boolean isDirty = false;

        ResolverCache(File cacheFile) {
            this.cacheFile = cacheFile;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void load() {
            if (this.cacheFile != null && this.cacheFile.exists()) {
                BufferedReader reader = null;
                try {
                    String line;
                    ManifestCacheElement currentEntry = null;
                    reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.cacheFile), "UTF-8"));
                    while ((line = reader.readLine()) != null) {
                        if (line.startsWith(KernelResolver.BUNDLE_LINE)) {
                            if (currentEntry == null) {
                                throw new IOException("Cache file contents corrupted");
                            }
                            if ((line = line.substring(KernelResolver.BUNDLE_LINE.length())).startsWith(currentEntry.mfSymbolicName)) {
                                line = line.substring(currentEntry.mfSymbolicName.length() + 1);
                                BundleCacheElement bEntry = new BundleCacheElement(this, line);
                                currentEntry.addBundleEntry(bEntry.getSymbolicName(), bEntry);
                                continue;
                            }
                            throw new IOException("Cache file contents corrupted");
                        }
                        if (line.startsWith(KernelResolver.INUSE_KERNEL_FEATURES)) {
                            String[] parts = line.substring(KernelResolver.INUSE_KERNEL_FEATURES.length()).split(KernelResolver.SPLIT_CHAR);
                            if (parts.length > 0) {
                                this.featuresInUse = Arrays.asList(parts);
                                continue;
                            }
                            this.featuresInUse = Collections.emptyList();
                            continue;
                        }
                        currentEntry = new ManifestCacheElement(line);
                        this.cacheEntries.put(currentEntry.mfSymbolicName, currentEntry);
                    }
                    Utils.tryToClose(reader);
                }
                catch (IOException e) {
                    this.cacheEntries.clear();
                }
                finally {
                    Utils.tryToClose(reader);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void store() {
            if (this.cacheFile != null && this.isDirty) {
                PrintWriter writer = null;
                try {
                    boolean parentExists = true;
                    File parent = this.cacheFile.getParentFile();
                    if (!parent.exists()) {
                        parentExists = parent.mkdirs();
                    }
                    if (!parentExists) {
                        throw new IOException("Unable to create parent(s) of file " + this.cacheFile.getAbsolutePath());
                    }
                    writer = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.cacheFile), "UTF-8"));
                    for (ManifestCacheElement entry : this.cacheEntries.values()) {
                        entry.write(writer);
                        writer.write(NL);
                        for (BundleCacheElement bEntry : entry.getBundleElements()) {
                            writer.write(KernelResolver.BUNDLE_LINE);
                            writer.write(entry.mfSymbolicName);
                            writer.write(124);
                            bEntry.write(writer);
                            writer.write(NL);
                        }
                    }
                    writer.write(KernelResolver.INUSE_KERNEL_FEATURES);
                    boolean isFirst = true;
                    for (String s : this.featuresInUse) {
                        if (isFirst) {
                            isFirst = false;
                        } else {
                            writer.write(59);
                        }
                        writer.write(s);
                    }
                    writer.write(NL);
                    writer.flush();
                    this.isDirty = false;
                    Utils.tryToClose(writer);
                }
                catch (IOException e) {
                    System.out.println(MessageFormat.format(BootstrapConstants.messages.getString("warning.noPlatformCache"), this.cacheFile.getName(), e));
                }
                finally {
                    Utils.tryToClose(writer);
                }
            }
        }

        public void delete() {
            if (this.cacheFile != null && this.cacheFile.exists()) {
                this.cacheFile.delete();
            }
        }

        public ManifestCacheElement checkEntry(File mfFile, boolean followIncludes, NameBasedLocalBundleRepository repo) {
            Object element;
            ManifestCacheElement entry = this.cacheEntries.get(mfFile.getName());
            if (entry != null && entry.isUsable(mfFile, this)) {
                return entry;
            }
            this.isDirty = true;
            boolean inSubsystemContent = false;
            BufferedReader reader = null;
            String logProvider = null;
            ArrayList<File> jarList = new ArrayList<File>();
            ArrayList<File> fileList = new ArrayList<File>();
            LinkedHashMap<String, BundleCacheElement> bundleEntries = new LinkedHashMap<String, BundleCacheElement>();
            try {
                String line;
                reader = new BufferedReader(new InputStreamReader(new FileInputStream(mfFile)));
                while ((line = reader.readLine()) != null) {
                    if (line.isEmpty() || line.startsWith("#")) {
                        inSubsystemContent = false;
                        continue;
                    }
                    if (line.startsWith(KernelResolver.LOG_PROVIDER) && logProvider == null) {
                        if (line.length() <= KernelResolver.LOG_PROVIDER.length() + 1) continue;
                        logProvider = line.substring(KernelResolver.LOG_PROVIDER.length() + 1).trim();
                        continue;
                    }
                    if (line.startsWith(KernelResolver.SUBSYSTEM_CONTENT)) {
                        line = line.substring(KernelResolver.SUBSYSTEM_CONTENT.length() + 1).trim();
                        inSubsystemContent = true;
                    } else {
                        line = line.trim();
                    }
                    if (!inSubsystemContent) continue;
                    if (!line.endsWith(",")) {
                        inSubsystemContent = false;
                    }
                    if (line.contains(KernelResolver.BOOT_JAR_TYPE)) {
                        element = new SubsystemContentElement(line);
                        File bestMatchFile = repo.selectBundle(((SubsystemContentElement)element).symbolicName, VersionUtility.stringToVersionRange(((SubsystemContentElement)element).vrangeString));
                        if (bestMatchFile == null) {
                            throw new LaunchException("Could not find bundle for " + element + ".", BootstrapConstants.messages.getString("error.missingBundleException"));
                        }
                        jarList.add(bestMatchFile);
                        continue;
                    }
                    if (followIncludes && line.contains(KernelResolver.INCLUDED_FILE)) {
                        element = new SubsystemContentElement(line);
                        File includedManifest = null;
                        if (((SubsystemContentElement)element).location != null) {
                            includedManifest = new File(repo.getRootDirectory(), ((SubsystemContentElement)element).location);
                        }
                        if (includedManifest == null || !includedManifest.exists()) continue;
                        ManifestCacheElement included = this.checkEntry(includedManifest, followIncludes, repo);
                        fileList.add(includedManifest);
                        if (included.bootJarList != null) {
                            jarList.addAll(included.bootJarList);
                        }
                        if (included.includedFileList == null) continue;
                        fileList.addAll(included.includedFileList);
                        continue;
                    }
                    if (!line.contains(KernelResolver.BUNDLE_TYPE) && line.contains(KernelResolver.TYPE)) continue;
                    element = new SubsystemContentElement(line);
                    BundleCacheElement cacheElement = new BundleCacheElement(this, (SubsystemContentElement)element);
                    bundleEntries.put(((SubsystemContentElement)element).symbolicName, cacheElement);
                }
                entry = new ManifestCacheElement(mfFile, jarList, fileList, logProvider, bundleEntries);
                this.cacheEntries.put(mfFile.getName(), entry);
                element = entry;
            }
            catch (IOException e) {
                try {
                    throw new LaunchException("Kernel definition could not be read: " + mfFile.getAbsolutePath(), MessageFormat.format(BootstrapConstants.messages.getString("error.unknownException"), e));
                }
                catch (Throwable throwable) {
                    Utils.tryToClose(reader);
                    throw throwable;
                }
            }
            Utils.tryToClose(reader);
            return element;
        }

        public List<File> getJarFiles(File mfFile) {
            ManifestCacheElement entry;
            if (mfFile != null && (entry = this.cacheEntries.get(mfFile.getName())) != null) {
                return entry.bootJarList;
            }
            return Collections.emptyList();
        }

        private ManifestCacheElement get(File f) {
            return this.cacheEntries.get(f.getName());
        }

        public Collection<ManifestCacheElement> getManifestElements() {
            return this.cacheEntries.values();
        }

        public void dispose() {
            for (ManifestCacheElement element : this.cacheEntries.values()) {
                element.dispose();
            }
            this.cacheEntries.clear();
        }
    }

    public static interface KernelBundleElement {
        public String getSymbolicName();

        public String getRangeString();

        public String getLocation();

        public File getCachedBestMatch();

        public void setBestMatch(File var1);

        public int getStartLevel();

        public String toNameVersionString();
    }
}

