/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.injectionengine.ffdc;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.Util;
import com.ibm.ws.ffdc.DiagnosticModule;
import com.ibm.ws.ffdc.FFDC;
import com.ibm.ws.ffdc.IncidentStream;
import com.ibm.ws.injectionengine.AbstractInjectionEngine;
import com.ibm.ws.injectionengine.ffdc.Formattable;
import java.util.ArrayList;

public class InjectionDiagnosticModule
extends DiagnosticModule {
    private static final String CLASS_NAME = InjectionDiagnosticModule.class.getName();
    private static final TraceComponent tc = Tr.register((String)CLASS_NAME, (String)"Injection", (String)"com.ibm.wsspi.injectionengine.injection");
    private static InjectionDiagnosticModule svInstance = null;
    private boolean ivRegisteredWithFFDC = false;
    private AbstractInjectionEngine ivInjectionEngine = null;
    private String[] ivPackageList = new String[]{"com.ibm.ws.injectionengine", "com.ibm.wsspi.injectionengine"};

    private InjectionDiagnosticModule() {
    }

    public static synchronized InjectionDiagnosticModule instance() {
        if (svInstance == null) {
            svInstance = new InjectionDiagnosticModule();
        }
        return svInstance;
    }

    public synchronized void initialize(AbstractInjectionEngine service) {
        this.ivInjectionEngine = service;
    }

    public synchronized boolean registerWithFFDCService() {
        boolean result = true;
        boolean abort = false;
        int retCode = 0;
        int packageIndex = 0;
        if (this.ivRegisteredWithFFDC) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"InjectionDiagnosticModule already registered");
            }
            result = false;
            abort = true;
        }
        if (this.ivInjectionEngine == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"InjectionDiagnosticModule not initialized: registration with FFDC Service not performed");
            }
            result = false;
            abort = true;
        }
        while (!abort && packageIndex < this.ivPackageList.length) {
            retCode = FFDC.registerDiagnosticModule((DiagnosticModule)this, (String)this.ivPackageList[packageIndex]);
            switch (retCode) {
                case 0: {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break;
                    Tr.event((TraceComponent)tc, (String)("InjectionDiagnosticModule successfully registered for package " + this.ivPackageList[packageIndex]));
                    break;
                }
                case 1: {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)("Unable to register InjectionDiagnosticModule as another diagnostic module has already been registered with the package " + this.ivPackageList[packageIndex]));
                    }
                    result = false;
                    break;
                }
                case 2: {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)"Unable to register InjectionDiagnosticModule as it does not support the minimum diagnostic module interface.");
                    }
                    result = false;
                    abort = true;
                    break;
                }
                case 3: {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)"Unable to register InjectionDiagnosticModule due to an unknown failure.");
                    }
                    result = false;
                    abort = true;
                    break;
                }
                default: {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)("InjectionDiagnosticModule registration with " + this.ivPackageList[packageIndex] + " resulted in an " + "unexpected return code: " + retCode));
                    }
                    result = false;
                    abort = true;
                }
            }
            ++packageIndex;
        }
        return result;
    }

    public void ffdcDumpDefault(Throwable th, IncidentStream is, Object callerThis, Object[] o, String sourceId) {
        is.writeLine("", "*** Start InjectionDiagnosticModule Dump ***");
        if (o != null) {
            is.writeLine("", "> InjectionDiagnosticModule: dump Object array : " + o.length);
            ArrayList<Object> nonFormattable = new ArrayList<Object>();
            for (Object obj : o) {
                if (obj == this.ivInjectionEngine) continue;
                if (obj instanceof Formattable) {
                    ((Formattable)obj).formatTo(is);
                    continue;
                }
                nonFormattable.add(obj);
            }
            if (nonFormattable.size() > 0) {
                is.writeLine("", "");
                is.writeLine("", "   Non-Formattable :");
                for (Object e : nonFormattable) {
                    is.writeLine("", "      > " + Util.identity(e));
                    is.writeLine("", "           " + e);
                }
            }
            is.writeLine("", "< InjectionDiagnosticModule: dump Object array complete");
        }
        this.ivInjectionEngine.formatTo(is);
        is.writeLine("", "*** InjectionDiagnosticModule Dump Complete ***");
    }

    public static void main(String[] args) {
        InjectionDiagnosticModule dm = new InjectionDiagnosticModule();
        dm.validate();
    }
}

