/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.injectionengine;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.injectionengine.AbstractInjectionEngine;
import com.ibm.ws.javaee.dd.common.JNDIEnvironmentRef;
import com.ibm.wsspi.injectionengine.ComponentNameSpaceConfiguration;
import com.ibm.wsspi.injectionengine.InjectionConfigurationException;
import com.ibm.wsspi.injectionengine.InjectionException;
import com.ibm.wsspi.injectionengine.InjectionProcessor;
import com.ibm.wsspi.injectionengine.InjectionProcessorContextImpl;
import com.ibm.wsspi.injectionengine.InjectionProcessorProvider;
import com.ibm.wsspi.injectionengine.MethodMap;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class InjectionProcessorManager {
    private static final String CLASS_NAME = InjectionProcessorManager.class.getName();
    private static final TraceComponent tc = Tr.register(InjectionProcessorManager.class, (String)"Injection", (String)"com.ibm.wsspi.injectionengine.injection");
    private final AbstractInjectionEngine ivInjectionEngine;
    private final ComponentNameSpaceConfiguration ivNameSpaceConfig;
    private final InjectionProcessorContextImpl ivContext;
    private final List<InjectionProcessorProvider<?, ?>> ivProviders;
    private InjectionProcessor<?, ?>[] ivProcessors;
    private int[] ivOverrideIndices;

    public InjectionProcessorManager(AbstractInjectionEngine injectionEngine, ComponentNameSpaceConfiguration compNSConfig, InjectionProcessorContextImpl context, List<InjectionProcessorProvider<?, ?>> providers) {
        this.ivInjectionEngine = injectionEngine;
        this.ivNameSpaceConfig = compNSConfig;
        this.ivContext = context;
        this.ivProviders = providers;
        block0: for (int processorIndex = 0; processorIndex < providers.size(); ++processorIndex) {
            InjectionProcessorProvider<?, ?> provider = providers.get(processorIndex);
            Class<Annotation> overrideAnnClass = provider.getOverrideAnnotationClass();
            if (overrideAnnClass == null) continue;
            for (int overriddenProcessorIndex = 0; overriddenProcessorIndex < providers.size(); ++overriddenProcessorIndex) {
                if (overrideAnnClass != this.ivProviders.get(overriddenProcessorIndex).getAnnotationClass()) continue;
                if (this.ivOverrideIndices == null) {
                    this.ivOverrideIndices = new int[providers.size()];
                    Arrays.fill(this.ivOverrideIndices, -1);
                }
                this.ivOverrideIndices[overriddenProcessorIndex] = processorIndex;
                continue block0;
            }
        }
    }

    private <A extends Annotation, AS extends Annotation> InjectionProcessor<A, AS> getProcessor(int processorIndex, InjectionProcessorProvider<A, AS> provider) throws InjectionException {
        if (this.ivProcessors == null) {
            this.ivProcessors = new InjectionProcessor[this.ivProviders.size()];
        }
        if (this.ivProcessors[processorIndex] == null) {
            this.ivProcessors[processorIndex] = this.ivProviders.get(processorIndex).createInjectionProcessor();
            this.ivContext.initProcessor(this.ivProcessors[processorIndex], this.ivNameSpaceConfig);
        }
        InjectionProcessor<?, ?> processor = this.ivProcessors[processorIndex];
        return processor;
    }

    public void processXML() throws InjectionException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"processXML");
        }
        for (int processorIndex = 0; processorIndex < this.ivProviders.size(); ++processorIndex) {
            InjectionProcessorProvider<?, ?> provider = this.ivProviders.get(processorIndex);
            if (!this.isProcessXMLNeeded(provider)) continue;
            InjectionProcessor<?, ?> processor = this.getProcessor(processorIndex, provider);
            try {
                processor.processXML();
                continue;
            }
            catch (InjectionException iex) {
                FFDCFilter.processException((Throwable)iex, (String)(CLASS_NAME + ".processXML"), (String)"300", (Object)this, (Object[])new Object[]{processor});
                Tr.error((TraceComponent)tc, (String)"FAILED_TO_PROCESS_XML_FROM_DD_CWNEN0009E", (Object)new Object[]{iex.getMessage()});
                throw iex;
            }
            catch (Throwable t) {
                FFDCFilter.processException((Throwable)t, (String)(CLASS_NAME + ".processXML"), (String)"768", (Object)this, (Object[])new Object[]{processor});
                Tr.error((TraceComponent)tc, (String)"FAILED_TO_PROCESS_XML_FROM_DD_CWNEN0009E", (Object)new Object[]{t});
                throw new InjectionConfigurationException("Failed to process xml from Deployment Descriptor.", t);
            }
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"processXML");
        }
    }

    private boolean isProcessXMLNeeded(InjectionProcessorProvider<?, ?> provider) {
        List<Class<JNDIEnvironmentRef>> refClasses;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("isProcessXMLNeeded: " + provider));
        }
        if ((refClasses = provider.getJNDIEnvironmentRefClasses()) == null) {
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"isProcessXMLNeeded: true (unknown)");
            }
            return true;
        }
        for (Class<JNDIEnvironmentRef> refClass : refClasses) {
            List<JNDIEnvironmentRef> refs = this.ivNameSpaceConfig.getJNDIEnvironmentRefs(refClass);
            if (refs == null || refs.isEmpty()) continue;
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("isProcessXMLNeeded: true (" + refClass.getName() + ")"));
            }
            return true;
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"isProcessXMLNeeded: false");
        }
        return false;
    }

    public void processAnnotations(Class<?> classHierarchy) throws InjectionException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("processAnnotations: " + classHierarchy));
        }
        for (Class<?> klass = classHierarchy; klass != null && klass != Object.class; klass = klass.getSuperclass()) {
            Member[] fields = this.getAllDeclaredFields(klass, classHierarchy);
            for (int processorIndex = 0; processorIndex < this.ivProviders.size(); ++processorIndex) {
                InjectionProcessorProvider<?, ?> provider = this.ivProviders.get(processorIndex);
                this.processClassAnnotations(processorIndex, provider, klass);
                if (fields == null) continue;
                this.processMemberAnnotations(processorIndex, provider, fields, (AnnotatedElement[])fields);
            }
        }
        Member[] methods = InjectionProcessorManager.getAllDeclaredMethods(classHierarchy);
        for (int processorIndex = 0; processorIndex < this.ivProviders.size(); ++processorIndex) {
            this.processMemberAnnotations(processorIndex, this.ivProviders.get(processorIndex), methods, (AnnotatedElement[])methods);
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"processAnnotations");
        }
    }

    private <A extends Annotation, AS extends Annotation> void addOrMergeInjectionBinding(int processorIndex, InjectionProcessor<A, AS> processor, Class<?> klass, Member member, A ann) throws InjectionException {
        int overrideIndex;
        if (this.ivOverrideIndices != null && (overrideIndex = this.ivOverrideIndices[processorIndex]) != -1) {
            this.ivOverrideIndices[processorIndex] = -1;
            InjectionProcessor<?, ?> overrideProcessor = this.getProcessor(overrideIndex, this.ivProviders.get(overrideIndex));
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("adding override processor " + overrideProcessor + " to " + processor));
            }
            InjectionProcessorContextImpl.setOverrideProcessor(processor, overrideProcessor);
        }
        InjectionProcessorContextImpl.addOrMergeInjectionBinding(processor, klass, member, ann);
    }

    static String toStringSecure(Annotation ann) {
        Class<? extends Annotation> annType = ann.annotationType();
        StringBuilder sb = new StringBuilder();
        sb.append('@').append(annType.getName()).append('(');
        boolean any = false;
        for (Method m : annType.getMethods()) {
            Object value;
            Object defaultValue = m.getDefaultValue();
            if (defaultValue == null) continue;
            String name = m.getName();
            try {
                value = m.invoke((Object)ann, new Object[0]);
                value = name.equals("password") && !defaultValue.equals(value) ? "********" : (value instanceof Object[] ? Arrays.toString((Object[])value) : String.valueOf(value));
            }
            catch (Throwable t) {
                value = "<" + t + ">";
            }
            if (any) {
                sb.append(", ");
            } else {
                any = true;
            }
            sb.append(name).append('=').append(value);
        }
        return sb.append(')').toString();
    }

    private <A extends Annotation, AS extends Annotation> void processClassAnnotations(int processorIndex, InjectionProcessorProvider<A, AS> provider, Class<?> klass) throws InjectionException {
        Class<A> annClass = provider.getAnnotationClass();
        if (annClass != null) {
            InjectionProcessor<A, AS> processor;
            Annotation[] singleAnns;
            AS pluralAnn;
            Class<AS> pluralAnnClass;
            A ann = klass.getAnnotation(annClass);
            if (ann != null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("found class annotation " + InjectionProcessorManager.toStringSecure(ann)));
                }
                InjectionProcessor<A, AS> processor2 = this.getProcessor(processorIndex, provider);
                this.addOrMergeInjectionBinding(processorIndex, processor2, klass, (Member)null, ann);
            }
            if ((pluralAnnClass = provider.getAnnotationsClass()) != null && (pluralAnn = klass.getAnnotation(pluralAnnClass)) != null && (singleAnns = (processor = this.getProcessor(processorIndex, provider)).getAnnotations((Annotation)pluralAnn)) != null) {
                for (Annotation singleAnn : singleAnns) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("found plural class annotation " + InjectionProcessorManager.toStringSecure(singleAnn)));
                    }
                    this.addOrMergeInjectionBinding(processorIndex, processor, klass, null, singleAnn);
                }
            }
        }
    }

    private Field[] getAllDeclaredFields(Class<?> klass, Class<?> classHierarchy) {
        try {
            return klass.getDeclaredFields();
        }
        catch (Throwable ex) {
            FFDCFilter.processException((Throwable)ex, (String)(CLASS_NAME + ".getAllDeclaredFields"), (String)"249", (Object[])new Object[]{classHierarchy, klass});
            if (classHierarchy != klass) {
                Tr.warning((TraceComponent)tc, (String)"SUPER_FIELD_ANNOTATIONS_IGNORED_CWNEN0048W", (Object)new Object[]{klass.getName(), classHierarchy.getName(), ex.toString()});
                if (this.ivInjectionEngine.isValidationFailable(this.ivNameSpaceConfig.isCheckApplicationConfiguration())) {
                    throw new RuntimeException("Resource annotations on the fields of the " + klass.getName() + " class could not be processed. The " + klass.getName() + " class is being processed for annotations because it is" + " referenced by the " + classHierarchy.getName() + " application class." + " The annotations could not be obtained because of the exception : " + ex, ex);
                }
            } else {
                Tr.warning((TraceComponent)tc, (String)"FIELD_ANNOTATIONS_IGNORED_CWNEN0047W", (Object)new Object[]{klass.getName(), ex.toString()});
                if (this.ivInjectionEngine.isValidationFailable(this.ivNameSpaceConfig.isCheckApplicationConfiguration())) {
                    throw new RuntimeException("Resource annotations on the fields of the " + klass.getName() + " class could not be processed. The annotations could not be obtained" + " because of the exception : " + ex, ex);
                }
            }
            return null;
        }
    }

    private static Method[] getAllDeclaredMethods(Class<?> classHierarchy) {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        Collection<MethodMap.MethodInfo> methodInfos = MethodMap.getAllDeclaredMethods(classHierarchy);
        Method[] methods = new Method[methodInfos.size()];
        int index = 0;
        for (MethodMap.MethodInfo methodInfo : methodInfos) {
            Method method = methodInfo.getMethod();
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("adding method " + method));
            }
            methods[index++] = method;
        }
        return methods;
    }

    private <A extends Annotation> void processMemberAnnotations(int processorIndex, InjectionProcessorProvider<A, ?> provider, Member[] members, AnnotatedElement[] annotatedMembers) throws InjectionException {
        Class<A> annClass = provider.getAnnotationClass();
        if (annClass != null) {
            for (int i = 0; i < members.length; ++i) {
                A ann = annotatedMembers[i].getAnnotation(annClass);
                if (ann == null) continue;
                Member member = members[i];
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("found member annotation " + InjectionProcessorManager.toStringSecure(ann) + " on " + member));
                }
                InjectionProcessor<A, ?> processor = this.getProcessor(processorIndex, provider);
                this.addOrMergeInjectionBinding(processorIndex, processor, member.getDeclaringClass(), member, ann);
            }
        }
    }

    public void processBindings() throws InjectionException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"processBindings");
        }
        if (this.ivProcessors != null) {
            for (InjectionProcessor<?, ?> processor : this.ivProcessors) {
                if (processor == null) continue;
                try {
                    InjectionProcessorContextImpl.processBindings(processor);
                }
                catch (InjectionException iex) {
                    FFDCFilter.processException((Throwable)iex, (String)(CLASS_NAME + ".processBindings"), (String)"480", (Object)this, (Object[])new Object[]{processor});
                    Tr.error((TraceComponent)tc, (String)"FAILED_TO_PROCESS_BINDINGS_CWNEN0011E", (Object)new Object[]{iex.getMessage()});
                    throw iex;
                }
                catch (Throwable t) {
                    FFDCFilter.processException((Throwable)t, (String)(CLASS_NAME + ".processBindings"), (String)"815", (Object)this, (Object[])new Object[]{processor});
                    Tr.error((TraceComponent)tc, (String)"FAILED_TO_PROCESS_BINDINGS_CWNEN0011E", (Object)new Object[]{t});
                    throw new InjectionException("Failed to process bindings for metadata", t);
                }
            }
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"processBindings");
        }
    }
}

