/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jaxrs20.client.security.saml;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.security.saml2.PropagationHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.Arrays;
import java.util.Map;
import javax.ws.rs.ProcessingException;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class PropagationHandler
extends AbstractPhaseInterceptor<Message> {
    private static final TraceComponent tc = Tr.register(PropagationHandler.class, (String)"com.ibm.ws.jaxrs20.client", (String)"com.ibm.ws.jaxrs20.client.internal.resources.JAXRSClientMessages");
    static final long serialVersionUID = 5699156845639467812L;

    public PropagationHandler() {
        super("pre-logical");
    }

    public void handleMessage(Message message) throws Fault {
        Object samlHandler = message.get((Object)"com.ibm.ws.jaxrs.client.saml.sendToken");
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Please check if customer is using the [com.ibm.ws.jaxrs.client.saml.sendToken], client configuration property and the value should be true", (Object[])new Object[0]);
        }
        if (samlHandler != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("The client configuration property [com.ibm.ws.jaxrs.client.saml.sendToken] value is " + samlHandler), (Object[])new Object[0]);
            }
            String handler = samlHandler.toString().toLowerCase();
            this.configClientSAMLHandler(message, handler);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @FFDCIgnore(value={NoClassDefFoundError.class})
    private void configClientSAMLHandler(Message message, String samlHander) {
        if (samlHander.equals("true")) {
            String address;
            String saml = null;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Entering SAML Handler", (Object[])new Object[0]);
            }
            if ((address = (String)message.get((Object)Message.ENDPOINT_ADDRESS)).startsWith("https") && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"user is using SSL connection", (Object[])new Object[0]);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"About to get a SAML authentication token from the runAs Subject", (Object[])new Object[0]);
            }
            try {
                saml = PropagationHelper.getEncodedSaml20Token((boolean)false);
                if (saml == null || saml.isEmpty()) return;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Retrieved the encoded SAML token. About to set it on the request Header " + saml), (Object[])new Object[0]);
                }
                Map headers = (Map)message.get((Object)Message.PROTOCOL_HEADERS);
                headers.put("Authorization", Arrays.asList("SAML " + saml));
                message.put((Object)Message.PROTOCOL_HEADERS, (Object)headers);
                return;
            }
            catch (NoClassDefFoundError ncdfe) {
                Tr.warning((TraceComponent)tc, (String)"failed_to_extract_saml_token_from_subject", (Object[])new Object[]{ncdfe});
                return;
            }
            catch (Throwable ncdfe) {
                void e;
                FFDCFilter.processException((Throwable)ncdfe, (String)"com.ibm.ws.jaxrs20.client.security.saml.PropagationHandler", (String)"96", (Object)((Object)this), (Object[])new Object[]{message, samlHander});
                Tr.warning((TraceComponent)tc, (String)"failed_to_extract_saml_token_from_subject", (Object[])new Object[]{e});
                throw new ProcessingException((Throwable)e);
            }
        } else {
            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) return;
            Tr.debug((TraceComponent)tc, (String)"No client SAML handler configuration is specified, skipping this handler.", (Object[])new Object[0]);
        }
    }
}

