/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jpa.container.context.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.aries.jpa.container.context.JTAPersistenceContextManager;
import org.apache.aries.jpa.container.context.PersistenceContextProvider;
import org.apache.aries.jpa.container.context.impl.NLS;
import org.apache.aries.jpa.container.context.impl.PersistenceContextManager;
import org.apache.aries.jpa.container.context.impl.QuiesceParticipantImpl;
import org.apache.aries.jpa.container.context.transaction.impl.DestroyCallback;
import org.apache.aries.jpa.container.context.transaction.impl.JTAPersistenceContextRegistry;
import org.apache.aries.util.AriesFrameworkUtil;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.SynchronousBundleListener;
import org.osgi.util.tracker.BundleTracker;
import org.osgi.util.tracker.BundleTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlobalPersistenceManager
implements PersistenceContextProvider,
SynchronousBundleListener,
BundleActivator {
    private static final String QUIESCE_PARTICIPANT_CLASS = "org.apache.aries.quiesce.participant.QuiesceParticipant";
    private static final Logger _logger = LoggerFactory.getLogger((String)"org.apache.aries.jpa.container.context");
    private JTAPersistenceContextRegistry registry;
    private ServiceRegistration registryReg;
    private Map<Bundle, PersistenceContextManager> managers = new HashMap<Bundle, PersistenceContextManager>();
    private Map<Bundle, Set<String>> persistenceContexts = new HashMap<Bundle, Set<String>>();
    private ServiceRegistration quiesceReg;
    private DestroyCallback quiesceTidyUp;
    private ServiceRegistration pcpReg;
    private Bundle bundle;
    private BundleTracker subsystemContextBundleTracker;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerContext(String unitName, Bundle client, HashMap<String, Object> properties) {
        if (_logger.isDebugEnabled()) {
            _logger.debug("Registering bundle {} as a client of persistence unit {} with properties {}.", new Object[]{client.getSymbolicName() + "_" + client.getVersion(), unitName, properties});
        }
        if (!this.registry.jtaIntegrationAvailable()) {
            _logger.warn(NLS.MESSAGES.getMessage("no.tran.manager.for.bundle", new Object[]{unitName, client.getSymbolicName(), client.getVersion()}));
        }
        Bundle frameworkBundle = this.findFrameworkBundle(client);
        PersistenceContextManager manager = null;
        boolean newManager = false;
        GlobalPersistenceManager globalPersistenceManager = this;
        synchronized (globalPersistenceManager) {
            if (this.managers.containsKey(frameworkBundle)) {
                manager = this.managers.get(frameworkBundle);
            } else {
                if (_logger.isDebugEnabled()) {
                    _logger.debug("No existing manager for the framework with identity hash code {}. Creating a new one.", new Object[]{System.identityHashCode(frameworkBundle)});
                }
                manager = new PersistenceContextManager(frameworkBundle.getBundleContext(), this.registry);
                this.managers.put(frameworkBundle, manager);
                frameworkBundle.getBundleContext().addBundleListener((BundleListener)this);
                newManager = true;
            }
            if (!this.persistenceContexts.containsKey(client)) {
                this.persistenceContexts.put(client, new HashSet());
            }
            this.persistenceContexts.get(client).add(unitName);
        }
        if (newManager) {
            manager.open();
        }
        manager.registerContext(unitName, client, properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bundleChanged(BundleEvent event) {
        Bundle bundle = event.getBundle();
        if (event.getType() == 256) {
            Set<Object> contextsToBeRemoved = new HashSet();
            Bundle frameworkBundle = this.findFrameworkBundle(bundle);
            PersistenceContextManager manager = null;
            boolean removeManager = false;
            GlobalPersistenceManager globalPersistenceManager = this;
            synchronized (globalPersistenceManager) {
                if (this.persistenceContexts.containsKey(bundle)) {
                    contextsToBeRemoved = this.persistenceContexts.remove(bundle);
                    if (_logger.isDebugEnabled()) {
                        _logger.debug("The bundle {} in framework {}, which is a client of the persistence contexts {} is stopping.", new Object[]{bundle.getSymbolicName() + "_" + bundle.getVersion(), System.identityHashCode(frameworkBundle), contextsToBeRemoved});
                    }
                    if ((manager = this.managers.get(frameworkBundle)) == null) {
                        _logger.error(NLS.MESSAGES.getMessage("no.context.manager.for.framework", new Object[]{frameworkBundle.getSymbolicName(), frameworkBundle.getVersion()}));
                        throw new IllegalStateException();
                    }
                } else if (this.managers.containsKey(bundle)) {
                    if (_logger.isDebugEnabled()) {
                        _logger.debug("The framework {} is stopping.", new Object[]{bundle.getSymbolicName() + "_" + bundle.getVersion(), System.identityHashCode(frameworkBundle)});
                    }
                    removeManager = true;
                    manager = this.managers.remove(bundle);
                    bundle.getBundleContext().removeBundleListener((BundleListener)this);
                    for (Bundle b : bundle.getBundleContext().getBundles()) {
                        if (!this.persistenceContexts.containsKey(b)) continue;
                        contextsToBeRemoved.addAll((Collection<Object>)this.persistenceContexts.remove(b));
                    }
                }
            }
            if (removeManager) {
                manager.close();
            } else {
                for (String string : contextsToBeRemoved) {
                    manager.unregisterContext(string, bundle);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void quiesceBundle(Bundle bundleToQuiesce, final DestroyCallback callback) {
        if (bundleToQuiesce == this.bundle) {
            AriesFrameworkUtil.safeUnregisterService((ServiceRegistration)this.pcpReg);
            this.pcpReg = null;
            final ArrayList<Map.Entry<Bundle, PersistenceContextManager>> mgrs = new ArrayList<Map.Entry<Bundle, PersistenceContextManager>>();
            GlobalPersistenceManager globalPersistenceManager = this;
            synchronized (globalPersistenceManager) {
                mgrs.addAll(this.managers.entrySet());
            }
            if (this.managers.isEmpty()) {
                callback.callback();
            } else {
                final GlobalPersistenceManager gpm = this;
                DestroyCallback destroy = new DestroyCallback(){
                    int count;
                    {
                        this.count = mgrs.size();
                    }

                    @Override
                    public void callback() {
                        --this.count;
                        if (this.count == 0) {
                            for (Map.Entry entry : mgrs) {
                                BundleContext ctx = ((Bundle)entry.getKey()).getBundleContext();
                                if (ctx == null) continue;
                                ctx.removeBundleListener((BundleListener)gpm);
                            }
                            callback.callback();
                        }
                    }
                };
                for (Map.Entry entry : mgrs) {
                    ((PersistenceContextManager)((Object)entry.getValue())).quiesceAllUnits(destroy);
                }
            }
        } else {
            Bundle frameworkBundle = bundleToQuiesce.getBundleContext().getBundle(0L);
            PersistenceContextManager mgr = this.managers.get(frameworkBundle);
            if (mgr == null) {
                callback.callback();
            } else {
                mgr.quiesceUnits(bundleToQuiesce, callback);
            }
        }
    }

    public void start(BundleContext context) throws Exception {
        this.bundle = context.getBundle();
        this.registry = new JTAPersistenceContextRegistry(context);
        this.subsystemContextBundleTracker = this.createSubsystemContextBundleTracker();
        this.subsystemContextBundleTracker.open();
        this.pcpReg = context.registerService(PersistenceContextProvider.class.getName(), (Object)this, null);
        this.registryReg = context.registerService(JTAPersistenceContextManager.class.getName(), (Object)this.registry, null);
        try {
            context.getBundle().loadClass(QUIESCE_PARTICIPANT_CLASS);
            this.quiesceTidyUp = new QuiesceParticipantImpl(this);
            this.quiesceReg = context.registerService(QUIESCE_PARTICIPANT_CLASS, (Object)this.quiesceTidyUp, null);
        }
        catch (ClassNotFoundException e) {
            _logger.info(NLS.MESSAGES.getMessage("quiesce.manager.not.there", new Object[0]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(BundleContext context) throws Exception {
        AriesFrameworkUtil.safeUnregisterService((ServiceRegistration)this.pcpReg);
        AriesFrameworkUtil.safeUnregisterService((ServiceRegistration)this.registryReg);
        AriesFrameworkUtil.safeUnregisterService((ServiceRegistration)this.quiesceReg);
        if (this.quiesceTidyUp != null) {
            this.quiesceTidyUp.callback();
        }
        ArrayList<PersistenceContextManager> mgrs = new ArrayList<PersistenceContextManager>();
        Map<Bundle, Set<String>> map = this.persistenceContexts;
        synchronized (map) {
            mgrs.addAll(this.managers.values());
        }
        for (PersistenceContextManager mgr : mgrs) {
            mgr.close();
        }
        this.subsystemContextBundleTracker.close();
        this.registry.close();
    }

    public Bundle getBundle() {
        return this.bundle;
    }

    private BundleTracker createSubsystemContextBundleTracker() {
        BundleContext context = this.getSystemBundleContext();
        BundleTrackerCustomizer customizer = this.createSubsystemContextBundleTrackerCustomizer();
        return new BundleTracker(context, 32, customizer);
    }

    private BundleContext getSystemBundleContext() {
        return this.bundle.getBundleContext().getBundle(0L).getBundleContext();
    }

    private BundleTrackerCustomizer createSubsystemContextBundleTrackerCustomizer() {
        return new BundleTrackerCustomizer(){

            public Bundle addingBundle(Bundle bundle, BundleEvent event) {
                String symName = bundle.getSymbolicName();
                if (symName != null && symName.startsWith("org.osgi.service.subsystem.region.context.")) {
                    return bundle;
                }
                return null;
            }

            public void modifiedBundle(Bundle bundle, BundleEvent event, Object object) {
            }

            public void removedBundle(Bundle bundle, BundleEvent event, Object object) {
            }
        };
    }

    private Bundle findFrameworkBundle(Bundle client) {
        BundleContext clientBundleContext = client.getBundleContext();
        Bundle[] tracked = this.subsystemContextBundleTracker.getBundles();
        if (tracked != null) {
            for (Bundle subsystemContextBundle : tracked) {
                if (clientBundleContext.getBundle(subsystemContextBundle.getBundleId()) == null) continue;
                return subsystemContextBundle;
            }
        }
        return clientBundleContext.getBundle(0L);
    }
}

