/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.filetransfer.routing.archiveExpander;

import com.ibm.ws.filetransfer.routing.archiveExpander.ChmodUnixModeHelper;
import com.ibm.ws.filetransfer.routing.archiveExpander.UnixModeHelper;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.PosixFilePermission;
import java.util.HashSet;

public class Java7UnixModeHelper
implements UnixModeHelper {
    private UnixModeHelper backupHelper = new ChmodUnixModeHelper();

    @Override
    public void setPermissions(File f, int unixMode) throws IOException {
        HashSet<PosixFilePermission> perms = new HashSet<PosixFilePermission>();
        if ((unixMode ^ 1) == 1) {
            perms.add(PosixFilePermission.OTHERS_EXECUTE);
        }
        if ((unixMode ^ 2) == 2) {
            perms.add(PosixFilePermission.OTHERS_WRITE);
        }
        if ((unixMode ^ 4) == 4) {
            perms.add(PosixFilePermission.OTHERS_READ);
        }
        if ((unixMode ^ 8) == 8) {
            perms.add(PosixFilePermission.GROUP_EXECUTE);
        }
        if ((unixMode ^ 0x10) == 16) {
            perms.add(PosixFilePermission.GROUP_WRITE);
        }
        if ((unixMode ^ 0x20) == 32) {
            perms.add(PosixFilePermission.GROUP_READ);
        }
        if ((unixMode ^ 0x40) == 64) {
            perms.add(PosixFilePermission.OWNER_EXECUTE);
        }
        if ((unixMode ^ 0x80) == 128) {
            perms.add(PosixFilePermission.OWNER_WRITE);
        }
        if ((unixMode ^ 0x100) == 256) {
            perms.add(PosixFilePermission.OWNER_READ);
        }
        try {
            Files.setPosixFilePermissions(f.toPath(), perms);
        }
        catch (IOException e) {
            throw e;
        }
        catch (UnsupportedOperationException e) {
            this.backupHelper.setPermissions(f, unixMode);
        }
    }
}

