/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.request.timing.manager;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.request.timing.RequestTimingService;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class ThreadDumpManager {
    private static final TraceComponent tc = Tr.register(ThreadDumpManager.class, (String)"requestTiming", (String)"com.ibm.ws.request.timing.internal.resources.LoggingMessages");
    private final int threadDumpsRequired;
    private final int threadDumpDuration;
    private volatile int threadDumpsGenerated;
    private volatile ScheduledFuture<?> timeKeeper = null;
    private final Object syncTimerObject = new Object(){};
    private final Runnable generateThreadDump = new Runnable(){

        @Override
        @Trivial
        public void run() {
            RequestTimingService.getLibertyProcess().createJavaDump((Set)new HashSet<String>(){
                {
                    this.add("thread");
                }
            });
            ThreadDumpManager.this.threadDumpsGenerated++;
            if (ThreadDumpManager.this.threadDumpsGenerated >= ThreadDumpManager.this.threadDumpsRequired) {
                ThreadDumpManager.this.stopTimer();
            }
        }
    };

    public ThreadDumpManager(int threadDumpsRequired, int threadDumpDuration) {
        this.threadDumpsRequired = threadDumpsRequired;
        this.threadDumpDuration = threadDumpDuration;
        this.threadDumpsGenerated = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startTimer() {
        if (this.timeKeeper == null) {
            boolean startedTimer = false;
            Object object = this.syncTimerObject;
            synchronized (object) {
                if (this.timeKeeper == null) {
                    this.threadDumpsGenerated = 0;
                    this.timeKeeper = RequestTimingService.getScheduledExecutorService().scheduleAtFixedRate(this.generateThreadDump, 0L, this.threadDumpDuration, TimeUnit.MINUTES);
                    startedTimer = true;
                }
            }
            if (startedTimer && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Starting thread dump scheduler with initial delay (ms) : 0 and period (min) : " + this.threadDumpDuration), (Object[])new Object[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopTimer() {
        boolean stoppedTimer = false;
        Object object = this.syncTimerObject;
        synchronized (object) {
            if (this.timeKeeper != null) {
                this.timeKeeper.cancel(false);
                this.timeKeeper = null;
                stoppedTimer = true;
            }
        }
        if (stoppedTimer && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Stopping thread dump scheduler.", (Object[])new Object[0]);
        }
    }
}

