/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jpa.management;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.jpa.management.JPAApplInfo;
import com.ibm.ws.jpa.management.JPAPUnitInfo;
import com.ibm.ws.jpa.management.JPAPXml;
import com.ibm.ws.jpa.management.JPAPuScope;
import com.ibm.ws.jpa.management.JPAPxmlInfo;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class JPAScopeInfo {
    private static final String CLASS_NAME = JPAScopeInfo.class.getName();
    private static final TraceComponent tc = Tr.register((String)CLASS_NAME, (String)"JPA", (String)"com.ibm.ws.jpa.jpa");
    private String scopeName;
    private JPAPuScope scope;
    private Map<String, JPAPxmlInfo> pxmlsInfo;

    JPAScopeInfo(String scopeName, JPAPuScope scope) {
        this.scopeName = scopeName;
        this.scope = scope;
        this.pxmlsInfo = new HashMap<String, JPAPxmlInfo>();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)this.toString());
        }
    }

    void processPersistenceUnit(JPAPXml pxml, JPAApplInfo applInfo) {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("processPersistenceUnit" + pxml));
        }
        URL pxmlRootURL = pxml.getRootURL();
        String pxmlInfoKey = this.scope == JPAPuScope.EAR_Scope ? pxml.getArchiveName() : pxmlRootURL.toString();
        JPAPxmlInfo pxmlInfo = this.pxmlsInfo.get(pxmlInfoKey);
        if (pxmlInfo == null) {
            pxmlInfo = new JPAPxmlInfo(this, pxmlRootURL);
            this.pxmlsInfo.put(pxmlInfoKey, pxmlInfo);
            pxmlInfo.extractPersistenceUnits(pxml);
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"processPersistenceUnit", (Object)this.getPUList());
        }
    }

    String getScopeName() {
        return this.scopeName;
    }

    private String getPUList() {
        StringBuilder sbuf = new StringBuilder();
        for (JPAPxmlInfo pxmlInfo : this.pxmlsInfo.values()) {
            pxmlInfo.toStringBuilder(sbuf);
        }
        return sbuf.toString();
    }

    public JPAPuScope getScopeType() {
        return this.scope;
    }

    JPAPUnitInfo getPuInfo(String puName) {
        int archiveEnd;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getPuInfo : " + puName));
        }
        JPAPUnitInfo rtnVal = null;
        if (this.scope == JPAPuScope.EAR_Scope && (archiveEnd = puName.indexOf(35)) != -1) {
            String archiveName = puName.substring(0, archiveEnd);
            puName = puName.substring(archiveEnd + 1);
            JPAPxmlInfo pxmlInfo = this.pxmlsInfo.get(archiveName);
            if (pxmlInfo != null) {
                rtnVal = pxmlInfo.getPuInfo(puName);
            }
        } else {
            JPAPxmlInfo pxmlInfo;
            Iterator<JPAPxmlInfo> i$ = this.pxmlsInfo.values().iterator();
            while (i$.hasNext() && (rtnVal = (pxmlInfo = i$.next()).getPuInfo(puName)) == null) {
            }
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getPuInfo : " + (rtnVal != null ? rtnVal.getPersistenceUnitName() : "PU not found.")));
        }
        return rtnVal;
    }

    int getAllPuCount() {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getAllPuCount", (Object)this);
        }
        int rtnCount = 0;
        for (JPAPxmlInfo pxmlInfo : this.pxmlsInfo.values()) {
            rtnCount += pxmlInfo.getPuCount();
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getAllPuCount : " + rtnCount));
        }
        return rtnCount;
    }

    JPAPUnitInfo getUniquePuInfo() {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getUniquePuInfo");
        }
        JPAPUnitInfo rtnVal = null;
        for (JPAPxmlInfo pxmlInfo : this.pxmlsInfo.values()) {
            Set<String> puNames = pxmlInfo.getPuNames();
            if (rtnVal == null && puNames.size() == 1) {
                rtnVal = pxmlInfo.getPuInfo(puNames.iterator().next());
                continue;
            }
            if (puNames.size() == 0) continue;
            rtnVal = null;
            break;
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getUniquePuInfo", rtnVal);
        }
        return rtnVal;
    }

    void close() {
        for (JPAPxmlInfo pxmlInfo : this.pxmlsInfo.values()) {
            pxmlInfo.close();
        }
        this.pxmlsInfo.clear();
    }

    StringBuilder toStringBuilder(StringBuilder sbuf) {
        sbuf.append("\nScopeInfo: ScopeName = ").append(this.scopeName).append("\tScope = ").append((Object)this.scope);
        for (JPAPxmlInfo pxmlInfo : this.pxmlsInfo.values()) {
            pxmlInfo.toStringBuilder(sbuf);
        }
        return sbuf;
    }

    public String toString() {
        return "ScopeName = \"" + this.scopeName + "\"\tScope = " + (Object)((Object)this.scope) + "\t# persistence.xml = " + this.pxmlsInfo.size();
    }
}

