/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jpa.management;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.csi.J2EEName;
import com.ibm.ws.Transaction.UOWCoordinator;
import com.ibm.ws.jpa.JPAAccessor;
import com.ibm.ws.jpa.JPAExPcBindingContext;
import com.ibm.ws.jpa.JPAExPcBindingContextAccessor;
import com.ibm.ws.jpa.JPAPuId;
import com.ibm.ws.jpa.management.AbstractJPAComponent;
import com.ibm.ws.jpa.management.JPAExEmInvocation;
import com.ibm.ws.jpa.management.JPAPCtxtInjectionBinding;
import com.ibm.ws.jpa.management.JPAPUnitInfo;
import com.ibm.ws.jpa.management.JPAPUnitInjectionBinding;
import com.ibm.ws.jpa.management.JPARuntime;
import com.ibm.ws.jpa.management.JPATxEntityManager;
import com.ibm.ws.uow.embeddable.SynchronizationRegistryUOWScope;
import com.ibm.wsspi.injectionengine.InjectionBinding;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.persistence.EntityManager;
import javax.persistence.LockModeType;
import javax.persistence.TransactionRequiredException;

public class JPAExEntityManager
extends JPATxEntityManager {
    private static final long serialVersionUID = 8772611731925961602L;
    private static final TraceComponent tc = Tr.register(JPAExEntityManager.class, (String)"JPA", (String)"com.ibm.ws.jpa.jpa");
    private static final JPAPuId[] NoPuIds = new JPAPuId[0];
    private static final Map<ExPcBindingKey, ExPcBindingInfo> svExPcBindingMap = new ConcurrentHashMap<ExPcBindingKey, ExPcBindingInfo>();

    public JPAExEntityManager(JPAPuId puRefId, JPAPUnitInfo puInfo, J2EEName j2eeName, String refName, Map<?, ?> properties, boolean isUnsynchronized, AbstractJPAComponent abstractJPAComponent) {
        super(puRefId, puInfo, j2eeName, refName, properties, isUnsynchronized, abstractJPAComponent);
    }

    @Override
    protected Object readResolve() {
        JPARuntime jpaRuntime = this.ivAbstractJPAComponent.getJPARuntime();
        return jpaRuntime.isDefault() ? this : jpaRuntime.createJPAExEntityManager(this.ivPuRefId, this.ivPuInfo, this.ivJ2eeName, this.ivRefName, this.ivProperties, this.ivUnsynchronized, this.ivAbstractJPAComponent);
    }

    private static ExPcBindingInfo getExPcBindingInfo(ExPcBindingKey exPcBindingKey) {
        ExPcBindingInfo exPcInfo = svExPcBindingMap.get(exPcBindingKey);
        if (exPcInfo == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"getExPcBindingInfo : Inconsistent internal error.");
            }
            throw new RuntimeException("Can not find " + exPcBindingKey + " in SFSB extend-scoped entity manager association cache.");
        }
        return exPcInfo;
    }

    @Override
    EntityManager getEMInvocationInfo(boolean requireTx, LockModeType mode) {
        boolean globalTx;
        JPAExPcBindingContextAccessor exPcAccessor = this.ivAbstractJPAComponent.getExPcBindingContext();
        if (exPcAccessor == null) {
            throw new IllegalStateException("The EJB container has not registered an extended-scoped persistence context binding context accessor with the JPA service.  An accessor is required to provide extended-scoped persistence context management for stateful beans.");
        }
        JPAExPcBindingContext currentContext = exPcAccessor.getExPcBindingContext();
        if (currentContext == null) {
            Tr.error((TraceComponent)tc, (String)"NO_COMPONENT_CONTEXT_CWWJP0038E", (Object)this.ivPuRefId.getPuName());
            throw new RuntimeException("The component context does not exist on the thread.  The server run time environment is not able to associate the operation thread with any Java Platform, Enterprise Edition 5 (Java EE 5) application component.  This condition can occur when the client attempts EntityManager operations on a non-server application thread.  Make sure that a Java EE 5 application does not execute EntityManager operations within static code blocks or in threads that are created by the Java EE application.");
        }
        UOWCoordinator uowCoord = this.ivAbstractJPAComponent.getUOWCurrent().getUOWCoord();
        SynchronizationRegistryUOWScope uowSyncRegistry = JPAExEntityManager.getSynchronizationRegistryUOWScope(uowCoord);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getEMInvocationInfo", (Object)new Object[]{"tid=" + JPAExEntityManager.txIdToString(uowCoord), currentContext.thisToString()});
        }
        if (!(globalTx = uowCoord.isGlobal()) && mode != null && !LockModeType.NONE.equals((Object)mode)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("getEMInvocationInfo : TransactionRequiredException: No active transaction for " + this.ivPuRefId));
            }
            throw new TransactionRequiredException("No active transaction for " + this.ivPuRefId);
        }
        ExPcBindingKey exPcBindingKey = new ExPcBindingKey(currentContext.getBindId(), this.ivPuRefId);
        ExPcBindingInfo exPcInfo = JPAExEntityManager.getExPcBindingInfo(exPcBindingKey);
        if (exPcInfo.em == null) {
            exPcInfo.em = this.ivEntityManagerPool.getEntityManager(globalTx, this.ivUnsynchronized);
            exPcInfo.txKeyPuId = this.ivTxKeyPuId;
        }
        EntityManager em = exPcInfo.em;
        if (globalTx) {
            JPAExEmInvocation invocationEm = JPAExEntityManager.getInvocation(uowSyncRegistry, this.ivTxKeyPuId);
            if (invocationEm == null) {
                boolean isBmtNUserTxBegunInMethod;
                invocationEm = this.ivAbstractJPAComponent.getJPARuntime().createExEmInvocation(uowCoord, em, this.ivUnsynchronized);
                JPAExEntityManager.setInvocation(uowSyncRegistry, this.ivTxKeyPuId, invocationEm);
                boolean isCmt = !currentContext.isBmt();
                boolean bl = isBmtNUserTxBegunInMethod = currentContext.isBmt() && currentContext.hasBmtUserTxBegunInMethod();
                if (!this.ivUnsynchronized && (isCmt || isBmtNUserTxBegunInMethod)) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("CMT=" + isCmt + ", UserTxBegun=" + isBmtNUserTxBegunInMethod + " -> em=" + em));
                    }
                    em.joinTransaction();
                }
            } else if (invocationEm.ivEm != em) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"getEMInvocationInfo : Different persistence context already associate with a JTA tx.");
                }
                throw exPcAccessor.newEJBException("5.9.1 A persistence context is associated to the current JTA transaction and it is different than the extend-scoped persistence context bound to this SFSB.");
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getEMInvocationInfo : " + em));
        }
        return em;
    }

    static JPAPuId[] getExtendedContextPuIds(Collection<InjectionBinding<?>> injectionBindings, String ejbName, Set<String> persistenceRefNames, List<Object> bindingList) {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getExtendedContextPuIds : " + (injectionBindings != null ? "<" + injectionBindings.size() + "> :" + injectionBindings : "No Injection Bindings")));
        }
        JPAPuId[] rtnValue = NoPuIds;
        if (injectionBindings != null && injectionBindings.size() > 0) {
            HashSet<JPAPuId> extendedPuIds = new HashSet<JPAPuId>();
            for (InjectionBinding<?> binding : injectionBindings) {
                JPAPCtxtInjectionBinding pcBinding;
                if (!(binding instanceof JPAPCtxtInjectionBinding) || !(pcBinding = (JPAPCtxtInjectionBinding)binding).containsComponent(ejbName)) continue;
                if (isTraceOn && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("extended persistence-context-ref name=" + pcBinding.getJndiName() + " contains component=" + ejbName));
                }
                if (pcBinding.isExtendedType()) {
                    JPAPUnitInfo puInfo;
                    JPAPuId puId = pcBinding.ivPuId;
                    String puName = puId.getPuName();
                    if ((puName == null || puName.length() == 0) && (puInfo = ((AbstractJPAComponent)JPAAccessor.getJPAComponent()).findPersistenceUnitInfo(puId)) != null) {
                        puId.setPuName(puInfo.getPersistenceUnitName());
                    }
                    extendedPuIds.add(puId);
                    if (bindingList != null) {
                        bindingList.add((Object)pcBinding);
                    }
                }
                if (persistenceRefNames == null) continue;
                persistenceRefNames.add(pcBinding.getJndiName());
            }
            if (extendedPuIds.size() > 0) {
                rtnValue = extendedPuIds.toArray(new JPAPuId[extendedPuIds.size()]);
            }
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getExtendedContextPuIds : " + rtnValue.length));
        }
        return rtnValue;
    }

    static Set<JPAPuId> scanForTxSynchronizationCollisions(List<Object> bindingList) {
        if (bindingList == null) {
            return new HashSet<JPAPuId>();
        }
        HashMap<JPAPuId, Boolean> knownPuIdMap = new HashMap<JPAPuId, Boolean>();
        HashSet<JPAPuId> returnSet = new HashSet<JPAPuId>();
        for (Object o : bindingList) {
            Boolean pVal;
            Boolean isUnsynchronized;
            JPAPCtxtInjectionBinding injBinding = (JPAPCtxtInjectionBinding)((Object)o);
            JPAPuId puid = injBinding.ivPuId;
            Boolean bl = isUnsynchronized = injBinding.isUnsynchronized() ? Boolean.TRUE : Boolean.FALSE;
            if (Boolean.TRUE.equals(isUnsynchronized)) {
                returnSet.add(puid);
            }
            if ((pVal = knownPuIdMap.put(puid, isUnsynchronized)) == null || pVal.equals(isUnsynchronized)) continue;
            Tr.error((TraceComponent)tc, (String)"JPATXSYNC_INCOMPATIBLE_CWWJP0044E", (Object)puid);
            String msgTxt = "CWWJP0044E: Multiple extended persistence context definitions of the persistence unit " + puid + " have been declared with unequal synchronization configuration.";
            throw new IllegalStateException(msgTxt);
        }
        return returnSet;
    }

    static boolean hasAppManagedPC(Collection<InjectionBinding<?>> injectionBindings, String ejbName, Set<String> persistenceRefNames) {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("hasAppManagedPC : " + (injectionBindings != null ? "<" + injectionBindings.size() + "> :" + injectionBindings : "No Injection Bindings")));
        }
        boolean rtnValue = false;
        if (injectionBindings != null && injectionBindings.size() > 0) {
            for (InjectionBinding<?> binding : injectionBindings) {
                JPAPUnitInjectionBinding puBinding;
                if (!(binding instanceof JPAPUnitInjectionBinding)) continue;
                if (isTraceOn && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("persistence-unit-ref name=" + binding.getJndiName() + " contains component=" + ejbName));
                }
                if (!(puBinding = (JPAPUnitInjectionBinding)binding).containsComponent(ejbName)) continue;
                rtnValue = true;
                if (persistenceRefNames == null) continue;
                persistenceRefNames.add(puBinding.getJndiName());
            }
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("hasAppManagedPC : " + rtnValue));
        }
        return rtnValue;
    }

    static JPAExPcBindingContext boundSfsbToExtendedPC(String j2eeName, boolean isBMT, JPAPuId[] exPcPuIds, Set<JPAPuId> unsynchronizedJPAPuIdSet, AbstractJPAComponent abstractJPAComponent) {
        JPAExPcBindingContextAccessor exPcAccessor;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("boundSfsbToExtendedPC : " + j2eeName + ", isBMT=" + isBMT + ", ExPcPuIds=" + Arrays.toString(exPcPuIds) + ", unsynchronizedJPAPuIdSet=" + unsynchronizedJPAPuIdSet));
        }
        if (unsynchronizedJPAPuIdSet == null) {
            unsynchronizedJPAPuIdSet = new HashSet<JPAPuId>();
        }
        if (isBMT && !abstractJPAComponent.ivTxCallbackRegistered) {
            abstractJPAComponent.registerLTCCallback();
        }
        if ((exPcAccessor = abstractJPAComponent.getExPcBindingContext()) == null) {
            throw new IllegalStateException("The EJB container has not registered an extended-scoped persistence context binding context accessor with the JPA service.  An accessor is required to provide extended-scoped persistence context management for stateful beans.");
        }
        JPAExPcBindingContext childContext = null;
        if (exPcPuIds != null && exPcPuIds.length > 0) {
            JPAPuId[] parentPuIds;
            long parentBindId;
            boolean notInheritingParent;
            childContext = new JPAExPcBindingContext(j2eeName, isBMT, exPcPuIds);
            long childBindId = childContext.getBindId();
            JPAExPcBindingContext parentContext = exPcAccessor.getExPcBindingContext();
            if (parentContext == null) {
                notInheritingParent = true;
                parentBindId = -1L;
                parentPuIds = NoPuIds;
            } else {
                notInheritingParent = false;
                parentBindId = parentContext.getBindId();
                parentPuIds = parentContext.getExPcPuIds();
            }
            boolean createNewBindingInfo = notInheritingParent || parentPuIds.length == 0;
            for (JPAPuId puId : exPcPuIds) {
                ExPcBindingInfo exPcInfo = null;
                ExPcBindingKey childBindingKey = new ExPcBindingKey(childBindId, puId);
                boolean txUnsynchronized = unsynchronizedJPAPuIdSet.contains(puId);
                if (createNewBindingInfo || !JPAExEntityManager.parentHasSameExPc(parentPuIds, puId)) {
                    exPcInfo = new ExPcBindingInfo(childBindingKey, txUnsynchronized);
                } else {
                    ExPcBindingKey parentBindingKey = new ExPcBindingKey(parentBindId, puId);
                    exPcInfo = svExPcBindingMap.get(parentBindingKey);
                    if (txUnsynchronized != exPcInfo.isTxUnsynchronized()) {
                        Tr.error((TraceComponent)tc, (String)"JPATXSYNC_INCOMPATIBLE_INHERITANCE_CWWJP0045E", (Object)puId);
                        String msgTxt = "CWWJP0045E: A superclass has injected an extended persistence context for persistence unit " + puId + " that has a synchronization attribute incompatible with an extended persistence context injection in a subclass.";
                        throw new IllegalStateException(msgTxt);
                    }
                    exPcInfo.addNewlyBoundSfsb(childBindingKey);
                }
                svExPcBindingMap.put(childBindingKey, exPcInfo);
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("Added PuId:" + puId), (Object)exPcInfo);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("[BindId=" + parentBindId + "] --instantiate--> [BindId=" + childBindId + "]  exPcBindingMap size=" + svExPcBindingMap.size()), (Object)new Object[]{JPAExEntityManager.toStringPuIds("ExPC declared in caller component", parentPuIds), JPAExEntityManager.toStringPuIds("ExPC declared in callee component", exPcPuIds), svExPcBindingMap});
            }
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"No ExPc processing is needed.");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("boundSfsbToExtendedPC : " + (childContext != null ? childContext.thisToString() : "null")));
        }
        return childContext;
    }

    static void joinExtendedPC(JPAExPcBindingContext bindingContext, AbstractJPAComponent jpaComponent) {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("enlistExtendedPC: " + bindingContext.thisToString()));
        }
        if (bindingContext.isBmt()) {
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"enlistExtendedPC: incorrectly called with BMT context");
            }
            throw new IllegalArgumentException();
        }
        UOWCoordinator uowCoord = jpaComponent.getUOWCurrent().getUOWCoord();
        if (!uowCoord.isGlobal()) {
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"enlistExtendedPC: incorrectly called outside global tx");
            }
            throw new IllegalStateException();
        }
        SynchronizationRegistryUOWScope uowSyncRegistry = JPAExEntityManager.getSynchronizationRegistryUOWScope(uowCoord);
        ExPcBindingKey bindingKey = new ExPcBindingKey(bindingContext.getBindId(), null);
        JPAPuId[] arr$ = bindingContext.getExPcPuIds();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            JPAPuId puId;
            bindingKey.puId = puId = arr$[i$];
            ExPcBindingInfo exPcBindingInfo = JPAExEntityManager.getExPcBindingInfo(bindingKey);
            boolean txUnsynchronized = exPcBindingInfo.isTxUnsynchronized();
            if (exPcBindingInfo.em == null) {
                if (!isTraceOn || !tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)"not joining unused lazy persistence context");
                continue;
            }
            JPAExEmInvocation invocationEm = JPAExEntityManager.getInvocation(uowSyncRegistry, exPcBindingInfo.txKeyPuId);
            if (invocationEm == null) {
                if (isTraceOn && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("joining " + exPcBindingInfo.txKeyPuId));
                }
                invocationEm = jpaComponent.getJPARuntime().createExEmInvocation(uowCoord, exPcBindingInfo.em, txUnsynchronized);
                JPAExEntityManager.setInvocation(uowSyncRegistry, exPcBindingInfo.txKeyPuId, invocationEm);
                if (txUnsynchronized != invocationEm.ivUnsynchronized) {
                    Tr.error((TraceComponent)tc, (String)"JPATXSYNC_ILLEGAL_PROPAGATION_CWWJP0046E");
                    String msgTxt = "CWWJP0046E: An UNSYNCHRONIZED JPA persistence context cannot be propagated into a SYNCHRONIZED EntityManager.";
                    throw new IllegalStateException(msgTxt);
                }
                if (txUnsynchronized) continue;
                exPcBindingInfo.em.joinTransaction();
                continue;
            }
            if (invocationEm.ivEm != exPcBindingInfo.em) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"enlistExtendedPC : Different persistence context already associate with a JTA tx.");
                }
                throw jpaComponent.getExPcBindingContext().newEJBException("5.9.1 A persistence context is associated to the current JTA transaction and it is different than the extend-scoped persistence context bound to this SFSB.");
            }
            if (txUnsynchronized == invocationEm.ivUnsynchronized) continue;
            Tr.error((TraceComponent)tc, (String)"JPATXSYNC_INCOMPATIBLE_PROPAGATION_CWWJP0047E", (Object)new Object[]{exPcBindingInfo.txKeyPuId, invocationEm.ivUnsynchronized ? "UNSYNCHRONIZED" : "SYNCHRONIZED", bindingContext.getName()});
            StringBuilder sb = new StringBuilder();
            sb.append("CWWJP0047E: The persistence context associated with persistence unit '");
            sb.append(exPcBindingInfo.txKeyPuId);
            sb.append("' has SynchronizationType of type ");
            sb.append(invocationEm.ivUnsynchronized ? "UNSYNCHRONIZED" : "SYNCHRONIZED");
            sb.append(", which is incompatible with the extended persistence context ");
            sb.append("declared by ");
            sb.append(bindingContext.getName());
            throw new IllegalStateException(new String(sb));
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"enlistExtendedPC");
        }
    }

    static void unboundSfsbFromExtendedPC(JPAExPcBindingContext bindingContext) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("unboundSfsbFromExtendedPC : " + bindingContext));
        }
        JPAPuId[] puIds = bindingContext.getExPcPuIds();
        long bindId = bindingContext.getBindId();
        ExPcBindingKey bindingKey = new ExPcBindingKey(bindId, null);
        JPAPuId[] arr$ = puIds;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            EntityManager em;
            JPAPuId puId;
            bindingKey.puId = puId = arr$[i$];
            ExPcBindingInfo exPcBindingInfo = svExPcBindingMap.remove(bindingKey);
            if (exPcBindingInfo == null || exPcBindingInfo.removeRemovedOrDiscardedSfsb(bindingKey) != 0 || (em = exPcBindingInfo.getEntityManager()) == null) continue;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("All SFSBs using the same extend-scoped persistence context have been removed, closing EntityManager " + em));
            }
            if (!em.isOpen()) continue;
            em.close();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("unboundSfsbFromExtendedPC : exPcBindMap size=" + svExPcBindingMap.size()));
        }
    }

    private static final boolean parentHasSameExPc(JPAPuId[] parentPuIds, JPAPuId puId) {
        for (JPAPuId parentPuId : parentPuIds) {
            if (!parentPuId.equals(puId)) continue;
            return true;
        }
        return false;
    }

    private static final String toStringPuIds(String desc, JPAPuId[] puids) {
        StringBuilder sbuf = new StringBuilder(desc);
        sbuf.append('\n');
        for (JPAPuId puid : puids) {
            sbuf.append("   ").append(puid).append('\n');
        }
        return sbuf.toString();
    }

    static class ExPcBindingInfo {
        EntityManager em;
        JPAPuId txKeyPuId;
        List<ExPcBindingKey> bindingKeys;
        boolean txUnsynchronized;

        ExPcBindingInfo(ExPcBindingKey bindingKey, boolean txUnsynchronized) {
            this.addNewlyBoundSfsb(bindingKey);
            this.em = null;
            this.txUnsynchronized = txUnsynchronized;
        }

        EntityManager getEntityManager() {
            return this.em;
        }

        void addNewlyBoundSfsb(ExPcBindingKey bindingKey) {
            if (this.bindingKeys == null) {
                this.bindingKeys = new ArrayList<ExPcBindingKey>();
            }
            this.bindingKeys.add(bindingKey);
        }

        int removeRemovedOrDiscardedSfsb(ExPcBindingKey bindingKey) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)("removeRemovedOrDiscardedSfsb : " + bindingKey));
            }
            this.bindingKeys.remove(bindingKey);
            int sfsbRemainsBound = this.bindingKeys.size();
            if (sfsbRemainsBound == 0) {
                this.bindingKeys = null;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("removeRemovedOrDiscardedSfsb : # SFSBs still bound to this extended context=" + sfsbRemainsBound));
            }
            return sfsbRemainsBound;
        }

        boolean isTxUnsynchronized() {
            return this.txUnsynchronized;
        }

        public String toString() {
            return "{ExPcBindingInfo: em=" + this.em + "\n" + Arrays.toString(this.bindingKeys.toArray()) + '}';
        }
    }

    static class ExPcBindingKey {
        long bindId;
        JPAPuId puId;

        ExPcBindingKey(long abindId, JPAPuId apuId) {
            this.bindId = abindId;
            this.puId = apuId;
        }

        public int hashCode() {
            return (int)(this.bindId ^ this.bindId >>> 32) + this.puId.hashCode();
        }

        public boolean equals(Object o) {
            boolean rtnValue = false;
            if (o instanceof ExPcBindingKey) {
                rtnValue = this.equals((ExPcBindingKey)o);
            }
            return rtnValue;
        }

        public boolean equals(ExPcBindingKey bindingKey) {
            return this.bindId == bindingKey.bindId && this.puId.equals(bindingKey.puId);
        }

        public String toString() {
            return "{ExPcBindingKey: BindId=" + this.bindId + ", puId=" + this.puId + '}';
        }
    }
}

