/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jpa.management;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.jpa.management.AbstractJPAComponent;
import com.ibm.ws.jpa.management.JPAPUnitInfo;
import com.ibm.ws.jpa.management.JPAPooledEntityManager;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.persistence.Cache;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceUnitUtil;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.metamodel.Metamodel;

final class JPAEMPool
implements EntityManagerFactory {
    private static final String CLASS_NAME = JPAEMPool.class.getName();
    private static final TraceComponent tc = Tr.register((String)CLASS_NAME, (String)"JPA", (String)"com.ibm.ws.jpa.jpa");
    protected final EntityManagerFactory ivFactory;
    private final Map<?, ?> ivProperties;
    private int ivPoolCapacity;
    private int ivPoolSize = 0;
    private JPAPUnitInfo ivPUnitInfo = null;
    private final ConcurrentLinkedQueue<EntityManager> ivPool = new ConcurrentLinkedQueue();
    private final AbstractJPAComponent ivAbstractJpaComponent;

    JPAEMPool(EntityManagerFactory factory, Map<?, ?> properties, int capacity, JPAPUnitInfo jpaPUnitInfo, AbstractJPAComponent jpaComponent) {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("JPAEMPool : " + factory + ", " + properties + ", capacity = " + capacity));
        }
        this.ivFactory = factory;
        if (capacity > 0) {
            HashMap<Object, Object> props = null;
            props = properties == null || properties.isEmpty() ? new HashMap() : new HashMap(properties);
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("getEntityManager : adding pool to em properties: " + this));
            }
            props.put("wsjpa.PooledFactory", this);
            this.ivProperties = props;
        } else {
            this.ivProperties = properties;
        }
        this.ivPoolCapacity = capacity;
        this.ivPUnitInfo = jpaPUnitInfo;
        this.ivAbstractJpaComponent = jpaComponent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntityManager getEntityManager(boolean jtaTxExists, boolean unsynchronized) {
        EntityManager em;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getEntityManager : [" + this.ivPoolSize + "] tx = " + jtaTxExists + " unsynchronized = " + unsynchronized));
        }
        if ((em = this.ivPool.poll()) != null) {
            JPAEMPool jPAEMPool = this;
            synchronized (jPAEMPool) {
                --this.ivPoolSize;
            }
            if (jtaTxExists && !unsynchronized) {
                em.joinTransaction();
            }
        } else {
            em = this.ivAbstractJpaComponent.getJPARuntime().createEntityManagerInstance(this.ivFactory, this.ivProperties, unsynchronized);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getEntityManager : [" + this.ivPoolSize + "] " + em));
        }
        return em;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void putEntityManager(EntityManager entityManager) {
        if (entityManager != null && entityManager.isOpen()) {
            boolean addToPool = false;
            entityManager.clear();
            JPAEMPool jPAEMPool = this;
            synchronized (jPAEMPool) {
                if (this.ivPoolSize < this.ivPoolCapacity) {
                    ++this.ivPoolSize;
                    addToPool = true;
                }
            }
            if (addToPool) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("putEntityManager : [" + this.ivPoolSize + "] " + entityManager));
                }
                this.ivPool.add(entityManager);
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("putEntityManager : close : " + entityManager));
                }
                entityManager.close();
            }
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("putEntityManager : not open : " + entityManager));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void shutdown() {
        JPAEMPool jPAEMPool = this;
        synchronized (jPAEMPool) {
            this.ivPoolCapacity = -1;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("shutdown : " + this));
        }
        EntityManager em = this.ivPool.poll();
        while (em != null) {
            if (em.isOpen()) {
                em.close();
            }
            em = this.ivPool.poll();
        }
        JPAEMPool jPAEMPool2 = this;
        synchronized (jPAEMPool2) {
            this.ivPoolSize = 0;
        }
    }

    public String toString() {
        String identity = Integer.toHexString(System.identityHashCode(this));
        return "JPAEMPool@" + identity + "[" + this.ivPoolSize + "/" + this.ivPoolCapacity + ", " + this.ivFactory + "]";
    }

    public void close() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("close : " + this));
        }
        throw new UnsupportedOperationException("This operation is not supported on a pooling EntityManagerFactory.");
    }

    public EntityManager createEntityManager() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("createEntityManager : " + this));
        }
        EntityManager em = this.getEntityManager(false, false);
        JPAPooledEntityManager pem = new JPAPooledEntityManager(this, em, this.ivAbstractJpaComponent, true);
        return pem;
    }

    public EntityManager createEntityManager(Map arg0) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("createEntityManager : " + this));
        }
        throw new UnsupportedOperationException("This operation is not supported on a pooling EntityManagerFactory.");
    }

    public Cache getCache() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getCache : " + this));
        }
        throw new UnsupportedOperationException("This operation is not supported on a pooling EntityManagerFactory.");
    }

    public CriteriaBuilder getCriteriaBuilder() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getCriteriaBuilder : " + this));
        }
        throw new UnsupportedOperationException("This operation is not supported on a pooling EntityManagerFactory.");
    }

    public Metamodel getMetamodel() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getMetamodel : " + this));
        }
        throw new UnsupportedOperationException("This operation is not supported on a pooling EntityManagerFactory.");
    }

    public PersistenceUnitUtil getPersistenceUnitUtil() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getPersistenceUnitUtil : " + this));
        }
        throw new UnsupportedOperationException("This operation is not supported on a pooling EntityManagerFactory.");
    }

    public Map<String, Object> getProperties() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getProperties : " + this));
        }
        throw new UnsupportedOperationException("This operation is not supported on a pooling EntityManagerFactory.");
    }

    public boolean isOpen() {
        return true;
    }
}

