/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jpa.management;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.csi.J2EEName;
import com.ibm.ws.jpa.JPAAccessor;
import com.ibm.ws.jpa.JPAPuId;
import com.ibm.ws.jpa.management.AbstractJPAComponent;
import com.ibm.ws.jpa.management.JPAPUnitInfo;
import com.ibm.ws.jpa.management.JPARuntime;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Map;
import javax.persistence.Cache;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceException;
import javax.persistence.PersistenceUnitUtil;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.metamodel.Metamodel;

public class JPAEMFactory
implements EntityManagerFactory,
Serializable {
    private static final long serialVersionUID = 5790871719838228801L;
    private static final TraceComponent tc = Tr.register((String)JPAEMFactory.class.getName(), (String)"JPA", (String)"com.ibm.ws.jpa.jpa");
    private JPAPuId ivPuId;
    private J2EEName ivJ2eeName;
    protected transient EntityManagerFactory ivFactory;

    protected JPAEMFactory(JPAPuId puId, J2EEName j2eeName, EntityManagerFactory emf) {
        this.ivPuId = puId;
        this.ivJ2eeName = j2eeName;
        this.ivFactory = emf;
    }

    public JPAEMFactory(JPAEMFactory wrapper) {
        this.ivPuId = wrapper.ivPuId;
        this.ivJ2eeName = wrapper.ivJ2eeName;
        this.ivFactory = wrapper.ivFactory;
    }

    public <T> T unwrap(Class<T> cls) {
        if (cls.isInstance(this.ivFactory)) {
            return cls.cast(this.ivFactory);
        }
        throw new PersistenceException(cls.toString());
    }

    public void close() {
        this.ivFactory.close();
    }

    public EntityManager createEntityManager() {
        return this.ivFactory.createEntityManager();
    }

    public EntityManager createEntityManager(Map arg0) {
        return this.ivFactory.createEntityManager(arg0);
    }

    public boolean isOpen() {
        return this.ivFactory.isOpen();
    }

    public String toString() {
        return super.toString() + '[' + this.ivPuId + ", " + this.ivJ2eeName + ", " + this.ivFactory + ']';
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("writeObject : " + this.ivPuId + ", " + this.ivJ2eeName));
        }
        out.writeObject(this.ivPuId);
        out.writeObject(this.ivJ2eeName);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"writeObject");
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"readObject");
        }
        this.ivPuId = (JPAPuId)in.readObject();
        this.ivJ2eeName = (J2EEName)in.readObject();
        JPAPUnitInfo puInfo = ((AbstractJPAComponent)JPAAccessor.getJPAComponent()).findPersistenceUnitInfo(this.ivPuId);
        this.ivFactory = puInfo.getEntityManagerFactory(this.ivJ2eeName);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("readObject : " + this));
        }
    }

    private Object readResolve() {
        JPAEMFactory wrapper;
        JPARuntime jpaRuntime = ((AbstractJPAComponent)JPAAccessor.getJPAComponent()).getJPARuntime();
        JPAEMFactory jPAEMFactory = wrapper = jpaRuntime.isDefault() ? this : jpaRuntime.createJPAEMFactory(this.ivPuId, this.ivJ2eeName, this.ivFactory);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("readResolve: " + wrapper));
        }
        return wrapper;
    }

    public Cache getCache() {
        return this.ivFactory.getCache();
    }

    public Map<String, Object> getProperties() {
        return this.ivFactory.getProperties();
    }

    public CriteriaBuilder getCriteriaBuilder() {
        return this.ivFactory.getCriteriaBuilder();
    }

    public Metamodel getMetamodel() {
        return this.ivFactory.getMetamodel();
    }

    public PersistenceUnitUtil getPersistenceUnitUtil() {
        return this.ivFactory.getPersistenceUnitUtil();
    }
}

