/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jpa.management;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.jpa.JPAPuId;
import com.ibm.ws.jpa.management.GenericConnection;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Logger;
import javax.sql.DataSource;

public final class GenericDataSource
implements DataSource {
    private static final String CLASS_NAME = GenericDataSource.class.getName();
    private static final TraceComponent tc = Tr.register((String)CLASS_NAME, (String)"JPA", (String)"com.ibm.ws.jpa.jpa");
    private JPAPuId ivPuId;
    private String ivDataSourceName = null;
    private int ivLoginTimeout = 0;
    private PrintWriter ivLogWriter = null;

    GenericDataSource(JPAPuId puId, String dataSourceName) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("<init> : " + puId + ", dataSourceName = " + dataSourceName));
        }
        this.ivDataSourceName = dataSourceName;
        this.ivPuId = puId;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"<init>");
        }
    }

    public String toString() {
        String identity = Integer.toHexString(System.identityHashCode(this));
        return "GenericDataSource@" + identity + "[" + this.ivPuId + ", " + this.ivDataSourceName + "]";
    }

    @Override
    public Connection getConnection() throws SQLException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getConnection : " + this.ivPuId));
        }
        GenericConnection result = new GenericConnection(this.ivPuId, this.ivDataSourceName);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getConnection : " + result));
        }
        return result;
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getConnection : " + this.ivPuId + ", username = " + username));
        }
        GenericConnection result = new GenericConnection(this.ivPuId, this.ivDataSourceName);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getConnection : " + result));
        }
        return result;
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getLogWriter : " + this.ivPuId + ", " + this.ivLogWriter));
        }
        return this.ivLogWriter;
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setLogWriter : " + this.ivPuId + ", " + out));
        }
        this.ivLogWriter = out;
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setLoginTimeout : " + this.ivPuId + ", " + seconds));
        }
        this.ivLoginTimeout = seconds;
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getLoginTimeout : " + this.ivPuId + ", " + this.ivLoginTimeout));
        }
        return this.ivLoginTimeout;
    }

    @Override
    public Logger getParentLogger() {
        return Logger.getLogger("");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("isWrapperFor : " + this.ivPuId + ", " + iface));
        }
        boolean result = false;
        if (iface != null && iface.isInstance(this)) {
            result = true;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("isWrapperFor : " + result));
        }
        return result;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("unwrap : " + this.ivPuId + ", " + iface));
        }
        T result = null;
        try {
            result = iface.cast(this);
        }
        catch (Throwable ex) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("unwrap : SQLException: " + this.getClass().getName() + " does not implement " + iface));
            }
            throw new SQLException(this.getClass().getName() + " does not implement " + iface);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("unwrap : " + result));
        }
        return result;
    }
}

