/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jpa.container.osgi.jndi;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.dopriv.SystemGetPropertyPrivileged;
import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.jpa.JPAAccessor;
import com.ibm.ws.jpa.JPAComponent;
import com.ibm.ws.jpa.JPALookupDelegate;
import com.ibm.ws.jpa.JPAPuId;
import com.ibm.ws.jpa.container.osgi.jndi.JPAJndiLookupInfo;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.injectionengine.InjectionException;
import java.security.AccessController;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import javax.persistence.EntityManagerFactory;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/ejs/ras/TraceComponent;")
@InjectedFFDC
@Component(service={ObjectFactory.class, JPAJndiLookupObjectFactory.class})
public class JPAJndiLookupObjectFactory
implements ObjectFactory {
    private static final String CLASS_NAME = JPAJndiLookupObjectFactory.class.getName();
    private static final TraceComponent tc = Tr.register((String)CLASS_NAME, (String)"JPA", (String)"com.ibm.ws.jpa.jpa");
    public static final String USE_EMF_PROXY = "com.ibm.websphere.persistence.useEntityManagerFactoryProxy";
    private static final boolean USE_EMF_PROXY_VALUE = Boolean.parseBoolean((String)AccessController.doPrivileged(new SystemGetPropertyPrivileged("com.ibm.websphere.persistence.useEntityManagerFactoryProxy", "true")));
    private final AtomicReference<JPALookupDelegate> lookupDelegate;
    protected String ivInstanceClassName;
    static final long serialVersionUID = -5932832165591353941L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    public JPAJndiLookupObjectFactory() {
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"<init>", (Object)new Object[0]);
        }
        this.lookupDelegate = new AtomicReference();
        this.ivInstanceClassName = CLASS_NAME;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"<init>");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"<init>", (Object)this);
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> env) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getObjectInstance", (Object)new Object[]{obj, name, nameCtx, env});
        }
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (!(obj instanceof Reference)) {
            Object v0 = null;
            if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
                v0 = v0;
                Tr.exit((TraceComponent)tc, (String)"getObjectInstance", v0);
            }
            return v0;
        }
        Reference ref = (Reference)obj;
        if (!this.ivInstanceClassName.equals(ref.getFactoryClassName())) {
            Object v1 = null;
            if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
                v1 = v1;
                Tr.exit((TraceComponent)tc, (String)"getObjectInstance", v1);
            }
            return v1;
        }
        RefAddr addr = ref.get("JPAJndiLookupInfo");
        if (addr == null) {
            NamingException nex = new NamingException("The address for this Reference is empty (null)");
            throw nex;
        }
        Object retObj = null;
        JPAJndiLookupInfo info = (JPAJndiLookupInfo)addr.getContent();
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getting EntityManagerFactory for " + info));
        }
        JPAPuId puId = info.getPuId();
        J2EEName j2eeName = info.getJ2EEName();
        String refName = info.getReferenceName();
        boolean isSFSB = this.checkSFSBAccess(info, info.isSFSB());
        JPAComponent jpaService = JPAAccessor.getJPAComponent();
        JPALookupDelegate delegate = this.lookupDelegate.get();
        if (delegate != null) {
            retObj = info.isFactory() ? delegate.getEntityManagerFactory(puId.getPuName(), j2eeName) : delegate.getEntityManager(puId.getPuName(), j2eeName, info.isExtendedContextType(), info.getPersistenceProperties());
        }
        if (retObj == null) {
            if (info.isFactory()) {
                retObj = jpaService.getEntityManagerFactory(puId, j2eeName, USE_EMF_PROXY_VALUE || isSFSB);
            } else {
                Map<?, ?> pCtxtProperties = info.getPersistenceProperties();
                retObj = jpaService.getEntityManager(puId, j2eeName, refName, info.isExtendedContextType(), info.isUnsynchronized(), pCtxtProperties);
            }
        }
        EntityManagerFactory entityManagerFactory = retObj;
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            entityManagerFactory = entityManagerFactory;
            Tr.exit((TraceComponent)tc, (String)"getObjectInstance", (Object)entityManagerFactory);
        }
        return entityManagerFactory;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    protected boolean checkSFSBAccess(JPAJndiLookupInfo info, boolean isSFSB) throws InjectionException {
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"checkSFSBAccess", (Object)new Object[]{info, isSFSB});
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("checkSFSBAccess: " + info + ", isSFSB=" + isSFSB));
        }
        if (!isSFSB && !info.isFactory() && info.isExtendedContextType()) {
            JPAPuId puId = info.getPuId();
            Tr.error((TraceComponent)tc, (String)"EXTEND_PC_NOT_IN_SFSB_CWWJP0003E", (Object)new Object[]{puId.getPuName()});
            throw new InjectionException("CWWJP0003E: The " + puId.getPuName() + " extended" + " persistence context can be initiated within the scope" + " of a stateful session bean only.");
        }
        boolean bl = isSFSB;
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            bl = bl;
            Tr.exit((TraceComponent)tc, (String)"checkSFSBAccess", (Object)bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    @org.osgi.service.component.annotations.Reference(service=JPALookupDelegate.class, cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC)
    protected void setLookupDelegate(JPALookupDelegate ref) {
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setLookupDelegate", (Object)new Object[]{ref});
        }
        this.lookupDelegate.set(ref);
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setLookupDelegate");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    protected void unsetLookupDelegate(JPALookupDelegate ref) {
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"unsetLookupDelegate", (Object)new Object[]{ref});
        }
        this.lookupDelegate.lazySet(null);
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"unsetLookupDelegate");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    static {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("useEntityManagerFactoryProxy = " + USE_EMF_PROXY_VALUE));
        }
    }
}

