/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.security;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.SecurityService;
import com.ibm.ws.security.authentication.tai.TAIService;
import com.ibm.ws.webcontainer.security.AuthResult;
import com.ibm.ws.webcontainer.security.AuthenticationResult;
import com.ibm.ws.webcontainer.security.ProviderAuthenticationResult;
import com.ibm.ws.webcontainer.security.ReferrerURLCookieHandler;
import com.ibm.ws.webcontainer.security.SSOCookieHelperImpl;
import com.ibm.ws.webcontainer.security.WebAppSecurityConfig;
import com.ibm.ws.webcontainer.security.WebAuthenticator;
import com.ibm.ws.webcontainer.security.WebProviderAuthenticatorHelper;
import com.ibm.ws.webcontainer.security.WebRequest;
import com.ibm.ws.webcontainer.security.WebRequestImpl;
import com.ibm.ws.webcontainer.security.internal.SSOAuthenticator;
import com.ibm.ws.webcontainer.security.internal.TAIAuthenticator;
import com.ibm.ws.webcontainer.security.metadata.SecurityMetadata;
import com.ibm.ws.webcontainer.security.oauth20.OAuth20Service;
import com.ibm.ws.webcontainer.security.openid20.OpenidClientService;
import com.ibm.ws.webcontainer.security.openidconnect.OidcClient;
import com.ibm.ws.webcontainer.security.openidconnect.OidcServer;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.kernel.service.utils.ConcurrentServiceReferenceMap;
import com.ibm.wsspi.security.tai.TrustAssociationInterceptor;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class WebProviderAuthenticatorProxy
implements WebAuthenticator {
    private static final TraceComponent tc = Tr.register(WebProviderAuthenticatorProxy.class);
    static final List<String> authenticatorOdering = Collections.unmodifiableList(Arrays.asList("com.ibm.ws.security.spnego", "com.ibm.ws.security.openid"));
    AuthenticationResult OAUTH_CONT = new AuthenticationResult(AuthResult.CONTINUE, "OAuth service said continue...");
    AuthenticationResult OPENID_CLIENT_CONT = new AuthenticationResult(AuthResult.CONTINUE, "OpenID client service said continue...");
    AuthenticationResult OIDC_SERVER_CONT = new AuthenticationResult(AuthResult.CONTINUE, "OpenID Connect server said continue...");
    AuthenticationResult OIDC_CLIENT_CONT = new AuthenticationResult(AuthResult.CONTINUE, "OpenID Connect client said continue...");
    AuthenticationResult SPNEGO_CONT = new AuthenticationResult(AuthResult.CONTINUE, "SPNEGO said continue...");
    AuthenticationResult JASPI_CONT = new AuthenticationResult(AuthResult.CONTINUE, "JASPI said continue...");
    private final AtomicServiceReference<SecurityService> securityServiceRef;
    private final AtomicServiceReference<TAIService> taiServiceRef;
    private final ConcurrentServiceReferenceMap<String, TrustAssociationInterceptor> interceptorServiceRef;
    private volatile WebAppSecurityConfig webAppSecurityConfig;
    private final ConcurrentServiceReferenceMap<String, WebAuthenticator> webAuthenticatorRef;
    private final AtomicServiceReference<OAuth20Service> oauthServiceRef;
    private final AtomicServiceReference<OpenidClientService> openIdClientServiceRef;
    private final AtomicServiceReference<OidcServer> oidcServerRef;
    private final AtomicServiceReference<OidcClient> oidcClientRef;
    private WebProviderAuthenticatorHelper authHelper;
    private ReferrerURLCookieHandler referrerURLCookieHandler = null;
    static final long serialVersionUID = -1060959921971705664L;

    public WebProviderAuthenticatorProxy(AtomicServiceReference<SecurityService> securityServiceRef, AtomicServiceReference<TAIService> taiServiceRef, ConcurrentServiceReferenceMap<String, TrustAssociationInterceptor> interceptorServiceRef, WebAppSecurityConfig webAppSecurityConfig, AtomicServiceReference<OAuth20Service> oauthServiceRef, AtomicServiceReference<OpenidClientService> openIdClientServiceRef, AtomicServiceReference<OidcServer> oidcServerRef, AtomicServiceReference<OidcClient> oidcClientRef, ConcurrentServiceReferenceMap<String, WebAuthenticator> webAuthenticatorRef) {
        this.securityServiceRef = securityServiceRef;
        this.taiServiceRef = taiServiceRef;
        this.interceptorServiceRef = interceptorServiceRef;
        this.webAppSecurityConfig = webAppSecurityConfig;
        this.oauthServiceRef = oauthServiceRef;
        this.oidcServerRef = oidcServerRef;
        this.openIdClientServiceRef = openIdClientServiceRef;
        this.oidcClientRef = oidcClientRef;
        this.webAuthenticatorRef = webAuthenticatorRef;
        this.authHelper = new WebProviderAuthenticatorHelper(securityServiceRef);
        this.referrerURLCookieHandler = new ReferrerURLCookieHandler(webAppSecurityConfig);
    }

    public void setWebProviderAuthenticatorHelper(WebProviderAuthenticatorHelper authHelper) {
        this.authHelper = authHelper;
    }

    @Override
    public AuthenticationResult authenticate(WebRequest webRequest) {
        HttpServletRequest request = webRequest.getHttpServletRequest();
        HttpServletResponse response = webRequest.getHttpServletResponse();
        AuthenticationResult authResult = this.handleTAI(webRequest, true);
        if (authResult.getStatus() == AuthResult.CONTINUE && (authResult = this.handleAccessToken(request, response)).getStatus() == AuthResult.CONTINUE) {
            webRequest.setCallAfterSSO(false);
            authResult = this.handleSpnego(webRequest);
            if (authResult.getStatus() == AuthResult.CONTINUE && (authResult = this.handleOidcClient(request, response, true)).getStatus() == AuthResult.CONTINUE && (authResult = this.handleSSO(webRequest, null)).getStatus() == AuthResult.CONTINUE) {
                webRequest.setCallAfterSSO(true);
                authResult = this.handleSpnego(webRequest);
                if (authResult.getStatus() == AuthResult.CONTINUE && (authResult = this.handleTAI(webRequest, false)).getStatus() == AuthResult.CONTINUE) {
                    authResult = this.handleOidcClient(request, response, false);
                }
            }
        }
        return authResult;
    }

    /*
     * WARNING - void declaration
     */
    AuthenticationResult handleJaspi(WebRequest webRequest, HashMap<String, Object> props) {
        WebAuthenticator jaspiAuthenticator;
        AuthenticationResult authResult = this.JASPI_CONT;
        if (this.webAuthenticatorRef != null && (jaspiAuthenticator = (WebAuthenticator)this.webAuthenticatorRef.getService((Object)"com.ibm.ws.security.jaspi")) != null) {
            block13: {
                if (props == null) {
                    authResult = this.handleSSO(webRequest, null);
                    if (authResult.getStatus() == AuthResult.CONTINUE) {
                        authResult = this.handleSSO(webRequest, "jaspicSession");
                        if (authResult.getStatus() == AuthResult.SUCCESS) {
                            HashMap<String, Object> requestProps = new HashMap<String, Object>();
                            requestProps.put("javax.servlet.http.registerSession.subject", authResult.getSubject());
                            webRequest.setProperties(requestProps);
                        }
                        authResult = jaspiAuthenticator.authenticate(webRequest);
                    }
                } else {
                    try {
                        authResult = jaspiAuthenticator.authenticate(webRequest.getHttpServletRequest(), webRequest.getHttpServletResponse(), props);
                    }
                    catch (Exception requestProps) {
                        void e;
                        FFDCFilter.processException((Throwable)requestProps, (String)"com.ibm.ws.webcontainer.security.WebProviderAuthenticatorProxy", (String)"185", (Object)this, (Object[])new Object[]{webRequest, props});
                        if (!tc.isDebugEnabled()) break block13;
                        Tr.debug((TraceComponent)tc, (String)"Internal error handling JASPI request", (Object[])new Object[]{e});
                    }
                }
            }
            if (authResult.getStatus() == AuthResult.SUCCESS) {
                SSOCookieHelperImpl ssoCh;
                boolean registerSession = false;
                Map<String, Object> reqProps = webRequest.getProperties();
                if (reqProps != null) {
                    registerSession = Boolean.valueOf((String)reqProps.get("javax.servlet.http.registerSession"));
                }
                if (registerSession) {
                    ssoCh = new SSOCookieHelperImpl(this.webAppSecurityConfig, "jaspicSession");
                    ssoCh.addSSOCookiesToResponse(authResult.getSubject(), webRequest.getHttpServletRequest(), webRequest.getHttpServletResponse());
                }
                ssoCh = new SSOCookieHelperImpl(this.webAppSecurityConfig);
                if (props != null && props.get("authType") != null && props.get("authType").equals("FORM_LOGIN")) {
                    ssoCh.addSSOCookiesToResponse(authResult.getSubject(), webRequest.getHttpServletRequest(), webRequest.getHttpServletResponse());
                } else {
                    HttpServletResponse response = webRequest.getHttpServletResponse();
                    if (!response.isCommitted()) {
                        ssoCh.removeSSOCookieFromResponse(response);
                    }
                }
            }
        }
        return authResult;
    }

    @Override
    public AuthenticationResult authenticate(HttpServletRequest request, HttpServletResponse response, HashMap<String, Object> props) throws Exception {
        WebRequestImpl webRequest = new WebRequestImpl(request, response, null, null, null, null, null);
        AuthenticationResult authResult = this.handleJaspi(webRequest, props);
        if (authResult.getStatus() == AuthResult.CONTINUE) {
            authResult = this.handleOpenidClient(request, response);
        }
        return authResult;
    }

    private AuthenticationResult handleTAI(WebRequest webRequest, boolean beforeSSO) {
        TAIAuthenticator taiAuthenticator = this.getTaiAuthenticator();
        if (taiAuthenticator == null) {
            return new AuthenticationResult(AuthResult.CONTINUE, "TAI invoke " + (beforeSSO ? "before" : "after") + " SSO is not available, skipping TAI...");
        }
        return taiAuthenticator.authenticate(webRequest, beforeSSO);
    }

    private AuthenticationResult handleSSO(WebRequest webRequest, String ssoCookieName) {
        WebAuthenticator authenticator = this.getSSOAuthenticator(webRequest, ssoCookieName);
        AuthenticationResult authResult = authenticator.authenticate(webRequest);
        if (authResult == null || authResult.getStatus() != AuthResult.SUCCESS) {
            authResult = new AuthenticationResult(AuthResult.CONTINUE, "SSO did not succeed, so continue ...");
        }
        return authResult;
    }

    private AuthenticationResult handleAccessToken(HttpServletRequest req, HttpServletResponse res) {
        return this.handleOAuth(req, res);
    }

    private AuthenticationResult handleSpnego(WebRequest webRequest) {
        HttpServletResponse response;
        HttpServletRequest request;
        WebAuthenticator webAuthenticator;
        AuthenticationResult authResult = this.SPNEGO_CONT;
        if (this.webAuthenticatorRef != null && (webAuthenticator = (WebAuthenticator)this.webAuthenticatorRef.getService((Object)"com.ibm.ws.security.spnego")) != null && (authResult = webAuthenticator.authenticate(webRequest)).getStatus() == AuthResult.SUCCESS && AuthResult.SUCCESS == (authResult = this.authHelper.loginWithHashtable(request = webRequest.getHttpServletRequest(), response = webRequest.getHttpServletResponse(), authResult.getSubject())).getStatus()) {
            SSOCookieHelperImpl ssoCh = new SSOCookieHelperImpl(this.webAppSecurityConfig);
            ssoCh.addSSOCookiesToResponse(authResult.getSubject(), request, response);
        }
        return authResult;
    }

    private AuthenticationResult handleOpenidClient(HttpServletRequest request, HttpServletResponse response) throws Exception {
        AuthenticationResult authResult = this.OPENID_CLIENT_CONT;
        OpenidClientService openIdClientService = (OpenidClientService)this.openIdClientServiceRef.getService();
        if (openIdClientService != null) {
            String opId = openIdClientService.getOpenIdIdentifier(request);
            if (opId != null && !opId.isEmpty()) {
                openIdClientService.createAuthRequest(request, response);
                authResult = new AuthenticationResult(AuthResult.REDIRECT_TO_PROVIDER, "OpenID client creates auth request...");
            } else if (openIdClientService.getRpRequestIdentifier(request, response) != null) {
                ProviderAuthenticationResult result = openIdClientService.verifyOpResponse(request, response);
                if (result.getStatus() != AuthResult.SUCCESS) {
                    return new AuthenticationResult(AuthResult.FAILURE, "OpenID client failed with status code " + (Object)((Object)result.getStatus()));
                }
                authResult = this.authHelper.loginWithUserName(request, response, result.getUserName(), result.getSubject(), result.getCustomProperties(), openIdClientService.isMapIdentityToRegistryUser());
            }
        }
        return authResult;
    }

    private AuthenticationResult handleOidcClient(HttpServletRequest req, HttpServletResponse res, boolean firstCall) {
        AuthenticationResult authResult = this.OIDC_CLIENT_CONT;
        OidcClient oidcClient = (OidcClient)this.oidcClientRef.getService();
        if (oidcClient == null) {
            return new AuthenticationResult(AuthResult.CONTINUE, "OpenID Connect client is not available, skipping OpenID Connect client...");
        }
        String provider = oidcClient.getOidcProvider(req);
        if (provider == null) {
            return new AuthenticationResult(AuthResult.CONTINUE, "not an OpenID Connect client request, skipping OpenID Connect client...");
        }
        ProviderAuthenticationResult oidcResult = oidcClient.authenticate(req, res, provider, this.referrerURLCookieHandler, firstCall);
        if (oidcResult.getStatus() == AuthResult.CONTINUE) {
            return this.OIDC_CLIENT_CONT;
        }
        if (oidcResult.getStatus() == AuthResult.REDIRECT_TO_PROVIDER) {
            return new AuthenticationResult(AuthResult.REDIRECT, oidcResult.getRedirectUrl());
        }
        if (oidcResult.getStatus() == AuthResult.FAILURE) {
            if (401 == oidcResult.getHttpStatusCode()) {
                return new AuthenticationResult(AuthResult.OAUTH_CHALLENGE, "OpenID Connect client failed the request...");
            }
            return new AuthenticationResult(AuthResult.FAILURE, "OpenID Connect client failed the request...");
        }
        if (oidcResult.getStatus() != AuthResult.SUCCESS) {
            if (401 == oidcResult.getHttpStatusCode()) {
                return new AuthenticationResult(AuthResult.OAUTH_CHALLENGE, "OpenID Connect client returned with status: " + (Object)((Object)oidcResult.getStatus()));
            }
            return new AuthenticationResult(AuthResult.FAILURE, "OpenID Connect client returned with status: " + (Object)((Object)oidcResult.getStatus()));
        }
        if (oidcResult.getStatus() == AuthResult.SUCCESS && oidcResult.getUserName() != null && AuthResult.SUCCESS == (authResult = this.authHelper.loginWithUserName(req, res, oidcResult.getUserName(), oidcResult.getSubject(), oidcResult.getCustomProperties(), oidcClient.isMapIdentityToRegistryUser(provider))).getStatus()) {
            boolean bDisableLtpaCookie = firstCall;
            boolean bPropagationTokenAuthenticated = this.isNotNullAndTrue(req, "com.ibm.ws.webcontainer.security.openidconnect.propagation.token.authenticated");
            boolean bAuthnSessionDisabled = (Boolean)req.getAttribute("com.ibm.ws.webcontainer.security.openidconnect.authn.session.disabled");
            String inboundValue = (String)req.getAttribute("com.ibm.ws.webcontainer.security.openidconnect.inbound.propagation.value");
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Booleans: fisrtCall:" + firstCall + " tokenAuthenticated:" + bPropagationTokenAuthenticated + " SessionDisabled:" + bAuthnSessionDisabled + " inboundValue:" + inboundValue), (Object[])new Object[0]);
            }
            if ("none".equals(inboundValue) && !bDisableLtpaCookie || "required".equals(inboundValue) && !bAuthnSessionDisabled || "supported".equals(inboundValue) && !bPropagationTokenAuthenticated && !bDisableLtpaCookie) {
                SSOCookieHelperImpl ssoCh = new SSOCookieHelperImpl(this.webAppSecurityConfig);
                ssoCh.addSSOCookiesToResponse(authResult.getSubject(), req, res);
            }
        }
        return authResult;
    }

    boolean isNotNullAndTrue(HttpServletRequest req, String key) {
        Boolean result = (Boolean)req.getAttribute(key);
        if (result != null) {
            return result;
        }
        return false;
    }

    private AuthenticationResult handleOidcServerAuth(HttpServletRequest req, HttpServletResponse res) {
        AuthenticationResult authResult = this.OIDC_SERVER_CONT;
        OAuth20Service oauthService = (OAuth20Service)this.oauthServiceRef.getService();
        if (oauthService == null) {
            return new AuthenticationResult(AuthResult.CONTINUE, "OAuth service is not available, skipping OAuth...");
        }
        OidcServer oidcServer = (OidcServer)this.oidcServerRef.getService();
        if (oidcServer == null) {
            return this.OIDC_SERVER_CONT;
        }
        ProviderAuthenticationResult oidcResult = oidcServer.authenticate(req, res, this.oauthServiceRef);
        if (oidcResult.getStatus() != AuthResult.SUCCESS) {
            return new AuthenticationResult(AuthResult.FAILURE, "OpenID Connect server failed the request with status: " + (Object)((Object)oidcResult.getStatus()));
        }
        if (authResult.getStatus() == AuthResult.SUCCESS && authResult.getUserName() != null) {
            authResult = this.authHelper.loginWithUserName(req, res, oidcResult.getUserName(), oidcResult.getSubject(), oidcResult.getCustomProperties(), false);
        }
        return authResult;
    }

    private AuthenticationResult handleOAuth(HttpServletRequest req, HttpServletResponse res) {
        AuthenticationResult authResult = this.OAUTH_CONT;
        if (this.oauthServiceRef != null) {
            OAuth20Service oauthService = (OAuth20Service)this.oauthServiceRef.getService();
            if (oauthService == null) {
                return new AuthenticationResult(AuthResult.CONTINUE, "OAuth service is not available, skipping OAuth...");
            }
            ProviderAuthenticationResult oauthResult = oauthService.authenticate(req, res);
            if (oauthResult.getStatus() == AuthResult.CONTINUE) {
                return this.OAUTH_CONT;
            }
            if (oauthResult.getStatus() == AuthResult.FAILURE) {
                if (401 == oauthResult.getHttpStatusCode()) {
                    return new AuthenticationResult(AuthResult.OAUTH_CHALLENGE, "OAuth service failed the request");
                }
                return new AuthenticationResult(AuthResult.FAILURE, "OAuth service failed the request...");
            }
            if (oauthResult.getStatus() != AuthResult.SUCCESS) {
                if (401 == oauthResult.getHttpStatusCode()) {
                    return new AuthenticationResult(AuthResult.OAUTH_CHALLENGE, "OAuth service failed the request due to unsuccessful request");
                }
                return new AuthenticationResult(AuthResult.FAILURE, "OAuth service returned with status: " + (Object)((Object)oauthResult.getStatus()));
            }
            if (oauthResult.getUserName() != null) {
                authResult = this.authHelper.loginWithUserName(req, res, oauthResult.getUserName(), oauthResult.getSubject(), oauthResult.getCustomProperties(), true);
            }
        }
        return authResult;
    }

    private TAIAuthenticator getTaiAuthenticator() {
        TAIAuthenticator taiAuthenticator = null;
        TAIService taiService = (TAIService)this.taiServiceRef.getService();
        Iterator interceptorServices = this.interceptorServiceRef.getServices();
        if (taiService != null || interceptorServices != null && interceptorServices.hasNext()) {
            SecurityService securityService = (SecurityService)this.securityServiceRef.getService();
            taiAuthenticator = new TAIAuthenticator(taiService, this.interceptorServiceRef, securityService.getAuthenticationService(), new SSOCookieHelperImpl(this.webAppSecurityConfig, this.oidcServerRef));
        }
        return taiAuthenticator;
    }

    public WebAuthenticator getSSOAuthenticator(WebRequest webRequest, String ssoCookieName) {
        SecurityMetadata securityMetadata = webRequest.getSecurityMetadata();
        SecurityService securityService = (SecurityService)this.securityServiceRef.getService();
        SSOCookieHelperImpl cookieHelper = ssoCookieName != null ? new SSOCookieHelperImpl(this.webAppSecurityConfig, ssoCookieName) : new SSOCookieHelperImpl(this.webAppSecurityConfig, this.oidcServerRef);
        return new SSOAuthenticator(securityService.getAuthenticationService(), securityMetadata, this.webAppSecurityConfig, cookieHelper);
    }

    public ConcurrentServiceReferenceMap<String, WebAuthenticator> getWebAuthenticatorRefs() {
        return this.webAuthenticatorRef;
    }
}

