/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.security;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.kernel.security.thread.ThreadIdentityException;
import com.ibm.ws.kernel.security.thread.ThreadIdentityManager;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.security.SecurityService;
import com.ibm.ws.security.authentication.AuthenticationService;
import com.ibm.ws.security.authentication.UnauthenticatedSubjectService;
import com.ibm.ws.security.authentication.principals.WSPrincipal;
import com.ibm.ws.security.authentication.tai.TAIService;
import com.ibm.ws.security.authentication.utility.SubjectHelper;
import com.ibm.ws.security.authorization.AuthorizationService;
import com.ibm.ws.security.authorization.jacc.JaccService;
import com.ibm.ws.security.collaborator.CollaboratorUtils;
import com.ibm.ws.security.context.SubjectManager;
import com.ibm.ws.security.registry.RegistryException;
import com.ibm.ws.security.registry.UserRegistry;
import com.ibm.ws.security.registry.UserRegistryService;
import com.ibm.ws.threadContext.ComponentMetaDataAccessorImpl;
import com.ibm.ws.webcontainer.osgi.WebContainer;
import com.ibm.ws.webcontainer.osgi.webapp.WebAppConfiguration;
import com.ibm.ws.webcontainer.security.AuthResult;
import com.ibm.ws.webcontainer.security.AuthenticateApi;
import com.ibm.ws.webcontainer.security.AuthenticationResult;
import com.ibm.ws.webcontainer.security.JaspiService;
import com.ibm.ws.webcontainer.security.PostParameterHelper;
import com.ibm.ws.webcontainer.security.SSOCookieHelperImpl;
import com.ibm.ws.webcontainer.security.UnprotectedResourceService;
import com.ibm.ws.webcontainer.security.WebAppAuthorizationHelper;
import com.ibm.ws.webcontainer.security.WebAppSecurityConfig;
import com.ibm.ws.webcontainer.security.WebAuthenticator;
import com.ibm.ws.webcontainer.security.WebAuthenticatorProxy;
import com.ibm.ws.webcontainer.security.WebProviderAuthenticatorProxy;
import com.ibm.ws.webcontainer.security.WebRequest;
import com.ibm.ws.webcontainer.security.WebRequestImpl;
import com.ibm.ws.webcontainer.security.WebSecurityContext;
import com.ibm.ws.webcontainer.security.internal.BasicAuthAuthenticator;
import com.ibm.ws.webcontainer.security.internal.ChallengeReply;
import com.ibm.ws.webcontainer.security.internal.DenyReply;
import com.ibm.ws.webcontainer.security.internal.FormLoginExtensionProcessor;
import com.ibm.ws.webcontainer.security.internal.FormLogoutExtensionProcessor;
import com.ibm.ws.webcontainer.security.internal.HTTPSRedirectHandler;
import com.ibm.ws.webcontainer.security.internal.OAuthChallengeReply;
import com.ibm.ws.webcontainer.security.internal.PermitReply;
import com.ibm.ws.webcontainer.security.internal.RedirectReply;
import com.ibm.ws.webcontainer.security.internal.ReturnReply;
import com.ibm.ws.webcontainer.security.internal.SRTServletRequestUtils;
import com.ibm.ws.webcontainer.security.internal.TAIChallengeReply;
import com.ibm.ws.webcontainer.security.internal.URLHandler;
import com.ibm.ws.webcontainer.security.internal.WebAppSecurityConfigImpl;
import com.ibm.ws.webcontainer.security.internal.WebReply;
import com.ibm.ws.webcontainer.security.internal.WebSecurityCollaboratorException;
import com.ibm.ws.webcontainer.security.internal.WebSecurityHelperImpl;
import com.ibm.ws.webcontainer.security.jacc.WebAppJaccAuthorizationHelper;
import com.ibm.ws.webcontainer.security.metadata.FormLoginConfiguration;
import com.ibm.ws.webcontainer.security.metadata.LoginConfiguration;
import com.ibm.ws.webcontainer.security.metadata.MatchResponse;
import com.ibm.ws.webcontainer.security.metadata.SecurityConstraint;
import com.ibm.ws.webcontainer.security.metadata.SecurityConstraintCollection;
import com.ibm.ws.webcontainer.security.metadata.SecurityMetadata;
import com.ibm.ws.webcontainer.security.metadata.WebResourceCollection;
import com.ibm.ws.webcontainer.security.oauth20.OAuth20Service;
import com.ibm.ws.webcontainer.security.openid20.OpenidClientService;
import com.ibm.ws.webcontainer.security.openidconnect.OidcClient;
import com.ibm.ws.webcontainer.security.openidconnect.OidcServer;
import com.ibm.wsspi.kernel.service.location.WsLocationAdmin;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.kernel.service.utils.ConcurrentServiceReferenceMap;
import com.ibm.wsspi.security.tai.TrustAssociationInterceptor;
import com.ibm.wsspi.webcontainer.RequestProcessor;
import com.ibm.wsspi.webcontainer.collaborator.IWebAppSecurityCollaborator;
import com.ibm.wsspi.webcontainer.extension.ExtensionProcessor;
import com.ibm.wsspi.webcontainer.metadata.WebComponentMetaData;
import com.ibm.wsspi.webcontainer.metadata.WebModuleMetaData;
import com.ibm.wsspi.webcontainer.security.SecurityViolationException;
import com.ibm.wsspi.webcontainer.servlet.IExtendedRequest;
import com.ibm.wsspi.webcontainer.servlet.IServletContext;
import com.ibm.wsspi.webcontainer.webapp.WebAppConfig;
import java.io.IOException;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.servlet.DispatcherType;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class WebAppSecurityCollaboratorImpl
implements IWebAppSecurityCollaborator,
WebAppAuthorizationHelper {
    private static final TraceComponent tc = Tr.register(WebAppSecurityCollaboratorImpl.class);
    static final String KEY_ID = "id";
    static final String KEY_SERVICE_ID = "service.id";
    static final String KEY_COMPONENT_NAME = "component.name";
    public static final String KEY_SECURITY_SERVICE = "securityService";
    public static final String KEY_TAI_SERVICE = "taiService";
    public static final String KEY_INTERCEPTOR_SERVICE = "interceptorService";
    static final String KEY_OAUTH_SERVICE = "oauthService";
    static final String KEY_OIDC_SERVER = "oidcServer";
    static final String KEY_OIDC_CLIENT = "oidcClient";
    static final String KEY_OPENID_CLIENT_SERVICE = "openidClientService";
    static final String KEY_JACC_SERVICE = "jaccService";
    static final String JASPI_SERVICE_COMPONENT_NAME = "com.ibm.ws.security.jaspi";
    public static final String KEY_WEB_AUTHENTICATOR = "webAuthenticator";
    public static final String KEY_UNPROTECTED_RESOURCE_SERVICE = "unprotectedResourceService";
    protected final ConcurrentServiceReferenceMap<String, WebAuthenticator> webAuthenticatorRef = new ConcurrentServiceReferenceMap("webAuthenticator");
    protected final ConcurrentServiceReferenceMap<String, UnprotectedResourceService> unprotectedResourceServiceRef = new ConcurrentServiceReferenceMap("unprotectedResourceService");
    protected final AtomicServiceReference<TAIService> taiServiceRef = new AtomicServiceReference("taiService");
    protected final ConcurrentServiceReferenceMap<String, TrustAssociationInterceptor> interceptorServiceRef = new ConcurrentServiceReferenceMap("interceptorService");
    protected final AtomicServiceReference<OAuth20Service> oauthServiceRef = new AtomicServiceReference("oauthService");
    protected final AtomicServiceReference<OidcServer> oidcServerRef = new AtomicServiceReference("oidcServer");
    protected final AtomicServiceReference<OidcClient> oidcClientRef = new AtomicServiceReference("oidcClient");
    protected final AtomicServiceReference<OpenidClientService> openidClientRef = new AtomicServiceReference("openidClientService");
    protected final AtomicServiceReference<SecurityService> securityServiceRef = new AtomicServiceReference("securityService");
    protected final AtomicServiceReference<JaccService> jaccServiceRef = new AtomicServiceReference("jaccService");
    private final String KEY_LOCATION_ADMIN = "locationAdmin";
    private final AtomicServiceReference<WsLocationAdmin> locationAdminRef = new AtomicServiceReference("locationAdmin");
    private static final WebReply PERMIT_REPLY = new PermitReply();
    private static final WebReply DENY_AUTHN_FAILED = new DenyReply("AuthenticationFailed");
    private static final WebReply DENY_AUTHZ_FAILED = new DenyReply("AuthorizationFailed");
    private static final String AUTH_TYPE = "AUTH_TYPE";
    private static final String ALL_AUTHENTICATED_ROLE = "**";
    private static final String STARSTAR_ROLE = "_starstar_";
    private static WebAppSecurityConfig globalConfig = null;
    protected volatile WebAppSecurityConfig webAppSecConfig = null;
    protected volatile AuthenticateApi authenticateApi = null;
    protected volatile PostParameterHelper postParameterHelper = null;
    protected CollaboratorUtils collabUtils;
    protected SubjectHelper subjectHelper;
    protected SubjectManager subjectManager;
    protected HTTPSRedirectHandler httpsRedirectHandler;
    protected WebAuthenticatorProxy authenticatorProxy;
    protected WebProviderAuthenticatorProxy providerAuthenticatorProxy;
    private UnauthenticatedSubjectService unauthenticatedSubjectService;
    private WebAppAuthorizationHelper wasch = this;
    private boolean isJaspiEnabled = false;
    static final long serialVersionUID = -7101035121847652981L;

    public WebAppSecurityCollaboratorImpl() {
        this(new SubjectHelper(), new SubjectManager(), new HTTPSRedirectHandler());
    }

    public WebAppSecurityCollaboratorImpl(SubjectHelper subjectHelper, SubjectManager subjectManager, HTTPSRedirectHandler httpsRedirectHandler) {
        this.subjectHelper = subjectHelper;
        this.subjectManager = subjectManager;
        this.httpsRedirectHandler = httpsRedirectHandler;
        this.collabUtils = new CollaboratorUtils(subjectManager);
    }

    public WebAppSecurityCollaboratorImpl(SubjectHelper subjectHelper, SubjectManager subjectManager, HTTPSRedirectHandler httpsRedirectHandler, WebAppSecurityConfig webAppSecConfig) {
        this.subjectHelper = subjectHelper;
        this.subjectManager = subjectManager;
        this.httpsRedirectHandler = httpsRedirectHandler;
        this.webAppSecConfig = webAppSecConfig;
        WebSecurityHelperImpl.setWebAppSecurityConfig(webAppSecConfig);
    }

    public void setSecurityService(ServiceReference<SecurityService> reference) {
        this.securityServiceRef.setReference(reference);
    }

    public void unsetSecurityService(ServiceReference<SecurityService> reference) {
        this.securityServiceRef.unsetReference(reference);
    }

    public void setTaiService(ServiceReference<TAIService> reference) {
        this.taiServiceRef.setReference(reference);
    }

    public void unsetTaiService(ServiceReference<TAIService> reference) {
        this.taiServiceRef.unsetReference(reference);
    }

    public synchronized void setInterceptorService(ServiceReference<TrustAssociationInterceptor> ref) {
        String id = this.getComponentId(ref);
        this.interceptorServiceRef.putReference((Object)id, ref);
    }

    public synchronized void unsetInterceptorService(ServiceReference<TrustAssociationInterceptor> ref) {
        String id = this.getComponentId(ref);
        this.interceptorServiceRef.removeReference((Object)id, ref);
    }

    protected void setOauthService(ServiceReference<OAuth20Service> reference) {
        this.oauthServiceRef.setReference(reference);
    }

    protected void unsetOauthService(ServiceReference<OAuth20Service> reference) {
        this.oauthServiceRef.unsetReference(reference);
    }

    protected void setOidcServer(ServiceReference<OidcServer> reference) {
        this.oidcServerRef.setReference(reference);
        if (this.webAppSecConfig != null) {
            this.webAppSecConfig.setSsoCookieName(this.oidcServerRef, this.oidcClientRef);
        }
    }

    protected void unsetOidcServer(ServiceReference<OidcServer> reference) {
        this.oidcServerRef.unsetReference(reference);
    }

    protected void setOidcClient(ServiceReference<OidcClient> reference) {
        this.oidcClientRef.setReference(reference);
        if (this.webAppSecConfig != null) {
            this.webAppSecConfig.setSsoCookieName(this.oidcServerRef, this.oidcClientRef);
        }
    }

    protected void unsetOidcClient(ServiceReference<OidcClient> reference) {
        this.oidcClientRef.unsetReference(reference);
    }

    protected void setOpenidClientService(ServiceReference<OpenidClientService> reference) {
        this.openidClientRef.setReference(reference);
    }

    protected void unsetOpenidClientService(ServiceReference<OpenidClientService> reference) {
        this.openidClientRef.unsetReference(reference);
    }

    public void setWebAuthenticator(ServiceReference<WebAuthenticator> ref) {
        String cn = (String)ref.getProperty(KEY_COMPONENT_NAME);
        this.webAuthenticatorRef.putReference((Object)cn, ref);
        if (cn.equals(JASPI_SERVICE_COMPONENT_NAME)) {
            this.isJaspiEnabled = true;
        }
    }

    public void unsetWebAuthenticator(ServiceReference<WebAuthenticator> ref) {
        String cn = (String)ref.getProperty(KEY_COMPONENT_NAME);
        this.webAuthenticatorRef.removeReference((Object)cn, ref);
        if (cn.equals(JASPI_SERVICE_COMPONENT_NAME)) {
            this.isJaspiEnabled = false;
        }
    }

    public void setUnprotectedResourceService(ServiceReference<UnprotectedResourceService> ref) {
        this.unprotectedResourceServiceRef.putReference((Object)this.getServiceId(ref), ref);
    }

    public void unsetUnprotectedResourceService(ServiceReference<UnprotectedResourceService> ref) {
        this.unprotectedResourceServiceRef.removeReference((Object)this.getServiceId(ref), ref);
    }

    String getServiceId(ServiceReference<UnprotectedResourceService> ref) {
        long lId = (Long)ref.getProperty(KEY_SERVICE_ID);
        return "urs_" + lId;
    }

    public void setUnauthenticatedSubjectService(UnauthenticatedSubjectService srv) {
        this.unauthenticatedSubjectService = srv;
    }

    protected void unsetUnauthenticatedSubjectService(UnauthenticatedSubjectService srv) {
        if (this.unauthenticatedSubjectService == srv) {
            this.unauthenticatedSubjectService = null;
        }
    }

    protected void setLocationAdmin(ServiceReference<WsLocationAdmin> ref) {
        this.locationAdminRef.setReference(ref);
    }

    protected void unsetLocationAdmin(ServiceReference<WsLocationAdmin> ref) {
        this.locationAdminRef.unsetReference(ref);
    }

    protected void setJaccService(ServiceReference<JaccService> ref) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"enabling JACC service", (Object[])new Object[0]);
        }
        this.jaccServiceRef.setReference(ref);
        this.wasch = new WebAppJaccAuthorizationHelper(this.jaccServiceRef);
    }

    protected void unsetJaccService(ServiceReference<JaccService> ref) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"disabling JACC service", (Object[])new Object[0]);
        }
        this.jaccServiceRef.unsetReference(ref);
        this.wasch = this;
    }

    protected void activate(ComponentContext cc, Map<String, Object> props) {
        this.locationAdminRef.activate(cc);
        this.securityServiceRef.activate(cc);
        this.interceptorServiceRef.activate(cc);
        this.taiServiceRef.activate(cc);
        this.oauthServiceRef.activate(cc);
        this.oidcServerRef.activate(cc);
        this.oidcClientRef.activate(cc);
        this.openidClientRef.activate(cc);
        this.jaccServiceRef.activate(cc);
        this.webAuthenticatorRef.activate(cc);
        this.unprotectedResourceServiceRef.activate(cc);
        this.webAppSecConfig = new WebAppSecurityConfigImpl(props, this.locationAdminRef, this.oidcServerRef, this.oidcClientRef);
        WebSecurityHelperImpl.setWebAppSecurityConfig(this.webAppSecConfig);
        SSOCookieHelperImpl ssoCookieHelper = new SSOCookieHelperImpl(this.webAppSecConfig, this.oidcServerRef);
        this.authenticateApi = new AuthenticateApi(ssoCookieHelper, this.securityServiceRef, this.collabUtils, this.webAuthenticatorRef, this.unprotectedResourceServiceRef);
        this.postParameterHelper = new PostParameterHelper(this.webAppSecConfig);
        this.providerAuthenticatorProxy = new WebProviderAuthenticatorProxy(this.securityServiceRef, this.taiServiceRef, this.interceptorServiceRef, this.webAppSecConfig, this.oauthServiceRef, this.openidClientRef, this.oidcServerRef, this.oidcClientRef, this.webAuthenticatorRef);
        this.authenticatorProxy = new WebAuthenticatorProxy(this.webAppSecConfig, this.postParameterHelper, this.securityServiceRef, this.providerAuthenticatorProxy, this.oidcServerRef);
    }

    protected void modified(Map<String, Object> newProperties) {
        WebAppSecurityConfigImpl newWebAppSecConfig = new WebAppSecurityConfigImpl(newProperties, this.locationAdminRef, this.oidcServerRef, this.oidcClientRef);
        String deltaString = newWebAppSecConfig.getChangedProperties(this.webAppSecConfig);
        this.webAppSecConfig = newWebAppSecConfig;
        WebSecurityHelperImpl.setWebAppSecurityConfig(this.webAppSecConfig);
        SSOCookieHelperImpl ssoCookieHelper = new SSOCookieHelperImpl(this.webAppSecConfig, this.oidcServerRef);
        this.authenticateApi = new AuthenticateApi(ssoCookieHelper, this.securityServiceRef, this.collabUtils, this.webAuthenticatorRef, this.unprotectedResourceServiceRef);
        this.postParameterHelper = new PostParameterHelper(this.webAppSecConfig);
        this.providerAuthenticatorProxy = new WebProviderAuthenticatorProxy(this.securityServiceRef, this.taiServiceRef, this.interceptorServiceRef, this.webAppSecConfig, this.oauthServiceRef, this.openidClientRef, this.oidcServerRef, this.oidcClientRef, this.webAuthenticatorRef);
        this.authenticatorProxy = new WebAuthenticatorProxy(this.webAppSecConfig, this.postParameterHelper, this.securityServiceRef, this.providerAuthenticatorProxy, this.oidcServerRef);
        Tr.audit((TraceComponent)tc, (String)"WEB_APP_SECURITY_CONFIGURATION_UPDATED", (Object[])new Object[]{deltaString});
    }

    protected void deactivate(ComponentContext cc) {
        this.locationAdminRef.deactivate(cc);
        this.securityServiceRef.deactivate(cc);
        this.taiServiceRef.deactivate(cc);
        this.interceptorServiceRef.deactivate(cc);
        this.oauthServiceRef.deactivate(cc);
        this.oidcServerRef.deactivate(cc);
        this.oidcClientRef.deactivate(cc);
        this.openidClientRef.deactivate(cc);
        this.jaccServiceRef.deactivate(cc);
        this.webAuthenticatorRef.deactivate(cc);
        this.unprotectedResourceServiceRef.deactivate(cc);
        WebSecurityHelperImpl.setWebAppSecurityConfig(null);
    }

    /*
     * WARNING - void declaration
     */
    public ExtensionProcessor getFormLoginExtensionProcessor(IServletContext webapp) {
        try {
            SecurityService securityService = (SecurityService)this.securityServiceRef.getService();
            UserRegistryService userRegistryService = securityService.getUserRegistryService();
            UserRegistry userRegistry = null;
            if (userRegistryService.isUserRegistryConfigured()) {
                userRegistry = userRegistryService.getUserRegistry();
            }
            return new FormLoginExtensionProcessor(this.webAppSecConfig, securityService.getAuthenticationService(), userRegistry, webapp, this.providerAuthenticatorProxy, this.oidcServerRef, this.webAuthenticatorRef);
        }
        catch (RegistryException securityService) {
            FFDCFilter.processException((Throwable)securityService, (String)"com.ibm.ws.webcontainer.security.WebAppSecurityCollaboratorImpl", (String)"383", (Object)this, (Object[])new Object[]{webapp});
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                void e;
                Tr.debug((TraceComponent)tc, (String)"RegistryException while trying to create FormLoginExtensionProcessor", (Object[])new Object[]{e});
            }
            return null;
        }
    }

    public ExtensionProcessor getFormLogoutExtensionProcessor(IServletContext webapp) {
        return new FormLogoutExtensionProcessor(webapp, this.webAppSecConfig, this.getAuthenticateApi(this.webAppSecConfig, this.oidcServerRef, this.securityServiceRef, this.collabUtils));
    }

    public Principal getUserPrincipal() {
        return this.collabUtils.getCallerPrincipal(false, null, true, this.isJaspiEnabled);
    }

    public void handleException(HttpServletRequest req, HttpServletResponse rsp, Throwable wse) throws ServletException, IOException, ClassCastException {
        WebReply reply = ((WebSecurityCollaboratorException)wse).getWebReply();
        int sc = reply.getStatusCode();
        if (sc == 500) {
            String method = null;
            if (req != null) {
                method = req.getMethod();
            }
            String url = this.getRequestURL(req);
            ServletException ex = new ServletException(TraceNLS.getFormattedMessage(this.getClass(), (String)"com.ibm.ws.webcontainer.security.resources.WebAppSecurityMessages", (String)"SEC_WEB_INTERNAL_SERVER_ERROR", (Object[])new Object[]{method, url}, (String)"CWWKS9115E: The server encountered an unexpected condition which prevented it from fulfilling the request of method {0} for URL {1}. Review the server logs for more information."), wse);
            throw ex;
        }
        reply.writeResponse(rsp);
    }

    public boolean isUserInRole(String role, IExtendedRequest req) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("isUserInRole role = " + role), (Object[])new Object[0]);
        }
        if (role == null) {
            return false;
        }
        Subject subject = this.subjectManager.getCallerSubject();
        if (subject == null) {
            return false;
        }
        return this.wasch.isUserInRole(role, req, subject);
    }

    /*
     * WARNING - void declaration
     */
    public void postInvoke(Object secObject) throws ServletException {
        if (secObject != null) {
            WebAuthenticator jaspiService;
            WebSecurityContext webSecurityContext = (WebSecurityContext)secObject;
            if (webSecurityContext.getJaspiAuthContext() != null && this.webAuthenticatorRef != null && (jaspiService = (WebAuthenticator)this.webAuthenticatorRef.getService((Object)JASPI_SERVICE_COMPONENT_NAME)) != null) {
                try {
                    ((JaspiService)((Object)jaspiService)).postInvoke(webSecurityContext);
                }
                catch (Exception exception) {
                    void e;
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webcontainer.security.WebAppSecurityCollaboratorImpl", (String)"479", (Object)this, (Object[])new Object[]{secObject});
                    throw new ServletException((Throwable)e);
                }
            }
            Subject invokedSubject = webSecurityContext.getInvokedSubject();
            Subject receivedSubject = webSecurityContext.getReceivedSubject();
            this.subjectManager.setCallerSubject(receivedSubject);
            this.subjectManager.setInvocationSubject(invokedSubject);
            try {
                this.resetSyncToOSThread(webSecurityContext);
            }
            catch (ThreadIdentityException threadIdentityException) {
                void e;
                FFDCFilter.processException((Throwable)threadIdentityException, (String)"com.ibm.ws.webcontainer.security.WebAppSecurityCollaboratorImpl", (String)"492", (Object)this, (Object[])new Object[]{secObject});
                throw new ServletException((Throwable)e);
            }
        }
    }

    public Object preInvoke(HttpServletRequest req, HttpServletResponse resp, String servletName, boolean enforceSecurity) throws SecurityViolationException, IOException {
        Subject invokedSubject = this.subjectManager.getInvocationSubject();
        Subject receivedSubject = this.subjectManager.getCallerSubject();
        WebSecurityContext webSecurityContext = new WebSecurityContext(invokedSubject, receivedSubject);
        this.setUnauthenticatedSubjectIfNeeded(invokedSubject, receivedSubject);
        if (enforceSecurity) {
            if (req != null) {
                this.performSecurityChecks(req, resp, receivedSubject, webSecurityContext);
            }
            this.performDelegation(servletName);
            this.syncToOSThread(webSecurityContext);
        }
        return webSecurityContext;
    }

    /*
     * WARNING - void declaration
     */
    private void syncToOSThread(WebSecurityContext webSecurityContext) throws SecurityViolationException {
        try {
            Object token = ThreadIdentityManager.setAppThreadIdentity((Subject)this.subjectManager.getInvocationSubject());
            webSecurityContext.setSyncToOSThreadToken(token);
        }
        catch (ThreadIdentityException token) {
            void tie;
            FFDCFilter.processException((Throwable)token, (String)"com.ibm.ws.webcontainer.security.WebAppSecurityCollaboratorImpl", (String)"541", (Object)this, (Object[])new Object[]{webSecurityContext});
            SecurityViolationException secVE = this.convertWebSecurityException(new WebSecurityCollaboratorException(tie.getMessage(), DENY_AUTHZ_FAILED, webSecurityContext));
            throw secVE;
        }
    }

    private void resetSyncToOSThread(WebSecurityContext webSecurityContext) throws ThreadIdentityException {
        Object token = webSecurityContext.getSyncToOSThreadToken();
        if (token != null) {
            ThreadIdentityManager.resetChecked((Object)token);
        }
    }

    private void performSecurityChecks(HttpServletRequest req, HttpServletResponse resp, Subject receivedSubject, WebSecurityContext webSecurityContext) throws SecurityViolationException, IOException {
        String uriName = new URLHandler(this.webAppSecConfig).getServletURI(req);
        SecurityMetadata securityMetadata = this.getSecurityMetadata();
        MatchResponse matchResponse = this.getMatchResponse(req);
        WebRequestImpl webRequest = new WebRequestImpl(req, resp, this.getApplicationName(), webSecurityContext, securityMetadata, matchResponse, this.webAppSecConfig);
        WebReply webReply = null;
        if (this.isJaspiEnabled && ((JaspiService)this.webAuthenticatorRef.getService((Object)JASPI_SERVICE_COMPONENT_NAME)).isAnyProviderRegistered()) {
            webReply = this.handleJaspi(receivedSubject, uriName, webRequest, webSecurityContext);
        }
        if (webReply == null) {
            this.performPrecludedAccessTests(webRequest, webSecurityContext, uriName);
            this.optionallyAuthenticateUnprotectedResource(webRequest);
            webReply = this.determineWebReply(receivedSubject, uriName, webRequest);
        }
        this.validateWebReply(webSecurityContext, webReply);
        webReply.writeResponse(resp);
    }

    private WebReply handleJaspi(Subject receivedSubject, String uriName, WebRequest webRequest, WebSecurityContext webSecurityContext) throws SecurityViolationException, IOException {
        this.performPrecludedAccessTests(webRequest, webSecurityContext, uriName);
        WebReply webReply = this.unprotectedSpecialURI(webRequest, uriName, webRequest.getHttpServletRequest().getMethod());
        if (webReply == null) {
            AuthenticationResult authResult = this.providerAuthenticatorProxy.handleJaspi(webRequest, null);
            if (authResult.getStatus() == AuthResult.RETURN) {
                webReply = new ReturnReply(webRequest.getHttpServletResponse().getStatus(), authResult.getReason());
                SecurityViolationException secVE = this.convertWebSecurityException(new WebSecurityCollaboratorException(webReply.message, webReply, webSecurityContext));
                throw secVE;
            }
            if (authResult.getStatus() != AuthResult.CONTINUE) {
                webReply = this.determineWebReply(receivedSubject, uriName, webRequest, authResult);
            }
        }
        return webReply;
    }

    private void performPrecludedAccessTests(WebRequest webRequest, WebSecurityContext webSecurityContext, String uriName) throws SecurityViolationException {
        WebReply webReply = null;
        webReply = this.wasch.checkPrecludedAccess(webRequest, uriName);
        if (webReply != null) {
            this.validateWebReply(webSecurityContext, webReply);
        }
    }

    private void validateWebReply(WebSecurityContext webSecurityContext, WebReply webReply) throws SecurityViolationException {
        if (webReply.getStatusCode() != 200) {
            SecurityViolationException secVE = this.convertWebSecurityException(new WebSecurityCollaboratorException(webReply.message, webReply, webSecurityContext));
            throw secVE;
        }
    }

    public void optionallyAuthenticateUnprotectedResource(WebRequest webRequest) {
        if (this.webAppSecConfig.isUseAuthenticationDataForUnprotectedResourceEnabled() && this.unprotectedResource(webRequest) == PERMIT_REPLY && this.needToAuthenticateSubject(webRequest)) {
            webRequest.disableFormLoginRedirect();
            this.setAuthenticatedSubjectIfNeeded(webRequest);
        }
    }

    private boolean needToAuthenticateSubject(WebRequest webRequest) {
        OidcServer oidcServer;
        OAuth20Service oauthService;
        HttpServletRequest req = webRequest.getHttpServletRequest();
        if (this.isProviderSpecialProtectedURI(req, oauthService = (OAuth20Service)this.oauthServiceRef.getService(), oidcServer = (OidcServer)this.oidcServerRef.getService(), false)) {
            if (this.isProviderSpecialProtectedURI(req, oauthService, oidcServer, true)) {
                webRequest.setProviderSpecialUnprotectedURI(true);
                return true;
            }
            return false;
        }
        if (webRequest.hasAuthenticationData()) {
            return true;
        }
        return this.isUnprotectedResourceAuthenRequired(webRequest);
    }

    private WebReply unprotectedResource(WebRequest webRequest) {
        WebReply webReply = null;
        List<String> requiredRoles = webRequest.getRequiredRoles();
        if (requiredRoles.isEmpty()) {
            webRequest.setUnprotectedURI(true);
            return PERMIT_REPLY;
        }
        SecurityService securityService = (SecurityService)this.securityServiceRef.getService();
        AuthorizationService authzService = securityService.getAuthorizationService();
        if (authzService == null) {
            return new DenyReply("An internal error occured. Unable to perform authorization check.");
        }
        boolean everyoneAllowed = authzService.isEveryoneGranted(webRequest.getApplicationName(), requiredRoles);
        if (everyoneAllowed) {
            webRequest.setUnprotectedURI(true);
            return PERMIT_REPLY;
        }
        return webReply;
    }

    public void setAuthenticatedSubjectIfNeeded(WebRequest webRequest) {
        AuthenticationResult authResult = this.authenticateRequest(webRequest);
        if (authResult != null && authResult.getStatus() == AuthResult.SUCCESS) {
            SubjectManager subjectManager = new SubjectManager();
            subjectManager.setCallerSubject(authResult.getSubject());
        }
    }

    /*
     * WARNING - void declaration
     */
    private void performDelegation(String servletName) {
        Subject delegationSubject;
        block4: {
            String roleName;
            delegationSubject = this.subjectManager.getCallerSubject();
            SecurityMetadata secMetadata = this.getSecurityMetadata();
            if (secMetadata != null && (roleName = secMetadata.getRunAsRoleForServlet(servletName)) != null) {
                try {
                    SecurityService securityService = (SecurityService)this.securityServiceRef.getService();
                    AuthenticationService authService = securityService.getAuthenticationService();
                    delegationSubject = authService.delegate(roleName, this.getApplicationName());
                }
                catch (IllegalArgumentException securityService) {
                    void e;
                    FFDCFilter.processException((Throwable)securityService, (String)"com.ibm.ws.webcontainer.security.WebAppSecurityCollaboratorImpl", (String)"733", (Object)this, (Object[])new Object[]{servletName});
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block4;
                    Tr.debug((TraceComponent)tc, (String)"Exception performing delegation.", (Object[])new Object[]{e});
                }
            }
        }
        if (delegationSubject != null) {
            this.subjectManager.setInvocationSubject(delegationSubject);
        }
    }

    public WebReply determineWebReply(Subject receivedSubject, String uriName, WebRequest webRequest) {
        WebReply webReply = this.performInitialChecks(webRequest, uriName);
        if (webReply != null) {
            return webReply;
        }
        AuthenticationResult authResult = this.authenticateRequest(webRequest);
        return this.determineWebReply(receivedSubject, uriName, webRequest, authResult);
    }

    private WebReply determineWebReply(Subject receivedSubject, String uriName, WebRequest webRequest, AuthenticationResult authResult) {
        if (authResult != null && authResult.getStatus() != AuthResult.SUCCESS) {
            String realm = authResult.realm;
            if (realm == null) {
                realm = this.collabUtils.getUserRegistryRealm(this.securityServiceRef);
            }
            return this.createReplyForAuthnFailure(authResult, realm);
        }
        boolean isAuthorized = false;
        if (authResult != null) {
            this.subjectManager.setCallerSubject(authResult.getSubject());
            isAuthorized = this.wasch.authorize(authResult, webRequest, uriName);
        }
        if (isAuthorized) {
            this.subjectManager.setInvocationSubject(authResult.getSubject());
            return new PermitReply();
        }
        this.subjectManager.setCallerSubject(receivedSubject);
        return DENY_AUTHZ_FAILED;
    }

    public Object preInvoke(String servletName) throws SecurityViolationException, IOException {
        return this.preInvoke(null, null, servletName, true);
    }

    public Object preInvoke() throws SecurityViolationException {
        this.subjectManager.clearSubjects();
        return null;
    }

    public boolean authenticate(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Subject callerSubject = this.subjectManager.getCallerSubject();
        if (!this.subjectHelper.isUnauthenticated(callerSubject)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"The underlying login mechanism has committed", (Object[])new Object[0]);
            }
            return true;
        }
        WebReply webReply = PERMIT_REPLY;
        boolean result = true;
        WebRequestImpl webRequest = new WebRequestImpl(req, resp, this.getSecurityMetadata(), this.webAppSecConfig);
        AuthenticationResult authResult = this.authenticateRequest(webRequest);
        if (authResult.getStatus() == AuthResult.SUCCESS) {
            this.authenticateApi = this.getAuthenticateApi(this.webAppSecConfig, this.oidcServerRef, this.securityServiceRef, this.collabUtils);
            this.authenticateApi.postProgrammaticAuthenticate(req, resp, authResult);
        } else {
            String realm = authResult.realm;
            if (realm == null) {
                realm = this.collabUtils.getUserRegistryRealm(this.securityServiceRef);
            }
            webReply = this.createReplyForAuthnFailure(authResult, realm);
            result = false;
        }
        webReply.writeResponse(resp);
        return result;
    }

    public List<String> getURIsInSecurityConstraints(String appName, String contextRoot, String vHost, List<String> urlPatternsInAnnotation) {
        SecurityMetadata ddMetaData = this.getSecurityMetadata();
        ArrayList<String> urlPatternConflicts = null;
        for (String urlPatternFromAnno : urlPatternsInAnnotation) {
            SecurityConstraintCollection securityConstraintCollection = ddMetaData.getSecurityConstraintCollection();
            if (securityConstraintCollection == null) continue;
            List<SecurityConstraint> securityConstraints = securityConstraintCollection.getSecurityConstraints();
            for (SecurityConstraint securityConstraint : securityConstraints) {
                for (WebResourceCollection webResourceColl : securityConstraint.getWebResourceCollections()) {
                    List<String> urlPatternsInDD = webResourceColl.getUrlPatterns();
                    if (!urlPatternsInDD.contains(urlPatternFromAnno)) continue;
                    if (urlPatternConflicts == null) {
                        urlPatternConflicts = new ArrayList<String>();
                    }
                    urlPatternConflicts.add(urlPatternFromAnno);
                }
            }
        }
        return urlPatternConflicts;
    }

    public void login(HttpServletRequest req, HttpServletResponse resp, String username, @Sensitive String password) throws ServletException {
        BasicAuthAuthenticator basicAuthAuthenticator = this.getBasicAuthAuthenticator();
        if (basicAuthAuthenticator == null) {
            String url = this.getRequestURL(req);
            throw new ServletException(TraceNLS.getFormattedMessage(this.getClass(), (String)"com.ibm.ws.webcontainer.security.resources.WebAppSecurityMessages", (String)"SEC_WEB_NULL_AUTHENTICATOR", (Object[])new Object[]{url, username}, (String)"CWWKS9116E: Login to the URL {0} failed for user {1} due to an internal error. Review the server logs for more information."));
        }
        AuthenticateApi aa = this.getAuthenticateApi(this.webAppSecConfig, this.oidcServerRef, this.securityServiceRef, this.collabUtils);
        aa.login(req, resp, username, password, this.webAppSecConfig, basicAuthAuthenticator);
        String authType = this.getSecurityMetadata().getLoginConfiguration().getAuthenticationMethod();
        SRTServletRequestUtils.setPrivateAttribute(req, AUTH_TYPE, authType);
    }

    public void logout(HttpServletRequest res, HttpServletResponse resp) throws ServletException {
        AuthenticateApi aa = this.getAuthenticateApi(this.webAppSecConfig, this.oidcServerRef, this.securityServiceRef, this.collabUtils);
        aa.logoutServlet30(res, resp, this.webAppSecConfig);
    }

    private SecurityViolationException convertWebSecurityException(WebSecurityCollaboratorException e) {
        int sc = 403;
        WebReply wr = e.getWebReply();
        if (wr != null) {
            sc = wr.getStatusCode();
        }
        SecurityViolationException secVE = new SecurityViolationException(e.getMessage(), sc);
        secVE.initCause((Throwable)e);
        secVE.setWebSecurityContext(e.getWebSecurityContext());
        return secVE;
    }

    private boolean setUnauthenticatedSubjectIfNeeded(Subject invokedSubject, Subject receivedSubject) {
        if (invokedSubject == null && receivedSubject == null) {
            SubjectManager sm = new SubjectManager();
            sm.setInvocationSubject(this.unauthenticatedSubjectService.getUnauthenticatedSubject());
            return true;
        }
        return false;
    }

    public AuthenticationResult authenticateRequest(WebRequest webRequest) {
        WebAuthenticatorProxy authenticator = this.getWebAuthenticatorProxy();
        return authenticator.authenticate(webRequest);
    }

    protected WebAuthenticatorProxy getWebAuthenticatorProxy() {
        return this.authenticatorProxy;
    }

    public BasicAuthAuthenticator getBasicAuthAuthenticator() {
        WebAuthenticatorProxy authenticatorProxy = this.getWebAuthenticatorProxy();
        return authenticatorProxy.getBasicAuthAuthenticator();
    }

    public WebReply createReplyForAuthnFailure(AuthenticationResult authResult, String realm) {
        WebReply reply = null;
        switch (authResult.getStatus()) {
            case FAILURE: {
                return DENY_AUTHN_FAILED;
            }
            case SEND_401: {
                return new ChallengeReply(realm);
            }
            case OAUTH_CHALLENGE: {
                return new OAuthChallengeReply(authResult.getReason());
            }
            case TAI_CHALLENGE: {
                return new TAIChallengeReply(authResult.getTAIChallengeCode());
            }
            case REDIRECT: {
                return new RedirectReply(authResult.getRedirectURL(), authResult.getCookies());
            }
            case UNKNOWN: 
            case CONTINUE: {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Authentication failed with status [" + (Object)((Object)authResult.getStatus()) + "] and reason [" + authResult.getReason() + "]"), (Object[])new Object[0]);
                }
                return DENY_AUTHN_FAILED;
            }
        }
        return reply;
    }

    public boolean authorize(AuthenticationResult authResult, String appName, String uriName, Subject previousCaller, List<String> requiredRoles) {
        this.subjectManager.setCallerSubject(authResult.getSubject());
        boolean isAuthorized = this.authorize(authResult, appName, uriName, requiredRoles);
        if (isAuthorized) {
            this.subjectManager.setInvocationSubject(authResult.getSubject());
        } else {
            this.subjectManager.setCallerSubject(previousCaller);
        }
        return isAuthorized;
    }

    private boolean authorize(AuthenticationResult authResult, String appName, String uriName, List<String> requiredRoles) {
        SecurityService securityService = (SecurityService)this.securityServiceRef.getService();
        if (securityService == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Authorization failed due to null securityService object. Known to occur when a request comes during server shutdown.", (Object[])new Object[0]);
            }
            return false;
        }
        AuthorizationService authzService = securityService.getAuthorizationService();
        if (authzService == null) {
            return false;
        }
        boolean isAuthorized = authzService.isAuthorized(appName, requiredRoles, authResult.getSubject());
        if (!isAuthorized) {
            String authUserName = authResult.getUserName();
            String authRealm = authResult.getRealm();
            if (authRealm != null && authUserName != null) {
                Tr.audit((TraceComponent)tc, (String)"SEC_AUTHZ_FAILED", (Object[])new Object[]{authUserName.concat(":").concat(authRealm), appName, uriName, requiredRoles});
            } else {
                authUserName = authResult.getSubject().getPrincipals(WSPrincipal.class).iterator().next().getName();
                Tr.audit((TraceComponent)tc, (String)"SEC_AUTHZ_FAILED", (Object[])new Object[]{authUserName, appName, uriName, requiredRoles});
            }
        }
        return isAuthorized;
    }

    public WebReply performInitialChecks(WebRequest webRequest, String uriName) {
        WebReply webReply = null;
        HttpServletRequest req = webRequest.getHttpServletRequest();
        String methodName = req.getMethod();
        if (uriName == null || uriName.length() == 0) {
            return new DenyReply("Invalid URI passed to Security Collaborator.");
        }
        if (this.unsupportedAuthMech()) {
            return new DenyReply("Authentication Failed : DIGEST not supported");
        }
        if (this.wasch.isSSLRequired(webRequest, uriName)) {
            return this.httpsRedirectHandler.getHTTPSRedirectWebReply(req);
        }
        webReply = this.unprotectedSpecialURI(webRequest, uriName, methodName);
        if (webReply != null) {
            return webReply;
        }
        webReply = this.unprotectedResource(webRequest);
        if (webReply == PERMIT_REPLY) {
            if (this.shouldWePerformTAIForUnProtectedURI(webRequest)) {
                return null;
            }
            return webReply;
        }
        return null;
    }

    private boolean shouldWePerformTAIForUnProtectedURI(WebRequest webRequest) {
        if (this.taiServiceRef.getService() != null) {
            return ((TAIService)this.taiServiceRef.getService()).isInvokeForUnprotectedURI();
        }
        return false;
    }

    public boolean unsupportedAuthMech() {
        String authType;
        LoginConfiguration lc;
        boolean result = false;
        SecurityMetadata sm = this.getSecurityMetadata();
        if (sm != null && (lc = sm.getLoginConfiguration()) != null && "DIGEST".equalsIgnoreCase(authType = lc.getAuthenticationMethod())) {
            result = true;
        }
        return result;
    }

    private MatchResponse getMatchResponse(HttpServletRequest req) throws SecurityViolationException {
        MatchResponse matchResponse = MatchResponse.NO_MATCH_RESPONSE;
        if (req != null) {
            String method = req.getMethod();
            String uriName = new URLHandler(this.webAppSecConfig).getServletURI(req);
            SecurityMetadata securityMetadata = this.getSecurityMetadata();
            SecurityConstraintCollection collection = securityMetadata.getSecurityConstraintCollection();
            if (null != collection) {
                matchResponse = collection.getMatchResponse(uriName, method);
            }
            if (MatchResponse.CUSTOM_NO_MATCH_RESPONSE.equals(matchResponse)) {
                String url = this.getRequestURL(req);
                throw new SecurityViolationException(TraceNLS.getFormattedMessage(this.getClass(), (String)"com.ibm.ws.webcontainer.security.resources.WebAppSecurityMessages", (String)"SEC_WEB_ILLEGAL_REQUEST", (Object[])new Object[]{method, url}, (String)"CWWKS9117E: The method {0} is not allowed to process for URL {1}. If this error is unexpected, ensure that the application allows the methods that the client is requesting."), 403);
            }
        }
        return matchResponse;
    }

    protected String getApplicationName() {
        ComponentMetaData cmd = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().getComponentMetaData();
        WebModuleMetaData wmmd = (WebModuleMetaData)((WebComponentMetaData)cmd).getModuleMetaData();
        return wmmd.getConfiguration().getApplicationName();
    }

    protected String getModuleName() {
        ComponentMetaData cmd = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().getComponentMetaData();
        WebModuleMetaData wmmd = (WebModuleMetaData)((WebComponentMetaData)cmd).getModuleMetaData();
        return wmmd.getConfiguration().getModuleName();
    }

    public SecurityMetadata getSecurityMetadata() {
        SecurityMetadata secMetadata = null;
        ComponentMetaData cmd = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().getComponentMetaData();
        WebModuleMetaData wmmd = (WebModuleMetaData)cmd.getModuleMetaData();
        secMetadata = (SecurityMetadata)wmmd.getSecurityMetaData();
        return secMetadata;
    }

    protected void setSecurityMetadata(SecurityMetadata secMetadata) {
        ComponentMetaData cmd = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().getComponentMetaData();
        WebModuleMetaData wmmd = (WebModuleMetaData)((WebComponentMetaData)cmd).getModuleMetaData();
        wmmd.setSecurityMetaData((Object)secMetadata);
    }

    private boolean isValidAuthMethodForFormLogin(String authenticationMethod) {
        return "FORM".equals(authenticationMethod) || "CLIENT_CERT".equals(authenticationMethod) && this.webAppSecConfig.getAllowFailOverToFormLogin();
    }

    private WebReply unprotectedSpecialURI(WebRequest webRequest, String uriName, String methodName) {
        LoginConfiguration loginConfig = webRequest.getLoginConfig();
        if (loginConfig == null) {
            return null;
        }
        String authenticationMethod = loginConfig.getAuthenticationMethod();
        FormLoginConfiguration formLoginConfig = loginConfig.getFormLoginConfiguration();
        if (formLoginConfig == null || authenticationMethod == null) {
            return null;
        }
        String loginPage = formLoginConfig.getLoginPage();
        String errorPage = formLoginConfig.getErrorPage();
        if (this.isValidAuthMethodForFormLogin(authenticationMethod) && loginPage != null && errorPage != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(" We have a custom login or error page request, web app login URL:[" + loginPage + "], errorPage URL:[" + errorPage + "], and the requested URI:[" + uriName + "]"), (Object[])new Object[0]);
            }
            if (loginPage.equals(uriName) || errorPage.equals(uriName)) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("authorize, login or error page[" + uriName + "]  requested, permit: "), (Object[])new Object[]{PERMIT_REPLY});
                }
                return PERMIT_REPLY;
            }
            if (uriName != null && uriName.equals("/j_security_check") && methodName != null && methodName.equals("POST")) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("authorize, login or error page[" + uriName + "]  requested, permit: "), (Object[])new Object[]{PERMIT_REPLY});
                }
                return PERMIT_REPLY;
            }
        } else if (webRequest.getHttpServletRequest().getDispatcherType().equals((Object)DispatcherType.ERROR)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("authorize, error page[" + uriName + "]  requested, permit: "), (Object[])new Object[]{PERMIT_REPLY});
            }
            return PERMIT_REPLY;
        }
        return null;
    }

    protected String getRequestURL(HttpServletRequest req) {
        String url = null;
        if (req != null) {
            StringBuffer buf = req.getRequestURL();
            String query = req.getQueryString();
            if (query != null && query.length() > 0) {
                buf.append("?").append(query);
            }
            url = buf.toString();
        }
        return url;
    }

    public static void setGlobalWebAppSecurityConfig(WebAppSecurityConfig config) {
        globalConfig = config;
    }

    public static WebAppSecurityConfig getGlobalWebAppSecurityConfig() {
        return globalConfig;
    }

    protected AuthenticateApi getAuthenticateApi(WebAppSecurityConfig webAppSecConfig, AtomicServiceReference<OidcServer> oidcServerRef, AtomicServiceReference<SecurityService> securityServiceRef, CollaboratorUtils collabUtils) {
        if (this.authenticateApi == null) {
            SSOCookieHelperImpl ssoCookieHelper = new SSOCookieHelperImpl(webAppSecConfig, oidcServerRef);
            this.authenticateApi = new AuthenticateApi(ssoCookieHelper, securityServiceRef, collabUtils, this.webAuthenticatorRef, this.unprotectedResourceServiceRef);
        }
        return this.authenticateApi;
    }

    protected boolean isProviderSpecialProtectedURI(HttpServletRequest req, OAuth20Service oauthService, OidcServer oidcServer, boolean protectedUri) {
        if (oidcServer != null && oidcServer.isOIDCSpecificURI(req, protectedUri)) {
            return true;
        }
        return oauthService != null && oauthService.isOauthSpecificURI(req, protectedUri);
    }

    private boolean isServletSpec31() {
        return WebContainer.getServletContainerSpecLevel() >= 31;
    }

    protected WebAppConfig getWebAppConfig() {
        WebModuleMetaData wmmd;
        WebAppConfig wac = null;
        ComponentMetaData cmd = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().getComponentMetaData();
        if (cmd instanceof WebComponentMetaData && !((wac = (wmmd = (WebModuleMetaData)((WebComponentMetaData)cmd).getModuleMetaData()).getConfiguration()) instanceof WebAppConfiguration)) {
            wac = null;
        }
        return wac;
    }

    @Override
    public boolean isUserInRole(String role, IExtendedRequest req, Subject subject) {
        RequestProcessor reqProc = req.getWebAppDispatcherContext().getCurrentServletReference();
        String realRole = null;
        if (reqProc != null) {
            String servletName = reqProc.getName();
            realRole = this.getSecurityMetadata().getSecurityRoleReferenced(servletName, role);
        } else {
            realRole = role;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("isUserInRole realRole = " + realRole), (Object[])new Object[0]);
        }
        if (realRole != null && realRole.equals(ALL_AUTHENTICATED_ROLE)) {
            realRole = STARSTAR_ROLE;
        }
        if (realRole == null) {
            if (role.equals(ALL_AUTHENTICATED_ROLE) && this.isServletSpec31()) {
                realRole = ALL_AUTHENTICATED_ROLE;
            } else {
                return false;
            }
        }
        final Subject finalSubject = subject;
        final ArrayList<String> roles = new ArrayList<String>();
        roles.add(realRole);
        final SecurityService securityService = (SecurityService)this.securityServiceRef.getService();
        boolean inRole = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){
            static final long serialVersionUID = 8098862515352287807L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Boolean run() {
                AuthorizationService authzService = securityService.getAuthorizationService();
                if (authzService == null) {
                    return false;
                }
                return authzService.isAuthorized(WebAppSecurityCollaboratorImpl.this.getApplicationName(), (Collection)roles, finalSubject);
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(1.class);
            }
        });
        return inRole;
    }

    @Override
    public boolean authorize(AuthenticationResult authResult, WebRequest webRequest, String uriName) {
        return this.authorize(authResult, webRequest.getApplicationName(), uriName, webRequest.getRequiredRoles());
    }

    @Override
    public boolean isSSLRequired(WebRequest webRequest, String uriName) {
        return this.httpsRedirectHandler.shouldRedirectToHttps(webRequest);
    }

    @Override
    public WebReply checkPrecludedAccess(WebRequest webRequest, String uriName) {
        DenyReply webReply = null;
        if (webRequest.isAccessPrecluded()) {
            webReply = new DenyReply("Access is precluded because security constraints are specified, but the required roles are empty.");
        } else if (MatchResponse.DENY_MATCH_RESPONSE.equals(webRequest.getMatchResponse())) {
            webReply = new DenyReply("Http uncovered method found, denying reply.");
        } else {
            HttpServletRequest req = webRequest.getHttpServletRequest();
            List<String> requiredRoles = webRequest.getRequiredRoles();
            String defaultMethod = (String)req.getAttribute("com.ibm.ws.webcontainer.security.checkdefaultmethod");
            if (defaultMethod == "TRACE" && requiredRoles.isEmpty()) {
                webReply = new DenyReply("Illegal request. Default implementation of TRACE not allowed.");
            }
        }
        return webReply;
    }

    boolean isUnprotectedResourceAuthenRequired(WebRequest webRequest) {
        HttpServletRequest request = webRequest.getHttpServletRequest();
        Set serviceIds = this.unprotectedResourceServiceRef.keySet();
        for (String serviceId : serviceIds) {
            UnprotectedResourceService service = (UnprotectedResourceService)this.unprotectedResourceServiceRef.getService((Object)serviceId);
            if (!service.isAuthenticationRequired(request)) continue;
            return true;
        }
        return false;
    }

    private String getComponentId(ServiceReference<TrustAssociationInterceptor> ref) {
        String id = (String)ref.getProperty(KEY_ID);
        if (id == null && (id = (String)ref.getProperty(KEY_COMPONENT_NAME)) == null) {
            id = (String)ref.getProperty("component.id");
        }
        return id;
    }
}

