/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.security;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.common.internal.encoder.Base64Coder;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.webcontainer.security.AuthResult;
import com.ibm.ws.webcontainer.security.AuthenticationResult;
import com.ibm.ws.webcontainer.security.CookieHelper;
import com.ibm.ws.webcontainer.security.WebAppSecurityConfig;
import com.ibm.ws.webcontainer.security.internal.StringUtil;
import com.ibm.wsspi.webcontainer.servlet.IExtendedRequest;
import com.ibm.wsspi.webcontainer.servlet.IServletRequest;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class PostParameterHelper {
    private static final TraceComponent tc = Tr.register(PostParameterHelper.class);
    public static final String INITIAL_URL = "INITIAL_URL";
    public static final String PARAM_NAMES = "PARAM_NAMES";
    public static final String PARAM_VALUES = "PARAM_VALUES";
    public static final String POSTPARAM_COOKIE = "WASPostParam";
    private static final String POSTPARAM_FAILED = "NO_PARAMETER";
    private static final String POSTPARAM_URL = "U";
    private static final String POSTPARAM_PARAM = "P";
    private final WebAppSecurityConfig webAppSecurityConfig;
    static final long serialVersionUID = -874649166593953798L;

    public PostParameterHelper(WebAppSecurityConfig webAppSecConfig) {
        this.webAppSecurityConfig = webAppSecConfig;
    }

    /*
     * WARNING - void declaration
     */
    public byte[] getInputStreamData(HttpServletRequest req) {
        byte[] output;
        block6: {
            if (!(req instanceof IServletRequest)) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"It is not an IServletRequest object", (Object[])new Object[0]);
                }
                return null;
            }
            if (!req.getMethod().equalsIgnoreCase("POST")) {
                return null;
            }
            output = null;
            IServletRequest extRequest = (IServletRequest)req;
            try {
                HashMap params = extRequest.getInputStreamData();
                ByteArrayOutputStream baOut = new ByteArrayOutputStream();
                ObjectOutputStream oOut = new ObjectOutputStream(baOut);
                oOut.writeObject(params);
                output = baOut.toByteArray();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Data saved. Lenth : " + output.length), (Object[])new Object[0]);
                }
            }
            catch (IOException params) {
                void e;
                FFDCFilter.processException((Throwable)params, (String)"com.ibm.ws.webcontainer.security.PostParameterHelper", (String)"88", (Object)this, (Object[])new Object[]{req});
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block6;
                Tr.debug((TraceComponent)tc, (String)"An exception saving InputStreamData : ", (Object[])new Object[]{e});
            }
        }
        return output;
    }

    /*
     * WARNING - void declaration
     */
    public void putInputStreamData(HttpServletRequest req, byte[] input) {
        block7: {
            if (!(req instanceof IExtendedRequest)) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"It is not an IExtendedRequest object", (Object[])new Object[0]);
                }
                return;
            }
            if (!req.getMethod().equalsIgnoreCase("POST")) {
                return;
            }
            if (input == null || input.length == 0) {
                return;
            }
            IExtendedRequest extRequest = (IExtendedRequest)req;
            Map restoredMap = null;
            try {
                ByteArrayInputStream inParamsStream = new ByteArrayInputStream(input);
                ObjectInputStream inParamsObjStream = new ObjectInputStream(inParamsStream);
                restoredMap = (Map)inParamsObjStream.readObject();
                if (restoredMap != null) {
                    extRequest.setInputStreamData((HashMap)restoredMap);
                }
            }
            catch (Exception inParamsStream) {
                void e;
                FFDCFilter.processException((Throwable)inParamsStream, (String)"com.ibm.ws.webcontainer.security.PostParameterHelper", (String)"128", (Object)this, (Object[])new Object[]{req, input});
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block7;
                Tr.debug((TraceComponent)tc, (String)"An exception restoring InputStreamData : ", (Object[])new Object[]{e});
            }
        }
    }

    public void save(HttpServletRequest req, HttpServletResponse res) {
        AuthenticationResult authResult = new AuthenticationResult(AuthResult.SUCCESS, (String)null);
        this.save(req, res, authResult);
        List<Cookie> cookieList = authResult.getCookies();
        if (cookieList != null && cookieList.size() > 0) {
            CookieHelper.addCookiesToResponse(cookieList, res);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void save(HttpServletRequest req, HttpServletResponse res, AuthenticationResult authResult) {
        block8: {
            if (!(req instanceof IServletRequest)) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"It is not an IServletRequest object", (Object[])new Object[0]);
                }
                return;
            }
            if (!req.getMethod().equalsIgnoreCase("POST")) {
                return;
            }
            String reqURL = req.getRequestURI();
            IServletRequest extRequest = (IServletRequest)req;
            try {
                HashMap params = extRequest.getInputStreamData();
                String postParamSaveMethod = this.webAppSecurityConfig.getPostParamSaveMethod();
                if (postParamSaveMethod.equalsIgnoreCase("Cookie")) {
                    this.saveToCookie(params, reqURL, authResult);
                } else if (postParamSaveMethod.equalsIgnoreCase("Session")) {
                    this.saveToSession(req, reqURL, params);
                }
            }
            catch (IOException params) {
                void exc;
                FFDCFilter.processException((Throwable)params, (String)"com.ibm.ws.webcontainer.security.PostParameterHelper", (String)"179", (Object)this, (Object[])new Object[]{req, res, authResult});
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block8;
                Tr.debug((TraceComponent)tc, (String)"IO Exception storing POST parameters onto a cookie or session: ", (Object[])new Object[]{exc});
            }
        }
    }

    private void saveToCookie(Map params, String reqURL, AuthenticationResult result) {
        Hashtable<String, Object> cookie = new Hashtable<String, Object>();
        cookie.put(POSTPARAM_URL, reqURL);
        cookie.put(POSTPARAM_PARAM, params);
        String strParam = this.encodeParameters(cookie);
        if (strParam != null) {
            Cookie paramCookie = new Cookie(POSTPARAM_COOKIE, strParam);
            paramCookie.setMaxAge(-1);
            paramCookie.setPath(reqURL);
            if (this.webAppSecurityConfig.getHttpOnlyCookies()) {
                paramCookie.setHttpOnly(true);
            }
            if (this.webAppSecurityConfig.getSSORequiresSSL()) {
                paramCookie.setSecure(true);
            }
            result.setCookie(paramCookie);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("encoded POST parameters: " + strParam), (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - void declaration
     */
    public String encodeParameters(Hashtable cookie) {
        String strParam;
        block5: {
            strParam = null;
            try {
                ByteArrayOutputStream baOut = new ByteArrayOutputStream();
                ObjectOutputStream oOut = new ObjectOutputStream(baOut);
                oOut.writeObject(cookie);
                byte[] baParam = baOut.toByteArray();
                int postParamSaveSize = this.webAppSecurityConfig.getPostParamCookieSize();
                if (baParam != null && baParam.length < postParamSaveSize) {
                    byte[] encParam = Base64Coder.base64Encode(baParam);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("encoded length:" + encParam.length), (Object[])new Object[0]);
                    }
                    strParam = StringUtil.toString(encParam);
                } else {
                    Tr.warning((TraceComponent)tc, (String)"SEC_FORM_POST_NULL_OR_TOO_LARGE", (Object[])new Object[0]);
                }
            }
            catch (IOException baOut) {
                void e;
                FFDCFilter.processException((Throwable)baOut, (String)"com.ibm.ws.webcontainer.security.PostParameterHelper", (String)"237", (Object)this, (Object[])new Object[]{cookie});
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block5;
                Tr.debug((TraceComponent)tc, (String)"Exception storing POST parameters onto a cookie: ", (Object[])new Object[]{e});
            }
        }
        return strParam;
    }

    private void saveToSession(HttpServletRequest req, String reqURL, Map params) {
        HttpSession postparamsession = req.getSession(true);
        if (postparamsession != null && req.getParameterNames() != null) {
            postparamsession.setAttribute(INITIAL_URL, (Object)reqURL);
            postparamsession.setAttribute(PARAM_NAMES, null);
            postparamsession.setAttribute(PARAM_VALUES, (Object)params);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("URL saved: " + reqURL.toString()), (Object[])new Object[0]);
            }
        }
    }

    public void restore(HttpServletRequest req, HttpServletResponse res) {
        this.restore(req, res, false);
    }

    public void restore(HttpServletRequest req, HttpServletResponse res, boolean anyMethod) {
        String postParamSaveMethod;
        if (!(req instanceof IExtendedRequest)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"It is not an IExtendedRequest object", (Object[])new Object[0]);
            }
            return;
        }
        if (!anyMethod && !req.getMethod().equalsIgnoreCase("GET")) {
            return;
        }
        String reqURL = req.getRequestURI();
        IExtendedRequest extRequest = (IExtendedRequest)req;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(" method : " + req.getMethod() + " URL:" + reqURL), (Object[])new Object[0]);
        }
        if ((postParamSaveMethod = this.webAppSecurityConfig.getPostParamSaveMethod()).equalsIgnoreCase("Cookie")) {
            this.restoreFromCookie(extRequest, res, reqURL);
        } else if (postParamSaveMethod.equalsIgnoreCase("Session")) {
            this.restoreFromSession(extRequest, req, reqURL);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void restoreFromSession(IExtendedRequest extRequest, HttpServletRequest req, String reqURL) {
        HttpSession postparamsession;
        block9: {
            postparamsession = req.getSession(false);
            if (postparamsession == null) {
                return;
            }
            String previousReq = (String)postparamsession.getAttribute(INITIAL_URL);
            if (previousReq != null && previousReq.equals(reqURL)) {
                try {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Found the session, restoring POST parameters.", (Object[])new Object[0]);
                    }
                    extRequest.setMethod("POST");
                    Map paramValues = (Map)postparamsession.getAttribute(PARAM_VALUES);
                    if (paramValues != null && !paramValues.isEmpty()) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Restoring POST paramameters for URL : " + reqURL), (Object[])new Object[0]);
                        }
                        extRequest.setInputStreamData((HashMap)paramValues);
                    }
                    break block9;
                }
                catch (IOException paramValues) {
                    FFDCFilter.processException((Throwable)paramValues, (String)"com.ibm.ws.webcontainer.security.PostParameterHelper", (String)"327", (Object)this, (Object[])new Object[]{extRequest, req, reqURL});
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        void exc;
                        Tr.debug((TraceComponent)tc, (String)"IOException restoring POST parameters onto a cookie: ", (Object[])new Object[]{exc});
                    }
                    break block9;
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Parameters NOT restored. Original URL : " + previousReq + " req. URL : " + reqURL), (Object[])new Object[0]);
            }
        }
        postparamsession.setAttribute(INITIAL_URL, null);
        postparamsession.setAttribute(PARAM_NAMES, null);
        postparamsession.setAttribute(PARAM_VALUES, null);
    }

    /*
     * WARNING - void declaration
     */
    private void restoreFromCookie(IExtendedRequest extRequest, HttpServletResponse res, String reqURL) {
        block8: {
            byte[] cookieValueBytes = extRequest.getCookieValueAsBytes(POSTPARAM_COOKIE);
            if (cookieValueBytes == null) {
                return;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Found the cookie, restoring POST parameters: " + new String(cookieValueBytes)), (Object[])new Object[0]);
            }
            extRequest.setMethod("POST");
            try {
                Hashtable restoredMap = this.decodeParameters(cookieValueBytes);
                if (restoredMap != null && restoredMap.get(POSTPARAM_URL).equals(reqURL)) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Restored POST paramameter for original URL:" + restoredMap.get(POSTPARAM_URL)), (Object[])new Object[0]);
                    }
                    Map restoredParams = (Map)restoredMap.get(POSTPARAM_PARAM);
                    extRequest.setInputStreamData((HashMap)restoredParams);
                }
            }
            catch (Exception restoredMap) {
                void e;
                FFDCFilter.processException((Throwable)restoredMap, (String)"com.ibm.ws.webcontainer.security.PostParameterHelper", (String)"364", (Object)this, (Object[])new Object[]{extRequest, res, reqURL});
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block8;
                Tr.debug((TraceComponent)tc, (String)"Exception restoring POST parameters from the cookie: ", (Object[])new Object[]{e});
            }
        }
        Cookie paramCookie = new Cookie(POSTPARAM_COOKIE, POSTPARAM_FAILED);
        paramCookie.setPath(reqURL);
        paramCookie.setMaxAge(0);
        if (this.webAppSecurityConfig.getHttpOnlyCookies()) {
            paramCookie.setHttpOnly(true);
        }
        if (this.webAppSecurityConfig.getSSORequiresSSL()) {
            paramCookie.setSecure(true);
        }
        res.addCookie(paramCookie);
    }

    public Hashtable decodeParameters(byte[] cookieValueBytes) throws IOException, ClassNotFoundException {
        byte[] bParams = Base64Coder.base64Decode(cookieValueBytes);
        ByteArrayInputStream inParamsStream = new ByteArrayInputStream(bParams);
        ObjectInputStream inParamsObjStream = new ObjectInputStream(inParamsStream);
        Hashtable restoredMap = (Hashtable)inParamsObjStream.readObject();
        return restoredMap;
    }
}

