/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.audit.event;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.security.audit.AuditEvent;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.webcontainer.security.AuthenticationResult;
import com.ibm.ws.webcontainer.security.WebRequest;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class AuthenticationEvent
extends AuditEvent {
    private static final TraceComponent tc = Tr.register(AuthenticationEvent.class);
    static final long serialVersionUID = -3647429720385819010L;

    public AuthenticationEvent() {
        this.setInitiator((Map)AuditEvent.STD_INITIATOR.clone());
        this.setObserver((Map)AuditEvent.STD_OBSERVER.clone());
        this.setTarget((Map)AuditEvent.STD_TARGET.clone());
    }

    public AuthenticationEvent(WebRequest webreq, AuthenticationResult authResult) {
        this();
        HttpServletRequest req = webreq.getHttpServletRequest();
        this.set("initiator.host.address", req.getRemoteAddr());
        String agent = req.getHeader("User-Agent");
        if (agent != null) {
            this.set("initiator.host.agent", agent);
        }
        this.set("target.name", req.getRequestURI());
        this.set("target.host.address", req.getLocalAddr() + ":" + req.getLocalPort());
        this.set("target.credential.type", "basic");
        this.set("target.credential.token", "bob");
        switch (authResult.getStatus()) {
            case SUCCESS: {
                this.setOutcome("success");
                break;
            }
            case FAILURE: {
                this.setOutcome("failure");
                this.set("reason.reasonCode", (Object)authResult.getStatus());
                this.set("reason.reasonType", "http");
                break;
            }
        }
    }
}

