/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.zos.registration.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.kernel.zos.NativeMethodManager;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.zos.registration.internal.Product;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class ProductRegistrationImpl {
    private static final TraceComponent tc = Tr.register(ProductRegistrationImpl.class);
    static final long serialVersionUID = -3325036921923361546L;

    public void initialize(NativeMethodManager nativeMethodManager) {
        nativeMethodManager.registerNatives(ProductRegistrationImpl.class);
    }

    public void registerProduct(Product p) {
        String owner = p.owner();
        String name = p.name();
        String version = p.versionRelease();
        byte[] ownerBytes = p.getOwnerBytes();
        byte[] nameBytes = p.getNameBytes();
        byte[] versionBytes = p.getVersionBytes();
        byte[] pidBytes = p.getPidBytes();
        byte[] qualifierBytes = p.getQualifierBytes();
        if (ownerBytes == null || nameBytes == null || versionBytes == null || pidBytes == null || qualifierBytes == null) {
            Tr.error((TraceComponent)tc, (String)"PRODUCT_REGISTRATION_FAILED_BAD_PARM", (Object[])new Object[]{owner, name, version});
            return;
        }
        int native_rc = this.ntv_registerProduct(ownerBytes, nameBytes, versionBytes, pidBytes, qualifierBytes);
        if (native_rc == 0 || native_rc == 4) {
            Tr.info((TraceComponent)tc, (String)"PRODUCT_REGISTRATION_SUCCESSFUL", (Object[])new Object[]{owner, name, version});
            p.setRegistered(true);
        } else {
            Tr.error((TraceComponent)tc, (String)"PRODUCT_REGISTRATION_UNSUCCESSFUL", (Object[])new Object[]{owner, name, version, native_rc});
        }
    }

    public void deregisterProduct(Product p) {
        if (!p.getRegistered()) {
            return;
        }
        int native_rc = this.ntv_deregisterProduct(p.getOwnerBytes(), p.getNameBytes(), p.getVersionBytes(), p.getPidBytes(), p.getQualifierBytes());
        if (native_rc == 0 || native_rc == 4) {
            Tr.info((TraceComponent)tc, (String)"PRODUCT_DEREGISTRATION_SUCCESSFUL", (Object[])new Object[]{p.owner(), p.name(), p.version()});
        } else {
            Tr.error((TraceComponent)tc, (String)"PRODUCT_DEREGISTRATION_UNSUCCESSFUL", (Object[])new Object[]{p.owner(), p.name(), p.version(), native_rc});
        }
    }

    protected native int ntv_registerProduct(byte[] var1, byte[] var2, byte[] var3, byte[] var4, byte[] var5);

    protected native int ntv_deregisterProduct(byte[] var1, byte[] var2, byte[] var3, byte[] var4, byte[] var5);
}

