/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.zos.registration.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.kernel.provisioning.ProductExtension;
import com.ibm.ws.kernel.provisioning.ProductExtensionInfo;
import com.ibm.ws.kernel.zos.NativeMethodManager;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.zos.core.NativeService;
import com.ibm.ws.zos.core.internal.CoreBundleActivator;
import com.ibm.ws.zos.registration.internal.Product;
import com.ibm.ws.zos.registration.internal.ProductRegistrationImpl;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class ProductManager {
    private static final TraceComponent tc = Tr.register(ProductManager.class);
    protected HashMap<String, Product> productMap = new HashMap();
    protected Product baseServer = null;
    protected ProductRegistrationImpl productRegistrationImpl = new ProductRegistrationImpl();
    private int successfullRegistrationCount;
    static final long serialVersionUID = -6974674765924936226L;

    public ProductManager(NativeMethodManager nativeMethodManager) {
        this.productRegistrationImpl.initialize(nativeMethodManager);
    }

    public void start(BundleContext bundleContext) {
        String versionPath = CoreBundleActivator.firstNotNull(bundleContext.getProperty("wlp.lib.dir"), "") + "versions";
        String[] productFiles = this.getProductFiles(versionPath);
        ArrayList<Object> files = productFiles == null ? new ArrayList() : new ArrayList<String>(Arrays.asList(productFiles));
        Iterator productExtensions = ProductExtension.getProductExtensions().iterator();
        while (productExtensions != null && productExtensions.hasNext()) {
            File prodExtVersionDir;
            boolean dirExists;
            String prodExtLocation;
            ProductExtensionInfo prodExt = (ProductExtensionInfo)productExtensions.next();
            String prodExtName = prodExt.getName();
            if (0 == prodExtName.length() || (prodExtLocation = prodExt.getLocation()) == null) continue;
            if (!(prodExtLocation.charAt(0) == '/')) {
                String installPath = CoreBundleActivator.firstNotNull(bundleContext.getProperty("wlp.install.dir"), "");
                File installParent = new File(installPath).getParentFile();
                prodExtLocation = installParent.getAbsolutePath() + "/" + prodExtLocation;
            }
            if (!(dirExists = AccessController.doPrivileged(new PrivilegedAction<Boolean>(prodExtVersionDir = new File(prodExtLocation, "lib/versions")){
                final /* synthetic */ File val$prodExtVersionDir;
                static final long serialVersionUID = -3001126058791452659L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;
                {
                    this.val$prodExtVersionDir = file;
                }

                @Override
                public Boolean run() {
                    return this.val$prodExtVersionDir.exists();
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(1.class);
                }
            }).booleanValue())) continue;
            String[] prodExtVersionFiles = this.getProductFiles(prodExtVersionDir.getAbsolutePath());
            files.addAll(Arrays.asList(prodExtVersionFiles));
        }
        if (files != null && files.size() > 0) {
            this.buildProducts(files);
        }
        this.registerBase();
        this.registerProducts();
        if (this.isServerAuthorizedToDeregister(bundleContext)) {
            Tr.info((TraceComponent)tc, (String)"PRODUCT_REGISTRATION_SUMMARY_AUTHORIZED", (Object[])new Object[]{this.successfullRegistrationCount});
        } else {
            Tr.info((TraceComponent)tc, (String)"PRODUCT_REGISTRATION_SUMMARY_NOT_AUTHORIZED", (Object[])new Object[]{this.successfullRegistrationCount});
        }
    }

    public void stop(BundleContext bundleContext) {
        if (this.isServerAuthorizedToDeregister(bundleContext)) {
            this.deregisterProducts();
            this.deregisterBase();
        }
    }

    protected void registerBase() {
        if (this.baseServer == null) {
            this.baseServer = new Product(null, "IBM", "WAS FOR Z/OS", "8.5", "5655-W65", "WAS Z/OS", null, "true");
        }
        this.productRegistrationImpl.registerProduct(this.baseServer);
        if (this.baseServer.getRegistered()) {
            ++this.successfullRegistrationCount;
        }
    }

    protected void registerProducts() {
        if (!this.productMap.isEmpty()) {
            for (Product p : this.productMap.values()) {
                this.productRegistrationImpl.registerProduct(p);
                if (!p.getRegistered()) continue;
                ++this.successfullRegistrationCount;
            }
        }
    }

    protected void deregisterBase() {
        this.productRegistrationImpl.deregisterProduct(this.baseServer);
        this.baseServer = null;
    }

    protected void deregisterProducts() {
        if (!this.productMap.isEmpty()) {
            for (Product p : this.productMap.values()) {
                this.productRegistrationImpl.deregisterProduct(p);
            }
            this.productMap.clear();
        }
    }

    protected boolean isServerAuthorizedToDeregister(BundleContext bundleContext) {
        boolean authorized = false;
        String filter = "(&(native.service.name=IFADEREG)(is.authorized=true))";
        try {
            ServiceReference[] nativeServices = bundleContext.getServiceReferences(NativeService.class.getCanonicalName(), filter);
            if (nativeServices != null && nativeServices.length > 0) {
                authorized = true;
            }
        }
        catch (InvalidSyntaxException nativeServices) {
            FFDCFilter.processException((Throwable)nativeServices, (String)"com.ibm.ws.zos.registration.internal.ProductManager", (String)"253", (Object)this, (Object[])new Object[]{bundleContext});
        }
        return authorized;
    }

    protected String[] getProductFiles(String versionPath) {
        final String vp = versionPath;
        String[] files = AccessController.doPrivileged(new PrivilegedAction<String[]>(){
            static final long serialVersionUID = -99723688122817338L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public String[] run() {
                File versionDir = new File(vp);
                @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
                @InjectedFFDC
                final class PropertiesFilter
                implements FilenameFilter {
                    private static final String propFiles = ".properties";
                    static final long serialVersionUID = -2054259084767293020L;
                    private static final /* synthetic */ TraceComponent $$$tc$$$;

                    PropertiesFilter() {
                    }

                    @Override
                    public boolean accept(File dir, String name) {
                        return name.endsWith(propFiles);
                    }

                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
                    static {
                        $$$tc$$$ = Tr.register(PropertiesFilter.class);
                    }
                }
                PropertiesFilter filter = new PropertiesFilter();
                String[] files = versionDir.list(filter);
                return files;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(2.class);
            }
        });
        if (files != null && files.length > 0) {
            for (int i = 0; i < files.length; ++i) {
                files[i] = versionPath + "/" + files[i];
            }
        }
        return files;
    }

    protected void buildProducts(List<String> files) {
        HashMap<String, Product> replacesMap = new HashMap<String, Product>();
        for (String file : files) {
            Product product = this.processFile(file);
            if (product == null) continue;
            this.productMap.put(product.productID(), product);
            if (product.replaces() == null) continue;
            replacesMap.put(product.replaces(), product);
        }
        this.baseServer = this.resolveBaseProduct(replacesMap);
        if (this.baseServer != null) {
            this.productMap.remove(this.baseServer.productID());
        }
    }

    protected Product processFile(String filename) {
        Product product = null;
        Properties prop = this.readProperties(filename);
        if (prop != null) {
            product = new Product(prop);
        }
        return product;
    }

    protected Properties readProperties(String filename) {
        FileInputStream fis = this.getPropertiesFile(filename);
        Properties prop = null;
        if (fis != null) {
            prop = this.loadProperties(fis);
            this.closePropertiesFile(fis);
        }
        return prop;
    }

    protected FileInputStream getPropertiesFile(String filename) {
        final String fn = filename;
        FileInputStream fis = AccessController.doPrivileged(new PrivilegedAction<FileInputStream>(){
            static final long serialVersionUID = -4704326921734996181L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public FileInputStream run() {
                FileInputStream theFile = null;
                try {
                    theFile = new FileInputStream(fn);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    FFDCFilter.processException((Throwable)fileNotFoundException, (String)"com.ibm.ws.zos.registration.internal.ProductManager$3", (String)"397", (Object)this, (Object[])new Object[0]);
                }
                return theFile;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(3.class);
            }
        });
        return fis;
    }

    protected Properties loadProperties(FileInputStream fis) {
        Properties prop = null;
        try {
            prop = new Properties();
            prop.load(fis);
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.zos.registration.internal.ProductManager", (String)"417", (Object)this, (Object[])new Object[]{fis});
        }
        return prop;
    }

    protected void closePropertiesFile(FileInputStream fis) {
        try {
            fis.close();
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.zos.registration.internal.ProductManager", (String)"432", (Object)this, (Object[])new Object[]{fis});
        }
    }

    protected Product resolveBaseProduct(HashMap<String, Product> replacesMap) {
        Product base = null;
        base = this.productMap.get("com.ibm.websphere.appserver");
        if (base == null) {
            return base;
        }
        if (!replacesMap.isEmpty()) {
            while (replacesMap.containsKey(base.productID())) {
                this.productMap.remove(base.productID());
                String oldBaseProductID = base.productID();
                base = replacesMap.get(oldBaseProductID);
                replacesMap.remove(oldBaseProductID);
            }
        }
        return base;
    }
}

