/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.zos.registration.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.UnsupportedEncodingException;
import java.util.Properties;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class Product {
    private static final TraceComponent tc = Tr.register(Product.class);
    protected static final String UNKNOWN = "UNKNOWN";
    protected static final String VERSION_DIR_NAME = "versions";
    protected static final String BASE_PRODUCTID = "com.ibm.websphere.appserver";
    protected static final String PROPERTIES_FILE = ".properties";
    protected final String productID;
    protected static final String PRODUCTID = "com.ibm.websphere.productId";
    private final String owner;
    protected static final String OWNER = "com.ibm.websphere.productOwner";
    private final String name;
    protected static final String NAME = "com.ibm.websphere.productName";
    private final String version;
    protected static final String VERSION = "com.ibm.websphere.productVersion";
    private final String pid;
    protected static final String PID = "com.ibm.websphere.productPID";
    private final String qualifier;
    protected static final String QUALIFIER = "com.ibm.websphere.productQualifier";
    private final String replaces;
    protected static final String REPLACES = "com.ibm.websphere.productReplaces";
    private final String gssp;
    protected static final String GSSP = "com.ibm.websphere.gssp";
    protected static final String DEFAULT_BASE_PROD_OWNER = "IBM";
    protected static final String DEFAULT_BASE_PROD_NAME = "WAS FOR Z/OS";
    protected static final String DEFAULT_BASE_PROD_VERSION = "8.5";
    protected static final String DEFAULT_BASE_PID = "5655-W65";
    protected static final String DEFAULT_BASE_PROD_QUALIFIER = "WAS Z/OS";
    protected static final String DEFAULT_BASE_PROD_GSSP = "true";
    private byte[] ownerBytes;
    private byte[] nameBytes;
    private byte[] versionBytes;
    private byte[] pidBytes;
    private byte[] qualifierBytes;
    protected static final int PRODUCT_OWNER_MAX_LENGTH = 16;
    protected static final int PRODUCT_NAME_MAX_LENGTH = 16;
    protected static final int PRODUCT_VERSION_MAX_LENGTH = 8;
    protected static final int PRODUCT_ID_MAX_LENGTH = 8;
    protected static final int PRODUCT_QUALIFIER_MAX_LENGTH = 8;
    private boolean registered;
    static final long serialVersionUID = -2422963442266523104L;

    protected Product(Properties prop) {
        this.productID = this.check(prop.getProperty(PRODUCTID));
        this.owner = this.check(prop.getProperty(OWNER));
        this.name = this.check(prop.getProperty(NAME));
        this.version = this.check(prop.getProperty(VERSION));
        this.pid = this.check(prop.getProperty(PID));
        this.qualifier = this.check(prop.getProperty(QUALIFIER));
        this.replaces = prop.getProperty(REPLACES);
        this.gssp = prop.getProperty(GSSP, "false");
    }

    protected Product(String productID, String owner, String name, String version, String pid, String qualifier, String replaces, String gssp) {
        this.productID = this.check(productID);
        this.owner = this.check(owner);
        this.name = this.check(name);
        this.version = this.check(version);
        this.pid = this.check(pid);
        this.qualifier = this.check(qualifier);
        this.replaces = replaces;
        this.gssp = gssp == null ? "false" : gssp;
    }

    @Trivial
    protected String productID() {
        return this.productID;
    }

    @Trivial
    protected String owner() {
        return this.owner;
    }

    @Trivial
    protected String name() {
        return this.name;
    }

    @Trivial
    protected String version() {
        return this.version;
    }

    @Trivial
    protected String gssp() {
        return this.gssp;
    }

    protected String versionRelease() {
        String[] parts = this.version.split("\\.");
        if (parts.length > 1) {
            return parts[0] + "." + parts[1];
        }
        return this.version;
    }

    @Trivial
    protected String pid() {
        return this.pid;
    }

    @Trivial
    protected String qualifier() {
        return this.qualifier;
    }

    @Trivial
    public String replaces() {
        return this.replaces;
    }

    @Trivial
    protected String check(String s) {
        String t = s == null ? UNKNOWN : s;
        return t;
    }

    protected byte[] getOwnerBytes() {
        this.ownerBytes = this.ownerBytes != null ? this.ownerBytes : this.validateAndTranslate(this.owner, 16, "owner");
        return this.ownerBytes;
    }

    protected byte[] getNameBytes() {
        this.nameBytes = this.nameBytes != null ? this.nameBytes : this.validateAndTranslate(this.name, 16, "name");
        return this.nameBytes;
    }

    protected byte[] getVersionBytes() {
        this.versionBytes = this.gssp.equals(DEFAULT_BASE_PROD_GSSP) ? this.validateAndTranslate("NOTUSAGE", 8, "version") : (this.versionBytes != null ? this.versionBytes : this.validateAndTranslate(this.version, 8, "version"));
        return this.versionBytes;
    }

    protected byte[] getPidBytes() {
        this.pidBytes = this.pidBytes != null ? this.pidBytes : this.validateAndTranslate(this.pid, 8, "id");
        return this.pidBytes;
    }

    protected byte[] getQualifierBytes() {
        this.qualifierBytes = this.qualifierBytes != null ? this.qualifierBytes : this.validateAndTranslate(this.qualifier, 8, "qualifier");
        return this.qualifierBytes;
    }

    @Trivial
    protected void setRegistered(boolean registered) {
        this.registered = registered;
    }

    protected boolean getRegistered() {
        return this.registered;
    }

    @Trivial
    protected byte[] validateAndTranslate(String str, int requiredLength, String parm) {
        byte[] retVal = null;
        if (str == null || str.length() == 0) {
            retVal = this.convertToEbcdic(" ");
            return retVal;
        }
        int strlen = str.length();
        if (strlen > requiredLength) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("RegistrationProcessor::validateAndTranslate, truncating parm " + parm + " from (" + str + ") to (" + str.substring(0, requiredLength) + ")"), (Object[])new Object[0]);
            }
            str = str.substring(0, requiredLength);
        }
        retVal = this.convertToEbcdic(str);
        return retVal;
    }

    @Trivial
    private byte[] convertToEbcdic(String str) {
        byte[] retVal = null;
        try {
            retVal = str.getBytes("Cp1047");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            FFDCFilter.processException((Throwable)unsupportedEncodingException, (String)"com.ibm.ws.zos.registration.internal.Product", (String)"466", (Object)this, (Object[])new Object[]{str});
        }
        return retVal;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(super.toString());
        sb.append(" [Owner: ").append(this.owner == null ? "NULL" : this.owner);
        sb.append(", Name: ").append(this.name == null ? "NULL" : this.name);
        sb.append(", Version: ").append(this.version == null ? "NULL" : this.version);
        sb.append(", ProductId: ").append(this.productID == null ? "NULL" : this.productID);
        sb.append(", PID: ").append(this.pid == null ? "NULL" : this.pid);
        sb.append(", Qualifier: ").append(this.qualifier == null ? "NULL" : this.qualifier);
        sb.append(", Replaces: ").append(this.replaces == null ? "NULL" : this.replaces);
        sb.append(", GSSP: ").append(this.gssp == null ? "false" : this.gssp).append("]");
        return sb.toString();
    }
}

