/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.zos.logging.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.zos.logging.internal.NativeTraceData;
import com.ibm.ws.zos.logging.internal.NativeTraceHandler;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
class TraceListenerThread
extends Thread {
    private final NativeTraceHandler nativeTraceHandler;
    private volatile boolean keepGoing = true;
    private long threadElement_ptr;
    static final long serialVersionUID = 9034272414392446130L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    TraceListenerThread(NativeTraceHandler nativeTraceHandler) {
        this.nativeTraceHandler = nativeTraceHandler;
        this.setDaemon(true);
        this.setName("z/OS Native Trace Processing");
    }

    @Override
    public void run() {
        this.threadElement_ptr = this.nativeTraceHandler.ntv_getThreadElement();
        if (this.threadElement_ptr != 0L) {
            while (this.keepGoing) {
                try {
                    byte[] outputArea = null;
                    try {
                        outputArea = this.nativeTraceHandler.ntv_getTraces(this.threadElement_ptr);
                    }
                    catch (Throwable throwable) {
                        FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.zos.logging.internal.TraceListenerThread", (String)"54", (Object)this, (Object[])new Object[0]);
                    }
                    NativeTraceData traceData = new NativeTraceData(outputArea);
                    this.nativeTraceHandler.writeNativeTrace(traceData.getTraceLevel(), traceData.getTracePoint(), traceData.getVarargListPointer(), traceData.getCreateTime(), traceData.getCreatingTcb(), traceData.getCreateState(), traceData.getCreateKey());
                    this.nativeTraceHandler.ntv_traceWritten(this.threadElement_ptr);
                }
                catch (Exception outputArea) {
                    FFDCFilter.processException((Throwable)outputArea, (String)"com.ibm.ws.zos.logging.internal.TraceListenerThread", (String)"68", (Object)this, (Object[])new Object[0]);
                }
            }
        }
    }

    public void end() {
        this.keepGoing = false;
        this.nativeTraceHandler.ntv_stopListeningForTraces(this.threadElement_ptr);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(TraceListenerThread.class);
    }
}

