/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.zos.jni.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.kernel.boot.delegated.zos.NativeMethodHelper;
import com.ibm.ws.kernel.zos.NativeMethodManager;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.zos.jni.internal.AngelUtilsImpl;
import com.ibm.ws.zos.jni.internal.NativeMethodInfo;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.Version;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class NativeMethodManagerImpl
implements BundleActivator,
BundleListener,
NativeMethodManager {
    protected Map<Bundle, Set<Class<?>>> bundleData = new HashMap();
    protected Map<Class<?>, NativeMethodInfo> nativeInfo = new HashMap();
    protected ServiceRegistration<NativeMethodManager> serviceRegistration;
    protected final BundleContext bundleContext;
    static final long serialVersionUID = -1734923749141722654L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public NativeMethodManagerImpl(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public synchronized void start(BundleContext bundleContext) {
        bundleContext.addBundleListener((BundleListener)this);
        Hashtable<String, String> properties = new Hashtable<String, String>();
        ((Dictionary)properties).put("service.vendor", "IBM");
        this.serviceRegistration = bundleContext.registerService(NativeMethodManager.class, (Object)this, properties);
        AngelUtilsImpl.INSTANCE.start(bundleContext);
    }

    public synchronized void stop(BundleContext bundleContext) {
        AngelUtilsImpl.INSTANCE.stop();
        bundleContext.removeBundleListener((BundleListener)this);
        this.serviceRegistration.unregister();
        this.serviceRegistration = null;
        HashSet classes = new HashSet();
        classes.addAll(this.nativeInfo.keySet());
        for (Class clazz : classes) {
            this.removeRegistration(clazz);
        }
        this.bundleData.clear();
        this.nativeInfo.clear();
    }

    public void registerNatives(Class<?> clazz) {
        this.registerNatives(clazz, null);
    }

    public synchronized void registerNatives(Class<?> clazz, Object[] extraInfo) {
        Version bundleVersion;
        Bundle bundle = this.getBundle(clazz);
        Version version = bundleVersion = bundle != null ? bundle.getVersion() : null;
        if (this.nativeInfo.containsKey(clazz)) {
            return;
        }
        for (String candidate : this.getStructureCandidates(clazz, bundleVersion)) {
            long dllHandle = this.invokeHelperRegisterNatives(clazz, candidate, extraInfo);
            if (dllHandle <= 0L) continue;
            this.addRegistration(clazz, bundle, extraInfo, candidate, dllHandle);
            return;
        }
        throw new UnsatisfiedLinkError("Native method descriptor for " + clazz.getCanonicalName() + " not found");
    }

    public void bundleChanged(BundleEvent event) {
        if (event.getType() == 4) {
            this.cleanupRegistrations(event.getBundle());
        }
    }

    synchronized void cleanupRegistrations(Bundle bundle) {
        Set<Class<?>> classes = this.bundleData.remove(bundle);
        if (classes != null) {
            for (Class<?> clazz : classes) {
                this.removeRegistration(clazz);
            }
        }
    }

    private synchronized void removeRegistration(Class<?> clazz) {
        NativeMethodInfo info = this.nativeInfo.remove(clazz);
        if (info != null) {
            this.invokeHelperDeregisterNatives(info.getDllHandle(), info.getClazz(), info.getNativeDescriptorName(), info.getExtraInfo());
        }
    }

    List<String> getStructureCandidates(Class<?> clazz, Version bundleVersion) {
        ArrayList<String> candidates = new ArrayList<String>();
        String prefix = "zJNI_";
        String stem = "zJNI_" + clazz.getCanonicalName().replaceAll("\\.", "_");
        if (bundleVersion != null) {
            candidates.add(stem + "__" + bundleVersion.getMajor() + "_" + bundleVersion.getMinor() + "_" + bundleVersion.getMicro());
            candidates.add(stem + "__" + bundleVersion.getMajor() + "_" + bundleVersion.getMinor());
            candidates.add(stem + "__" + bundleVersion.getMajor());
        }
        candidates.add(stem);
        candidates.add("zJNI_" + clazz.getSimpleName());
        return candidates;
    }

    protected synchronized void addRegistration(Class<?> clazz, Bundle bundle, Object[] extraInfo, String descriptorName, long dllHandle) {
        if (bundle != null) {
            Set<Class<?>> bundleClasses = this.bundleData.get(bundle);
            if (bundleClasses == null) {
                bundleClasses = new HashSet();
                this.bundleData.put(bundle, bundleClasses);
            }
            bundleClasses.add(clazz);
        }
        this.nativeInfo.put(clazz, new NativeMethodInfo(clazz, descriptorName, extraInfo, dllHandle));
    }

    protected long invokeHelperRegisterNatives(Class<?> clazz, String structureName, Object[] extraInfo) {
        return NativeMethodHelper.registerNatives(clazz, (String)structureName, (Object[])extraInfo);
    }

    protected long invokeHelperDeregisterNatives(long dllHandle, Class<?> clazz, String structureName, Object[] extraInfo) {
        return NativeMethodHelper.deregisterNatives((long)dllHandle, clazz, (String)structureName, (Object[])extraInfo);
    }

    protected Bundle getBundle(Class<?> clazz) {
        return FrameworkUtil.getBundle(clazz);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(NativeMethodManagerImpl.class);
    }
}

