/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.zos.jni.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.kernel.zos.AngelUtils;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.zos.core.NativeClientService;
import com.ibm.ws.zos.core.NativeService;
import java.util.HashSet;
import java.util.Set;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public enum AngelUtilsImpl implements AngelUtils
{
    INSTANCE;

    private static final TraceComponent tc;
    private static final String ZOS_SERVERSERVICE_CLASS;
    private static final String ZOS_CLIENTSERVICE_CLASS;
    private ServiceRegistration<AngelUtils> serviceRef;
    private BundleContext myBundleCtx;
    static final long serialVersionUID = -7168124102289267520L;

    public void start(BundleContext systemBundleCtx) {
        if (systemBundleCtx != null) {
            this.myBundleCtx = systemBundleCtx;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"about to register with OSGi", (Object[])new Object[0]);
            }
            this.serviceRef = this.myBundleCtx.registerService(AngelUtils.class, (Object)this, null);
        }
    }

    public void stop() {
        if (AngelUtilsImpl.INSTANCE.serviceRef != null) {
            AngelUtilsImpl.INSTANCE.serviceRef.unregister();
            AngelUtilsImpl.INSTANCE.serviceRef = null;
        }
    }

    public boolean areServicesAvailable(Set<String> services) {
        boolean authorized = false;
        if (services == null || services.isEmpty()) {
            return false;
        }
        Set<String> authServices = this.getAvailableServices();
        if (!authServices.isEmpty() && authServices.containsAll(services)) {
            authorized = true;
        }
        return authorized;
    }

    public Set<String> getAvailableServices() {
        HashSet<String> services = new HashSet<String>();
        try {
            ServiceReference[] nativeServices = this.myBundleCtx.getServiceReferences(ZOS_SERVERSERVICE_CLASS, "(is.authorized=true)");
            if (nativeServices != null) {
                for (int i = 0; i < nativeServices.length; ++i) {
                    services.add((String)nativeServices[i].getProperty("native.service.name"));
                }
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"return from call to getServiceReferences, returned null)", (Object[])new Object[0]);
            }
        }
        catch (InvalidSyntaxException nativeServices) {
            FFDCFilter.processException((Throwable)nativeServices, (String)"com.ibm.ws.zos.jni.internal.AngelUtilsImpl", (String)"113", (Object)((Object)this), (Object[])new Object[0]);
        }
        return services;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    static {
        tc = Tr.register(AngelUtilsImpl.class);
        ZOS_SERVERSERVICE_CLASS = NativeService.class.getCanonicalName();
        ZOS_CLIENTSERVICE_CLASS = NativeClientService.class.getCanonicalName();
    }
}

