/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.zos.core.utils.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.kernel.zos.NativeMethodManager;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.zos.core.utils.NativeUtils;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.Calendar;
import java.util.Map;
import java.util.TimeZone;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class NativeUtilsImpl
implements NativeUtils {
    private static final TraceComponent tc = Tr.register(NativeUtilsImpl.class);
    private static final long JAVA_MVS_ORIGIN_DIFFERENCE = NativeUtilsImpl.calculateClockOriginDifference();
    protected NativeMethodManager nativeMethodManager = null;
    static final long serialVersionUID = 6019717290382030333L;

    protected void activate(Map<String, Object> properties) throws Exception {
        this.nativeMethodManager.registerNatives(NativeUtilsImpl.class);
    }

    protected void deactivate() {
    }

    protected void setNativeMethodManager(NativeMethodManager nativeMethodManager) {
        this.nativeMethodManager = nativeMethodManager;
    }

    protected void unsetNativeMethodManager(NativeMethodManager nativeMethodManager) {
        if (this.nativeMethodManager == nativeMethodManager) {
            this.nativeMethodManager = null;
        }
    }

    @Trivial
    private static long calculateClockOriginDifference() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeZone(TimeZone.getTimeZone("UTC"));
        calendar.clear();
        calendar.set(1900, 0, 1);
        return calendar.getTime().getTime();
    }

    @Trivial
    public static long getStckMillis(long stck) {
        long micros = stck >>> 12;
        long stckMillis = micros / 1000L;
        return stckMillis + JAVA_MVS_ORIGIN_DIFFERENCE;
    }

    @Override
    public long getSTCK() {
        return this.ntv_getStck();
    }

    @Override
    public ByteBuffer mapDirectByteBuffer(long address, int size) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Mapping direct byte buffer", (Object[])new Object[]{Long.toHexString(address), size});
        }
        return this.ntv_mapDirectByteBuffer(address, size).asReadOnlyBuffer();
    }

    @Override
    public byte[] convertAsciiStringToFixedLengthEBCDIC(String s, int requiredLength) {
        byte[] retVal = null;
        String blank = " ";
        String str = s;
        if (str == null || str.length() == 0) {
            str = blank;
        }
        str = NativeUtilsImpl.pad(str, requiredLength);
        retVal = NativeUtilsImpl.convertToEbcdic(str);
        return retVal;
    }

    protected native long ntv_getStck();

    protected native ByteBuffer ntv_mapDirectByteBuffer(long var1, int var3);

    protected native long ntv_getTaskId();

    protected native int ntv_getPid();

    protected native byte[] ntv_getSmfData();

    protected native byte[] ntv_getTimeusedData();

    private static String pad(String s, int len) {
        if (s.length() > len) {
            s = s.substring(0, len);
        } else {
            StringBuffer buf = new StringBuffer(s);
            while (buf.length() < len) {
                buf.append(" ");
            }
            s = buf.toString();
        }
        return s;
    }

    private static byte[] convertToEbcdic(String str) {
        byte[] retVal = null;
        try {
            retVal = str.getBytes("Cp1047");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            FFDCFilter.processException((Throwable)unsupportedEncodingException, (String)"com.ibm.ws.zos.core.utils.internal.NativeUtilsImpl", (String)"217", null, (Object[])new Object[]{str});
        }
        return retVal;
    }

    @Override
    public long getTaskId() {
        return this.ntv_getTaskId();
    }

    @Override
    public int getPid() {
        return this.ntv_getPid();
    }

    @Override
    public byte[] getSmfData() {
        return this.ntv_getSmfData();
    }

    @Override
    public byte[] getTimeusedData() {
        return this.ntv_getTimeusedData();
    }
}

