/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.zos.core.utils.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.zos.core.utils.DoubleGutter;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.Map;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class DoubleGutterImpl
implements DoubleGutter {
    private final Charset ebcdicCharset = Charset.forName("IBM-1047");
    private final Charset asciiCharset = Charset.forName("ISO8859-1");
    static final long serialVersionUID = 6011203284019612456L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    protected void activate(Map<String, Object> properties) throws Exception {
    }

    protected void deactivate(int reason) {
    }

    boolean isPrintable(char ch) {
        return ch < '\u0080' && !Character.isISOControl(ch);
    }

    @Override
    public String asDoubleGutter(long address, byte[] data) {
        int i;
        if (data == null) {
            data = new byte[]{};
        }
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("  data_address=%08x_%08x, data_length=%d", (int)(address >>> 32), (int)address, data.length));
        if (data.length == 0 || address == 0L) {
            return sb.toString();
        }
        sb.append("\n");
        sb.append("  +--------------------------------------------------------------------------+\n");
        sb.append(String.format("  |OSet| A=%016x Length=%07x |     EBCDIC     |     ASCII      |\n", address, data.length));
        sb.append("  +----+-----------------------------------+----------------+----------------+\n");
        StringBuilder binary = new StringBuilder();
        StringBuilder ebcdic = new StringBuilder();
        StringBuilder ascii = new StringBuilder();
        CharBuffer asciiBuffer = this.asciiCharset.decode(ByteBuffer.wrap(data));
        CharBuffer ebcdicBuffer = this.ebcdicCharset.decode(ByteBuffer.wrap(data));
        String digits = "0123456789ABCDEF";
        int maxLength = data.length <= 16384 ? data.length : 16384;
        for (i = 0; i < maxLength; ++i) {
            char ebcdicChar;
            binary.append(digits.charAt((data[i] & 0xF0) >>> 4));
            binary.append(digits.charAt(data[i] & 0xF));
            if (i % 4 == 3 && i % 16 != 15) {
                binary.append(' ');
            }
            if (this.isPrintable(ebcdicChar = ebcdicBuffer.get(i))) {
                ebcdic.append(ebcdicChar);
            } else {
                ebcdic.append('.');
            }
            char asciiChar = asciiBuffer.get(i);
            if (this.isPrintable(asciiChar)) {
                ascii.append(asciiChar);
            } else {
                ascii.append('.');
            }
            if (i % 16 != 15) continue;
            String offset = String.format("%04x", i & 0xFFFFFFF0);
            String line = String.format("  |%s|%s|%s|%s|\n", offset, binary, ebcdic, ascii);
            sb.append(line);
            binary = new StringBuilder();
            ebcdic = new StringBuilder();
            ascii = new StringBuilder();
        }
        if (i % 16 != 0) {
            String offset = String.format("%04x", i & 0xFFFFFFF0);
            String line = String.format("  |%s|%-35s|%-16s|%-16s|\n", offset, binary, ebcdic, ascii);
            sb.append(line);
        }
        sb.append("  +--------------------------------------------------------------------------+");
        return sb.toString();
    }

    @Override
    public String asDoubleGutter(long address, ByteBuffer data) {
        byte[] byteData = null;
        if (data != null) {
            byteData = new byte[data.remaining()];
            data.duplicate().get(byteData);
        }
        return this.asDoubleGutter(address, byteData);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(DoubleGutterImpl.class);
    }
}

