/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.zos.core.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.kernel.zos.NativeMethodManager;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.zos.core.Angel;
import com.ibm.ws.zos.core.NativeClientService;
import com.ibm.ws.zos.core.NativeService;
import com.ibm.ws.zos.core.internal.AngelImpl;
import com.ibm.ws.zos.core.internal.CoreBundleActivator;
import com.ibm.ws.zos.core.internal.NativeServiceImpl;
import java.io.File;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceRegistration;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class NativeServiceTracker
implements BundleActivator {
    private static final TraceComponent tc = Tr.register(NativeServiceTracker.class);
    static String WAS_LIB_DIR;
    static final String AUTHORIZED_FUNCTION_MODULE = "native/zos/s390x/bbgzsafm";
    static final String UNAUTHORIZED_FUNCTION_MODULE = "native/zos/s390x/bbgzsufm";
    final NativeMethodManager nativeMethodManager;
    BundleContext bundleContext = null;
    boolean registeredWithAngel = false;
    Set<ServiceRegistration<NativeService>> registrations = new HashSet<ServiceRegistration<NativeService>>();
    Set<ServiceRegistration<NativeClientService>> clientRegistrations = new HashSet<ServiceRegistration<NativeClientService>>();
    ServiceRegistration<Angel> angelRegistration = null;
    static final long serialVersionUID = -8710513574582728893L;

    public NativeServiceTracker(NativeMethodManager nativeMethodManager) {
        this.nativeMethodManager = nativeMethodManager;
    }

    public void start(BundleContext bundleContext) throws BundleException {
        this.bundleContext = bundleContext;
        WAS_LIB_DIR = CoreBundleActivator.firstNotNull(bundleContext.getProperty("wlp.lib.dir"), "");
        this.nativeMethodManager.registerNatives(NativeServiceTracker.class);
        ServiceResults loadServiceResult = this.loadUnauthorized();
        if (loadServiceResult.returnValue != 0) {
            Tr.error((TraceComponent)tc, (String)"UNABLE_TO_LOAD_UNAUTHORIZED_BPX4LOD", (Object[])new Object[]{UNAUTHORIZED_FUNCTION_MODULE, loadServiceResult.returnValue, Integer.toHexString(loadServiceResult.returnCode), Integer.toHexString(loadServiceResult.reasonCode)});
            throw new BundleException("Unable to load the z/OS unauthorized native library native/zos/s390x/bbgzsufm");
        }
        int registerReturnCode = this.registerServer();
        if (registerReturnCode == 0) {
            this.registeredWithAngel = true;
        } else if (registerReturnCode == 4103) {
            Tr.info((TraceComponent)tc, (String)"SERVER_NOT_AUTHORIZED_TO_CONNECT_TO_ANGEL", (Object[])new Object[0]);
        } else if (registerReturnCode == 4107) {
            Tr.info((TraceComponent)tc, (String)"SERVER_SAFM_NOT_APF_AUTHORIZED", (Object[])new Object[0]);
        } else if (registerReturnCode == 4104) {
            Tr.info((TraceComponent)tc, (String)"ANGEL_NOT_AVAILABLE", (Object[])new Object[]{registerReturnCode});
            Tr.info((TraceComponent)tc, (String)"SERVER_SAFM_NOT_SAF_AUTHORIZED", (Object[])new Object[0]);
        } else {
            Tr.info((TraceComponent)tc, (String)"ANGEL_NOT_AVAILABLE", (Object[])new Object[]{registerReturnCode});
        }
        this.populateServiceRegistry();
    }

    public void stop(BundleContext bundleContext) {
        this.unregisterOSGiServices();
        if (this.registeredWithAngel) {
            this.deregisterServer();
            this.registeredWithAngel = false;
        }
    }

    boolean fileExists(final File file) {
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){
            static final long serialVersionUID = 7132465353326503382L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Boolean run() {
                return file.exists();
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(1.class);
            }
        });
    }

    private ServiceResults loadUnauthorized() {
        File library = new File(WAS_LIB_DIR, UNAUTHORIZED_FUNCTION_MODULE);
        if (!this.fileExists(library)) {
            Tr.error((TraceComponent)tc, (String)"LIBRARY_DOES_NOT_EXIST", (Object[])new Object[]{library.getAbsolutePath()});
        }
        return this.ntv_loadUnauthorized(library.getAbsolutePath());
    }

    private int registerServer() {
        File library = new File(WAS_LIB_DIR, AUTHORIZED_FUNCTION_MODULE);
        if (!this.fileExists(library)) {
            Tr.error((TraceComponent)tc, (String)"LIBRARY_DOES_NOT_EXIST", (Object[])new Object[]{library.getAbsolutePath()});
        }
        return this.ntv_registerServer(library.getAbsolutePath());
    }

    private int deregisterServer() {
        return this.ntv_deregisterServer();
    }

    synchronized void populateServiceRegistry() {
        int angelVersion;
        int i;
        ArrayList<String> permittedServices = new ArrayList<String>();
        ArrayList<String> deniedServices = new ArrayList<String>();
        ArrayList<String> permittedClientServices = new ArrayList<String>();
        ArrayList<String> deniedClientServices = new ArrayList<String>();
        TreeSet permittedProfiles = new TreeSet();
        TreeSet deniedProfiles = new TreeSet();
        TreeSet permittedClientProfiles = new TreeSet();
        TreeSet deniedClientProfiles = new TreeSet();
        this.getNativeServiceEntries(permittedServices, deniedServices, permittedClientServices, deniedClientServices);
        for (i = 0; i < permittedServices.size(); i += 2) {
            this.registerOSGiService((String)permittedServices.get(i), (String)permittedServices.get(i + 1), true, false);
            permittedProfiles.add(permittedServices.get(i + 1));
        }
        for (i = 0; i < deniedServices.size(); i += 2) {
            this.registerOSGiService((String)deniedServices.get(i), (String)deniedServices.get(i + 1), false, false);
            deniedProfiles.add(deniedServices.get(i + 1));
        }
        for (i = 0; i < permittedClientServices.size(); i += 2) {
            this.registerOSGiService((String)permittedClientServices.get(i), (String)permittedClientServices.get(i + 1), true, true);
            permittedClientProfiles.add(permittedClientServices.get(i + 1));
        }
        for (i = 0; i < deniedClientServices.size(); i += 2) {
            this.registerOSGiService((String)deniedClientServices.get(i), (String)deniedClientServices.get(i + 1), false, true);
            deniedClientProfiles.add(deniedClientServices.get(i + 1));
        }
        for (String profile : permittedProfiles) {
            Tr.info((TraceComponent)tc, (String)"AUTHORIZED_SERVICE_AVAILABLE", (Object[])new Object[]{profile});
        }
        for (String profile : deniedProfiles) {
            Tr.info((TraceComponent)tc, (String)"AUTHORIZED_SERVICE_NOT_AVAILABLE", (Object[])new Object[]{profile});
        }
        for (String profile : permittedClientProfiles) {
            Tr.info((TraceComponent)tc, (String)"AUTHORIZED_SERVICE_AVAILABLE", (Object[])new Object[]{"CLIENT." + profile});
        }
        for (String profile : deniedClientProfiles) {
            Tr.info((TraceComponent)tc, (String)"AUTHORIZED_SERVICE_NOT_AVAILABLE", (Object[])new Object[]{"CLIENT." + profile});
        }
        if (this.registeredWithAngel && (angelVersion = this.ntv_getAngelVersion()) != -1) {
            AngelImpl angel = new AngelImpl(this.ntv_getAngelVersion());
            Hashtable<String, String> properties = new Hashtable<String, String>();
            ((Dictionary)properties).put("service.vendor", "IBM");
            ((Dictionary)properties).put("angel.drm.version", Integer.toString(angel.getDRM_Version()));
            this.angelRegistration = this.bundleContext.registerService(Angel.class, (Object)angel, properties);
        }
    }

    synchronized void registerOSGiService(String name, String authorizationGroup, boolean isAuthorized, boolean client) {
        NativeServiceImpl service = new NativeServiceImpl(name.trim(), authorizationGroup.trim(), isAuthorized, client);
        Hashtable<String, String> properties = new Hashtable<String, String>();
        ((Dictionary)properties).put("service.vendor", "IBM");
        ((Dictionary)properties).put("native.service.name", service.getServiceName());
        ((Dictionary)properties).put("native.authorization.group.name", service.getAuthorizationGroup());
        ((Dictionary)properties).put("is.authorized", Boolean.toString(service.isPermitted()));
        if (client) {
            this.clientRegistrations.add((ServiceRegistration<NativeClientService>)this.bundleContext.registerService(NativeClientService.class, (Object)service, properties));
        } else {
            this.registrations.add((ServiceRegistration<NativeService>)this.bundleContext.registerService(NativeService.class, (Object)service, properties));
        }
    }

    synchronized void unregisterOSGiServices() {
        for (ServiceRegistration<NativeService> serviceRegistration : this.registrations) {
            serviceRegistration.unregister();
        }
        for (ServiceRegistration<NativeService> serviceRegistration : this.clientRegistrations) {
            serviceRegistration.unregister();
        }
        this.registrations.clear();
        this.clientRegistrations.clear();
        if (this.angelRegistration != null) {
            this.angelRegistration.unregister();
            this.angelRegistration = null;
        }
    }

    int getNativeServiceEntries(List<String> permittedServices, List<String> deniedServices, List<String> permittedClientServices, List<String> deniedClientServices) {
        return this.ntv_getNativeServiceEntries(permittedServices, deniedServices, permittedClientServices, deniedClientServices);
    }

    protected native ServiceResults ntv_loadUnauthorized(String var1);

    protected native int ntv_registerServer(String var1);

    protected native int ntv_deregisterServer();

    protected native int ntv_getNativeServiceEntries(List<String> var1, List<String> var2, List<String> var3, List<String> var4);

    protected native int ntv_getAngelVersion();

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    static final class ServiceResults {
        final int returnValue;
        final int returnCode;
        final int reasonCode;
        static final long serialVersionUID = 6799549788476491871L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        ServiceResults(int returnValue, int returnCode, int reasonCode) {
            this.returnValue = returnValue;
            this.returnCode = returnCode;
            this.reasonCode = reasonCode;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(ServiceResults.class);
        }
    }
}

