/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.collective.utility.tasks;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.collective.utility.ICollectiveRegistrationMBeanConnection;
import com.ibm.ws.collective.utility.TaskErrorException;
import com.ibm.ws.collective.utility.tasks.BaseCommandTask;
import com.ibm.ws.collective.utility.utils.ConsoleWrapper;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.ConnectException;
import java.net.UnknownHostException;
import javax.management.RuntimeMBeanException;

public class UnregisterHostTask
extends BaseCommandTask {
    private static final TraceComponent tc = Tr.register(UnregisterHostTask.class);
    private final ICollectiveRegistrationMBeanConnection registrationMBean;

    public UnregisterHostTask(String scriptName, ICollectiveRegistrationMBeanConnection registrationMBean) {
        super(tc, scriptName, null);
        this.registrationMBean = registrationMBean;
        this.reqArgs.add("--host");
        this.reqArgs.add("--port");
        this.reqArgs.add("--user");
        this.reqArgs.add("--password");
        this.promptableArgs.add("--password");
        this.knownArgs.addAll(this.reqArgs);
        this.knownArgs.addAll(this.promptableArgs);
        this.knownArgs.addAll(this.confirmedArgs);
        this.knownArgs.add("--hostName");
        this.addAutoAcceptArgument();
    }

    @Override
    public String getTaskName() {
        return "unregisterHost";
    }

    @Override
    public String getTaskUsage() {
        return this.getTaskUsage("unregisterHost.usage.options");
    }

    @Override
    public String getTaskHelp() {
        String footer = this.buildScriptOptions("certProps.option-key.autoAccept", "certProps.option-desc.autoAccept") + NL + NL + this.getOption("sslTrust.autoAccept", "com.ibm.websphere.collective.utility.autoAcceptCertificates");
        return this.getTaskHelp("unregisterHost.desc", "unregisterHost.usage.options", "connection.option-key.", "connection.option-desc.", null, footer, this.scriptName);
    }

    @Override
    public String getTaskDescription() {
        return this.getOption("unregisterHost.desc", new Object[0]);
    }

    @Override
    protected void abort(String message) {
        this.stderr.println(message);
    }

    @Override
    protected void abortAndPerformCleanup(String message, File collectiveResourcesDir) throws TaskErrorException {
    }

    private boolean unregisterHost(String host, int port, String user, String password, String hostName) {
        try {
            this.registrationMBean.unregisterHost(host, port, user, password, hostName);
            this.stdout.println(this.getMessage("unregisterHost.unregisterSuccess", hostName));
            return true;
        }
        catch (RuntimeMBeanException e) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Caught RuntimeMBeanException, this may be expected, but here's the stack incase it helps.", (Object[])new Object[]{e});
            }
            if (e.getCause() instanceof IllegalStateException) {
                this.stdout.println(this.getMessage("unregisterHost.unregisteredAlready", hostName));
                return true;
            }
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Unexpected RuntimeMBeanException while invoking the MBean", (Object[])new Object[]{e});
            }
            this.stderr.println(this.getMessage("error", e.getMessage()));
            this.abort(this.getMessage("common.connectionError", e.getMessage()));
        }
        catch (UnknownHostException e) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("UnknownHostException while invoking the MBean: " + e.getMessage()), (Object[])new Object[]{e});
            }
            this.abort(this.getMessage("common.hostError", host));
        }
        catch (ConnectException e) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("ConnectException while invoking the MBean: " + e.getMessage()), (Object[])new Object[]{e});
            }
            this.abort(this.getMessage("common.portError", String.valueOf(port)));
        }
        catch (IOException e) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"IOException while invoking the MBean", (Object[])new Object[]{e});
            }
            this.abort(this.getMessage("common.connectionError", e.getMessage()));
        }
        catch (Exception e) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Unexpected Exception while invoking the MBean", (Object[])new Object[]{e});
            }
            this.stderr.println(this.getMessage("error", e.getMessage()));
            this.abort(this.getMessage("common.connectionError", e.getMessage()));
        }
        return false;
    }

    @Override
    public void handleTask(ConsoleWrapper stdin, PrintStream stdout, PrintStream stderr, String[] args) {
        this.stdin = stdin;
        this.stdout = stdout;
        this.stderr = stderr;
        this.validateArgumentList(args, true);
        String hostName = this.getTaskTarget(args);
        if (hostName == null) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"The host name was not specified, defaulting to this hosts name", (Object[])new Object[0]);
            }
            hostName = this.getHostName();
        }
        String controllerHost = this.getArgumentValue("--host", args, null);
        int controllerPort = Integer.valueOf(this.getArgumentValue("--port", args, null));
        String user = this.getArgumentValue("--user", args, null);
        String password = this.getArgumentValue("--password", args, null);
        this.handleAutoAcceptArgument(args);
        stdout.println(this.getMessage("unregisterHost.attemptUnregister", new Object[0]));
        if (!this.unregisterHost(controllerHost, controllerPort, user, password, hostName)) {
            stdout.println(this.getMessage("unregisterHost.unregisterFailed", hostName));
        }
    }
}

