/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.collective.utility.tasks;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.collective.member.DockerEnvironmentUtil;
import com.ibm.ws.collective.member.internal.ssh.SSHKeyGenerator;
import com.ibm.ws.collective.member.internal.ssh.SSHKeyUtility;
import com.ibm.ws.collective.member.metadata.AdminMetadataParser;
import com.ibm.ws.collective.utility.IAdminMetadataManagerMBeanConnection;
import com.ibm.ws.collective.utility.ICollectiveRegistrationMBeanConnection;
import com.ibm.ws.collective.utility.ICollectiveRepositoryMBeanConnection;
import com.ibm.ws.collective.utility.IFileUtility;
import com.ibm.ws.collective.utility.TaskErrorException;
import com.ibm.ws.collective.utility.tasks.BaseCommandTask;
import com.ibm.ws.collective.utility.utils.ConsoleWrapper;
import com.ibm.ws.collective.utils.PasswordMaskUtil;
import com.ibm.ws.collective.utils.RepositoryPathUtility;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.management.RuntimeMBeanException;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;

public class JoinTask
extends BaseCommandTask {
    private static final TraceComponent tc = Tr.register(JoinTask.class);
    private final SSHKeyGenerator sshKeyGen;
    private final SSHKeyUtility sshKeyUtil;
    private File collectiveResourcesDir;
    private final ICollectiveRegistrationMBeanConnection registrationMBean;
    private final IAdminMetadataManagerMBeanConnection metadataManagerMBean;
    private final ICollectiveRepositoryMBeanConnection repositoryMBean;

    public JoinTask(String scriptName, IFileUtility fileUtility, SSHKeyGenerator sshKeyGen, SSHKeyUtility sshKeyUtil, ICollectiveRegistrationMBeanConnection registrationMBean, IAdminMetadataManagerMBeanConnection metadataManagerMBean, ICollectiveRepositoryMBeanConnection repositoryMBean) {
        super(tc, scriptName, fileUtility);
        this.sshKeyGen = sshKeyGen;
        this.sshKeyUtil = sshKeyUtil;
        this.registrationMBean = registrationMBean;
        this.metadataManagerMBean = metadataManagerMBean;
        this.repositoryMBean = repositoryMBean;
        this.reqArgs.add("--host");
        this.reqArgs.add("--port");
        this.reqArgs.add("--user");
        this.reqArgs.add("--password");
        this.reqArgs.add("--keystorePassword");
        this.promptableArgs.add("--password");
        this.confirmedArgs.add("--keystorePassword");
        this.confirmedArgs.add("--serverIdentityKeystorePassword");
        this.confirmedArgs.add("--collectiveTrustKeystorePassword");
        this.confirmedArgs.add("--httpsKeystorePassword");
        this.confirmedArgs.add("--httpsTruststorePassword");
        this.flagArgs.add("--createConfigFile");
        this.flagArgs.add("--useHostCredentials");
        this.flagArgs.add("--genDeployVariables");
        this.knownArgs.addAll(this.reqArgs);
        this.knownArgs.addAll(this.promptableArgs);
        this.knownArgs.addAll(this.confirmedArgs);
        this.knownArgs.addAll(this.promptableArgs);
        this.knownArgs.addAll(this.flagArgs);
        this.knownArgs.add("--serverIdentityCertificateValidity");
        this.knownArgs.add("--httpsCertificateSubject");
        this.knownArgs.add("--httpsCertificateValidity");
        this.knownArgs.add("--hostName");
        this.knownArgs.add("--encoding");
        this.knownArgs.add("--key");
        this.knownArgs.add("--hostJavaHome");
        this.addHostAuthInfoArgs(false);
        this.addAutoAcceptArgument();
    }

    @Override
    public String getTaskName() {
        return "join";
    }

    @Override
    public String getTaskUsage() {
        return this.getTaskUsage("join.usage.options");
    }

    @Override
    public String getTaskHelp() {
        String footer = this.buildScriptOptions("keystore.option-key.", "keystore.option-desc.") + this.buildScriptOptions("certProps.option-key.", "certProps.option-desc.") + this.buildScriptOptions("join.option-key.", "join.option-desc.") + this.buildScriptOptions("encoding.option-key.", "encoding.option-desc.") + this.buildScriptOptions("common.option-key.", "common.option-desc.") + this.buildScriptOptions("hostAuthInfo.option-key.", "hostAuthInfo.option-desc.") + NL + NL + this.getOption("sslTrust.autoAccept", "com.ibm.websphere.collective.utility.autoAcceptCertificates");
        return this.getTaskHelp("join.desc", "join.usage.options", "connection.option-key.", "connection.option-desc.", null, footer, this.scriptName);
    }

    @Override
    public String getTaskDescription() {
        return this.getOption("join.desc", new Object[0]);
    }

    @Override
    protected void abort(String message) throws TaskErrorException {
        this.stdout.println(this.getMessage("join.abort", new Object[0]));
        throw new TaskErrorException(message);
    }

    @Override
    protected void abortAndPerformCleanup(String message, File collectiveResourcesDir) throws TaskErrorException {
        this.stdout.println(this.getMessage("join.abort", new Object[0]));
        if (!this.fileUtility.recurisveDelete(collectiveResourcesDir)) {
            this.stdout.println(this.getMessage("join.cleanupFail", collectiveResourcesDir));
        }
        throw new TaskErrorException(message);
    }

    private Map<String, byte[]> join(String controllerHost, int controllerPort, String user, String password, String hostName, String userDir, String serverName, String installDir, String keystorePassword, Map<String, Object> certProps, Map<String, Object> hostAuthInfo) throws TaskErrorException {
        try {
            Map<String, byte[]> ret = this.registrationMBean.join(controllerHost, controllerPort, user, password, hostName, userDir, serverName, installDir, keystorePassword, certProps, hostAuthInfo);
            this.stdout.println(this.getMessage("join.mbeanComplete", new Object[0]));
            return ret;
        }
        catch (RuntimeMBeanException e) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Caught RuntimeMBeanException, this may be expected, but here's the stack incase it helps.", (Object[])new Object[]{e});
            }
            if (e.getCause() instanceof IllegalStateException) {
                this.abortAndPerformCleanup(this.getMessage("join.registeredAlready", serverName), this.collectiveResourcesDir);
            } else if (e.getCause() instanceof IllegalArgumentException) {
                this.abortAndPerformCleanup(this.getMessage("common.connectionError", e.getMessage()), this.collectiveResourcesDir);
            } else {
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)("Unexpected RuntimeMBeanException while invoking the MBean: " + e.getMessage()), (Object[])new Object[]{e});
                }
                this.stderr.println(this.getMessage("error", e.getMessage()));
                this.abortAndPerformCleanup(this.getMessage("common.connectionError", e.getMessage()), this.collectiveResourcesDir);
            }
        }
        catch (UnknownHostException e) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("UnknownHostException while invoking the MBean: " + e.getMessage()), (Object[])new Object[]{e});
            }
            this.abortAndPerformCleanup(this.getMessage("common.hostError", controllerHost), this.collectiveResourcesDir);
        }
        catch (ConnectException e) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("ConnectException while invoking the MBean: " + e.getMessage()), (Object[])new Object[]{e});
            }
            this.abortAndPerformCleanup(this.getMessage("common.portError", String.valueOf(controllerPort)), this.collectiveResourcesDir);
        }
        catch (IOException e) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("IOException while invoking the MBean: " + e.getMessage()), (Object[])new Object[]{e});
            }
            this.stdout.println("IOException while invoking the MBean: " + e);
            this.abortAndPerformCleanup(this.getMessage("common.connectionError", e.getMessage()), this.collectiveResourcesDir);
        }
        catch (Exception e) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("Unexpected Exception while invoking the MBean: " + e.getMessage()), (Object[])new Object[]{e});
            }
            this.stdout.println("Unexpected Exception while invoking the MBean: " + e);
            this.stderr.println(this.getMessage("error", e.getMessage()));
            this.abortAndPerformCleanup(this.getMessage("common.connectionError", e.getMessage()), this.collectiveResourcesDir);
        }
        return null;
    }

    private void deployAdminMetadata(String controllerHost, int controllerPort, String user, String password, String resourceType, String identity, Map<String, Object> metadata) throws TaskErrorException {
        try {
            this.metadataManagerMBean.deployAdminMetadata(controllerHost, controllerPort, user, password, resourceType, identity, metadata);
            this.stdout.println(this.getMessage("deployAdminMetadata.mbeanComplete", new Object[0]));
        }
        catch (RuntimeMBeanException e) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Caught RuntimeMBeanException, this may be expected, but here's the stack incase it helps.", (Object[])new Object[]{e});
            } else if (e.getCause() instanceof IllegalArgumentException) {
                this.abortAndPerformCleanup(this.getMessage("common.connectionError", e.getMessage()), this.collectiveResourcesDir);
            } else {
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)("Unexpected RuntimeMBeanException while invoking the MBean: " + e.getMessage()), (Object[])new Object[]{e});
                }
                this.stderr.println(this.getMessage("error", e.getMessage()));
                this.abortAndPerformCleanup(this.getMessage("common.connectionError", e.getMessage()), this.collectiveResourcesDir);
            }
        }
        catch (UnknownHostException e) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("UnknownHostException while invoking the MBean: " + e.getMessage()), (Object[])new Object[]{e});
            }
            this.abortAndPerformCleanup(this.getMessage("common.hostError", controllerHost), this.collectiveResourcesDir);
        }
        catch (ConnectException e) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("ConnectException while invoking the MBean: " + e.getMessage()), (Object[])new Object[]{e});
            }
            this.abortAndPerformCleanup(this.getMessage("common.portError", String.valueOf(controllerPort)), this.collectiveResourcesDir);
        }
        catch (IOException e) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("IOException while invoking the MBean: " + e.getMessage()), (Object[])new Object[]{e});
            }
            this.abortAndPerformCleanup(this.getMessage("common.connectionError", e.getMessage()), this.collectiveResourcesDir);
        }
        catch (Exception e) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("Unexpected Exception while invoking the MBean: " + e.getMessage()), (Object[])new Object[]{e});
            }
            this.stderr.println(this.getMessage("error", e.getMessage()));
            this.abortAndPerformCleanup(this.getMessage("common.connectionError", e.getMessage()), this.collectiveResourcesDir);
        }
    }

    private Map<String, Integer> allocateDeployVariables(String controllerHost, int controllerPort, String user, String password, String hostName, String[] names) throws TaskErrorException {
        try {
            Map<String, Integer> deployVars = this.repositoryMBean.allocateDeployVariables(controllerHost, controllerPort, user, password, hostName, names);
            this.stdout.println(this.getMessage("allocateDeployVariables.mbeanComplete", new Object[0]));
            return deployVars;
        }
        catch (RuntimeMBeanException e) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Caught RuntimeMBeanException, this may be expected, but here's the stack incase it helps.", (Object[])new Object[]{e});
            } else if (e.getCause() instanceof IllegalArgumentException) {
                this.abortAndPerformCleanup(this.getMessage("common.connectionError", e.getMessage()), this.collectiveResourcesDir);
            } else {
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)("Unexpected RuntimeMBeanException while invoking the MBean: " + e.getMessage()), (Object[])new Object[]{e});
                }
                this.stderr.println(this.getMessage("error", e.getMessage()));
                this.abortAndPerformCleanup(this.getMessage("common.connectionError", e.getMessage()), this.collectiveResourcesDir);
            }
        }
        catch (UnknownHostException e) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("UnknownHostException while invoking the MBean: " + e.getMessage()), (Object[])new Object[]{e});
            }
            this.abortAndPerformCleanup(this.getMessage("common.hostError", controllerHost), this.collectiveResourcesDir);
        }
        catch (ConnectException e) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("ConnectException while invoking the MBean: " + e.getMessage()), (Object[])new Object[]{e});
            }
            this.abortAndPerformCleanup(this.getMessage("common.portError", String.valueOf(controllerPort)), this.collectiveResourcesDir);
        }
        catch (IOException e) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("IOException while invoking the MBean: " + e.getMessage()), (Object[])new Object[]{e});
            }
            this.abortAndPerformCleanup(this.getMessage("common.connectionError", e.getMessage()), this.collectiveResourcesDir);
        }
        catch (Exception e) {
            Throwable cause = e.getCause();
            if (cause instanceof NoSuchMethodException) {
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)("NoSuchMethodException while invoking the MBean: " + e.getMessage()), (Object[])new Object[]{e});
                }
                this.abortAndPerformCleanup(this.getMessage("common.compatibilityError", e.getMessage()), this.collectiveResourcesDir);
            }
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("Unexpected Exception while invoking the MBean: " + e.getMessage()), (Object[])new Object[]{e});
            }
            this.stderr.println(this.getMessage("error", e.getMessage()));
            this.abortAndPerformCleanup(this.getMessage("common.connectionError", e.getMessage()), this.collectiveResourcesDir);
        }
        return null;
    }

    @Override
    public void handleTask(ConsoleWrapper stdin, PrintStream stdout, PrintStream stderr, String[] args) throws TaskErrorException {
        File runtimeMetadataFile;
        Map metadata;
        Map adminMetadata;
        File serverMetadataFile;
        AdminMetadataParser parser;
        Map<String, byte[]> joinResult;
        String encodedKeystorePassword;
        this.stdin = stdin;
        this.stdout = stdout;
        this.stderr = stderr;
        this.validateArgumentList(args, false);
        String serverName = this.getTaskTarget(args);
        String userDir = this.fileUtility.getUserDir();
        String installDir = this.fileUtility.getInstallDir();
        String serverDir = userDir + "servers" + "/" + serverName + "/";
        if (!this.fileUtility.exists(serverDir)) {
            userDir = this.fileUtility.resolvePath(userDir);
            this.abort(this.getMessage("serverNotFound", serverName, userDir));
        }
        this.collectiveResourcesDir = new File(serverDir + "resources/collective");
        if (this.fileUtility.exists(this.collectiveResourcesDir) && !this.fileUtility.isDirectoryEmpty(this.collectiveResourcesDir)) {
            this.abort(this.getMessage("join.errorAlreadyHasResources", new Object[0]));
        }
        serverName = this.fileUtility.fixServerNameCase(serverName);
        String controllerHost = this.getArgumentValue("--host", args, null);
        int controllerPort = Integer.valueOf(this.getArgumentValue("--port", args, null));
        String user = this.getArgumentValue("--user", args, null);
        String password = this.getArgumentValue("--password", args, null);
        String hostName = this.getArgumentValue("--hostName", args, this.getHostName());
        String defaultHTTPSCertificateSubject = "CN=" + hostName + ",OU=" + serverName + ",O=ibm,C=us";
        this.handleAutoAcceptArgument(args);
        String keystorePassword = this.getArgumentValue("--keystorePassword", args, null);
        String serverIdentityKeystorePassword = this.getArgumentValue("--serverIdentityKeystorePassword", args, keystorePassword);
        Integer serverIdentityCertificateValidity = Integer.valueOf(this.getArgumentValue("--serverIdentityCertificateValidity", args, String.valueOf(1825)));
        String collectiveTrustKSPassword = this.getArgumentValue("--collectiveTrustKeystorePassword", args, keystorePassword);
        String httpsKSPassword = this.getArgumentValue("--httpsKeystorePassword", args, keystorePassword);
        String httpsCertificateSubject = this.getArgumentValue("--httpsCertificateSubject", args, defaultHTTPSCertificateSubject);
        Integer httpsCertificateValidity = Integer.valueOf(this.getArgumentValue("--httpsCertificateValidity", args, String.valueOf(1825)));
        String httpsTSPassword = this.getArgumentValue("--httpsTruststorePassword", args, keystorePassword);
        if (serverIdentityCertificateValidity < 365) {
            this.abort(this.getMessage("common.validityTooShort", "--serverIdentityCertificateValidity"));
        }
        if (httpsCertificateValidity < 365) {
            this.abort(this.getMessage("common.validityTooShort", "--httpsCertificateValidity"));
        }
        try {
            new LdapName(httpsCertificateSubject);
        }
        catch (InvalidNameException e) {
            this.abort(this.getMessage("common.invalidDN", "--httpsCertificateSubject", httpsCertificateSubject));
        }
        String encoding = this.getArgumentValue("--encoding", args, "xor");
        String key = this.getArgumentValue("--key", args, null);
        this.validateEncoding(encoding, key);
        Map<Object, Object> hostAuthInfo = null;
        List<String> list = Arrays.asList(args);
        Boolean useHostCredentials = list.contains("--useHostCredentials");
        this.validateUseHostCredentialsOverrides(list, useHostCredentials);
        if (useHostCredentials.booleanValue()) {
            hostAuthInfo = new HashMap<String, Boolean>();
            hostAuthInfo.put("useHostCredentials", Boolean.TRUE);
        } else {
            hostAuthInfo = this.buildHostAuthInfo(args, this.sshKeyGen, this.sshKeyUtil, hostName, true, true, serverName, serverDir);
        }
        String java_home = System.getProperty("java.home");
        java_home = this.getArgumentValue("--hostJavaHome", args, java_home);
        hostAuthInfo.put("hostJavaHome", java_home);
        if (tc.isEventEnabled()) {
            Map hostAuthInfoWithMaskPassword = PasswordMaskUtil.maskPasswordsInMap(hostAuthInfo);
            Tr.event((TraceComponent)tc, (String)("Resulting hostAuthInfo:\n" + hostAuthInfoWithMaskPassword), (Object[])new Object[0]);
        }
        if ((encodedKeystorePassword = this.encodePassword(keystorePassword, "--keystorePassword", encoding, key)) == null) {
            this.abort(null);
        }
        String encodedServerIdentityKeystorePassword = this.encodePassword(serverIdentityKeystorePassword, "--serverIdentityKeystorePassword", encoding, key);
        String encodedCollectiveTrustKSPassword = this.encodePassword(collectiveTrustKSPassword, "--collectiveTrustKeystorePassword", encoding, key);
        String encodedHTTPSKSPassword = this.encodePassword(httpsKSPassword, "--httpsKeystorePassword", encoding, key);
        String encodedHTTPSTSPassword = this.encodePassword(httpsTSPassword, "--httpsTruststorePassword", encoding, key);
        if (encodedServerIdentityKeystorePassword == null || encodedCollectiveTrustKSPassword == null || encodedHTTPSKSPassword == null || encodedHTTPSTSPassword == null) {
            this.abort(null);
        }
        HashMap<String, Object> certProps = new HashMap<String, Object>();
        certProps.put("serverIdentityKeystorePassword", encodedServerIdentityKeystorePassword);
        certProps.put("serverIdentityCertificateValidity", serverIdentityCertificateValidity);
        certProps.put("collectiveTrustKeystorePassword", encodedCollectiveTrustKSPassword);
        certProps.put("httpsKeystorePassword", encodedHTTPSKSPassword);
        certProps.put("httpsCertificateSubject", httpsCertificateSubject);
        certProps.put("httpsCertificateValidity", httpsCertificateValidity);
        certProps.put("httpsTruststorePassword", encodedHTTPSTSPassword);
        File serverIdentityKeyFile = new File(serverDir + "resources/collective/serverIdentity.jks");
        File collectiveTrustKeyFile = new File(serverDir + "resources/collective/collectiveTrust.jks");
        File httpsKSFile = new File(serverDir + "resources/security/key.jks");
        File tmpHttpsKSFile = new File(serverDir + "resources/security/key.jks" + ".tmp");
        if (httpsKSFile.exists()) {
            stdout.println(this.getMessage("common.regenerateKey", httpsKSFile.getAbsolutePath()));
        }
        File httpsTSFile = new File(serverDir + "resources/security/trust.jks");
        File tmpHttpsTSFile = new File(serverDir + "resources/security/trust.jks" + ".tmp");
        if (httpsTSFile.exists()) {
            stdout.println(this.getMessage("common.regenerateTrust", httpsTSFile.getAbsolutePath()));
        }
        if (!this.fileUtility.createParentDirectory(stdout, serverIdentityKeyFile)) {
            this.abortAndPerformCleanup(null, this.collectiveResourcesDir);
        }
        if (!this.fileUtility.createParentDirectory(stdout, collectiveTrustKeyFile)) {
            this.abortAndPerformCleanup(null, this.collectiveResourcesDir);
        }
        if (!this.fileUtility.createParentDirectory(stdout, httpsKSFile)) {
            this.abortAndPerformCleanup(null, this.collectiveResourcesDir);
        }
        if (!this.fileUtility.createParentDirectory(stdout, tmpHttpsKSFile)) {
            this.abortAndPerformCleanup(null, this.collectiveResourcesDir);
        }
        if (!this.fileUtility.createParentDirectory(stdout, httpsTSFile)) {
            this.abortAndPerformCleanup(null, this.collectiveResourcesDir);
        }
        if (!this.fileUtility.createParentDirectory(stdout, tmpHttpsTSFile)) {
            this.abortAndPerformCleanup(null, this.collectiveResourcesDir);
        }
        stdout.println(this.getMessage("join.start", controllerHost, String.valueOf(controllerPort)));
        if (DockerEnvironmentUtil.isMemberInDockerEnvironment()) {
            hostName = DockerEnvironmentUtil.getContainerPropertyFromEnvironment((String)"containerHost");
            userDir = "Docker";
            serverName = DockerEnvironmentUtil.getContainerPropertyFromEnvironment((String)"containerName");
            hostAuthInfo.put("collectiveMemberType", "Liberty");
            hostAuthInfo.put("sys.container.type", "Docker");
        }
        if (!this.fileUtility.writeBytesToFile(stderr, (joinResult = this.join(controllerHost, controllerPort, user, password, hostName, userDir, serverName, installDir, keystorePassword, certProps, hostAuthInfo)).get("serverIdentity.jks"), serverIdentityKeyFile)) {
            this.abortAndPerformCleanup(this.getMessage("join.writeKeystoreFail", serverIdentityKeyFile.getAbsolutePath()), this.collectiveResourcesDir);
        }
        if (!this.fileUtility.writeBytesToFile(stderr, joinResult.get("collectiveTrust.jks"), collectiveTrustKeyFile)) {
            this.abortAndPerformCleanup(this.getMessage("join.writeKeystoreFail", collectiveTrustKeyFile.getAbsolutePath()), this.collectiveResourcesDir);
        }
        if (!this.fileUtility.writeBytesToFile(stderr, joinResult.get("key.jks"), tmpHttpsKSFile)) {
            this.abortAndPerformCleanup(this.getMessage("join.writeKeystoreFail", tmpHttpsKSFile.getAbsolutePath()), this.collectiveResourcesDir);
        }
        if (!this.fileUtility.writeBytesToFile(stderr, joinResult.get("trust.jks"), tmpHttpsTSFile)) {
            this.abortAndPerformCleanup(this.getMessage("join.writeKeystoreFail", tmpHttpsTSFile.getAbsolutePath()), this.collectiveResourcesDir);
        }
        this.updateExistingSSLKeys(httpsKSFile, tmpHttpsKSFile, httpsTSFile, tmpHttpsTSFile, this.collectiveResourcesDir);
        Boolean genDeployVariables = Arrays.asList(args).contains("--genDeployVariables");
        if (genDeployVariables.booleanValue()) {
            parser = new AdminMetadataParser();
            serverMetadataFile = new File(serverDir + "admin-metadata.xml");
            String[] names = parser.parseDeployVariableAdminMetadata(serverMetadataFile);
            stdout.println(this.getMessage("allocateDeployVariables.start", new Object[0]));
            Map<String, Integer> deployVars = this.allocateDeployVariables(controllerHost, controllerPort, user, password, hostName, names);
            String parentDir = serverDir + "configDropins/overrides";
            if (deployVars != null && deployVars.size() > 0) {
                HashSet<String> unresolvedDeployVars = this.createDeployVariableXMLFile(parentDir, deployVars, "deployVariables.xml");
                if (unresolvedDeployVars.isEmpty()) {
                    stdout.println(this.getMessage("deployVarsAreAllocated", new Object[0]));
                } else {
                    stdout.println(this.getMessage("deployVarsNotFound", unresolvedDeployVars));
                }
            } else {
                stdout.println(this.getMessage("deployVarsNotFound", deployVars));
            }
        }
        if ((adminMetadata = (parser = new AdminMetadataParser()).parseAdminMetadata(serverMetadataFile = new File(serverDir + "admin-metadata.xml"), "server")) != null && adminMetadata.containsKey("server")) {
            Map serverMetadata = (Map)adminMetadata.get("server");
            boolean userDirExists = this.fileUtility.exists(userDir);
            if (userDirExists) {
                String serverIdentity = RepositoryPathUtility.buildServerTuple((String)hostName, (String)userDir, (String)serverName);
                serverIdentity = RepositoryPathUtility.encodeServerTuple((String)serverIdentity);
                stdout.println(this.getMessage("deployAdminMetadata.start", new Object[0]));
                this.deployAdminMetadata(controllerHost, controllerPort, user, password, "server", serverIdentity, serverMetadata);
            } else {
                stdout.println(this.getMessage("userDirNotFound", userDir));
            }
        }
        if ((metadata = parser.parseAdminMetadata(runtimeMetadataFile = new File(installDir + "etc/admin-metadata.xml"), "runtime")) != null && metadata.containsKey("runtime")) {
            Map runtimeMetadata = (Map)adminMetadata.get("runtime");
            boolean installDirExists = this.fileUtility.exists(installDir);
            if (installDirExists) {
                String runtimeIdentity = hostName + "," + installDir;
                stdout.println(this.getMessage("deployAdminMetadata.start", new Object[0]));
                this.deployAdminMetadata(controllerHost, controllerPort, user, password, "runtime", runtimeIdentity, runtimeMetadata);
            } else {
                stdout.println(this.getMessage("installDirNotFound", installDir));
            }
        }
        stdout.println();
        stdout.println(this.getMessage("join.successful", serverName));
        String configXML = this.getConfigXML(args, controllerHost, controllerPort, hostName, encoding, key, encodedServerIdentityKeystorePassword, encodedCollectiveTrustKSPassword, encodedHTTPSKSPassword, encodedHTTPSTSPassword);
        this.handleConfigXML(stdout, args, serverDir, configXML);
    }

    private String getConfigXML(String[] args, String controllerHost, int controllerPort, String hostName, String encoding, String key, String encodedServerIdentityKeystorePassword, String encodedCollectiveTrustKSPassword, String encodedHTTPSKSPassword, String encodedHTTPSTSPassword) {
        String xmlSnippet = "    <featureManager>" + NL + "        <feature>collectiveMember-1.0</feature>" + NL + "    </featureManager>" + NL + NL + this.insertHostNameVariable(hostName) + NL + this.insertHostAuthInfo(args) + "    <!-- Connection to the collective controller -->" + NL + "    <collectiveMember controllerHost=\"" + controllerHost + "\"" + NL + "                      controllerPort=\"" + controllerPort + "\" />" + NL + NL + this.insertEncodingKey(encoding, key) + "    <!-- clientAuthenticationSupported set to enable bidirectional trust -->" + NL + "    <ssl id=\"defaultSSLConfig\"" + NL + "         keyStoreRef=\"defaultKeyStore\"" + NL + "         trustStoreRef=\"defaultTrustStore\"" + NL + "         clientAuthenticationSupported=\"true\" />" + NL + NL + "    <!-- inbound (HTTPS) keystore -->" + NL + "    <keyStore id=\"defaultKeyStore\" password=\"" + encodedHTTPSKSPassword + "\"" + NL + "              location=\"${server.config.dir}/" + "resources/security/key.jks" + "\" />" + NL + NL + "    <!-- inbound (HTTPS) truststore -->" + NL + "    <keyStore id=\"defaultTrustStore\" password=\"" + encodedHTTPSTSPassword + "\"" + NL + "              location=\"${server.config.dir}/" + "resources/security/trust.jks" + "\" />" + NL + NL + "    <!-- server identity keystore -->" + NL + "    <keyStore id=\"serverIdentity\" password=\"" + encodedServerIdentityKeystorePassword + "\"" + NL + "              location=\"${server.config.dir}/" + "resources/collective/serverIdentity.jks" + "\" />" + NL + NL + "    <!-- collective truststore -->" + NL + "    <keyStore id=\"collectiveTrust\" password=\"" + encodedCollectiveTrustKSPassword + "\"" + NL + "              location=\"${server.config.dir}/" + "resources/collective/collectiveTrust.jks" + "\" />" + NL;
        return xmlSnippet;
    }

    private HashSet<String> createDeployVariableXMLFile(String parentDir, Map<String, Integer> deployVars, String deployVariablesFileName) {
        File deployVariableFile = new File(parentDir, deployVariablesFileName);
        this.fileUtility.createParentDirectory(this.stdout, deployVariableFile);
        StringBuffer xmlBuffer = new StringBuffer();
        HashSet<String> unResolvedDeployVars = new HashSet<String>();
        this.stdout.println(this.getMessage("AllocatedDeployVars", new Object[0]));
        for (String deployVarName : deployVars.keySet()) {
            Integer value = deployVars.get(deployVarName);
            if (value != null) {
                String xmlStanzas = "    <variable name=\"" + deployVarName + "\" value=\"" + value + "\" />" + NL;
                xmlBuffer.append(xmlStanzas);
                this.stdout.println("[" + deployVarName + " = " + value + "]");
                continue;
            }
            unResolvedDeployVars.add(deployVarName);
        }
        String xmlTemplate = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + NL + NL + "<server description=\"This file was generated by the join command.\">" + NL + NL + "{1}" + NL + "</server>" + NL;
        String xmlData = MessageFormat.format(xmlTemplate, Calendar.getInstance().getTime(), xmlBuffer.toString());
        this.fileUtility.writeToFile(this.stderr, xmlData, deployVariableFile);
        return unResolvedDeployVars;
    }
}

