/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.collective.utility.tasks;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.collective.utility.CollectiveUtilityTask;
import com.ibm.ws.collective.utility.TaskErrorException;
import com.ibm.ws.collective.utility.tasks.BaseCommandTask;
import com.ibm.ws.collective.utility.utils.ConsoleWrapper;
import java.io.File;
import java.io.PrintStream;
import java.util.List;

public class HelpTask
extends BaseCommandTask {
    private static final TraceComponent tc = Tr.register(HelpTask.class);
    private final List<CollectiveUtilityTask> tasks;

    public HelpTask(String scriptName, List<CollectiveUtilityTask> tasks) {
        super(tc, scriptName, null);
        this.tasks = tasks;
    }

    @Override
    public String getTaskName() {
        return "help";
    }

    @Override
    public String getTaskUsage() {
        return this.getTaskUsage("help.usage.options");
    }

    @Override
    public String getTaskHelp() {
        return this.getTaskHelp("help.desc", "help.usage.options", null, null, null, null, this.scriptName);
    }

    @Override
    public String getTaskDescription() {
        return this.getOption("help.desc", new Object[0]);
    }

    @Override
    protected void abort(String message) throws TaskErrorException {
    }

    @Override
    protected void abortAndPerformCleanup(String message, File collectiveResourcesDir) throws TaskErrorException {
    }

    public String getScriptHelp() {
        return this.verboseHelp();
    }

    public String getTaskUsage(CollectiveUtilityTask task) {
        return task.getTaskUsage();
    }

    public String getScriptUsage() {
        StringBuffer scriptUsage = new StringBuffer(NL);
        scriptUsage.append(this.getMessage("usage", this.scriptName));
        scriptUsage.append(NL);
        return scriptUsage.toString();
    }

    private String verboseHelp() {
        StringBuffer verboseHelp = new StringBuffer(NL);
        verboseHelp.append(this.getMessage("usage", this.scriptName));
        verboseHelp.append(NL);
        if (this.tasks.size() > 0) {
            verboseHelp.append(NL);
            verboseHelp.append(this.getOption("global.actions", new Object[0]));
            verboseHelp.append(NL);
            for (CollectiveUtilityTask task : this.tasks) {
                verboseHelp.append(NL);
                verboseHelp.append("    ");
                verboseHelp.append(task.getTaskName());
                verboseHelp.append(NL);
                verboseHelp.append(task.getTaskDescription());
                verboseHelp.append(NL);
            }
            verboseHelp.append(NL);
            verboseHelp.append(this.getOption("global.options", new Object[0]));
            verboseHelp.append(NL);
            verboseHelp.append(this.getOption("global.options.statement", new Object[0]));
        }
        return verboseHelp.toString();
    }

    private String taskHelp(CollectiveUtilityTask task) {
        StringBuffer taskUsage = new StringBuffer(NL);
        taskUsage.append(task.getTaskHelp());
        taskUsage.append(NL);
        return taskUsage.toString();
    }

    private CollectiveUtilityTask getTask(String taskName) {
        CollectiveUtilityTask task = null;
        for (CollectiveUtilityTask availTask : this.tasks) {
            if (!availTask.getTaskName().equals(taskName)) continue;
            task = availTask;
        }
        return task;
    }

    @Override
    public void handleTask(ConsoleWrapper stdin, PrintStream stdout, PrintStream stderr, String[] args) {
        if (args.length == 1) {
            stdout.println(this.verboseHelp());
        } else {
            CollectiveUtilityTask task = this.getTask(args[1]);
            if (task == null) {
                stderr.println(NL + this.getMessage("task.unknown", args[1]) + NL);
            } else {
                stdout.println(this.taskHelp(task));
            }
        }
    }
}

