/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.collective.utility.tasks;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.collective.utility.ICollectiveRegistrationMBeanConnection;
import com.ibm.ws.collective.utility.IFileUtility;
import com.ibm.ws.collective.utility.TaskErrorException;
import com.ibm.ws.collective.utility.tasks.BaseCommandTask;
import com.ibm.ws.collective.utility.utils.ConsoleWrapper;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import javax.management.RuntimeMBeanException;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;

public class GenKeyTask
extends BaseCommandTask {
    private static final TraceComponent tc = Tr.register(GenKeyTask.class);
    private final ICollectiveRegistrationMBeanConnection registrationMBean;

    public GenKeyTask(String scriptName, IFileUtility fileUtility, ICollectiveRegistrationMBeanConnection registrationMBean) {
        super(tc, scriptName, fileUtility);
        this.registrationMBean = registrationMBean;
        this.reqArgs.add("--host");
        this.reqArgs.add("--port");
        this.reqArgs.add("--user");
        this.reqArgs.add("--password");
        this.reqArgs.add("--keystorePassword");
        this.promptableArgs.add("--password");
        this.confirmedArgs.add("--keystorePassword");
        this.knownArgs.addAll(this.reqArgs);
        this.knownArgs.addAll(this.promptableArgs);
        this.knownArgs.addAll(this.confirmedArgs);
        this.knownArgs.add("--certificateSubject");
        this.knownArgs.add("--certificateValidity");
        this.knownArgs.add("--encoding");
        this.knownArgs.add("--key");
        this.knownArgs.add("--keystoreFile");
        this.addAutoAcceptArgument();
    }

    @Override
    public String getTaskName() {
        return "genKey";
    }

    @Override
    public String getTaskUsage() {
        return this.getTaskUsage("genKey.usage.options");
    }

    @Override
    public String getTaskHelp() {
        String footer = this.buildScriptOptions("genKey.required-option-key.keystorePassword", "genKey.required-option-desc.keystorePassword") + this.buildScriptOptions("genKey.option-key.", "genKey.option-desc.") + this.buildScriptOptions("encoding.option-key.", "encoding.option-desc.") + this.buildScriptOptions("certProps.option-key.autoAccept", "certProps.option-desc.autoAccept") + NL + NL + this.getOption("sslTrust.autoAccept", "com.ibm.websphere.collective.utility.autoAcceptCertificates");
        return this.getTaskHelp("genKey.desc", "genKey.usage.options", "connection.option-key.", "connection.option-desc.", null, footer, this.scriptName);
    }

    @Override
    public String getTaskDescription() {
        return this.getOption("genKey.desc", new Object[0]);
    }

    @Override
    protected void abort(String message) throws TaskErrorException {
        this.stdout.println(this.getMessage("genKey.abort", new Object[0]));
        throw new TaskErrorException(message);
    }

    @Override
    protected void abortAndPerformCleanup(String message, File keyFile) throws TaskErrorException {
        this.stdout.println(this.getMessage("genKey.abort", new Object[0]));
        if (!this.fileUtility.recurisveDelete(keyFile)) {
            this.stdout.println(this.getMessage("genKey.cleanupFail", keyFile));
        }
        throw new TaskErrorException(message);
    }

    private Map<String, byte[]> genKey(String controllerHost, int controllerPort, String user, String password, String keystorePassword, Map<String, Object> certProps) throws TaskErrorException {
        try {
            Map<String, byte[]> ret = this.registrationMBean.genKey(controllerHost, controllerPort, user, password, keystorePassword, certProps, Boolean.FALSE);
            this.stdout.println(this.getMessage("genKey.mbeanComplete", new Object[0]));
            return ret;
        }
        catch (RuntimeMBeanException e) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Caught RuntimeMBeanException, this may be expected, but here's the stack incase it helps.", (Object[])new Object[]{e});
            }
            if (e.getCause() instanceof IllegalArgumentException) {
                this.abort(this.getMessage("common.connectionError", e.getMessage()));
            } else {
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)("Unexpected RuntimeMBeanException while invoking the MBean: " + e.getMessage()), (Object[])new Object[]{e});
                }
                this.stderr.println(this.getMessage("error", e.getMessage()));
                this.abort(this.getMessage("common.connectionError", e.getMessage()));
            }
        }
        catch (UnknownHostException e) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("UnknownHostException while invoking the MBean: " + e.getMessage()), (Object[])new Object[]{e});
            }
            this.abort(this.getMessage("common.hostError", controllerHost));
        }
        catch (ConnectException e) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("ConnectException while invoking the MBean: " + e.getMessage()), (Object[])new Object[]{e});
            }
            this.abort(this.getMessage("common.portError", String.valueOf(controllerPort)));
        }
        catch (IOException e) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("IOException while invoking the MBean: " + e.getMessage()), (Object[])new Object[]{e});
            }
            this.abort(this.getMessage("common.connectionError", e.getMessage()));
        }
        catch (Exception e) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("Unexpected Exception while invoking the MBean: " + e.getMessage()), (Object[])new Object[]{e});
            }
            this.stderr.println(this.getMessage("error", e.getMessage()));
            this.abort(this.getMessage("common.connectionError", e.getMessage()));
        }
        return null;
    }

    @Override
    public void handleTask(ConsoleWrapper stdin, PrintStream stdout, PrintStream stderr, String[] args) throws TaskErrorException {
        File oldKSFile;
        this.stdin = stdin;
        this.stdout = stdout;
        this.stderr = stderr;
        this.validateArgumentList(args, true);
        String controllerHost = this.getArgumentValue("--host", args, null);
        int controllerPort = Integer.valueOf(this.getArgumentValue("--port", args, null));
        String user = this.getArgumentValue("--user", args, null);
        String password = this.getArgumentValue("--password", args, null);
        this.handleAutoAcceptArgument(args);
        String keystorePassword = this.getArgumentValue("--keystorePassword", args, null);
        String defaultCertificateSubject = "CN=localhost,OU=client,O=ibm,C=us";
        String certificateSubject = this.getArgumentValue("--certificateSubject", args, defaultCertificateSubject);
        Integer certificateValidity = Integer.valueOf(this.getArgumentValue("--certificateValidity", args, String.valueOf(1825)));
        if (certificateValidity < 365) {
            this.abort(this.getMessage("common.validityTooShort", "--certificateValidity"));
        }
        try {
            new LdapName(certificateSubject);
        }
        catch (InvalidNameException e) {
            this.abort(this.getMessage("common.invalidDN", "--certificateSubject", certificateSubject));
        }
        String encoding = this.getArgumentValue("--encoding", args, "xor");
        String key = this.getArgumentValue("--key", args, null);
        this.validateEncoding(encoding, key);
        String encodedKeystorePassword = this.encodePassword(keystorePassword, "--keystorePassword", encoding, key);
        if (encodedKeystorePassword == null) {
            this.abort(null);
        }
        HashMap<String, Object> certProps = new HashMap<String, Object>();
        certProps.put("certificateSubject", certificateSubject);
        certProps.put("certificateValidity", certificateValidity);
        String defaultKeyStoreName = "key.jks";
        String keyStoreName = this.getArgumentValue("--keystoreFile", args, defaultKeyStoreName);
        File kSFile = new File(keyStoreName);
        File tmpKSFile = new File(keyStoreName + ".tmp");
        if (kSFile.exists()) {
            stdout.println(this.getMessage("common.regenerateKey", kSFile.getAbsolutePath()));
        }
        stdout.println(this.getMessage("genKey.start", controllerHost, String.valueOf(controllerPort)));
        Map<String, byte[]> genKeyResult = this.genKey(controllerHost, controllerPort, user, password, keystorePassword, certProps);
        if (!this.fileUtility.writeBytesToFile(stderr, genKeyResult.get("key.jks"), tmpKSFile)) {
            this.abortAndPerformCleanup(this.getMessage("genKey.writeKeystoreFail", tmpKSFile.getAbsolutePath()), tmpKSFile);
        }
        if (this.fileUtility.exists(kSFile) && !this.fileUtility.renameFile(kSFile, oldKSFile = this.findAvailableBackupFile(kSFile))) {
            this.abortAndPerformCleanup(this.getMessage("common.renameFailed", kSFile.getAbsolutePath(), oldKSFile.getAbsolutePath()), tmpKSFile);
        }
        if (!this.fileUtility.renameFile(tmpKSFile, kSFile)) {
            this.abortAndPerformCleanup(this.getMessage("common.renameFailed", tmpKSFile.getAbsolutePath(), kSFile.getAbsolutePath()), tmpKSFile);
        }
        stdout.println();
        stdout.println(this.getMessage("genKey.generatedKeystore", keyStoreName));
    }
}

