/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.collective.utility.tasks;

import com.ibm.websphere.crypto.InvalidPasswordEncodingException;
import com.ibm.websphere.crypto.PasswordUtil;
import com.ibm.websphere.crypto.UnsupportedCryptoAlgorithmException;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.collective.member.internal.ssh.SSHKeyGenerator;
import com.ibm.ws.collective.member.internal.ssh.SSHKeyPair;
import com.ibm.ws.collective.member.internal.ssh.SSHKeyUtility;
import com.ibm.ws.collective.utility.CollectiveUtilityTask;
import com.ibm.ws.collective.utility.ICommonMBeanConnection;
import com.ibm.ws.collective.utility.IFileUtility;
import com.ibm.ws.collective.utility.TaskErrorException;
import com.ibm.ws.collective.utility.utils.CommandUtils;
import com.ibm.ws.collective.utility.utils.ConsoleWrapper;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.NoSuchAlgorithmException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;

public abstract class BaseCommandTask
implements CollectiveUtilityTask,
ICommonMBeanConnection {
    static final String SLASH = "/";
    static final String NL = System.getProperty("line.separator");
    static final String SSH_KEYS_DIR = "resources/security/ssh";
    static final String SSH_PRIVATE_KEY = "resources/security/ssh/id_rsa";
    static final String SSH_PUBLIC_KEY = "resources/security/ssh/id_rsa.pub";
    static final String COLLECTIVE_RESOURCES_DIR = "resources/collective";
    static final String COLLECTIVE_UUID_FILE = "resources/collective/collective.uuid";
    static final String COLLECTIVE_NAME_FILE = "resources/collective/collective.name";
    static final String COLLECTIVE_ROOT_KEYS_FILE = "resources/collective/rootKeys.jks";
    static final String SERVER_IDENTITY_KEY_FILE = "resources/collective/serverIdentity.jks";
    static final String COLLECTIVE_TRUST_KEY_FILE = "resources/collective/collectiveTrust.jks";
    static final String HTTPS_SSL_KEY_FILE = "resources/security/key.jks";
    static final String HTTPS_TRUST_KEY_FILE = "resources/security/trust.jks";
    static final String COLLECTIVE_MARKER_FILE = "resources/collective/.collective";
    static final String DEPLOY_VARIABLES_PARENT_DIR = "configDropins/overrides";
    static final String DEPLOY_VARIABLES_FILE = "deployVariables.xml";
    static final String SERVER_ADMIN_METADATA_FILE = "admin-metadata.xml";
    static final String RUNTIME_ADMIN_METADATA_FILE = "etc/admin-metadata.xml";
    static final String CONTROLLER_ROOT_KEY_ALIAS = "controllerRoot";
    static final String MEMBER_ROOT_KEY_ALIAS = "memberRoot";
    static final String SERVER_IDENTITY_KEY_ALIAS = "serverIdentity";
    static final String HTTPS_KEY_ALIAS = "default";
    static final int VALIDITY_25_YEARS = 9125;
    static final int VALIDITY_5_YEARS = 1825;
    static final String XOR_ENCODING = "xor";
    static final String AES_ENCODING = "aes";
    static final String ARG_REQ_HOST = "--host";
    static final String ARG_REQ_PORT = "--port";
    static final String ARG_REQ_USER = "--user";
    static final String ARG_REQ_PASSWORD = "--password";
    static final String ARG_OPT_HOST_NAME = "--hostName";
    static final String ARG_OPT_ENCODING = "--encoding";
    static final String ARG_OPT_KEY = "--key";
    static final String ARG_OPT_CREATE_CONFIG_FILE = "--createConfigFile";
    static final String ARG_OPT_KEYSTORE_FILE = "--keystoreFile";
    static final String ARG_OPT_USE_HOST_CREDENTIALS = "--useHostCredentials";
    static final String ARG_OPT_GEN_DEPLOY_VARIABLES = "--genDeployVariables";
    static final String ARG_OPT_REMOVE_DEPLOY_VARIABLES = "--removeDeployVariables";
    static final String ARG_REQ_KEYSTORE_PASSWORD = "--keystorePassword";
    static final String ARG_OPT_COLLECTIVE_NAME = "--collectiveName";
    static final String ARG_OPT_AUTO_ACCEPT_CERTS = "--autoAcceptCertificates";
    static final String ARG_OPT_SERVER_IDENTITY_KEYSTORE_PASSWORD = "--serverIdentityKeystorePassword";
    static final String ARG_OPT_SERVER_IDENTITY_CERT_VALIDITY = "--serverIdentityCertificateValidity";
    static final String ARG_OPT_COLLECTIVE_TRUST_KS_PASSWORD = "--collectiveTrustKeystorePassword";
    static final String ARG_OPT_HTTPS_KEYSTORE_PASSWORD = "--httpsKeystorePassword";
    static final String ARG_OPT_HTTPS_CERTIFICATE_SUBJECT = "--httpsCertificateSubject";
    static final String ARG_OPT_HTTPS_CERTIFICATE_VALIDITY = "--httpsCertificateValidity";
    static final String ARG_OPT_HTTPS_TRUSTSTORE_PASSWORD = "--httpsTruststorePassword";
    static final String ARG_OPT_ROOT_KS_PASSWORD = "--rootKeystorePassword";
    static final String ARG_OPT_CERTIFICATE_SUBJECT = "--certificateSubject";
    static final String ARG_OPT_CERTIFICATE_VALIDITY = "--certificateValidity";
    static final String ARG_OPT_RPC_HOST = "--rpcHost";
    static final String ARG_OPT_RPC_PORT = "--rpcPort";
    static final String ARG_OPT_RPC_USER = "--rpcUser";
    static final String ARG_OPT_RPC_USER_PASSWORD = "--rpcUserPassword";
    static final String ARG_OPT_RPC_USER_HOME = "--rpcUserHome";
    static final String ARG_OPT_SSH_PRIVATE_KEY = "--sshPrivateKey";
    static final String ARG_OPT_SSH_PRIVATE_KEY_PASSWORD = "--sshPrivateKeyPassword";
    static final String ARG_OPT_USE_SUDO = "--useSudo";
    static final String ARG_OPT_SUDO_USER = "--sudoUser";
    static final String ARG_OPT_SUDO_USER_PASSWORD = "--sudoUserPassword";
    static final String ARG_OPT_HOST_READ_PATH = "--hostReadPath";
    static final String ARG_OPT_HOST_WRITE_PATH = "--hostWritePath";
    static final String ARG_OPT_HOST_JAVA_HOME = "--hostJavaHome";
    protected final String scriptName;
    protected final TraceComponent tc;
    protected final IFileUtility fileUtility;
    protected ConsoleWrapper stdin;
    protected PrintStream stdout;
    protected PrintStream stderr;
    protected Collection<String> reqArgs = new HashSet<String>();
    protected Collection<String> promptableArgs = new HashSet<String>();
    protected Collection<String> confirmedArgs = new HashSet<String>();
    protected Collection<String> flagArgs = new HashSet<String>();
    protected Collection<String> knownArgs = new HashSet<String>();
    protected Collection<String> noValueRequiredArgs = new HashSet<String>();
    private String rpcUser;
    private String rpcUserHome;
    private String sshPublicKey;
    private boolean isDefaultHostAuthInfo;

    public BaseCommandTask(TraceComponent tc, String scriptName, IFileUtility fileUtility) {
        this.tc = tc;
        this.scriptName = scriptName;
        this.fileUtility = fileUtility;
    }

    protected String getMessage(String key, Object ... args) {
        return CommandUtils.getMessage(key, args);
    }

    protected String getOption(String key, Object ... args) {
        return CommandUtils.getOption(key, args);
    }

    protected void addAutoAcceptArgument() {
        this.noValueRequiredArgs.add(ARG_OPT_AUTO_ACCEPT_CERTS);
        this.knownArgs.addAll(this.noValueRequiredArgs);
    }

    protected void handleAutoAcceptArgument(String[] args) {
        String autoAccept = this.getArgumentValue(ARG_OPT_AUTO_ACCEPT_CERTS, args, "false");
        if (autoAccept == null || autoAccept.compareTo("true") == 0) {
            System.setProperty("com.ibm.websphere.collective.utility.autoAcceptCertificates", "true");
        }
    }

    protected abstract void abort(String var1) throws TaskErrorException;

    protected abstract void abortAndPerformCleanup(String var1, File var2) throws TaskErrorException;

    protected String buildScriptOptions(String optionKeyPrefix, String optionDescPrefix) {
        StringBuilder scriptOptions = new StringBuilder();
        if (optionKeyPrefix != null && !optionKeyPrefix.isEmpty() && optionDescPrefix != null && !optionDescPrefix.isEmpty()) {
            Enumeration<String> keys = CommandUtils.getOptions().getKeys();
            TreeSet<String> optionKeys = new TreeSet<String>();
            while (keys.hasMoreElements()) {
                String key = keys.nextElement();
                if (!key.startsWith(optionKeyPrefix)) continue;
                optionKeys.add(key);
            }
            if (optionKeys.size() > 0) {
                for (String optionKey : optionKeys) {
                    String option = optionKey.substring(optionKeyPrefix.length());
                    scriptOptions.append(NL);
                    scriptOptions.append(CommandUtils.getOptions().getString(optionKey));
                    scriptOptions.append(NL);
                    scriptOptions.append(CommandUtils.getOptions().getString(optionDescPrefix + option));
                    scriptOptions.append(NL);
                }
            }
        }
        return scriptOptions.toString();
    }

    protected String getTaskUsage(String usage) {
        StringBuilder scriptHelp = new StringBuilder();
        scriptHelp.append(this.getOption("global.usage", new Object[0]));
        scriptHelp.append(NL);
        scriptHelp.append(this.getOption(usage, new Object[0]));
        return MessageFormat.format(scriptHelp.toString(), this.scriptName);
    }

    protected String getTaskHelp(String desc, String usage, String optionKeyPrefix, String optionDescPrefix, String addonKey, String footer, Object ... args) {
        StringBuilder scriptHelp = new StringBuilder();
        scriptHelp.append(this.getOption("global.description", new Object[0]));
        scriptHelp.append(NL);
        scriptHelp.append(this.getOption(desc, new Object[0]));
        scriptHelp.append(NL);
        scriptHelp.append(NL);
        scriptHelp.append(this.getOption("global.usage", new Object[0]));
        scriptHelp.append(NL);
        scriptHelp.append(this.getOption(usage, new Object[0]));
        scriptHelp.append(NL);
        String options = this.buildScriptOptions(optionKeyPrefix, optionDescPrefix);
        if (!options.isEmpty()) {
            scriptHelp.append(NL);
            scriptHelp.append(this.getOption("global.options", new Object[0]));
            scriptHelp.append(options);
        }
        if (addonKey != null && !addonKey.isEmpty()) {
            scriptHelp.append(NL);
            scriptHelp.append(this.getOption(addonKey, new Object[0]));
        }
        if (footer != null && !footer.isEmpty()) {
            scriptHelp.append(footer);
        }
        if (args.length == 0) {
            return scriptHelp.toString();
        }
        return MessageFormat.format(scriptHelp.toString(), args);
    }

    private String getArgName(String arg) {
        return arg.split("=")[0];
    }

    private boolean isKnownArgument(String arg) {
        String argName = this.getArgName(arg);
        for (String key : this.knownArgs) {
            if (!key.equalsIgnoreCase(argName)) continue;
            return true;
        }
        return false;
    }

    private void checkRequiredArguments(String[] args, boolean supportsDefaultTarget) {
        StringBuilder message = new StringBuilder();
        int additionalArgs = supportsDefaultTarget ? 1 : 2;
        if (args.length < this.reqArgs.size() + additionalArgs) {
            message.append(this.getMessage("insufficientArgs", new Object[0]));
            message.append(NL);
        }
        if (!supportsDefaultTarget && (args.length < 2 || args[1].startsWith("-"))) {
            message.append(this.getMessage("missingServerName", new Object[0]));
            message.append(NL);
        }
        for (String reqArg : this.reqArgs) {
            String lowerReqArg = reqArg.toLowerCase();
            boolean argFound = false;
            for (String arg : args) {
                if (!arg.toLowerCase().startsWith(lowerReqArg)) continue;
                argFound = true;
                break;
            }
            if (argFound) continue;
            message.append(this.getMessage("missingArg", reqArg));
            message.append(NL);
        }
        if (!message.toString().isEmpty()) {
            throw new IllegalArgumentException(message.toString());
        }
    }

    protected boolean isKeystorePwdUsed(String[] args, Collection<String> pwdArgs) {
        boolean keystorePwdUsed = false;
        for (int i = 2; i < args.length; ++i) {
            String arg = args[i];
            String option = arg.split("=")[0];
            pwdArgs.remove(option);
            if (!option.equals(ARG_REQ_KEYSTORE_PASSWORD)) continue;
            keystorePwdUsed = true;
        }
        return keystorePwdUsed;
    }

    protected void printMissingPasswordArgs(Collection pwdArgs) {
        Iterator iter = pwdArgs.iterator();
        StringBuilder message = new StringBuilder();
        StringBuilder pwdArgsString = new StringBuilder();
        while (iter.hasNext()) {
            String missingArg = (String)iter.next();
            pwdArgsString.append(missingArg);
            pwdArgsString.append("  ");
        }
        message.append(this.getMessage("insufficientArgs", new Object[0]));
        message.append(NL);
        message.append(this.getMessage("missingPasswordArg", ARG_REQ_KEYSTORE_PASSWORD, pwdArgsString));
        message.append(NL);
        throw new IllegalArgumentException(message.toString());
    }

    private String getValue(String arg) {
        String[] split = arg.split("=");
        if (split.length == 1) {
            return null;
        }
        if (split.length == 2) {
            return split[1];
        }
        StringBuffer value = new StringBuffer();
        for (int i = 1; i < split.length; ++i) {
            value.append(split[i]);
            if (i >= split.length - 1) continue;
            value.append("=");
        }
        return value.toString();
    }

    protected void validateArgumentList(String[] args, boolean supportsDefaultTarget) {
        this.validateArgumentList(args, true, supportsDefaultTarget);
    }

    protected void validateArgumentList(String[] args, boolean supportsTarget, boolean supportsDefaultTarget) {
        this.checkRequiredArguments(args, !supportsTarget || supportsDefaultTarget);
        int firstArg = 1;
        if (supportsTarget) {
            String primArg;
            if (!supportsDefaultTarget) {
                firstArg = 2;
            } else if (args.length > 1 && !(primArg = args[1]).startsWith("-")) {
                firstArg = 2;
            }
        }
        for (int i = firstArg; i < args.length; ++i) {
            String argName = this.getArgName(args[i]);
            String value = this.getValue(args[i]);
            if (!this.isKnownArgument(argName)) {
                throw new IllegalArgumentException(this.getMessage("invalidArg", argName));
            }
            if (this.promptableArgs.contains(argName) || this.confirmedArgs.contains(argName) || this.flagArgs.contains(argName) || value != null || this.noValueRequiredArgs.contains(argName)) continue;
            throw new IllegalArgumentException(this.getMessage("missingValue", argName));
        }
    }

    protected String getTaskTarget(String[] args) {
        String primArg = args[1];
        if (primArg.startsWith("-")) {
            return null;
        }
        return primArg;
    }

    protected String promptForPassword(String arg) {
        return this.stdin.readMaskedText(this.getMessage("password.enterText", arg) + " ");
    }

    private String promptForText(String arg) {
        String read1 = this.stdin.readMaskedText(this.getMessage("password.enterText", arg) + " ");
        String read2 = this.stdin.readMaskedText(this.getMessage("password.reenterText", arg) + " ");
        if (read1 == null && read2 == null) {
            throw new IllegalArgumentException("Unable to read either entry. Aborting prompt.");
        }
        if (read1 == null || read2 == null) {
            this.stdout.println(this.getMessage("password.readError", new Object[0]));
            return this.promptForText(arg);
        }
        if (read1.equals(read2)) {
            return read1;
        }
        this.stdout.println(this.getMessage("password.entriesDidNotMatch", new Object[0]));
        return this.promptForText(arg);
    }

    protected String getArgumentValue(String arg, String[] args, String defalt) {
        String argName = this.getArgName(arg);
        for (int i = 1; i < args.length; ++i) {
            String currentArgName = this.getArgName(args[i]);
            if (!currentArgName.equalsIgnoreCase(argName)) continue;
            String value = this.getValue(args[i]);
            if (value == null && this.promptableArgs.contains(argName)) {
                return this.promptForPassword(arg);
            }
            if (value == null && this.confirmedArgs.contains(argName)) {
                return this.promptForText(arg);
            }
            return value;
        }
        return defalt;
    }

    protected List<String> getArgumentList(String arg, String[] args, List<String> defalt) {
        ArrayList<String> ret = new ArrayList<String>();
        String argName = this.getArgName(arg);
        for (int i = 1; i < args.length; ++i) {
            String currentArgName = this.getArgName(args[i]);
            if (!currentArgName.equalsIgnoreCase(argName)) continue;
            String value = this.getValue(args[i]);
            ret.add(value);
        }
        if (ret.isEmpty()) {
            return defalt;
        }
        return ret;
    }

    protected String encodePassword(String password, String arg, String encoding, String key) {
        String encoded = null;
        try {
            encoded = PasswordUtil.encode((String)password, (String)encoding, (String)key);
        }
        catch (InvalidPasswordEncodingException e1) {
            e1.printStackTrace(this.stderr);
        }
        catch (UnsupportedCryptoAlgorithmException e1) {
            e1.printStackTrace(this.stderr);
        }
        if (encoded == null) {
            this.stdout.println(this.getMessage("common.encodeError", arg));
        }
        return encoded;
    }

    protected String getHostName() {
        try {
            InetAddress addr = InetAddress.getLocalHost();
            return addr.getCanonicalHostName().toLowerCase();
        }
        catch (UnknownHostException e) {
            this.stderr.println(this.getMessage("create.errGetHostName", "localhost", e.getMessage()));
            return "localhost";
        }
    }

    protected File findAvailableBackupFile(File backupTarget) {
        int extension = 1;
        File backupCandidate = new File(backupTarget.getAbsolutePath() + ".old");
        while (backupCandidate.exists()) {
            backupCandidate = new File(backupTarget.getAbsolutePath() + ".old." + extension);
            ++extension;
        }
        return backupCandidate;
    }

    protected void updateExistingSSLKeys(File httpsKSFile, File tmpHttpsKSFile, File httpsTSFile, File tmpHttpsTSFile, File collectiveResourcesDir) throws TaskErrorException {
        File oldHttpsTSFile;
        File oldHttpsKSFile;
        if (this.fileUtility.exists(httpsKSFile) && !this.fileUtility.renameFile(httpsKSFile, oldHttpsKSFile = this.findAvailableBackupFile(httpsKSFile))) {
            this.abortAndPerformCleanup(this.getMessage("common.renameFailed", httpsKSFile.getAbsolutePath(), oldHttpsKSFile.getAbsolutePath()), collectiveResourcesDir);
        }
        if (!this.fileUtility.renameFile(tmpHttpsKSFile, httpsKSFile)) {
            this.abortAndPerformCleanup(this.getMessage("common.renameFailed", tmpHttpsKSFile.getAbsolutePath(), httpsKSFile.getAbsolutePath()), collectiveResourcesDir);
        }
        if (this.fileUtility.exists(httpsTSFile) && !this.fileUtility.renameFile(httpsTSFile, oldHttpsTSFile = this.findAvailableBackupFile(httpsTSFile))) {
            this.abortAndPerformCleanup(this.getMessage("common.renameFailed", httpsTSFile.getAbsolutePath(), oldHttpsTSFile.getAbsolutePath()), collectiveResourcesDir);
        }
        if (!this.fileUtility.renameFile(tmpHttpsTSFile, httpsTSFile)) {
            this.abortAndPerformCleanup(this.getMessage("common.renameFailed", tmpHttpsTSFile.getAbsolutePath(), httpsTSFile.getAbsolutePath()), collectiveResourcesDir);
        }
    }

    protected void addHostAuthInfoArgs(boolean addHostLists) {
        this.confirmedArgs.add(ARG_OPT_RPC_USER_PASSWORD);
        this.confirmedArgs.add(ARG_OPT_SSH_PRIVATE_KEY_PASSWORD);
        this.confirmedArgs.add(ARG_OPT_SUDO_USER_PASSWORD);
        this.knownArgs.addAll(this.confirmedArgs);
        this.knownArgs.add(ARG_OPT_RPC_HOST);
        this.knownArgs.add(ARG_OPT_RPC_PORT);
        this.knownArgs.add(ARG_OPT_RPC_USER);
        this.knownArgs.add(ARG_OPT_RPC_USER_HOME);
        this.knownArgs.add(ARG_OPT_SSH_PRIVATE_KEY);
        this.knownArgs.add(ARG_OPT_USE_SUDO);
        this.knownArgs.add(ARG_OPT_SUDO_USER);
        if (addHostLists) {
            this.knownArgs.add(ARG_OPT_HOST_READ_PATH);
            this.knownArgs.add(ARG_OPT_HOST_WRITE_PATH);
            this.knownArgs.add(ARG_OPT_HOST_JAVA_HOME);
        }
    }

    boolean isDefaultHostAuthInfo(String[] args) {
        boolean isDefault = true;
        for (String arg : args) {
            String lowerArg = arg.toLowerCase();
            if (!lowerArg.startsWith(ARG_OPT_RPC_HOST.toLowerCase()) && !lowerArg.startsWith(ARG_OPT_RPC_PORT.toLowerCase()) && !lowerArg.startsWith(ARG_OPT_RPC_USER.toLowerCase()) && !lowerArg.startsWith(ARG_OPT_RPC_USER_PASSWORD.toLowerCase()) && !lowerArg.startsWith(ARG_OPT_RPC_USER_HOME.toLowerCase()) && !lowerArg.startsWith(ARG_OPT_SSH_PRIVATE_KEY.toLowerCase()) && !lowerArg.startsWith(ARG_OPT_SSH_PRIVATE_KEY_PASSWORD.toLowerCase()) && !lowerArg.startsWith(ARG_OPT_USE_SUDO.toLowerCase()) && !lowerArg.startsWith(ARG_OPT_SUDO_USER.toLowerCase()) && !lowerArg.startsWith(ARG_OPT_SUDO_USER_PASSWORD.toLowerCase())) continue;
            isDefault = false;
        }
        return isDefault;
    }

    void validateUseHostCredentialsOverrides(List<String> list, boolean useHostCredentials) throws TaskErrorException {
        if (useHostCredentials && (this.checkArgInArgs(list, ARG_OPT_RPC_HOST) || this.checkArgInArgs(list, ARG_OPT_RPC_PORT) || this.checkArgInArgs(list, ARG_OPT_RPC_USER) || this.checkArgInArgs(list, ARG_OPT_RPC_USER_HOME) || this.checkArgInArgs(list, ARG_OPT_RPC_USER_PASSWORD) || this.checkArgInArgs(list, ARG_OPT_SSH_PRIVATE_KEY) || this.checkArgInArgs(list, ARG_OPT_SSH_PRIVATE_KEY_PASSWORD) || this.checkArgInArgs(list, ARG_OPT_USE_SUDO) || this.checkArgInArgs(list, ARG_OPT_SUDO_USER) || this.checkArgInArgs(list, ARG_OPT_SUDO_USER_PASSWORD))) {
            this.abort(this.getMessage("join.useHostCredentialsButOtherCtedentialsAreSet", new Object[0]));
        }
    }

    private boolean checkArgInArgs(List<String> list, String key) {
        for (String s : list) {
            if (!s.startsWith(key + "=")) continue;
            return true;
        }
        return false;
    }

    void validateHostAuthInfoSettings(String rpcUserPassword, String sshKey, String sshKeyPassword, Boolean useSudo, String sudoUser, String sudoUserPassword) throws TaskErrorException {
        if (rpcUserPassword != null && sshKey != null) {
            this.abort(this.getMessage("hostAuthInfo.bothCredentialsSet", ARG_OPT_RPC_USER, ARG_OPT_SSH_PRIVATE_KEY));
        }
        if (sshKey == null && sshKeyPassword != null) {
            this.abort(this.getMessage("hostAuthInfo.sshKeyPasswordWithoutKey", new Object[0]));
        }
        if (!(useSudo == null || useSudo.booleanValue() || sudoUser == null && sudoUserPassword == null)) {
            this.abort(this.getMessage("hostAuthInfo.useSudoFalseWithSudoOptions", new Object[0]));
        }
    }

    Map<String, Object> buildHostAuthInfo(String rpcHost, int rpcPort, String rpcUser, String rpcUserPassword, String sshKey, String sshKeyPassword, Boolean useSudo, String sudoUser, String sudoUserPassword, List<String> readList, List<String> writeList, String hostJavaHome) {
        HashMap<String, Object> hostAuthInfo = new HashMap<String, Object>();
        hostAuthInfo.put("rpcHost", rpcHost);
        hostAuthInfo.put("rpcPort", rpcPort);
        hostAuthInfo.put("rpcUser", rpcUser);
        if (rpcUserPassword != null) {
            hostAuthInfo.put("rpcUserPassword", PasswordUtil.passwordEncode((String)rpcUserPassword));
        }
        if (sshKey != null) {
            hostAuthInfo.put("sshPrivateKey", sshKey);
        }
        if (sshKeyPassword != null) {
            hostAuthInfo.put("sshPrivateKeyPassword", PasswordUtil.passwordEncode((String)sshKeyPassword));
        }
        if (useSudo == null) {
            useSudo = false;
        }
        hostAuthInfo.put("useSudo", useSudo);
        if (sudoUser != null) {
            hostAuthInfo.put("sudoUser", sudoUser);
        }
        if (sudoUserPassword != null) {
            hostAuthInfo.put("sudoUserPassword", PasswordUtil.passwordEncode((String)sudoUserPassword));
        }
        if (readList != null) {
            hostAuthInfo.put("hostReadList", readList);
        }
        if (writeList != null) {
            hostAuthInfo.put("hostWriteList", writeList);
        }
        if (hostJavaHome != null) {
            hostAuthInfo.put("hostJavaHome", hostJavaHome);
        }
        return hostAuthInfo;
    }

    protected Map<String, Object> buildHostAuthInfo(String[] args, SSHKeyGenerator sshKeyGen, SSHKeyUtility sshKeyUtil, String hostName, boolean isThisHost, boolean readHostLists, String serverName, String serverDir) throws TaskErrorException {
        String currentUser = System.getProperty("user.name");
        String currentUserHome = System.getProperty("user.home");
        String rpcHost = this.getArgumentValue(ARG_OPT_RPC_HOST, args, hostName);
        int rpcPort = Integer.valueOf(this.getArgumentValue(ARG_OPT_RPC_PORT, args, "22"));
        this.rpcUser = this.getArgumentValue(ARG_OPT_RPC_USER, args, currentUser);
        this.rpcUserHome = this.getArgumentValue(ARG_OPT_RPC_USER_HOME, args, currentUserHome);
        String rpcUserPassword = this.getArgumentValue(ARG_OPT_RPC_USER_PASSWORD, args, null);
        String sshKeyPath = this.getArgumentValue(ARG_OPT_SSH_PRIVATE_KEY, args, null);
        String sshKeyPassword = this.getArgumentValue(ARG_OPT_SSH_PRIVATE_KEY_PASSWORD, args, null);
        String useSudoStr = this.getArgumentValue(ARG_OPT_USE_SUDO, args, null);
        Boolean useSudo = useSudoStr == null ? null : Boolean.valueOf(useSudoStr);
        String sudoUser = this.getArgumentValue(ARG_OPT_SUDO_USER, args, null);
        String sudoUserPassword = this.getArgumentValue(ARG_OPT_SUDO_USER_PASSWORD, args, null);
        String hostJavaHome = this.getArgumentValue(ARG_OPT_HOST_JAVA_HOME, args, null);
        List<String> readList = null;
        List<String> writeList = null;
        if (readHostLists) {
            readList = this.getArgumentList(ARG_OPT_HOST_READ_PATH, args, null);
            writeList = this.getArgumentList(ARG_OPT_HOST_WRITE_PATH, args, null);
        }
        this.isDefaultHostAuthInfo = this.isDefaultHostAuthInfo(args);
        if (useSudo == null && (sudoUser != null || sudoUserPassword != null)) {
            useSudo = true;
        }
        this.validateHostAuthInfoSettings(rpcUserPassword, sshKeyPath, sshKeyPassword, useSudo, sudoUser, sudoUserPassword);
        String sshKey = null;
        if (this.isDefaultHostAuthInfo && isThisHost) {
            sshKey = serverName != null ? this.getSSHKey(sshKeyUtil, this.rpcUserHome, serverName, serverDir) : this.generateSSHKeyPair(sshKeyGen, sshKeyUtil, hostName);
        } else if (sshKeyPath != null) {
            sshKey = this.readSSHKey(sshKeyPath, sshKeyUtil);
        }
        Map<String, Object> hostAuthInfo = this.buildHostAuthInfo(rpcHost, rpcPort, this.rpcUser, rpcUserPassword, sshKey, sshKeyPassword, useSudo, sudoUser, sudoUserPassword, readList, writeList, hostJavaHome);
        return hostAuthInfo;
    }

    protected void updateAuthorizedKeysFiles(SSHKeyUtility sshKeyUtil) {
        if (this.sshPublicKey != null) {
            try {
                this.stdout.println(this.getMessage("ssh.updateAuthorizedKeys", new Object[0]));
                sshKeyUtil.updateAuthorizedKeys(this.rpcUserHome, this.sshPublicKey);
            }
            catch (IOException e) {
                this.stdout.println(this.getMessage("ssh.cannotUpdateAuthorizedKeys", this.rpcUser, this.rpcUserHome, this.sshPublicKey, e.getMessage()));
            }
        }
    }

    private String getSSHKey(SSHKeyUtility sshKeyUtil, String userHome, String serverName, String serverDir) throws TaskErrorException {
        try {
            String publicKeyComment = "Generated SSH key for Liberty server " + serverName + " for Liberty management.";
            return sshKeyUtil.useSSHKeyPair(publicKeyComment, userHome, serverDir + SSH_PUBLIC_KEY, serverDir + SSH_PRIVATE_KEY);
        }
        catch (NoSuchAlgorithmException e) {
            throw new TaskErrorException(this.getMessage("ssh.couldNotCreateSSHKeys", e.getMessage()));
        }
        catch (IllegalStateException e) {
            throw new TaskErrorException(this.getMessage("ssh.invalidSSHKeyPair", e.getMessage()));
        }
        catch (IOException e) {
            throw new TaskErrorException(this.getMessage("ssh.couldNotReadSSHKeys", e.getMessage()));
        }
    }

    private String readSSHKey(String sshKeyPath, SSHKeyUtility sshKeyUtil) throws TaskErrorException {
        File keyFile = new File(sshKeyPath);
        try {
            String privateKey = sshKeyUtil.readStringFromFile(keyFile);
            return PasswordUtil.passwordEncode((String)privateKey);
        }
        catch (IOException e) {
            throw new TaskErrorException(this.getMessage("ssh.couldNotReadSSHKeys", e.getMessage()));
        }
    }

    private String generateSSHKeyPair(SSHKeyGenerator sshKeyGen, SSHKeyUtility sshKeyUtil, String hostName) throws TaskErrorException {
        String publicKeyComment = "Generated SSH key for host " + hostName + " for Liberty management.";
        try {
            SSHKeyPair keyPair = sshKeyGen.generate(publicKeyComment);
            this.sshPublicKey = keyPair.getPublickKey();
            return PasswordUtil.passwordEncode((String)keyPair.getPrivatekey());
        }
        catch (NoSuchAlgorithmException e) {
            throw new TaskErrorException(this.getMessage("ssh.couldNotCreateSSHKeys", e.getMessage()));
        }
        catch (IllegalStateException e) {
            throw new TaskErrorException(this.getMessage("ssh.invalidSSHKeyPair", e.getMessage()));
        }
        catch (IOException e) {
            throw new TaskErrorException(this.getMessage("ssh.couldNotReadSSHKeys", e.getMessage()));
        }
    }

    protected String insertHostAuthInfo(String[] args) {
        String osName = System.getProperty("os.name", "").toUpperCase();
        boolean isWindows = osName.contains("WIN");
        if (this.isDefaultHostAuthInfo && !isWindows) {
            return "";
        }
        Boolean useHostCredentials = Arrays.asList(args).contains(ARG_OPT_USE_HOST_CREDENTIALS);
        boolean firstPrinted = false;
        StringBuilder hostAuthInfoXML = new StringBuilder();
        hostAuthInfoXML.append("    <!-- Remote host authentication configuration -->" + NL);
        hostAuthInfoXML.append("    <hostAuthInfo ");
        if (useHostCredentials.booleanValue()) {
            firstPrinted = this.printLines(firstPrinted, hostAuthInfoXML);
            hostAuthInfoXML.append("useHostCredentials=\"true\"" + NL);
        } else {
            String rpcHost = this.getArgumentValue(ARG_OPT_RPC_HOST, args, null);
            String rpcPort = this.getArgumentValue(ARG_OPT_RPC_PORT, args, null);
            String rpcUser = this.getArgumentValue(ARG_OPT_RPC_USER, args, null);
            String rpcUserHome = this.getArgumentValue(ARG_OPT_RPC_USER_HOME, args, null);
            String rpcUserPassword = this.getArgumentValue(ARG_OPT_RPC_USER_PASSWORD, args, null);
            String sshKeyPath = this.getArgumentValue(ARG_OPT_SSH_PRIVATE_KEY, args, null);
            String sshKeyPassword = this.getArgumentValue(ARG_OPT_SSH_PRIVATE_KEY_PASSWORD, args, null);
            String useSudo = this.getArgumentValue(ARG_OPT_USE_SUDO, args, null);
            String sudoUser = this.getArgumentValue(ARG_OPT_SUDO_USER, args, null);
            String sudoUserPassword = this.getArgumentValue(ARG_OPT_SUDO_USER_PASSWORD, args, null);
            if (isWindows) {
                if (rpcUser == null) {
                    rpcUser = "admin_user_id";
                }
                if (rpcUserPassword == null) {
                    rpcUserPassword = "admin_user_password";
                }
            }
            if (rpcHost != null) {
                firstPrinted = this.printLines(firstPrinted, hostAuthInfoXML);
                hostAuthInfoXML.append("rpcHost=\"" + rpcHost + "\"" + NL);
            }
            if (rpcPort != null) {
                firstPrinted = this.printLines(firstPrinted, hostAuthInfoXML);
                hostAuthInfoXML.append("rpcPort=\"" + rpcPort + "\"" + NL);
            }
            if (rpcUser != null) {
                firstPrinted = this.printLines(firstPrinted, hostAuthInfoXML);
                hostAuthInfoXML.append("rpcUser=\"" + rpcUser + "\"" + NL);
            }
            if (rpcUserHome != null) {
                firstPrinted = this.printLines(firstPrinted, hostAuthInfoXML);
                hostAuthInfoXML.append("rpcUserHome=\"" + rpcUserHome + "\"" + NL);
            }
            if (rpcUserPassword != null) {
                firstPrinted = this.printLines(firstPrinted, hostAuthInfoXML);
                hostAuthInfoXML.append("rpcUserPassword=\"" + rpcUserPassword + "\"" + NL);
            }
            if (sshKeyPath != null) {
                firstPrinted = this.printLines(firstPrinted, hostAuthInfoXML);
                hostAuthInfoXML.append("sshPrivateKeyPath=\"" + sshKeyPath + "\"" + NL);
            }
            if (sshKeyPassword != null) {
                firstPrinted = this.printLines(firstPrinted, hostAuthInfoXML);
                hostAuthInfoXML.append("sshPrivateKeyPassword=\"" + sshKeyPassword + "\"" + NL);
            }
            if (useSudo != null) {
                firstPrinted = this.printLines(firstPrinted, hostAuthInfoXML);
                hostAuthInfoXML.append("useSudo=\"" + useSudo + "\"" + NL);
            }
            if (sudoUser != null) {
                firstPrinted = this.printLines(firstPrinted, hostAuthInfoXML);
                hostAuthInfoXML.append("sudoUser=\"" + sudoUser + "\"" + NL);
            }
            if (sudoUserPassword != null) {
                firstPrinted = this.printLines(firstPrinted, hostAuthInfoXML);
                hostAuthInfoXML.append("sudoUserPassword=\"" + sudoUserPassword + "\"" + NL);
            }
        }
        int lastNewline = hostAuthInfoXML.lastIndexOf(NL);
        hostAuthInfoXML.replace(lastNewline, hostAuthInfoXML.length(), " />" + NL + NL);
        return hostAuthInfoXML.toString();
    }

    private boolean printLines(boolean firstPrinted, StringBuilder hostAuthInfoXML) {
        if (firstPrinted) {
            hostAuthInfoXML.append("                  ");
        }
        return true;
    }

    protected void validateEncoding(String encoding, String key) throws TaskErrorException {
        if (AES_ENCODING.equals(encoding) && key == null) {
            this.abort(this.getMessage("encoding.aesRequiresKey", new Object[0]));
        } else if (XOR_ENCODING.equals(encoding) && key != null) {
            this.abort(this.getMessage("encoding.xorDoesNotSupportKey", new Object[0]));
        } else if (!(XOR_ENCODING.equals(encoding) || AES_ENCODING.equals(encoding) || this.isSupportedCustomEncoding(encoding))) {
            this.abort(this.getMessage("encoding.unsupportedEncoding", encoding));
        }
    }

    private boolean isSupportedCustomEncoding(String encoding) {
        return encoding != null && encoding.length() > 0 && PasswordUtil.isValidCryptoAlgorithm((String)encoding);
    }

    protected String insertHostNameVariable(String hostName) {
        return "    <!-- Define the host name for use by the collective." + NL + "         If the host name needs to be changed, the server should be" + NL + "         removed from the collective and re-joined or re-replicated. -->" + NL + "    <variable name=\"defaultHostName\" value=\"" + hostName + "\" />" + NL;
    }

    protected String insertEncodingKey(String encoding, String key) {
        if (XOR_ENCODING.equals(encoding)) {
            return "";
        }
        return "    <!-- AES key used to encode the keystore passwords -->" + NL + "    <variable name=\"wlp.password.encryption.key\" value\"" + key + "\" />" + NL + NL;
    }

    protected String getEndpointHost(String endpoint) {
        if (endpoint.contains(":") && endpoint.indexOf(":") == endpoint.lastIndexOf(":")) {
            return endpoint.split(":")[0];
        }
        return endpoint;
    }

    String getIncludePath(String serverDir, File outputFile) {
        File fServerDir = new File(serverDir);
        if (outputFile.getAbsolutePath().startsWith(fServerDir.getAbsolutePath())) {
            return outputFile.getAbsolutePath().replace(fServerDir.getAbsolutePath(), "${server.config.dir}");
        }
        File fWLP_USER = new File(this.fileUtility.getUserDir());
        if (outputFile.getAbsolutePath().startsWith(fWLP_USER.getAbsolutePath())) {
            return outputFile.getAbsolutePath().replace(fWLP_USER.getAbsolutePath(), "${wlp.user.dir}");
        }
        File fWLP_INSTALL = new File(this.fileUtility.getInstallDir());
        if (outputFile.getAbsolutePath().startsWith(fWLP_INSTALL.getAbsolutePath())) {
            return outputFile.getAbsolutePath().replace(fWLP_INSTALL.getAbsolutePath(), "${wlp.install.dir}");
        }
        return outputFile.getAbsolutePath();
    }

    protected File createConfigFileIfNeeded(String serverDir, String[] commandLine, String xmlSnippet) {
        String utilityName = this.scriptName;
        String taskName = this.getTaskName();
        File outputFile = null;
        Argument arg = new Argument(ARG_OPT_CREATE_CONFIG_FILE, commandLine);
        if (arg.isSpecified()) {
            String targetFilepath = arg.getValue();
            outputFile = this.generateConfigFileName(utilityName, taskName, serverDir, targetFilepath);
            String xmlTemplate = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>" + NL + "<server description=\"This file was generated by the ''{0} {1}'' command on {2,date,yyyy-MM-dd HH:mm:ss z}.\">" + NL + "{3}" + NL + "</server>" + NL;
            String xmlData = MessageFormat.format(xmlTemplate, utilityName, taskName, Calendar.getInstance().getTime(), xmlSnippet);
            this.fileUtility.createParentDirectory(this.stdout, outputFile);
            this.fileUtility.writeToFile(this.stderr, xmlData, outputFile);
        }
        return outputFile;
    }

    protected String getIncludeMessage(String serverDir, File outputFile) {
        return "    <include location=\"" + this.getIncludePath(serverDir, outputFile) + "\" />" + NL;
    }

    protected File generateConfigFileName(String utilityName, String taskName, String serverDir, String targetFilepath) {
        File outputFile;
        if (targetFilepath == null || targetFilepath.equals("")) {
            targetFilepath = serverDir + SLASH;
        }
        if (this.fileUtility.isDirectory(outputFile = new File(targetFilepath))) {
            outputFile = new File(outputFile, utilityName + "-" + taskName + "-include.xml");
        }
        if (this.fileUtility.exists(outputFile)) {
            String filePath = FilenameUtils.removeExtension((String)outputFile.getPath());
            String fileExt = FilenameUtils.getExtension((String)outputFile.getPath());
            int counter = 1;
            do {
                outputFile = new File(filePath + counter + "." + fileExt);
                ++counter;
            } while (this.fileUtility.exists(outputFile));
        }
        return outputFile;
    }

    protected boolean isConfigFileInDropins(String[] commandLine, boolean checkDefaultsOnly) {
        boolean match = false;
        String regex = "(.+)/configDropins/(defaults|overrides)/(.+)";
        if (checkDefaultsOnly) {
            regex = "(.+)/configDropins/defaults/(.+)";
        }
        Argument arg = new Argument(ARG_OPT_CREATE_CONFIG_FILE, commandLine);
        String targetFilepath = arg.getValue();
        if (arg.isSpecified() && arg.getValue() != null) {
            match = this.matches(regex, targetFilepath);
        }
        return match;
    }

    private boolean matches(String regex, String path) {
        boolean match = false;
        Pattern filepathPattern = Pattern.compile(regex);
        Matcher matcher = filepathPattern.matcher(path);
        if (matcher.matches()) {
            match = true;
        }
        return match;
    }

    protected void handleConfigXML(PrintStream stdout, String[] args, String serverDir, String configXML) {
        File configFile = this.createConfigFileIfNeeded(serverDir, args, configXML);
        if (configFile == null) {
            stdout.println(this.getMessage("common.updateServerXML", new Object[0]));
            stdout.println(configXML);
        } else {
            boolean checkDefaultsOnly = false;
            if (!this.isConfigFileInDropins(args, checkDefaultsOnly)) {
                String msg = this.getIncludeMessage(serverDir, configFile);
                stdout.println(this.getMessage("common.updateServerXML", new Object[0]));
                stdout.println(msg);
            }
        }
    }

    class Argument {
        private boolean specified = false;
        private final String value;

        Argument(String argName, String[] commandLine) {
            String MAGICAL_SENTINEL = "@!$#%$#%32543265k425k4/3nj5k43n?m2|5k4\\n5k2345";
            this.value = BaseCommandTask.this.getArgumentValue(argName, commandLine, "@!$#%$#%32543265k425k4/3nj5k43n?m2|5k4\\n5k2345");
            if (this.value != "@!$#%$#%32543265k425k4/3nj5k43n?m2|5k4\\n5k2345") {
                this.specified = true;
            }
        }

        boolean isSpecified() {
            return this.specified;
        }

        String getValue() {
            return this.value;
        }
    }
}

