/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.product.utility.extension;

import com.ibm.ws.kernel.productinfo.ProductInfo;
import com.ibm.ws.kernel.productinfo.ProductInfoParseException;
import com.ibm.ws.product.utility.BaseCommandTask;
import com.ibm.ws.product.utility.CommandConsole;
import com.ibm.ws.product.utility.ExecutionContext;
import com.ibm.ws.product.utility.extension.FileUtils;
import com.ibm.ws.product.utility.extension.IFixUtils;
import com.ibm.ws.product.utility.extension.VersionUtils;
import com.ibm.ws.product.utility.extension.ifix.xml.Applicability;
import com.ibm.ws.product.utility.extension.ifix.xml.IFixInfo;
import com.ibm.ws.product.utility.extension.ifix.xml.Offering;
import com.ibm.ws.product.utility.extension.ifix.xml.Problem;
import com.ibm.ws.product.utility.extension.ifix.xml.Resolves;
import com.ibm.ws.product.utility.extension.ifix.xml.UpdatedFile;
import com.ibm.ws.product.utility.extension.ifix.xml.Updates;
import java.io.BufferedReader;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.apache.aries.util.VersionRange;
import org.osgi.framework.Version;

public class IFixCompareCommandTask
extends BaseCommandTask {
    private static final String INSTALL_LOCATION_TO_COMPARE_TO_OPTION = "--target";
    private static final String APAR_TO_COMPARE_OPTION = "--apars";
    private static final String VERBOSE_OPTION = "--verbose";
    public static final String IFIX_COMPARE_TASK_NAME = "compare";
    private static final String APAR_FIX_PACK_ZIP_LOCATION = "lib/versions";
    private static final String APAR_FIX_PACK_ZIP_LOCATION_IN_ARCHIVE = "wlp/lib/versions";
    private static final String APAR_FIX_PACK_ZIP_FILENAME_PATTERN = "wlp_fp[0-9]+_aparIds.zip";
    private static final String APAR_CSV_ENTRY_NAME = "aparIds.csv";

    @Override
    public Set<String> getSupportedOptions() {
        return new HashSet<String>(Arrays.asList(INSTALL_LOCATION_TO_COMPARE_TO_OPTION, APAR_TO_COMPARE_OPTION, VERBOSE_OPTION));
    }

    @Override
    protected void doExecute(ExecutionContext context) {
        CommandConsole console = context.getCommandConsole();
        boolean toSet = context.optionExists(INSTALL_LOCATION_TO_COMPARE_TO_OPTION);
        boolean aparSet = context.optionExists(APAR_TO_COMPARE_OPTION);
        if (!toSet && !aparSet) {
            console.printlnErrorMessage(this.getMessage("compare.no.option.set", new Object[0]));
            return;
        }
        File wlpInstallationDirectory = context.getAttribute("WLP_INSTALLATION_LOCATION", File.class);
        InstalledIFixInformation installedIFixes = this.findInstalledIFixes(wlpInstallationDirectory, console, context.optionExists(VERBOSE_OPTION));
        if (toSet) {
            this.compareToInstallLocation(context, console, installedIFixes.validIFixes, wlpInstallationDirectory);
        }
        if (aparSet) {
            this.compareToAparList(context, console, installedIFixes.validIFixes, wlpInstallationDirectory);
        }
        if (!installedIFixes.iFixesWithMissingFiles.isEmpty()) {
            console.printlnInfoMessage("");
            console.printlnInfoMessage(this.getMessage("compare.invalid.ifixes.missing", installedIFixes.iFixesWithMissingFiles));
        }
        if (!installedIFixes.inapplicableIFixes.isEmpty()) {
            console.printlnInfoMessage("");
            console.printlnInfoMessage(this.getMessage("compare.invalid.ifixes.badversion", installedIFixes.inapplicableIFixes));
        }
        if (!installedIFixes.iFixesWithInvalidXml.isEmpty()) {
            console.printlnInfoMessage("");
            console.printlnErrorMessage(this.getMessage("compare.invalid.ifixes.bad.xml", installedIFixes.iFixesWithInvalidXml));
        }
    }

    private void compareToAparList(ExecutionContext context, CommandConsole console, Map<String, Set<String>> installedIFixes, File wlpInstallationDirectory) {
        List<String> aparList;
        String aparListString = context.getOptionValue(APAR_TO_COMPARE_OPTION);
        if ((aparListString = aparListString.trim()).isEmpty()) {
            aparList = Collections.emptyList();
        } else {
            String[] aparListArray;
            aparList = new ArrayList<String>();
            for (String apar : aparListArray = aparListString.split(",| |\t")) {
                if ((apar = apar.trim()).isEmpty() || aparList.contains(apar)) continue;
                aparList.add(apar);
            }
        }
        Set<String> aparsInstalled = null;
        try {
            aparsInstalled = this.findFixPackAparIds(wlpInstallationDirectory, console, context);
        }
        catch (IllegalArgumentException e) {
            console.printlnErrorMessage(e.getMessage());
            return;
        }
        catch (ZipException e) {
            console.printlnErrorMessage(this.getMessage("compare.error.reading.install", wlpInstallationDirectory, e.getMessage()));
            return;
        }
        catch (IOException e) {
            console.printlnErrorMessage(this.getMessage("compare.error.reading.install", wlpInstallationDirectory, e.getMessage()));
            return;
        }
        aparsInstalled.addAll(installedIFixes.keySet());
        ArrayList<String> missingApars = new ArrayList<String>();
        for (String apar : aparList) {
            if (aparsInstalled.contains(apar)) continue;
            missingApars.add(apar);
        }
        if (missingApars.isEmpty()) {
            console.printlnInfoMessage(this.getMessage("compare.all.apars.present", new Object[0]));
        } else {
            console.printlnInfoMessage(this.getMessage("compare.missing.apars", ((Object)missingApars).toString()));
        }
    }

    private void compareToInstallLocation(ExecutionContext context, CommandConsole console, Map<String, Set<String>> aparToIFixMap, File wlpInstallationDirectory) {
        String installToCompareToLocation = context.getOptionValue(INSTALL_LOCATION_TO_COMPARE_TO_OPTION);
        File installToCompareToFile = new File(installToCompareToLocation);
        if (!installToCompareToFile.exists()) {
            console.printlnErrorMessage(this.getMessage("compare.to.option.does.not.exist", installToCompareToLocation));
            return;
        }
        Set<String> aparsForNewInstall = null;
        try {
            aparsForNewInstall = this.findFixPackAparIds(installToCompareToFile, console, context);
        }
        catch (IllegalArgumentException e) {
            console.printlnErrorMessage(e.getMessage());
            return;
        }
        catch (ZipException e) {
            console.printlnErrorMessage(this.getMessage("compare.error.reading.install", installToCompareToLocation, e.getMessage()));
            return;
        }
        catch (IOException e) {
            console.printlnErrorMessage(this.getMessage("compare.error.reading.install", installToCompareToLocation, e.getMessage()));
            return;
        }
        HashMap<String, Set<String>> missingApars = new HashMap<String, Set<String>>();
        for (Map.Entry<String, Set<String>> aparIFixInfo : aparToIFixMap.entrySet()) {
            String apar = aparIFixInfo.getKey();
            if (aparsForNewInstall.contains(apar)) continue;
            missingApars.put(apar, aparIFixInfo.getValue());
        }
        if (missingApars.isEmpty()) {
            console.printlnInfoMessage(this.getMessage("compare.all.ifixes.present", wlpInstallationDirectory.getAbsolutePath(), installToCompareToLocation));
        } else {
            console.printlnInfoMessage(this.getMessage("compare.ifixes.missing", wlpInstallationDirectory.getAbsolutePath(), installToCompareToLocation));
            console.printlnInfoMessage("");
            console.printlnInfoMessage(this.getMessage("compare.list.missing.ifixes", wlpInstallationDirectory.getAbsolutePath(), installToCompareToLocation));
            this.printAparIFixInfo(console, missingApars);
        }
        for (String missingApar : missingApars.keySet()) {
            aparToIFixMap.remove(missingApar);
        }
        if (!aparToIFixMap.isEmpty()) {
            console.printlnInfoMessage("");
            console.printlnInfoMessage(this.getMessage("compare.list.included.ifixes", wlpInstallationDirectory.getAbsolutePath(), installToCompareToLocation));
            this.printAparIFixInfo(console, aparToIFixMap);
        }
    }

    private void printAparIFixInfo(CommandConsole console, Map<String, Set<String>> aparToIFixMap) {
        for (Map.Entry<String, Set<String>> aparIFixInfo : aparToIFixMap.entrySet()) {
            console.printlnInfoMessage(this.getMessage("compare.ifix.apar.info", aparIFixInfo.getKey(), aparIFixInfo.getValue()));
        }
    }

    private InstalledIFixInformation findInstalledIFixes(File wlpInstallationDirectory, CommandConsole console, boolean verbose) {
        InstalledIFixInformation installedIFixInformation = new InstalledIFixInformation();
        Set<IFixInfo> iFixInfos = IFixUtils.getInstalledIFixes(wlpInstallationDirectory, console);
        Version productVersion = null;
        try {
            productVersion = this.getProductVersion(wlpInstallationDirectory);
        }
        catch (VersionUtils.VersionParsingException e) {
            console.printlnErrorMessage(this.getMessage("compare.version.parsing.error", e.getMessage()));
        }
        for (IFixInfo iFixInfo : iFixInfos) {
            Resolves resolves;
            block14: {
                block13: {
                    try {
                        if (!this.isIFixFileListValid(iFixInfo, wlpInstallationDirectory)) {
                            installedIFixInformation.iFixesWithMissingFiles.add(iFixInfo.getId());
                            continue;
                        }
                    }
                    catch (ParseException e) {
                        installedIFixInformation.iFixesWithInvalidXml.add(iFixInfo.getId());
                        if (!verbose) break block13;
                        console.printlnErrorMessage(this.getMessage("compare.ifix.file.parse.error", iFixInfo.getId()));
                    }
                }
                try {
                    if (!this.isIFixApplicable(productVersion, iFixInfo)) {
                        installedIFixInformation.inapplicableIFixes.add(iFixInfo.getId());
                        continue;
                    }
                }
                catch (VersionUtils.VersionParsingException e) {
                    installedIFixInformation.iFixesWithInvalidXml.add(iFixInfo.getId());
                    if (!verbose) break block14;
                    console.printlnErrorMessage(e.getMessage());
                }
            }
            if ((resolves = iFixInfo.getResolves()) == null) {
                installedIFixInformation.iFixesWithInvalidXml.add(iFixInfo.getId());
                if (!verbose) continue;
                console.printlnErrorMessage(this.getMessage("compare.no.apar", iFixInfo.getId()));
                continue;
            }
            List<Problem> problems = resolves.getProblems();
            if (problems == null) {
                installedIFixInformation.iFixesWithInvalidXml.add(iFixInfo.getId());
                if (!verbose) continue;
                console.printlnErrorMessage(this.getMessage("compare.no.apar", iFixInfo.getId()));
                continue;
            }
            for (Problem problem : problems) {
                String problemId = problem.getDisplayId();
                if (problemId == null || problemId.isEmpty()) continue;
                Set<String> iFixesForThisApar = installedIFixInformation.validIFixes.get(problemId);
                if (iFixesForThisApar == null) {
                    iFixesForThisApar = new HashSet<String>();
                    installedIFixInformation.validIFixes.put(problemId, iFixesForThisApar);
                }
                iFixesForThisApar.add(iFixInfo.getId());
            }
        }
        return installedIFixInformation;
    }

    private Version getProductVersion(File wlpInstallationDirectory) throws VersionUtils.VersionParsingException {
        Map<String, ProductInfo> productProperties = VersionUtils.getAllProductInfo(wlpInstallationDirectory);
        ProductInfo wasProperties = productProperties.get("com.ibm.websphere.appserver");
        if (wasProperties == null) {
            throw new VersionUtils.VersionParsingException(this.getMessage("compare.no.was.properties.found", new Object[0]));
        }
        Version version = this.convertVersion(wasProperties);
        return version;
    }

    private Version convertVersion(ProductInfo wasProperties) throws VersionUtils.VersionParsingException {
        Version version;
        String versionString = wasProperties.getVersion();
        Pattern versionPattern = Pattern.compile("([0-9]*\\.[0-9]*\\.)([0-9]*)\\.([0-9]*)");
        Matcher matcher = versionPattern.matcher(versionString);
        if (!matcher.matches()) {
            throw new VersionUtils.VersionParsingException(this.getMessage("compare.version.incompatible", versionString));
        }
        int d3 = Integer.parseInt(matcher.group(2));
        int d4 = Integer.parseInt(matcher.group(3));
        versionString = matcher.group(1) + Integer.toString(d3 * 1000 + d4);
        try {
            version = Version.parseVersion((String)versionString);
        }
        catch (IllegalArgumentException e) {
            throw new VersionUtils.VersionParsingException(this.getMessage("compare.unable.to.parse.version", versionString, e.getMessage()));
        }
        return version;
    }

    private boolean isIFixFileListValid(IFixInfo iFixInfo, File wlpInstallationDirectory) throws ParseException {
        Updates updates = iFixInfo.getUpdates();
        if (updates == null) {
            return true;
        }
        Set<UpdatedFile> files = updates.getFiles();
        Pattern featureJarPattern = Pattern.compile(".*_([0-9]*\\.){3}v[0-9]{8}-[0-9]{4}\\.jar");
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        for (UpdatedFile file : files) {
            String fileId = file.getId();
            boolean isFeatureJar = featureJarPattern.matcher(fileId).matches();
            if (isFeatureJar) {
                File jarFile = new File(wlpInstallationDirectory, fileId);
                if (jarFile.exists()) continue;
                return false;
            }
            File fileOnDisk = new File(wlpInstallationDirectory, fileId);
            String fileDate = file.getDate();
            long metaDataDate = dateFormat.parse(fileDate).getTime();
            if (metaDataDate <= fileOnDisk.lastModified()) continue;
            return false;
        }
        return true;
    }

    private boolean isIFixApplicable(Version productVersion, IFixInfo iFixInfo) throws VersionUtils.VersionParsingException {
        if (productVersion == null) {
            return true;
        }
        Applicability applicability = iFixInfo.getApplicability();
        if (applicability == null) {
            throw new VersionUtils.VersionParsingException(this.getMessage("compare.unable.to.find.offering", iFixInfo.getId()));
        }
        List<Offering> offerings = applicability.getOfferings();
        if (offerings == null || offerings.isEmpty()) {
            throw new VersionUtils.VersionParsingException(this.getMessage("compare.unable.to.find.offering", iFixInfo.getId()));
        }
        String tolerance = offerings.get(0).getTolerance();
        VersionRange toleranceRange = VersionRange.parseVersionRange((String)tolerance);
        return toleranceRange.matches(productVersion);
    }

    private Set<String> findFixPackAparIds(File installLocation, CommandConsole console, ExecutionContext context) throws IllegalArgumentException, ZipException, IOException {
        Set<String> fixPackAparIds;
        if (installLocation.isDirectory()) {
            fixPackAparIds = this.readAparCsvFromExtractedInstall(installLocation);
            InstalledIFixInformation installedIFixes = this.findInstalledIFixes(installLocation, console, context.optionExists(VERBOSE_OPTION));
            for (String apar : installedIFixes.validIFixes.keySet()) {
                fixPackAparIds.add(apar);
            }
        } else {
            String fileName = installLocation.getName();
            if (!FileUtils.matchesFileExtension(".jar", fileName) && !FileUtils.matchesFileExtension(".zip", fileName)) {
                throw new IllegalArgumentException(this.getMessage("compare.install.not.zip.or.dir", installLocation.getAbsolutePath()));
            }
            fixPackAparIds = this.readAparCsvFromArchiveInstall(installLocation, console);
        }
        return fixPackAparIds;
    }

    private Set<String> convertCsvToSet(String csv) {
        String[] aparIds;
        if (csv == null) {
            return Collections.emptySet();
        }
        HashSet<String> fixPackAparIds = new HashSet<String>();
        for (String id : aparIds = csv.split(",")) {
            fixPackAparIds.add(id);
        }
        return fixPackAparIds;
    }

    private Set<String> readAparCsvFromArchiveInstall(File installLocation, CommandConsole console) throws ZipException, IOException {
        ZipFile installZipFile = new ZipFile(installLocation);
        Enumeration<? extends ZipEntry> zipEntries = installZipFile.entries();
        Pattern pattern = Pattern.compile("wlp/lib/versions/wlp_fp[0-9]+_aparIds.zip");
        HashSet<String> aparIds = new HashSet<String>();
        ArrayList<IFixInfo> ifixes = new ArrayList<IFixInfo>();
        ProductInfo info = null;
        while (zipEntries.hasMoreElements()) {
            ZipEntry entry = zipEntries.nextElement();
            String entryName = entry.getName();
            if (pattern.matcher(entryName).matches()) {
                ZipInputStream aparZipFileInputStream = new ZipInputStream(installZipFile.getInputStream(entry));
                ZipEntry aparCsvEntry = null;
                while ((aparCsvEntry = aparZipFileInputStream.getNextEntry()) != null && !APAR_CSV_ENTRY_NAME.equals(aparCsvEntry.getName())) {
                }
                if (aparCsvEntry == null) {
                    throw new IllegalArgumentException(this.getMessage("compare.no.csv.entry", installLocation.getAbsolutePath(), entryName, APAR_CSV_ENTRY_NAME));
                }
                String csv = this.readLine(aparZipFileInputStream);
                aparIds.addAll(this.convertCsvToSet(csv));
                continue;
            }
            if (entryName.startsWith("wlp/lib/fixes/")) {
                IFixInfo ifix = IFixUtils.parseIFix(installZipFile.getInputStream(entry), entryName, console);
                if (ifix == null) continue;
                ifixes.add(ifix);
                continue;
            }
            if (!entryName.startsWith("wlp/lib/versions/") || !entryName.endsWith(".properties")) continue;
            try {
                ProductInfo pi = ProductInfo.parseProductInfo((Reader)new InputStreamReader(installZipFile.getInputStream(entry), "UTF-8"), null);
                if (pi == null || !"com.ibm.websphere.appserver".equals(pi.getId())) continue;
                info = pi;
            }
            catch (ProductInfoParseException e) {}
        }
        installZipFile.close();
        Version v = null;
        if (info == null) {
            console.printErrorMessage(this.getMessage("compare.no.was.properties.found", new Object[0]));
        } else {
            try {
                v = this.convertVersion(info);
            }
            catch (VersionUtils.VersionParsingException e) {
                console.printErrorMessage(e.getMessage());
            }
        }
        for (IFixInfo fix : ifixes) {
            try {
                if (v != null && !this.isIFixApplicable(v, fix)) continue;
                Resolves resolves = fix.getResolves();
                if (resolves != null) {
                    List<Problem> problems = resolves.getProblems();
                    if (problems != null) {
                        for (Problem problem : resolves.getProblems()) {
                            aparIds.add(problem.getDisplayId());
                        }
                        continue;
                    }
                    console.printErrorMessage(this.getMessage("compare.no.apar", fix.getId()));
                    continue;
                }
                console.printErrorMessage(this.getMessage("compare.no.apar", fix.getId()));
            }
            catch (VersionUtils.VersionParsingException e) {
                console.printErrorMessage(e.getMessage());
            }
        }
        return aparIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> readAparCsvFromExtractedInstall(File installLocation) throws ZipException, IOException {
        File fixesFolder = new File(installLocation, APAR_FIX_PACK_ZIP_LOCATION);
        final Pattern pattern = Pattern.compile(APAR_FIX_PACK_ZIP_FILENAME_PATTERN);
        File[] fixPackZips = fixesFolder.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File arg0, String filename) {
                return pattern.matcher(filename).matches();
            }
        });
        HashSet<String> aparIds = new HashSet<String>();
        for (File aparFile : fixPackZips) {
            ZipFile aparZipFile = null;
            try {
                aparZipFile = new ZipFile(aparFile);
                ZipEntry aparCsvEntry = aparZipFile.getEntry(APAR_CSV_ENTRY_NAME);
                if (aparCsvEntry == null) {
                    throw new IllegalArgumentException(this.getMessage("compare.no.csv.entry", installLocation.getAbsolutePath(), aparFile.getName(), APAR_CSV_ENTRY_NAME));
                }
                InputStream csvInputStream = aparZipFile.getInputStream(aparCsvEntry);
                String aparCsv = this.readLine(csvInputStream);
                aparIds.addAll(this.convertCsvToSet(aparCsv));
            }
            finally {
                if (aparZipFile != null) {
                    aparZipFile.close();
                }
            }
        }
        return aparIds;
    }

    private String readLine(InputStream stream) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        return reader.readLine();
    }

    @Override
    public String getTaskDescription() {
        return this.getOption("compare.desc", new Object[0]);
    }

    @Override
    public String getTaskHelp() {
        return super.getTaskHelp("compare.desc", "compare.usage.options", "compare.option-key.", "compare.option-desc.", "compare.option.addon");
    }

    @Override
    public String getTaskName() {
        return IFIX_COMPARE_TASK_NAME;
    }

    private static class InstalledIFixInformation {
        public final Map<String, Set<String>> validIFixes = new HashMap<String, Set<String>>();
        public final Set<String> iFixesWithMissingFiles = new HashSet<String>();
        public final Set<String> iFixesWithInvalidXml = new HashSet<String>();
        public final Set<String> inapplicableIFixes = new HashSet<String>();

        private InstalledIFixInformation() {
        }
    }
}

