/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.config.utility;

import com.ibm.ws.config.utility.ConfigUtilityAction;
import com.ibm.ws.config.utility.TaskErrorException;
import com.ibm.ws.config.utility.actions.FindAction;
import com.ibm.ws.config.utility.actions.HelpAction;
import com.ibm.ws.config.utility.actions.InstallAction;
import com.ibm.ws.config.utility.utils.CommandUtils;
import com.ibm.ws.config.utility.utils.ConsoleWrapper;
import com.ibm.ws.config.utility.utils.FileUtility;
import com.ibm.ws.install.InstallException;
import com.ibm.ws.repository.exceptions.RepositoryException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;

public class ConfigUtility {
    public static final String SCRIPT_NAME = "configUtility";
    static final String NL = System.getProperty("line.separator");
    private final ConsoleWrapper stdin;
    private final PrintStream stdout;
    private final PrintStream stderr;
    List<ConfigUtilityAction> actions = new ArrayList<ConfigUtilityAction>();

    public ConfigUtility(ConsoleWrapper stdin, PrintStream stdout, PrintStream stderr) {
        this.stdin = stdin;
        this.stdout = stdout;
        this.stderr = stderr;
    }

    void registerAction(ConfigUtilityAction action) {
        this.actions.add(action);
    }

    private ConfigUtilityAction getAction(String actionName) {
        ConfigUtilityAction action = null;
        for (ConfigUtilityAction availAction : this.actions) {
            if (!availAction.getActionName().equals(actionName)) continue;
            action = availAction;
            break;
        }
        return action;
    }

    int runProgram(String[] args) {
        if (this.stdin == null) {
            this.stderr.println(CommandUtils.getMessage("error.missingIO", "stdin"));
            return 254;
        }
        if (this.stdout == null) {
            this.stderr.println(CommandUtils.getMessage("error.missingIO", "stdout"));
            return 253;
        }
        if (this.stderr == null) {
            this.stdout.println(CommandUtils.getMessage("error.missingIO", "stderr"));
            return 252;
        }
        if (args.length == 0) {
            this.stdout.println(HelpAction.getScriptUsage());
            return 0;
        }
        ConfigUtilityAction action = this.getAction(args[0]);
        if (action == null) {
            if (args[0].equalsIgnoreCase("--help")) {
                this.stdout.println(HelpAction.getHelpOptions());
                return 0;
            }
            this.stderr.println(CommandUtils.getMessage("task.unknown", args[0]));
            this.stderr.println(HelpAction.getScriptUsage());
            return 0;
        }
        try {
            action.handleAction(this.stdin, this.stdout, this.stderr, args);
        }
        catch (IllegalArgumentException e) {
            this.stderr.println();
            this.stderr.println(CommandUtils.getMessage("error", e.getMessage()));
            return 20;
        }
        catch (TaskErrorException e) {
            if (e.getMessage() != null) {
                this.stderr.println();
                this.stderr.println(CommandUtils.getMessage("error", e.getMessage()));
            }
            return 255;
        }
        catch (RepositoryException e) {
            if (e.getMessage() != null) {
                this.stderr.println();
                this.stderr.println(CommandUtils.getMessage("error", e.getMessage()));
            }
            return 251;
        }
        catch (InstallException e) {
            if (e.getMessage() != null) {
                this.stderr.println();
                this.stderr.println(e.getLocalizedMessage());
            }
            return 250;
        }
        return 0;
    }

    public static void main(String[] args) {
        ConsoleWrapper console = new ConsoleWrapper(System.console(), System.err);
        FileUtility fileUtil = new FileUtility(System.getenv("WLP_INSTALL_DIR"), System.getenv("WLP_USER_DIR"));
        ConfigUtility utility = new ConfigUtility(console, System.out, System.err);
        utility.registerAction(new FindAction());
        utility.registerAction(new HelpAction());
        utility.registerAction(new InstallAction(SCRIPT_NAME, fileUtil));
        int rc = utility.runProgram(args);
        System.exit(rc);
    }
}

