/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.subsystem.util.felix;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.felix.bundlerepository.Property;
import org.osgi.framework.Version;

public class FelixProperty
implements Property {
    private final String name;
    private final Object value;

    private static Set<?> asSet(List<?> list) {
        return new HashSet(list);
    }

    public FelixProperty(String name, Object value) {
        if (name == null) {
            throw new NullPointerException("Missing required parameter: name");
        }
        if (value == null) {
            throw new NullPointerException("Missing required parameter: value");
        }
        this.name = name;
        this.value = value;
    }

    public FelixProperty(Map.Entry<String, Object> entry) {
        this(entry.getKey(), entry.getValue());
    }

    public Object getConvertedValue() {
        if (this.value instanceof List) {
            return FelixProperty.asSet((List)this.value);
        }
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        if (this.value instanceof Version) {
            return "version";
        }
        if (this.value instanceof Long) {
            return "long";
        }
        if (this.value instanceof Double) {
            return "double";
        }
        if (this.value instanceof List) {
            return "set";
        }
        return null;
    }

    public String getValue() {
        return String.valueOf(this.value);
    }
}

