/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.utils;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.container.service.annotations.WebAnnotations;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.jaxrs20.api.JaxRsFactoryBeanCustomizer;
import com.ibm.ws.jaxrs20.injection.InjectionRuntimeContextHelper;
import com.ibm.ws.jaxrs20.injection.metadata.InjectionRuntimeContext;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.anno.info.ClassInfo;
import com.ibm.wsspi.anno.info.FieldInfo;
import com.ibm.wsspi.anno.info.MethodInfo;
import com.ibm.wsspi.anno.targets.AnnotationTargets_Targets;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.ApplicationPath;
import javax.ws.rs.Path;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.ParamConverter;
import javax.ws.rs.ext.Provider;
import javax.ws.rs.ext.Providers;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.ClassHelper;
import org.apache.cxf.common.util.PrimitiveUtils;
import org.apache.cxf.common.util.ProxyClassLoader;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.apache.cxf.jaxrs.ext.ProtocolHeaders;
import org.apache.cxf.jaxrs.impl.MetadataMap;
import org.apache.cxf.jaxrs.impl.PathSegmentImpl;
import org.apache.cxf.jaxrs.impl.tl.ThreadLocalContextResolver;
import org.apache.cxf.jaxrs.impl.tl.ThreadLocalHttpHeaders;
import org.apache.cxf.jaxrs.impl.tl.ThreadLocalInvocationHandler;
import org.apache.cxf.jaxrs.impl.tl.ThreadLocalMessageContext;
import org.apache.cxf.jaxrs.impl.tl.ThreadLocalProtocolHeaders;
import org.apache.cxf.jaxrs.impl.tl.ThreadLocalProviders;
import org.apache.cxf.jaxrs.impl.tl.ThreadLocalProxy;
import org.apache.cxf.jaxrs.impl.tl.ThreadLocalRequest;
import org.apache.cxf.jaxrs.impl.tl.ThreadLocalSecurityContext;
import org.apache.cxf.jaxrs.impl.tl.ThreadLocalUriInfo;
import org.apache.cxf.jaxrs.lifecycle.ResourceProvider;
import org.apache.cxf.jaxrs.lifecycle.SingletonResourceProvider;
import org.apache.cxf.jaxrs.model.AbstractResourceInfo;
import org.apache.cxf.jaxrs.model.ApplicationInfo;
import org.apache.cxf.jaxrs.model.ClassResourceInfo;
import org.apache.cxf.jaxrs.model.Parameter;
import org.apache.cxf.jaxrs.model.ParameterType;
import org.apache.cxf.jaxrs.model.ProviderInfo;
import org.apache.cxf.jaxrs.provider.ServerProviderFactory;
import org.apache.cxf.jaxrs.utils.ExceptionUtils;
import org.apache.cxf.jaxrs.utils.HttpUtils;
import org.apache.cxf.jaxrs.utils.JAXBUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.jaxrs.utils.MessageContextProxyClassLoader;
import org.apache.cxf.jaxrs.utils.ParameterizedCollectionType;
import org.apache.cxf.jaxrs.utils.ProxyInvocationHandler;
import org.apache.cxf.jaxrs.utils.ResourceUtils;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;

@TraceObjectField(fieldName="LOG", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
public final class InjectionUtils {
    private static final Logger LOG = LogUtils.getL7dLogger(InjectionUtils.class);
    private static final ResourceBundle BUNDLE = BundleUtils.getBundle(InjectionUtils.class);
    private static final String SERVLET_CONFIG_CLASS_NAME = "javax.servlet.ServletConfig";
    private static final String SERVLET_CONTEXT_CLASS_NAME = "javax.servlet.ServletContext";
    private static final String HTTP_SERVLET_REQUEST_CLASS_NAME = "javax.servlet.http.HttpServletRequest";
    private static final String HTTP_SERVLET_RESPONSE_CLASS_NAME = "javax.servlet.http.HttpServletResponse";
    private static final String ENUM_CONVERSION_CASE_SENSITIVE = "enum.conversion.case.sensitive";
    private static final String IGNORE_MATRIX_PARAMETERS = "ignore.matrix.parameters";
    private static List<String> explicitLifcycle = new ArrayList<String>();
    private static final Set<String> JAXRS_COMPONENTS_INTERFACE;
    private static final Set<String> JAXRS_COMPONENTS_ABSTRACTCLASS;
    static final long serialVersionUID = 5269457997359245202L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private InjectionUtils() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.InjectionUtils", "<init>", new Object[0]);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.utils.InjectionUtils", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static boolean isConcreteClass(Class<?> cls) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.InjectionUtils", "isConcreteClass", new Object[]{cls});
        }
        boolean bl = !cls.isInterface() && !Modifier.isAbstract(cls.getModifiers());
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.jaxrs.utils.InjectionUtils", "isConcreteClass", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static Type getSuperType(Class<?> serviceClass, TypeVariable<?> var) {
        Type result;
        Type[] genInterfaces;
        Type[] arr$;
        int len$;
        int i$;
        int pos;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.InjectionUtils", "getSuperType", new Object[]{serviceClass, var});
        }
        TypeVariable<?>[] vars = var.getGenericDeclaration().getTypeParameters();
        for (pos = 0; pos < vars.length && !vars[pos].getName().equals(var.getName()); ++pos) {
        }
        Type genericSubtype = serviceClass.getGenericSuperclass();
        if (!(genericSubtype instanceof ParameterizedType) && (i$ = 0) < (len$ = (arr$ = (genInterfaces = serviceClass.getGenericInterfaces())).length)) {
            Type t;
            genericSubtype = t = arr$[i$];
        }
        if (!(genericSubtype instanceof ParameterizedType)) {
            genericSubtype = null;
        }
        if ((result = InjectionUtils.getActualType(genericSubtype, pos)) == null || result == Object.class) {
            int boundPos;
            Type[] bounds = var.getBounds();
            int n = boundPos = bounds.length > pos ? pos : 0;
            if (bounds.length > boundPos && bounds[boundPos] != Object.class) {
                result = bounds[boundPos];
            }
        }
        Class<?> clazz = result;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            clazz = clazz;
            LOG.exiting("org.apache.cxf.jaxrs.utils.InjectionUtils", "getSuperType", clazz);
        }
        return clazz;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static Method checkProxy(Method methodToInvoke, Object resourceObject) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.InjectionUtils", "checkProxy", new Object[]{methodToInvoke, resourceObject});
        }
        if (Proxy.class.isInstance(resourceObject)) {
            String methodToInvokeName = methodToInvoke.getName();
            Class<?>[] methodToInvokeTypes = methodToInvoke.getParameterTypes();
            for (Class<?> c : resourceObject.getClass().getInterfaces()) {
                Method method;
                block9: {
                    try {
                        method = c.getMethod(methodToInvokeName, methodToInvokeTypes);
                        if (LOG == null || !LOG.isLoggable(Level.FINER)) break block9;
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        FFDCFilter.processException((Throwable)noSuchMethodException, (String)"org.apache.cxf.jaxrs.utils.InjectionUtils", (String)"188", null, (Object[])new Object[]{methodToInvoke, resourceObject});
                        if (methodToInvokeTypes.length <= 0) continue;
                        for (Method m : c.getMethods()) {
                            if (!m.getName().equals(methodToInvokeName) || m.getParameterTypes().length != methodToInvokeTypes.length) continue;
                            Class<?>[] methodTypes = m.getParameterTypes();
                            for (int i = 0; i < methodTypes.length && methodTypes[i].isAssignableFrom(methodToInvokeTypes[i]); ++i) {
                            }
                            Method method2 = m;
                            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                                method2 = method2;
                                LOG.exiting("org.apache.cxf.jaxrs.utils.InjectionUtils", "checkProxy", method2);
                            }
                            return method2;
                        }
                        continue;
                    }
                    method = method;
                    LOG.exiting("org.apache.cxf.jaxrs.utils.InjectionUtils", "checkProxy", method);
                }
                return method;
            }
        }
        Method method = methodToInvoke;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            method = method;
            LOG.exiting("org.apache.cxf.jaxrs.utils.InjectionUtils", "checkProxy", method);
        }
        return method;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static void injectFieldValue(final Field f, final Object o, final Object v) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.InjectionUtils", "injectFieldValue", new Object[]{f, o, v});
        }
        AccessController.doPrivileged(new PrivilegedAction<Object>(){
            static final long serialVersionUID = -2118125951566154519L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Object run() {
                try {
                    f.setAccessible(true);
                    f.set(o, v);
                }
                catch (IllegalAccessException illegalAccessException) {
                    FFDCFilter.processException((Throwable)illegalAccessException, (String)"org.apache.cxf.jaxrs.utils.InjectionUtils$1", (String)"222", (Object)this, (Object[])new Object[0]);
                    InjectionUtils.reportServerError("FIELD_ACCESS_FAILURE", f.getType().getName());
                }
                return null;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(1.class);
            }
        });
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.utils.InjectionUtils", "injectFieldValue");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static Object extractFieldValue(final Field f, final Object o) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.InjectionUtils", "extractFieldValue", new Object[]{f, o});
        }
        Object object = AccessController.doPrivileged(new PrivilegedAction<Object>(){
            static final long serialVersionUID = -5856109943614185911L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Object run() {
                try {
                    f.setAccessible(true);
                    return f.get(o);
                }
                catch (IllegalAccessException illegalAccessException) {
                    FFDCFilter.processException((Throwable)illegalAccessException, (String)"org.apache.cxf.jaxrs.utils.InjectionUtils$2", (String)"239", (Object)this, (Object[])new Object[0]);
                    InjectionUtils.reportServerError("FIELD_ACCESS_FAILURE", f.getType().getName());
                    return null;
                }
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(2.class);
            }
        });
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            object = object;
            LOG.exiting("org.apache.cxf.jaxrs.utils.InjectionUtils", "extractFieldValue", object);
        }
        return object;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static Class<?> getActualType(Type genericType) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.InjectionUtils", "getActualType", new Object[]{genericType});
        }
        Class<?> clazz = InjectionUtils.getActualType(genericType, 0);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            clazz = clazz;
            LOG.exiting("org.apache.cxf.jaxrs.utils.InjectionUtils", "getActualType", clazz);
        }
        return clazz;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static Class<?> getActualType(Type genericType, int pos) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.InjectionUtils", "getActualType", new Object[]{genericType, pos});
        }
        if (genericType == null) {
            Class<?> clazz = null;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                clazz = clazz;
                LOG.exiting("org.apache.cxf.jaxrs.utils.InjectionUtils", "getActualType", clazz);
            }
            return clazz;
        }
        if (genericType == Object.class) {
            Class clazz = (Class)genericType;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                clazz = clazz;
                LOG.exiting("org.apache.cxf.jaxrs.utils.InjectionUtils", "getActualType", clazz);
            }
            return clazz;
        }
        if (!ParameterizedType.class.isAssignableFrom(genericType.getClass())) {
            if (genericType instanceof TypeVariable) {
                genericType = InjectionUtils.getType(((TypeVariable)genericType).getBounds(), pos);
            } else if (genericType instanceof WildcardType) {
                WildcardType wildcardType = (WildcardType)genericType;
                Type[] bounds = wildcardType.getLowerBounds();
                if (bounds.length == 0) {
                    bounds = wildcardType.getUpperBounds();
                }
                genericType = InjectionUtils.getType(bounds, pos);
            } else if (genericType instanceof GenericArrayType) {
                genericType = ((GenericArrayType)genericType).getGenericComponentType();
            }
            Class<Object> cls = null;
            cls = !(genericType instanceof ParameterizedType) ? (Class<?>)genericType : (Class)((ParameterizedType)genericType).getRawType();
            Class<?> clazz = cls.isArray() ? cls.getComponentType() : cls;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                clazz = clazz;
                LOG.exiting("org.apache.cxf.jaxrs.utils.InjectionUtils", "getActualType", clazz);
            }
            return clazz;
        }
        ParameterizedType paramType = (ParameterizedType)genericType;
        Type t = InjectionUtils.getType(paramType.getActualTypeArguments(), pos);
        Class<?> clazz = InjectionUtils.getClassType(t);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            clazz = clazz;
            LOG.exiting("org.apache.cxf.jaxrs.utils.InjectionUtils", "getActualType", clazz);
        }
        return clazz;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static Class<?> getClassType(Type type) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.InjectionUtils", "getClassType", new Object[]{type});
        }
        if (type instanceof Class) {
            Class clazz = (Class)type;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                clazz = clazz;
                LOG.exiting("org.apache.cxf.jaxrs.utils.InjectionUtils", "getClassType", clazz);
            }
            return clazz;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Class clazz = (Class)parameterizedType.getRawType();
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                clazz = clazz;
                LOG.exiting("org.apache.cxf.jaxrs.utils.InjectionUtils", "getClassType", clazz);
            }
            return clazz;
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType genericArray = (GenericArrayType)type;
            Class<?> classType = InjectionUtils.getClassType(genericArray.getGenericComponentType());
            Class<?> clazz = Array.newInstance(classType, 0).getClass();
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                clazz = clazz;
                LOG.exiting("org.apache.cxf.jaxrs.utils.InjectionUtils", "getClassType", clazz);
            }
            return clazz;
        }
        if (type instanceof TypeVariable) {
            Class<?> clazz = InjectionUtils.getClassType(((TypeVariable)type).getBounds()[0]);
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                clazz = clazz;
                LOG.exiting("org.apache.cxf.jaxrs.utils.InjectionUtils", "getClassType", clazz);
            }
            return clazz;
        }
        if (type instanceof WildcardType) {
            Class<?> clazz = InjectionUtils.getClassType(((WildcardType)type).getUpperBounds()[0]);
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                clazz = clazz;
                LOG.exiting("org.apache.cxf.jaxrs.utils.InjectionUtils", "getClassType", clazz);
            }
            return clazz;
        }
        Class<?> clazz = null;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            clazz = clazz;
            LOG.exiting("org.apache.cxf.jaxrs.utils.InjectionUtils", "getClassType", clazz);
        }
        return clazz;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static Type getType(Type[] types, int pos) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.InjectionUtils", "getType", new Object[]{types, pos});
        }
        if (pos >= types.length) {
            throw new RuntimeException("No type can be found at position " + pos);
        }
        Type type = types[pos];
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            type = type;
            LOG.exiting("org.apache.cxf.jaxrs.utils.InjectionUtils", "getType", type);
        }
        return type;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static Class<?> getRawType(Type genericType) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.InjectionUtils", "getRawType", new Object[]{genericType});
        }
        if (genericType instanceof Class) {
            Class clazz = (Class)genericType;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                clazz = clazz;
                LOG.exiting("org.apache.cxf.jaxrs.utils.InjectionUtils", "getRawType", clazz);
            }
            return clazz;
        }
        if (genericType instanceof ParameterizedType) {
            ParameterizedType paramType = (ParameterizedType)genericType;
            Type t = paramType.getRawType();
            if (t instanceof Class) {
                Class clazz = (Class)t;
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    clazz = clazz;
                    LOG.exiting("org.apache.cxf.jaxrs.utils.InjectionUtils", "getRawType", clazz);
                }
                return clazz;
            }
        } else if (genericType instanceof GenericArrayType) {
            Class<?> clazz = InjectionUtils.getRawType(((GenericArrayType)genericType).getGenericComponentType());
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                clazz = clazz;
                LOG.exiting("org.apache.cxf.jaxrs.utils.InjectionUtils", "getRawType", clazz);
            }
            return clazz;
        }
        Class<?> clazz = null;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            clazz = clazz;
            LOG.exiting("org.apache.cxf.jaxrs.utils.InjectionUtils", "getRawType", clazz);
        }
        return clazz;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static Type[] getActualTypes(Type genericType) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.InjectionUtils", "getActualTypes", new Object[]{genericType});
        }
        if (genericType == null || !ParameterizedType.class.isAssignableFrom(genericType.getClass())) {
            Type[] typeArray = null;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                typeArray = typeArray;
                LOG.exiting("org.apache.cxf.jaxrs.utils.InjectionUtils", "getActualTypes", typeArray);
            }
            return typeArray;
        }
        ParameterizedType paramType = (ParameterizedType)genericType;
        Type[] typeArray = paramType.getActualTypeArguments();
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            typeArray = typeArray;
            LOG.exiting("org.apache.cxf.jaxrs.utils.InjectionUtils", "getActualTypes", typeArray);
        }
        return typeArray;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static void injectThroughMethod(Object requestObject, Method method, Object parameterValue) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.InjectionUtils", "injectThroughMethod", new Object[]{requestObject, method, parameterValue});
        }
        InjectionUtils.injectThroughMethod(requestObject, method, parameterValue, null);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.utils.InjectionUtils", "injectThroughMethod");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static void injectThroughMethod(Object requestObject, Method method, Object parameterValue, Message inMessage) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.InjectionUtils", "injectThroughMethod", new Object[]{requestObject, method, parameterValue, inMessage});
        }
        try {
            Method methodToInvoke = InjectionUtils.checkProxy(method, requestObject);
            methodToInvoke.invoke(requestObject, parameterValue);
        }
        catch (IllegalAccessException methodToInvoke) {
            FFDCFilter.processException((Throwable)methodToInvoke, (String)"org.apache.cxf.jaxrs.utils.InjectionUtils", (String)"374", null, (Object[])new Object[]{requestObject, method, parameterValue, inMessage});
            InjectionUtils.reportServerError("METHOD_ACCESS_FAILURE", method.getName());
        }
        catch (InvocationTargetException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"org.apache.cxf.jaxrs.utils.InjectionUtils", (String)"376", null, (Object[])new Object[]{requestObject, method, parameterValue, inMessage});
            Response r = JAXRSUtils.convertFaultToResponse((Throwable)ex.getCause(), (Message)inMessage);
            if (r != null) {
                inMessage.getExchange().put(Response.class, (Object)r);
                throw new WebApplicationException();
            }
            InjectionUtils.reportServerError("METHOD_ACCESS_FAILURE", method.getName());
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, (String)"org.apache.cxf.jaxrs.utils.InjectionUtils", (String)"383", null, (Object[])new Object[]{requestObject, method, parameterValue, inMessage});
            InjectionUtils.reportServerError("METHOD_INJECTION_FAILURE", method.getName());
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.utils.InjectionUtils", "injectThroughMethod");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static Object extractFromMethod(Object requestObject, Method method) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.InjectionUtils", "extractFromMethod", new Object[]{requestObject, method});
        }
        Object object = InjectionUtils.extractFromMethod(requestObject, method, true);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            object = object;
            LOG.exiting("org.apache.cxf.jaxrs.utils.InjectionUtils", "extractFromMethod", object);
        }
        return object;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static Object extractFromMethod(Object requestObject, Method method, boolean logError) {
        Object object;
        block5: {
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.entering("org.apache.cxf.jaxrs.utils.InjectionUtils", "extractFromMethod", new Object[]{requestObject, method, logError});
            }
            try {
                Method methodToInvoke = InjectionUtils.checkProxy(method, requestObject);
                object = methodToInvoke.invoke(requestObject, new Object[0]);
                if (LOG == null || !LOG.isLoggable(Level.FINER)) break block5;
            }
            catch (IllegalAccessException methodToInvoke) {
                FFDCFilter.processException((Throwable)methodToInvoke, (String)"org.apache.cxf.jaxrs.utils.InjectionUtils", (String)"398", null, (Object[])new Object[]{requestObject, method, logError});
                InjectionUtils.reportServerError("METHOD_ACCESS_FAILURE", method.getName(), logError);
            }
            catch (Exception ex) {
                FFDCFilter.processException((Throwable)ex, (String)"org.apache.cxf.jaxrs.utils.InjectionUtils", (String)"400", null, (Object[])new Object[]{requestObject, method, logError});
                InjectionUtils.reportServerError("METHOD_INJECTION_FAILURE", method.getName(), logError);
            }
            object = object;
            LOG.exiting("org.apache.cxf.jaxrs.utils.InjectionUtils", "extractFromMethod", object);
        }
        return object;
        Object v1 = null;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            v1 = v1;
            LOG.exiting("org.apache.cxf.jaxrs.utils.InjectionUtils", "extractFromMethod", v1);
        }
        return v1;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    @FFDCIgnore(value={NoSuchMethodException.class, NumberFormatException.class, Exception.class})
    public static <T> T handleParameter(String value, boolean decoded, Class<T> pClass, Type genericType, Annotation[] paramAnns, ParameterType pType, Message message) {
        Object result;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.InjectionUtils", "handleParameter", new Object[]{value, decoded, pClass, genericType, paramAnns, pType, message});
        }
        if (value == null) {
            T t = null;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                t = t;
                LOG.exiting("org.apache.cxf.jaxrs.utils.InjectionUtils", "handleParameter", t);
            }
            return t;
        }
        if (value.isEmpty() && genericType == Date.class) {
            T t = null;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                t = t;
                LOG.exiting("org.apache.cxf.jaxrs.utils.InjectionUtils", "handleParameter", t);
            }
            return t;
        }
        if (pType == ParameterType.PATH) {
            if (PathSegment.class.isAssignableFrom(pClass)) {
                T t = pClass.cast(new PathSegmentImpl(value, decoded));
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    t = t;
                    LOG.exiting("org.apache.cxf.jaxrs.utils.InjectionUtils", "handleParameter", t);
                }
                return t;
            }
            if (!MessageUtils.isTrue((Object)message.getContextualProperty(IGNORE_MATRIX_PARAMETERS))) {
                value = new PathSegmentImpl(value, false).getPath();
            }
        }
        if ((result = InjectionUtils.createFromParameterHandler(value = InjectionUtils.decodeValue(value, decoded, pType), pClass, genericType, paramAnns, message)) != null) {
            T t = pClass.cast(result);
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                t = t;
                LOG.exiting("org.apache.cxf.jaxrs.utils.InjectionUtils", "handleParameter", t);
            }
            return t;
        }
        if (pClass.isPrimitive()) {
            Object object;
            try {
                Object ret;
                object = ret = PrimitiveUtils.read((String)value, pClass);
            }
            catch (NumberFormatException nfe) {
                if (pType == ParameterType.PATH || pType == ParameterType.QUERY || pType == ParameterType.MATRIX) {
                    throw ExceptionUtils.toNotFoundException((Throwable)nfe, null);
                }
                throw ExceptionUtils.toBadRequestException((Throwable)nfe, null);
            }
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                object = object;
                LOG.exiting("org.apache.cxf.jaxrs.utils.InjectionUtils", "handleParameter", object);
            }
            return (T)object;
        }
        boolean adapterHasToBeUsed = false;
        Class cls = pClass;
        Class valueType = JAXBUtils.getValueTypeFromAdapter(pClass, pClass, (Annotation[])paramAnns);
        if (valueType != cls) {
            cls = valueType;
            adapterHasToBeUsed = true;
        }
        if (pClass == String.class && !adapterHasToBeUsed) {
            Object t = pClass.cast(value);
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                t = t;
                LOG.exiting("org.apache.cxf.jaxrs.utils.InjectionUtils", "handleParameter", t);
            }
            return t;
        }
        try {
            Constructor c = cls.getConstructor(String.class);
            result = c.newInstance(value);
        }
        catch (NoSuchMethodException ex) {
        }
        catch (WebApplicationException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"org.apache.cxf.jaxrs.utils.InjectionUtils", (String)"478", null, (Object[])new Object[]{value, decoded, pClass, genericType, paramAnns, pType, message});
            throw ex;
        }
        catch (Exception ex) {
            Throwable t = InjectionUtils.getOrThrowActualException(ex);
            LOG.severe(new org.apache.cxf.common.i18n.Message("CLASS_CONSTRUCTOR_FAILURE", BUNDLE, new Object[]{pClass.getName()}).toString());
            Response r = JAXRSUtils.toResponse((Response.Status)HttpUtils.getParameterFailureStatus(pType));
            throw ExceptionUtils.toHttpException((Throwable)t, (Response)r);
        }
        if (result == null) {
            String[] stringArray;
            if (cls.isEnum()) {
                String[] stringArray2 = new String[3];
                stringArray2[0] = "fromString";
                stringArray2[1] = "fromValue";
                stringArray = stringArray2;
                stringArray2[2] = "valueOf";
            } else {
                String[] stringArray3 = new String[2];
                stringArray3[0] = "valueOf";
                stringArray = stringArray3;
                stringArray3[1] = "fromString";
            }
            String[] methodNames = stringArray;
            result = InjectionUtils.evaluateFactoryMethods(value, pType, result, cls, methodNames);
        }
        if (adapterHasToBeUsed) {
            Object valueToReplace = result != null ? result : value;
            try {
                result = JAXBUtils.convertWithAdapter(valueToReplace, (Class)pClass, (Annotation[])paramAnns);
            }
            catch (Throwable t) {
                FFDCFilter.processException((Throwable)t, (String)"org.apache.cxf.jaxrs.utils.InjectionUtils", (String)"501", null, (Object[])new Object[]{value, decoded, pClass, genericType, paramAnns, pType, message});
                result = null;
            }
        }
        if (result == null) {
            InjectionUtils.reportServerError("WRONG_PARAMETER_TYPE", pClass.getName());
        }
        Object t = pClass.cast(result);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            t = t;
            LOG.exiting("org.apache.cxf.jaxrs.utils.InjectionUtils", "handleParameter", t);
        }
        return t;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static <T> T createFromParameterHandler(String value, Class<T> pClass, Type genericType, Annotation[] anns, Message message) {
        ServerProviderFactory pf;
        ParamConverter pm;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.InjectionUtils", "createFromParameterHandler", new Object[]{value, pClass, genericType, anns, message});
        }
        Object result = null;
        if (message != null && (pm = (pf = ServerProviderFactory.getInstance((Message)message)).createParameterHandler(pClass, genericType, anns, message)) != null) {
            result = pm.fromString(value);
        }
        Object object = result;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            object = object;
            LOG.exiting("org.apache.cxf.jaxrs.utils.InjectionUtils", "createFromParameterHandler", object);
        }
        return (T)object;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static void reportServerError(String messageName, String parameter) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.InjectionUtils", "reportServerError", new Object[]{messageName, parameter});
        }
        InjectionUtils.reportServerError(messageName, parameter, true);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.utils.InjectionUtils", "reportServerError");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static void reportServerError(String messageName, String parameter, boolean logError) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.InjectionUtils", "reportServerError", new Object[]{messageName, parameter, logError});
        }
        org.apache.cxf.common.i18n.Message errorMessage = new org.apache.cxf.common.i18n.Message(messageName, BUNDLE, new Object[]{parameter});
        if (logError) {
            LOG.severe(errorMessage.toString());
        }
        Response r = JAXRSUtils.toResponseBuilder((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).type(MediaType.TEXT_PLAIN_TYPE).entity((Object)errorMessage.toString()).build();
        throw ExceptionUtils.toInternalServerErrorException(null, (Response)r);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    @FFDCIgnore(value={Exception.class})
    private static Object evaluateFactoryMethods(String value, ParameterType pType, Object result, Class<?> cls, String[] methodNames) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.InjectionUtils", "evaluateFactoryMethods", new Object[]{value, pType, result, cls, methodNames});
        }
        Exception factoryMethodEx = null;
        for (String mName : methodNames) {
            try {
                result = InjectionUtils.evaluateFactoryMethod(value, cls, pType, mName);
                if (result == null) continue;
                factoryMethodEx = null;
            }
            catch (Exception ex) {
                factoryMethodEx = ex;
                if (!cls.isEnum()) break;
                if ("fromValue".equals(mName)) continue;
            }
            break;
        }
        if (factoryMethodEx != null) {
            Throwable t = InjectionUtils.getOrThrowActualException(factoryMethodEx);
            LOG.severe(new org.apache.cxf.common.i18n.Message("CLASS_VALUE_OF_FAILURE", BUNDLE, new Object[]{cls.getName()}).toString());
            throw new WebApplicationException(t, HttpUtils.getParameterFailureStatus(pType));
        }
        Object object = result;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            object = object;
            LOG.exiting("org.apache.cxf.jaxrs.utils.InjectionUtils", "evaluateFactoryMethods", object);
        }
        return object;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static <T> T evaluateFactoryMethod(String value, Class<T> pClass, ParameterType pType, String methodName) throws InvocationTargetException {
        block5: {
            T t;
            block6: {
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    LOG.entering("org.apache.cxf.jaxrs.utils.InjectionUtils", "evaluateFactoryMethod", new Object[]{value, pClass, pType, methodName});
                }
                try {
                    Method m = pClass.getMethod(methodName, String.class);
                    if (!Modifier.isStatic(m.getModifiers())) break block5;
                    t = pClass.cast(m.invoke(null, value));
                    if (LOG == null || !LOG.isLoggable(Level.FINER)) break block6;
                }
                catch (NoSuchMethodException m) {
                    FFDCFilter.processException((Throwable)m, (String)"org.apache.cxf.jaxrs.utils.InjectionUtils", (String)"590", null, (Object[])new Object[]{value, pClass, pType, methodName});
                }
                catch (IllegalAccessException ex) {
                    FFDCFilter.processException((Throwable)ex, (String)"org.apache.cxf.jaxrs.utils.InjectionUtils", (String)"592", null, (Object[])new Object[]{value, pClass, pType, methodName});
                }
                t = t;
                LOG.exiting("org.apache.cxf.jaxrs.utils.InjectionUtils", "evaluateFactoryMethod", t);
            }
            return t;
        }
        T t = null;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            t = t;
            LOG.exiting("org.apache.cxf.jaxrs.utils.InjectionUtils", "evaluateFactoryMethod", t);
        }
        return t;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static Throwable getOrThrowActualException(Throwable ex) {
        Throwable t;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.InjectionUtils", "getOrThrowActualException", new Object[]{ex});
        }
        Throwable throwable = t = ex instanceof InvocationTargetException ? ((InvocationTargetException)ex).getCause() : ex;
        if (t instanceof WebApplicationException) {
            throw (WebApplicationException)t;
        }
        Throwable throwable2 = t;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            throwable2 = throwable2;
            LOG.exiting("org.apache.cxf.jaxrs.utils.InjectionUtils", "getOrThrowActualException", throwable2);
        }
        return throwable2;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static Object handleBean(Class<?> paramType, Annotation[] paramAnns, MultivaluedMap<String, String> values, ParameterType pType, Message message, boolean decoded) {
        String memberKey;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.InjectionUtils", "handleBean", new Object[]{paramType, paramAnns, values, pType, message, decoded});
        }
        Object bean = null;
        try {
            if (paramType.isInterface()) {
                paramType = JAXBUtils.getValueTypeFromAdapter((Class)paramType, (Class)paramType, (Annotation[])paramAnns);
            }
            bean = paramType.newInstance();
        }
        catch (IllegalAccessException illegalAccessException) {
            FFDCFilter.processException((Throwable)illegalAccessException, (String)"org.apache.cxf.jaxrs.utils.InjectionUtils", (String)"618", null, (Object[])new Object[]{paramType, paramAnns, values, pType, message, decoded});
            InjectionUtils.reportServerError("CLASS_ACCESS_FAILURE", paramType.getName());
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, (String)"org.apache.cxf.jaxrs.utils.InjectionUtils", (String)"620", null, (Object[])new Object[]{paramType, paramAnns, values, pType, message, decoded});
            InjectionUtils.reportServerError("CLASS_INSTANTIATION_FAILURE", paramType.getName());
        }
        HashMap<String, MultivaluedMap> parsedValues = new HashMap<String, MultivaluedMap>();
        for (Map.Entry entry : values.entrySet()) {
            memberKey = (String)entry.getKey();
            String beanKey = null;
            int idx = memberKey.indexOf(46);
            if (idx == -1) {
                beanKey = "." + memberKey;
            } else {
                beanKey = memberKey.substring(0, idx);
                memberKey = memberKey.substring(idx + 1);
            }
            MultivaluedMap value = (MultivaluedMap)parsedValues.get(beanKey);
            if (value == null) {
                value = new MetadataMap();
                parsedValues.put(beanKey, value);
            }
            value.put((Object)memberKey, entry.getValue());
        }
        if (parsedValues.size() > 0) {
            for (Map.Entry entry : parsedValues.entrySet()) {
                boolean isbean;
                memberKey = (String)entry.getKey();
                boolean bl = isbean = !memberKey.startsWith(".");
                if (!isbean) {
                    memberKey = memberKey.substring(1);
                }
                AccessibleObject setter = null;
                AccessibleObject getter = null;
                for (Method method : paramType.getMethods()) {
                    if (method.getName().equalsIgnoreCase("set" + memberKey) && method.getParameterTypes().length == 1) {
                        setter = method;
                    } else if (method.getName().equalsIgnoreCase("get" + memberKey) || InjectionUtils.isBooleanType(method.getReturnType()) && method.getName().equalsIgnoreCase("is" + memberKey)) {
                        getter = method;
                    }
                    if (setter != null && getter != null) break;
                }
                if (setter == null) {
                    for (AccessibleObject accessibleObject : paramType.getFields()) {
                        if (!((Field)accessibleObject).getName().equalsIgnoreCase(memberKey)) continue;
                        setter = accessibleObject;
                        getter = accessibleObject;
                        break;
                    }
                }
                if (setter == null || getter == null) continue;
                Class<?> type = null;
                Type genericType = null;
                Object paramValue = null;
                if (setter instanceof Method) {
                    type = ((Method)Method.class.cast(setter)).getParameterTypes()[0];
                    genericType = ((Method)Method.class.cast(setter)).getGenericParameterTypes()[0];
                    paramValue = InjectionUtils.extractFromMethod(bean, (Method)getter);
                } else {
                    type = ((Field)Field.class.cast(setter)).getType();
                    genericType = ((Field)Field.class.cast(setter)).getGenericType();
                    paramValue = InjectionUtils.extractFieldValue((Field)getter, bean);
                }
                List<MultivaluedMap<String, String>> list = InjectionUtils.processValues(type, genericType, (MultivaluedMap<String, String>)((MultivaluedMap)entry.getValue()), isbean);
                for (MultivaluedMap<String, String> processedValues : list) {
                    Object appendValue;
                    if (InjectionUtils.isSupportedCollectionOrArray(type)) {
                        appendValue = InjectionUtils.injectIntoCollectionOrArray(type, genericType, paramAnns, processedValues, isbean, true, pType, message);
                        paramValue = InjectionUtils.mergeCollectionsOrArrays(paramValue, appendValue, genericType);
                    } else if (InjectionUtils.isSupportedMap(genericType)) {
                        appendValue = InjectionUtils.injectIntoMap(type, genericType, paramAnns, processedValues, true, pType, message);
                        paramValue = InjectionUtils.mergeMap(paramValue, appendValue, genericType);
                    } else {
                        paramValue = isbean ? InjectionUtils.handleBean(type, paramAnns, processedValues, pType, message, decoded) : InjectionUtils.handleParameter((String)((List)processedValues.values().iterator().next()).get(0), decoded, type, type, paramAnns, pType, message);
                    }
                    if (paramValue == null) continue;
                    if (setter instanceof Method) {
                        InjectionUtils.injectThroughMethod(bean, setter, paramValue);
                        continue;
                    }
                    InjectionUtils.injectFieldValue((Field)setter, bean, paramValue);
                }
            }
        }
        Object v1 = bean;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            v1 = v1;
            LOG.exiting("org.apache.cxf.jaxrs.utils.InjectionUtils", "handleBean", v1);
        }
        return v1;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static Object mergeMap(Object first, Object second, Type genericType) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.InjectionUtils", "mergeMap", new Object[]{first, second, genericType});
        }
        if (first == null) {
            Object object = second;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                object = object;
                LOG.exiting("org.apache.cxf.jaxrs.utils.InjectionUtils", "mergeMap", object);
            }
            return object;
        }
        if (first instanceof Map) {
            ((Map)Map.class.cast(first)).putAll((Map)second);
            Object object = first;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                object = object;
                LOG.exiting("org.apache.cxf.jaxrs.utils.InjectionUtils", "mergeMap", object);
            }
            return object;
        }
        Object v2 = null;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            v2 = v2;
            LOG.exiting("org.apache.cxf.jaxrs.utils.InjectionUtils", "mergeMap", v2);
        }
        return v2;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static Object injectIntoMap(Class<?> rawType, Type genericType, Annotation[] paramAnns, MultivaluedMap<String, String> processedValues, boolean decoded, ParameterType pathParam, Message message) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.InjectionUtils", "injectIntoMap", new Object[]{rawType, genericType, paramAnns, processedValues, decoded, pathParam, message});
        }
        ParameterizedType paramType = (ParameterizedType)genericType;
        Class keyType = (Class)paramType.getActualTypeArguments()[0];
        Type secondType = InjectionUtils.getType(paramType.getActualTypeArguments(), 1);
        if (secondType instanceof ParameterizedType) {
            MetadataMap theValues = new MetadataMap();
            ParameterizedType valueParamType = (ParameterizedType)secondType;
            Class valueType = (Class)InjectionUtils.getType(valueParamType.getActualTypeArguments(), 0);
            for (Map.Entry processedValuesEntry : processedValues.entrySet()) {
                List valuesList = (List)processedValuesEntry.getValue();
                for (String value : valuesList) {
                    Object o = InjectionUtils.handleParameter(value, decoded, valueType, valueType, paramAnns, pathParam, message);
                    theValues.add(InjectionUtils.convertStringToPrimitive((String)processedValuesEntry.getKey(), keyType), o);
                }
            }
            MetadataMap metadataMap = theValues;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                metadataMap = metadataMap;
                LOG.exiting("org.apache.cxf.jaxrs.utils.InjectionUtils", "injectIntoMap", metadataMap);
            }
            return metadataMap;
        }
        HashMap theValues = new HashMap();
        Class valueType = (Class)InjectionUtils.getType(paramType.getActualTypeArguments(), 1);
        for (Map.Entry processedValuesEntry : processedValues.entrySet()) {
            List valuesList = (List)processedValuesEntry.getValue();
            for (String value : valuesList) {
                Object o = InjectionUtils.handleParameter(value, decoded, valueType, valueType, paramAnns, pathParam, message);
                theValues.put(InjectionUtils.convertStringToPrimitive((String)processedValuesEntry.getKey(), keyType), o);
            }
        }
        HashMap hashMap = theValues;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            hashMap = hashMap;
            LOG.exiting("org.apache.cxf.jaxrs.utils.InjectionUtils", "injectIntoMap", hashMap);
        }
        return hashMap;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static boolean isSupportedMap(Type genericType) {
        ParameterizedType paramType;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.InjectionUtils", "isSupportedMap", new Object[]{genericType});
        }
        Class<?> rawType = InjectionUtils.getRawType(genericType);
        if (Map.class.isAssignableFrom(rawType) && genericType instanceof ParameterizedType && (paramType = (ParameterizedType)genericType).getActualTypeArguments().length == 2) {
            Class<?> firstType = InjectionUtils.getRawType(InjectionUtils.getType(paramType.getActualTypeArguments(), 0));
            Type secondType = InjectionUtils.getType(paramType.getActualTypeArguments(), 1);
            Class<?> secondRawType = InjectionUtils.getRawType(secondType);
            boolean bl = InjectionUtils.isPrimitive(firstType) && (InjectionUtils.isPrimitive(secondRawType) || InjectionUtils.allowedMapListValue(secondRawType, secondType));
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                bl = bl;
                LOG.exiting("org.apache.cxf.jaxrs.utils.InjectionUtils", "isSupportedMap", bl);
            }
            return bl;
        }
        boolean bl = false;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.jaxrs.utils.InjectionUtils", "isSupportedMap", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static boolean allowedMapListValue(Class<?> cls, Type type) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.InjectionUtils", "allowedMapListValue", new Object[]{cls, type});
        }
        if (List.class.isAssignableFrom(cls)) {
            Class<?> listtype = InjectionUtils.getRawType(InjectionUtils.getType(((ParameterizedType)type).getActualTypeArguments(), 0));
            boolean bl = InjectionUtils.isPrimitive(listtype);
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                bl = bl;
                LOG.exiting("org.apache.cxf.jaxrs.utils.InjectionUtils", "allowedMapListValue", bl);
            }
            return bl;
        }
        boolean bl = false;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.jaxrs.utils.InjectionUtils", "allowedMapListValue", bl);
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static List<MultivaluedMap<String, String>> processValues(Class<?> type, Type genericType, MultivaluedMap<String, String> values, boolean isbean) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.InjectionUtils", "processValues", new Object[]{type, genericType, values, isbean});
        }
        ArrayList<MultivaluedMap<String, String>> valuesList = new ArrayList<MultivaluedMap<String, String>>();
        if (isbean && InjectionUtils.isSupportedCollectionOrArray(type)) {
            Class<?> realType = InjectionUtils.getActualType(genericType);
            for (Map.Entry entry : values.entrySet()) {
                String memberKey = (String)entry.getKey();
                Class<?> memberType = null;
                for (Method method : realType.getMethods()) {
                    if (!method.getName().equalsIgnoreCase("set" + memberKey) || method.getParameterTypes().length != 1) continue;
                    memberType = method.getParameterTypes()[0];
                    break;
                }
                if (memberType == null) {
                    for (AccessibleObject accessibleObject : realType.getFields()) {
                        if (!((Field)accessibleObject).getName().equalsIgnoreCase(memberKey)) continue;
                        memberType = ((Field)accessibleObject).getType();
                        break;
                    }
                }
                if (memberType != null && InjectionUtils.isSupportedCollectionOrArray(memberType)) continue;
                int idx = 0;
                for (String value : (List)entry.getValue()) {
                    void var13_21;
                    MultivaluedMap multivaluedMap;
                    MultivaluedMap multivaluedMap2 = multivaluedMap = idx < valuesList.size() ? (MultivaluedMap)valuesList.get(idx) : null;
                    if (multivaluedMap == null) {
                        MetadataMap metadataMap = new MetadataMap();
                        valuesList.add((MultivaluedMap<String, String>)metadataMap);
                    }
                    var13_21.add((Object)memberKey, (Object)value);
                    ++idx;
                }
            }
        } else {
            valuesList.add(values);
        }
        ArrayList<MultivaluedMap<String, String>> arrayList = valuesList;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            arrayList = arrayList;
            LOG.exiting("org.apache.cxf.jaxrs.utils.InjectionUtils", "processValues", arrayList);
        }
        return arrayList;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static boolean isSupportedCollectionOrArray(Class<?> type) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.InjectionUtils", "isSupportedCollectionOrArray", new Object[]{type});
        }
        boolean bl = Collection.class.isAssignableFrom(type) || type.isArray();
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.jaxrs.utils.InjectionUtils", "isSupportedCollectionOrArray", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static Object mergeCollectionsOrArrays(Object first, Object second, Type genericType) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.InjectionUtils", "mergeCollectionsOrArrays", new Object[]{first, second, genericType});
        }
        if (first == null) {
            Object object = second;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                object = object;
                LOG.exiting("org.apache.cxf.jaxrs.utils.InjectionUtils", "mergeCollectionsOrArrays", object);
            }
            return object;
        }
        if (first instanceof Collection) {
            ((Collection)Collection.class.cast(first)).addAll((Collection)second);
            Object object = first;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                object = object;
                LOG.exiting("org.apache.cxf.jaxrs.utils.InjectionUtils", "mergeCollectionsOrArrays", object);
            }
            return object;
        }
        int firstLen = Array.getLength(first);
        int secondLen = Array.getLength(second);
        Object mergedArray = Array.newInstance(InjectionUtils.getActualType(genericType), firstLen + secondLen);
        System.arraycopy(first, 0, mergedArray, 0, firstLen);
        System.arraycopy(second, 0, mergedArray, firstLen, secondLen);
        Object object = mergedArray;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            object = object;
            LOG.exiting("org.apache.cxf.jaxrs.utils.InjectionUtils", "mergeCollectionsOrArrays", object);
        }
        return object;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    static Class<?> getCollectionType(Class<?> rawType) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.InjectionUtils", "getCollectionType", new Object[]{rawType});
        }
        Class type = null;
        if (SortedSet.class.isAssignableFrom(rawType)) {
            type = TreeSet.class;
        } else if (Set.class.isAssignableFrom(rawType)) {
            type = HashSet.class;
        } else if (Collection.class.isAssignableFrom(rawType)) {
            type = ArrayList.class;
        }
        Class<TreeSet> clazz = type;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            clazz = clazz;
            LOG.exiting("org.apache.cxf.jaxrs.utils.InjectionUtils", "getCollectionType", clazz);
        }
        return clazz;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static Object injectIntoCollectionOrArray(Class<?> rawType, Type genericType, Annotation[] paramAnns, MultivaluedMap<String, String> values, boolean isbean, boolean decoded, ParameterType pathParam, Message message) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.InjectionUtils", "injectIntoCollectionOrArray", new Object[]{rawType, genericType, paramAnns, values, isbean, decoded, pathParam, message});
        }
        Class<?> type = InjectionUtils.getCollectionType(rawType);
        Class<?> realType = rawType.isArray() ? rawType.getComponentType() : InjectionUtils.getActualType(genericType);
        Object theValues = null;
        if (type != null) {
            try {
                theValues = type.newInstance();
            }
            catch (IllegalAccessException illegalAccessException) {
                FFDCFilter.processException((Throwable)illegalAccessException, (String)"org.apache.cxf.jaxrs.utils.InjectionUtils", (String)"931", null, (Object[])new Object[]{rawType, genericType, paramAnns, values, isbean, decoded, pathParam, message});
                InjectionUtils.reportServerError("CLASS_ACCESS_FAILURE", type.getName());
            }
            catch (Exception ex) {
                FFDCFilter.processException((Throwable)ex, (String)"org.apache.cxf.jaxrs.utils.InjectionUtils", (String)"933", null, (Object[])new Object[]{rawType, genericType, paramAnns, values, isbean, decoded, pathParam, message});
                InjectionUtils.reportServerError("CLASS_INSTANTIATION_FAILURE", type.getName());
            }
        } else {
            theValues = Array.newInstance(realType, isbean ? 1 : ((List)values.values().iterator().next()).size());
        }
        if (isbean) {
            Object o = InjectionUtils.handleBean(realType, paramAnns, values, pathParam, message, decoded);
            InjectionUtils.addToCollectionValues(theValues, o, 0);
        } else {
            List<String> valuesList = (List<String>)values.values().iterator().next();
            valuesList = InjectionUtils.checkPathSegment(valuesList, realType, pathParam);
            for (int ind = 0; ind < valuesList.size(); ++ind) {
                Object o = InjectionUtils.handleParameter(valuesList.get(ind), decoded, realType, realType, paramAnns, pathParam, message);
                InjectionUtils.addToCollectionValues(theValues, o, ind);
            }
        }
        Object object = theValues;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            object = object;
            LOG.exiting("org.apache.cxf.jaxrs.utils.InjectionUtils", "injectIntoCollectionOrArray", object);
        }
        return object;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static void addToCollectionValues(Object theValues, Object o, int index) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.InjectionUtils", "addToCollectionValues", new Object[]{theValues, o, index});
        }
        if (o != null) {
            if (theValues instanceof Collection) {
                ((Collection)Collection.class.cast(theValues)).add(o);
            } else if (theValues.getClass().getComponentType().isPrimitive()) {
                Array.set(theValues, index, o);
            } else {
                ((Object[])theValues)[index] = o;
            }
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.utils.InjectionUtils", "addToCollectionValues");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static List<String> checkPathSegment(List<String> values, Class<?> type, ParameterType pathParam) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.InjectionUtils", "checkPathSegment", new Object[]{values, type, pathParam});
        }
        if (pathParam != ParameterType.PATH || !PathSegment.class.isAssignableFrom(type)) {
            List<String> list = values;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                list = list;
                LOG.exiting("org.apache.cxf.jaxrs.utils.InjectionUtils", "checkPathSegment", list);
            }
            return list;
        }
        ArrayList<String> newValues = new ArrayList<String>();
        for (String v : values) {
            String[] segments;
            for (String s : segments = StringUtils.split((String)v, (String)"/")) {
                if (s.length() == 0) continue;
                newValues.add(s);
            }
            if (!v.endsWith("/")) continue;
            newValues.add("");
        }
        ArrayList<String> arrayList = newValues;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            arrayList = arrayList;
            LOG.exiting("org.apache.cxf.jaxrs.utils.InjectionUtils", "checkPathSegment", arrayList);
        }
        return arrayList;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static Object createParameterObject(List<String> paramValues, Class<?> paramType, Type genericType, Annotation[] paramAnns, String defaultValue, boolean decoded, ParameterType pathParam, Message message) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.InjectionUtils", "createParameterObject", new Object[]{paramValues, paramType, genericType, paramAnns, defaultValue, decoded, pathParam, message});
        }
        if (paramValues == null) {
            if (defaultValue != null) {
                paramValues = Collections.singletonList(defaultValue);
            } else if (paramType.isPrimitive()) {
                paramValues = Collections.singletonList(Boolean.TYPE == paramType ? "false" : (Character.TYPE == paramType ? Character.toString('\u0000') : "0"));
            } else if (InjectionUtils.isSupportedCollectionOrArray(paramType)) {
                paramValues = Collections.emptyList();
            } else {
                Object v0 = null;
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    v0 = v0;
                    LOG.exiting("org.apache.cxf.jaxrs.utils.InjectionUtils", "createParameterObject", v0);
                }
                return v0;
            }
        }
        Object value = null;
        if (InjectionUtils.isSupportedCollectionOrArray(paramType)) {
            MetadataMap paramValuesMap = new MetadataMap();
            paramValuesMap.put((Object)"", paramValues);
            value = InjectionUtils.injectIntoCollectionOrArray(paramType, genericType, paramAnns, (MultivaluedMap<String, String>)paramValuesMap, false, decoded, pathParam, message);
        } else {
            String result = null;
            if (paramValues.size() > 0) {
                boolean isLast = pathParam == ParameterType.PATH;
                String string = result = isLast ? paramValues.get(paramValues.size() - 1) : paramValues.get(0);
            }
            if (result != null) {
                value = InjectionUtils.handleParameter(result, decoded, paramType, genericType, paramAnns, pathParam, message);
            }
        }
        Object object = value;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            object = object;
            LOG.exiting("org.apache.cxf.jaxrs.utils.InjectionUtils", "createParameterObject", object);
        }
        return object;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static <T> ThreadLocalProxy<T> createThreadLocalProxy(Class<T> type) {
        ProxyClassLoader loader;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.InjectionUtils", "createThreadLocalProxy", new Object[]{type});
        }
        ThreadLocalSecurityContext proxy = null;
        if (UriInfo.class.isAssignableFrom(type)) {
            proxy = new ThreadLocalUriInfo();
        } else if (HttpHeaders.class.isAssignableFrom(type)) {
            proxy = new ThreadLocalHttpHeaders();
        } else if (ProtocolHeaders.class.isAssignableFrom(type)) {
            proxy = new ThreadLocalProtocolHeaders();
        } else if (SecurityContext.class.isAssignableFrom(type)) {
            proxy = new ThreadLocalSecurityContext();
        } else if (ContextResolver.class.isAssignableFrom(type)) {
            proxy = new ThreadLocalContextResolver();
        } else if (Request.class.isAssignableFrom(type)) {
            proxy = new ThreadLocalRequest();
        } else if (Providers.class.isAssignableFrom(type)) {
            proxy = new ThreadLocalProviders();
        } else if (MessageContext.class.isAssignableFrom(type)) {
            proxy = new ThreadLocalMessageContext();
        } else if (type.getName().equals(MessageContext.class.getName())) {
            loader = new MessageContextProxyClassLoader(Proxy.class.getClassLoader(), type.getClassLoader(), ThreadLocalProxy.class.getClassLoader());
            proxy = (ThreadLocalProxy)Proxy.newProxyInstance((ClassLoader)loader, new Class[]{type, ThreadLocalProxy.class}, (InvocationHandler)new ProxyInvocationHandler((Object)new ThreadLocalMessageContext()));
        }
        if (proxy == null && InjectionUtils.isServletApiContext(type.getName())) {
            proxy = InjectionUtils.createThreadLocalServletApiContext(type.getName());
        }
        if (proxy == null) {
            loader = new ProxyClassLoader(Proxy.class.getClassLoader());
            loader.addLoader(type.getClassLoader());
            loader.addLoader(ThreadLocalProxy.class.getClassLoader());
            ThreadLocalProxy threadLocalProxy = (ThreadLocalProxy)Proxy.newProxyInstance((ClassLoader)loader, new Class[]{type, ThreadLocalProxy.class}, (InvocationHandler)new ThreadLocalInvocationHandler());
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                threadLocalProxy = threadLocalProxy;
                LOG.exiting("org.apache.cxf.jaxrs.utils.InjectionUtils", "createThreadLocalProxy", threadLocalProxy);
            }
            return threadLocalProxy;
        }
        ThreadLocalSecurityContext threadLocalSecurityContext = proxy;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            threadLocalSecurityContext = threadLocalSecurityContext;
            LOG.exiting("org.apache.cxf.jaxrs.utils.InjectionUtils", "createThreadLocalProxy", threadLocalSecurityContext);
        }
        return threadLocalSecurityContext;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static boolean isServletApiContext(String name) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.InjectionUtils", "isServletApiContext", new Object[]{name});
        }
        boolean bl = name.startsWith("javax.servlet.");
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.jaxrs.utils.InjectionUtils", "isServletApiContext", bl);
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static ThreadLocalProxy<?> createThreadLocalServletApiContext(String name) {
        ThreadLocalProxy threadLocalProxy;
        block10: {
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.entering("org.apache.cxf.jaxrs.utils.InjectionUtils", "createThreadLocalServletApiContext", new Object[]{name});
            }
            String proxyClassName = null;
            if (HTTP_SERVLET_REQUEST_CLASS_NAME.equals(name)) {
                proxyClassName = "org.apache.cxf.jaxrs.impl.tl.ThreadLocalHttpServletRequest";
            } else if (HTTP_SERVLET_RESPONSE_CLASS_NAME.equals(name)) {
                proxyClassName = "org.apache.cxf.jaxrs.impl.tl.ThreadLocalHttpServletResponse";
            } else if (SERVLET_CONTEXT_CLASS_NAME.equals(name)) {
                proxyClassName = "org.apache.cxf.jaxrs.impl.tl.ThreadLocalServletContext";
            } else if (SERVLET_CONFIG_CLASS_NAME.equals(name)) {
                proxyClassName = "org.apache.cxf.jaxrs.impl.tl.ThreadLocalServletConfig";
            }
            try {
                threadLocalProxy = (ThreadLocalProxy)InjectionUtils.class.getClassLoader().loadClass(proxyClassName).newInstance();
                if (LOG == null || !LOG.isLoggable(Level.FINER)) break block10;
            }
            catch (Throwable throwable) {
                void t;
                FFDCFilter.processException((Throwable)throwable, (String)"org.apache.cxf.jaxrs.utils.InjectionUtils", (String)"1100", null, (Object[])new Object[]{name});
                throw new RuntimeException((Throwable)t);
            }
            threadLocalProxy = threadLocalProxy;
            LOG.exiting("org.apache.cxf.jaxrs.utils.InjectionUtils", "createThreadLocalServletApiContext", threadLocalProxy);
        }
        return threadLocalProxy;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static Method getGetterFromSetter(Method setter) throws Exception {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.InjectionUtils", "getGetterFromSetter", new Object[]{setter});
        }
        Method method = setter.getClass().getMethod("get" + setter.getName().substring(3), new Class[0]);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            method = method;
            LOG.exiting("org.apache.cxf.jaxrs.utils.InjectionUtils", "getGetterFromSetter", method);
        }
        return method;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static void injectContextProxiesAndApplication(AbstractResourceInfo cri, Object instance, Application app) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.InjectionUtils", "injectContextProxiesAndApplication", new Object[]{cri, instance, app});
        }
        if (!cri.isSingleton()) {
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.exiting("org.apache.cxf.jaxrs.utils.InjectionUtils", "injectContextProxiesAndApplication");
            }
            return;
        }
        if (cri instanceof ApplicationInfo) {
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.exiting("org.apache.cxf.jaxrs.utils.InjectionUtils", "injectContextProxiesAndApplication");
            }
            return;
        }
        JaxRsFactoryBeanCustomizer beanCustomizer = InjectionRuntimeContextHelper.findBeanCustomizer(instance.getClass(), cri.getBus());
        Boolean isManagedBean = beanCustomizer != null;
        InjectionRuntimeContext irc = InjectionRuntimeContextHelper.getRuntimeContext();
        Object object = instance;
        synchronized (object) {
            for (Map.Entry entry : cri.getContextMethods().entrySet()) {
                Application value;
                Method method = (Method)entry.getValue();
                Object object2 = value = method.getParameterTypes()[0] == Application.class ? app : cri.getContextSetterProxy(method);
                if (isManagedBean.booleanValue()) {
                    irc.setRuntimeCtxObject(((Class)entry.getKey()).getName(), value);
                    continue;
                }
                InjectionUtils.injectThroughMethod(instance, method, value);
            }
            for (Field f : cri.getContextFields()) {
                Application value;
                Object object3 = value = f.getType() == Application.class ? app : cri.getContextFieldProxy(f);
                if (isManagedBean.booleanValue()) {
                    irc.setRuntimeCtxObject(f.getType().getName(), value);
                    continue;
                }
                InjectionUtils.injectFieldValue(f, instance, value);
            }
        }
        Object o = null;
        if (isManagedBean.booleanValue() && cri instanceof ClassResourceInfo) {
            o = beanCustomizer.onSingletonServiceInit(instance, InjectionRuntimeContextHelper.getBeanCustomizerContext(beanCustomizer, cri.getBus()));
            SingletonResourceProvider sp = new SingletonResourceProvider(o);
            ((ClassResourceInfo)cri).setResourceProvider((ResourceProvider)sp);
            instance = o;
        }
        if (!isManagedBean.booleanValue() && cri instanceof ClassResourceInfo) {
            Method postConstructMethod = ResourceUtils.findPostConstructMethod(instance.getClass());
            InjectionUtils.invokeLifeCycleMethod(instance, postConstructMethod);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.utils.InjectionUtils", "injectContextProxiesAndApplication");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static void injectContextProxies(AbstractResourceInfo cri, Object instance) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.InjectionUtils", "injectContextProxies", new Object[]{cri, instance});
        }
        InjectionUtils.injectContextProxiesAndApplication(cri, instance, null);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.utils.InjectionUtils", "injectContextProxies");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static void injectContextField(AbstractResourceInfo cri, Field f, Object o, Object value) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.InjectionUtils", "injectContextField", new Object[]{cri, f, o, value});
        }
        if (!cri.isSingleton()) {
            InjectionUtils.injectFieldValue(f, o, value);
        } else {
            ThreadLocalProxy proxy = cri.getContextFieldProxy(f);
            if (proxy != null) {
                proxy.set(value);
            }
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.utils.InjectionUtils", "injectContextField");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static void injectManagedObjectContextField(AbstractResourceInfo cri, Field f, Object o, Object value) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.InjectionUtils", "injectManagedObjectContextField", new Object[]{cri, f, o, value});
        }
        InjectionRuntimeContext irc = null;
        irc = InjectionRuntimeContextHelper.getRuntimeContext();
        irc.setRuntimeCtxObject(f.getType().getName(), value);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.utils.InjectionUtils", "injectManagedObjectContextField");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static void injectContexts(Object requestObject, AbstractResourceInfo resource, Message message) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.InjectionUtils", "injectContexts", new Object[]{requestObject, resource, message});
        }
        if (resource.contextsAvailable()) {
            JaxRsFactoryBeanCustomizer beanCustomizer;
            Class<?> clz = requestObject.getClass();
            if (resource instanceof ProviderInfo && !(resource instanceof ApplicationInfo) && resource.getConstructorProxies() == null) {
                ProviderInfo pi = (ProviderInfo)resource;
                clz = pi.getOldProvider().getClass();
            }
            if ((beanCustomizer = InjectionRuntimeContextHelper.findBeanCustomizer(clz, resource.getBus())) != null) {
                InjectionUtils.injectManagedObjectContextMethods(requestObject, resource, message);
                InjectionUtils.injectManagedObjectContextFields(requestObject, resource, message);
            } else {
                InjectionUtils.injectContextMethods(requestObject, resource, message);
                InjectionUtils.injectContextFields(requestObject, resource, message);
                if (!resource.isSingleton()) {
                    Method postConstructMethod = ResourceUtils.findPostConstructMethod(requestObject.getClass());
                    InjectionUtils.invokeLifeCycleMethod(requestObject, postConstructMethod);
                }
            }
            if (resource instanceof ApplicationInfo) {
                InjectionUtils.injectManagedObjectContextMethods(requestObject, resource, message);
                InjectionUtils.injectManagedObjectContextFields(requestObject, resource, message);
            }
            InjectionUtils.injectConstructorProxies(requestObject, resource, message);
        }
        InjectionRuntimeContextHelper.initSingletonEJBCDIProvider(resource, message, requestObject);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.utils.InjectionUtils", "injectContexts");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static void injectContextMethods(Object requestObject, AbstractResourceInfo cri, Message message) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.InjectionUtils", "injectContextMethods", new Object[]{requestObject, cri, message});
        }
        for (Map.Entry entry : cri.getContextMethods().entrySet()) {
            Object o;
            Method method = (Method)entry.getValue();
            if (method.getParameterTypes()[0] == Application.class && cri.isSingleton() || (o = JAXRSUtils.createContextValue((Message)message, (Type)method.getGenericParameterTypes()[0], (Class)((Class)entry.getKey()))) == null) continue;
            if (!cri.isSingleton()) {
                InjectionUtils.injectThroughMethod(requestObject, method, o, message);
                continue;
            }
            ThreadLocalProxy proxy = cri.getContextSetterProxy(method);
            if (proxy == null) continue;
            proxy.set(o);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.utils.InjectionUtils", "injectContextMethods");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static void injectManagedObjectContextMethods(Object requestObject, AbstractResourceInfo cri, Message message) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.InjectionUtils", "injectManagedObjectContextMethods", new Object[]{requestObject, cri, message});
        }
        for (Map.Entry entry : cri.getContextMethods().entrySet()) {
            Method method = (Method)entry.getValue();
            Object o = JAXRSUtils.createContextValue((Message)message, (Type)method.getGenericParameterTypes()[0], (Class)((Class)entry.getKey()));
            InjectionRuntimeContext irc = InjectionRuntimeContextHelper.getRuntimeContext();
            if (o == null) continue;
            irc.setRuntimeCtxObject(((Class)entry.getKey()).getName(), o);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.utils.InjectionUtils", "injectManagedObjectContextMethods");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static void injectContextFields(Object o, AbstractResourceInfo cri, Message m) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.InjectionUtils", "injectContextFields", new Object[]{o, cri, m});
        }
        for (Field f : cri.getContextFields()) {
            Object value;
            if (f.getType() == Application.class && cri.isSingleton() || (value = JAXRSUtils.createContextValue((Message)m, (Type)f.getGenericType(), f.getType())) == null) continue;
            InjectionUtils.injectContextField(cri, f, o, value);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.utils.InjectionUtils", "injectContextFields");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static void injectManagedObjectContextFields(Object o, AbstractResourceInfo cri, Message m) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.InjectionUtils", "injectManagedObjectContextFields", new Object[]{o, cri, m});
        }
        for (Field f : cri.getContextFields()) {
            Object value = JAXRSUtils.createContextValue((Message)m, (Type)f.getGenericType(), f.getType());
            InjectionUtils.injectManagedObjectContextField(cri, f, o, value);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.utils.InjectionUtils", "injectManagedObjectContextFields");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static void injectConstructorProxies(Object o, AbstractResourceInfo cri, Message m) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.InjectionUtils", "injectConstructorProxies", new Object[]{o, cri, m});
        }
        Map proxies = cri.getConstructorProxies();
        if (proxies != null) {
            for (Map.Entry entry : proxies.entrySet()) {
                Object value = JAXRSUtils.createContextValue((Message)m, (Type)((Type)entry.getKey()), (Class)((Class)entry.getKey()));
                ((ThreadLocalProxy)entry.getValue()).set(value);
            }
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.utils.InjectionUtils", "injectConstructorProxies");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static MultivaluedMap<String, Object> extractValuesFromBean(Object bean, String baseName) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.InjectionUtils", "extractValuesFromBean", new Object[]{bean, baseName});
        }
        MetadataMap values = new MetadataMap();
        InjectionUtils.fillInValuesFromBean(bean, baseName, (MultivaluedMap<String, Object>)values);
        MetadataMap metadataMap = values;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            metadataMap = metadataMap;
            LOG.exiting("org.apache.cxf.jaxrs.utils.InjectionUtils", "extractValuesFromBean", metadataMap);
        }
        return metadataMap;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static boolean isBooleanType(Class<?> cls) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.InjectionUtils", "isBooleanType", new Object[]{cls});
        }
        boolean bl = Boolean.TYPE == cls || Boolean.class == cls;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.jaxrs.utils.InjectionUtils", "isBooleanType", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static void fillInValuesFromBean(Object bean, String baseName, MultivaluedMap<String, Object> values) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.InjectionUtils", "fillInValuesFromBean", new Object[]{bean, baseName, values});
        }
        for (Method m : bean.getClass().getMethods()) {
            Object value;
            String propertyName;
            int minLen;
            String methodName = m.getName();
            boolean startsFromGet = methodName.startsWith("get");
            if (!startsFromGet && (!InjectionUtils.isBooleanType(m.getReturnType()) || !methodName.startsWith("is")) || m.getParameterTypes().length != 0) continue;
            int n = minLen = startsFromGet ? 3 : 2;
            if (methodName.length() <= minLen || baseName.contains(propertyName = (propertyName = methodName.substring(minLen)).length() == 1 ? propertyName.toLowerCase() : propertyName.substring(0, 1).toLowerCase() + propertyName.substring(1)) || "class".equals(propertyName) || "declaringClass".equals(propertyName)) continue;
            if (!"".equals(baseName)) {
                propertyName = baseName + "." + propertyName;
            }
            if ((value = InjectionUtils.extractFromMethod(bean, m)) == null) continue;
            if (InjectionUtils.isPrimitive(value.getClass()) || Date.class.isAssignableFrom(value.getClass())) {
                values.putSingle((Object)propertyName, value);
                continue;
            }
            if (value.getClass().isEnum()) {
                values.putSingle((Object)propertyName, (Object)value.toString());
                continue;
            }
            if (InjectionUtils.isSupportedCollectionOrArray(value.getClass())) {
                List<Object> theValues = null;
                theValues = value.getClass().isArray() ? Arrays.asList(value) : (value instanceof Set ? new ArrayList<Object>((Set)value) : CastUtils.cast((List)((List)value)));
                values.put((Object)propertyName, theValues);
                continue;
            }
            if (Map.class.isAssignableFrom(value.getClass())) {
                if (!InjectionUtils.isSupportedMap(m.getGenericReturnType())) continue;
                Map map = CastUtils.cast((Map)((Map)value));
                for (Map.Entry entry : map.entrySet()) {
                    values.add((Object)(propertyName + "." + entry.getKey().toString()), (Object)entry.getValue().toString());
                }
                continue;
            }
            InjectionUtils.fillInValuesFromBean(value, propertyName, values);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.utils.InjectionUtils", "fillInValuesFromBean");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static Map<Parameter, Class<?>> getParametersFromBeanClass(Class<?> beanClass, ParameterType type, boolean checkIgnorable) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.InjectionUtils", "getParametersFromBeanClass", new Object[]{beanClass, type, checkIgnorable});
        }
        LinkedHashMap params = new LinkedHashMap();
        for (Method m : beanClass.getMethods()) {
            int minLen;
            String methodName = m.getName();
            boolean startsFromGet = methodName.startsWith("get");
            if (!startsFromGet && (!InjectionUtils.isBooleanType(m.getReturnType()) || !methodName.startsWith("is")) || m.getParameterTypes().length != 0) continue;
            int n = minLen = startsFromGet ? 3 : 2;
            if (methodName.length() <= minLen) continue;
            String propertyName = StringUtils.uncapitalize((String)methodName.substring(minLen));
            if (m.getReturnType() == Class.class || checkIgnorable && InjectionUtils.canPropertyBeIgnored(m, propertyName)) continue;
            params.put(new Parameter(type, propertyName), m.getReturnType());
        }
        LinkedHashMap linkedHashMap = params;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            linkedHashMap = linkedHashMap;
            LOG.exiting("org.apache.cxf.jaxrs.utils.InjectionUtils", "getParametersFromBeanClass", linkedHashMap);
        }
        return linkedHashMap;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static boolean canPropertyBeIgnored(Method m, String propertyName) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.InjectionUtils", "canPropertyBeIgnored", new Object[]{m, propertyName});
        }
        for (Annotation ann : m.getAnnotations()) {
            String annType = ann.annotationType().getName();
            if (!"org.apache.cxf.aegis.type.java5.IgnoreProperty".equals(annType) && !"javax.xml.bind.annotation.XmlTransient".equals(annType)) continue;
            boolean bl = true;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                bl = bl;
                LOG.exiting("org.apache.cxf.jaxrs.utils.InjectionUtils", "canPropertyBeIgnored", bl);
            }
            return bl;
        }
        boolean bl = false;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.jaxrs.utils.InjectionUtils", "canPropertyBeIgnored", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static boolean isPrimitive(Class<?> type) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.InjectionUtils", "isPrimitive", new Object[]{type});
        }
        boolean bl = type.isPrimitive() || Number.class.isAssignableFrom(type) || Boolean.class.isAssignableFrom(type) || Character.class.isAssignableFrom(type) || String.class == type;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.jaxrs.utils.InjectionUtils", "isPrimitive", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static String decodeValue(String value, boolean decode, ParameterType param) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.InjectionUtils", "decodeValue", new Object[]{value, decode, param});
        }
        if (!decode) {
            String string = value;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                string = string;
                LOG.exiting("org.apache.cxf.jaxrs.utils.InjectionUtils", "decodeValue", string);
            }
            return string;
        }
        if (param == ParameterType.PATH || param == ParameterType.MATRIX) {
            String string = HttpUtils.pathDecode(value);
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                string = string;
                LOG.exiting("org.apache.cxf.jaxrs.utils.InjectionUtils", "decodeValue", string);
            }
            return string;
        }
        String string = HttpUtils.urlDecode(value);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.jaxrs.utils.InjectionUtils", "decodeValue", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static void invokeLifeCycleMethod(Object instance, Method method) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.InjectionUtils", "invokeLifeCycleMethod", new Object[]{instance, method});
        }
        if (method != null) {
            method = InjectionUtils.checkProxy(method, instance);
            try {
                method.invoke(instance, new Object[0]);
            }
            catch (InvocationTargetException invocationTargetException) {
                FFDCFilter.processException((Throwable)invocationTargetException, (String)"org.apache.cxf.jaxrs.utils.InjectionUtils", (String)"1502", null, (Object[])new Object[]{instance, method});
                String msg = "Method " + method.getName() + " can not be invoked" + " due to InvocationTargetException";
                throw new WebApplicationException(JAXRSUtils.toResponseBuilder((int)500).entity((Object)msg).build());
            }
            catch (IllegalAccessException ex) {
                FFDCFilter.processException((Throwable)ex, (String)"org.apache.cxf.jaxrs.utils.InjectionUtils", (String)"1506", null, (Object[])new Object[]{instance, method});
                String msg = "Method " + method.getName() + " can not be invoked" + " due to IllegalAccessException";
                throw ExceptionUtils.toInternalServerErrorException((Throwable)ex, (Response)JAXRSUtils.toResponseBuilder((int)500).entity((Object)msg).build());
            }
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.utils.InjectionUtils", "invokeLifeCycleMethod");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static Object convertStringToPrimitive(String value, Class<?> cls) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.InjectionUtils", "convertStringToPrimitive", new Object[]{value, cls});
        }
        Object object = InjectionUtils.convertStringToPrimitive(value, cls, new Annotation[0]);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            object = object;
            LOG.exiting("org.apache.cxf.jaxrs.utils.InjectionUtils", "convertStringToPrimitive", object);
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static Object convertStringToPrimitive(String value, Class<?> cls, Annotation[] anns) {
        Object obj;
        block17: {
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.entering("org.apache.cxf.jaxrs.utils.InjectionUtils", "convertStringToPrimitive", new Object[]{value, cls, anns});
            }
            Message m = JAXRSUtils.getCurrentMessage();
            Object obj2 = InjectionUtils.createFromParameterHandler(value, cls, cls, anns, m);
            if (obj2 != null) {
                Object obj3 = obj2;
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    obj3 = obj3;
                    LOG.exiting("org.apache.cxf.jaxrs.utils.InjectionUtils", "convertStringToPrimitive", obj3);
                }
                return obj3;
            }
            if (String.class == cls) {
                String string = value;
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    string = string;
                    LOG.exiting("org.apache.cxf.jaxrs.utils.InjectionUtils", "convertStringToPrimitive", string);
                }
                return string;
            }
            if (cls.isPrimitive()) {
                Object object = PrimitiveUtils.read((String)value, cls);
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    object = object;
                    LOG.exiting("org.apache.cxf.jaxrs.utils.InjectionUtils", "convertStringToPrimitive", object);
                }
                return object;
            }
            if (cls.isEnum()) {
                if (m != null && !MessageUtils.getContextualBoolean((Message)m, (String)ENUM_CONVERSION_CASE_SENSITIVE, (boolean)false)) {
                    obj2 = InjectionUtils.invokeValueOf(value.toUpperCase(), cls);
                }
                if (obj2 == null) {
                    try {
                        obj2 = InjectionUtils.invokeValueOf(value, cls);
                    }
                    catch (RuntimeException runtimeException) {
                        void ex;
                        FFDCFilter.processException((Throwable)runtimeException, (String)"org.apache.cxf.jaxrs.utils.InjectionUtils", (String)"1536", null, (Object[])new Object[]{value, cls, anns});
                        if (m == null) {
                            obj2 = InjectionUtils.invokeValueOf(value.toUpperCase(), cls);
                        }
                        throw ex;
                    }
                }
                Object obj4 = obj2;
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    obj4 = obj4;
                    LOG.exiting("org.apache.cxf.jaxrs.utils.InjectionUtils", "convertStringToPrimitive", obj4);
                }
                return obj4;
            }
            try {
                Constructor<?> c = cls.getConstructor(String.class);
                obj = c.newInstance(value);
                if (LOG == null || !LOG.isLoggable(Level.FINER)) break block17;
            }
            catch (Throwable c) {
                FFDCFilter.processException((Throwable)c, (String)"org.apache.cxf.jaxrs.utils.InjectionUtils", (String)"1549", null, (Object[])new Object[]{value, cls, anns});
                Object object = InjectionUtils.invokeValueOf(value, cls);
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    object = object;
                    LOG.exiting("org.apache.cxf.jaxrs.utils.InjectionUtils", "convertStringToPrimitive", object);
                }
                return object;
            }
            obj = obj;
            LOG.exiting("org.apache.cxf.jaxrs.utils.InjectionUtils", "convertStringToPrimitive", obj);
        }
        return obj;
    }

    /*
     * WARNING - void declaration
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static Object invokeValueOf(String value, Class<?> cls) {
        Object object;
        block3: {
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.entering("org.apache.cxf.jaxrs.utils.InjectionUtils", "invokeValueOf", new Object[]{value, cls});
            }
            try {
                Method m = cls.getMethod("valueOf", String.class);
                object = m.invoke(null, value);
                if (LOG == null || !LOG.isLoggable(Level.FINER)) break block3;
            }
            catch (Exception m) {
                void ex;
                FFDCFilter.processException((Throwable)m, (String)"org.apache.cxf.jaxrs.utils.InjectionUtils", (String)"1560", null, (Object[])new Object[]{value, cls});
                throw new RuntimeException((Throwable)ex);
            }
            object = object;
            LOG.exiting("org.apache.cxf.jaxrs.utils.InjectionUtils", "invokeValueOf", object);
        }
        return object;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static Class<?> getRawResponseClass(Object targetObject) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.InjectionUtils", "getRawResponseClass", new Object[]{targetObject});
        }
        if (targetObject != null) {
            Class<?> targetClass = targetObject.getClass();
            Class clazz = ClassHelper.getRealClassFromClass(targetClass);
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                clazz = clazz;
                LOG.exiting("org.apache.cxf.jaxrs.utils.InjectionUtils", "getRawResponseClass", clazz);
            }
            return clazz;
        }
        Class<?> clazz = null;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            clazz = clazz;
            LOG.exiting("org.apache.cxf.jaxrs.utils.InjectionUtils", "getRawResponseClass", clazz);
        }
        return clazz;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static boolean isAsyncMethod(Method method) {
        Class<?>[] parameterTypes;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.InjectionUtils", "isAsyncMethod", new Object[]{method});
        }
        for (Class<AsyncResponse> clazz : parameterTypes = method.getParameterTypes()) {
            if (!clazz.isAssignableFrom(AsyncResponse.class)) continue;
            boolean bl = true;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                bl = bl;
                LOG.exiting("org.apache.cxf.jaxrs.utils.InjectionUtils", "isAsyncMethod", bl);
            }
            return bl;
        }
        boolean bl = false;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.jaxrs.utils.InjectionUtils", "isAsyncMethod", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static Type getAsynchronizedGenericType(Object targetObject) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.InjectionUtils", "getAsynchronizedGenericType", new Object[]{targetObject});
        }
        if (targetObject instanceof Collection) {
            Class<?> rawType = targetObject.getClass();
            Class actualType = Object.class;
            if (((Collection)targetObject).size() > 0) {
                Object element = ((Collection)targetObject).iterator().next();
                actualType = element.getClass();
            }
            ParameterizedType parameterizedType = new ParameterizedType(){
                private Type actualType;
                private Type rawType;
                static final long serialVersionUID = 8325546680803105102L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                public ParameterizedType setTypes(Type actualType, Type rawType) {
                    this.actualType = actualType;
                    this.rawType = rawType;
                    return this;
                }

                @Override
                public Type[] getActualTypeArguments() {
                    return new Type[]{this.actualType};
                }

                @Override
                public Type getRawType() {
                    return this.rawType;
                }

                @Override
                public Type getOwnerType() {
                    return null;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(3.class);
                }
            }.setTypes((Type)((Object)actualType), rawType);
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                parameterizedType = parameterizedType;
                LOG.exiting("org.apache.cxf.jaxrs.utils.InjectionUtils", "getAsynchronizedGenericType", parameterizedType);
            }
            return parameterizedType;
        }
        Class<?> clazz = targetObject.getClass();
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            clazz = clazz;
            LOG.exiting("org.apache.cxf.jaxrs.utils.InjectionUtils", "getAsynchronizedGenericType", clazz);
        }
        return clazz;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static Type getGenericResponseType(Method invoked, Class<?> serviceCls, Object targetObject, Class<?> targetType, Exchange exchange) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.InjectionUtils", "getGenericResponseType", new Object[]{invoked, serviceCls, targetObject, targetType, exchange});
        }
        if (targetObject == null) {
            Type type = null;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                type = type;
                LOG.exiting("org.apache.cxf.jaxrs.utils.InjectionUtils", "getGenericResponseType", type);
            }
            return type;
        }
        Type type = null;
        type = GenericEntity.class.isAssignableFrom(targetObject.getClass()) ? InjectionUtils.processGenericTypeIfNeeded(serviceCls, targetType, ((GenericEntity)targetObject).getType()) : (invoked != null && invoked.getReturnType().isAssignableFrom(targetType) ? InjectionUtils.processGenericTypeIfNeeded(serviceCls, targetType, invoked.getGenericReturnType()) : (invoked != null && InjectionUtils.isAsyncMethod(invoked) ? InjectionUtils.processGenericTypeIfNeeded(serviceCls, targetType, InjectionUtils.getAsynchronizedGenericType(targetObject)) : targetObject.getClass()));
        Class<?> clazz = type;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            clazz = clazz;
            LOG.exiting("org.apache.cxf.jaxrs.utils.InjectionUtils", "getGenericResponseType", clazz);
        }
        return clazz;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static Class<?> updateParamClassToTypeIfNeeded(Class<?> paramCls, Type type) {
        Class clsType;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.InjectionUtils", "updateParamClassToTypeIfNeeded", new Object[]{paramCls, type});
        }
        if (paramCls != type && type instanceof Class && (paramCls.isAssignableFrom(clsType = (Class)type) || clsType != Object.class && !clsType.isInterface() && clsType.isAssignableFrom(paramCls))) {
            paramCls = clsType;
        }
        Class clazz = paramCls;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            clazz = clazz;
            LOG.exiting("org.apache.cxf.jaxrs.utils.InjectionUtils", "updateParamClassToTypeIfNeeded", clazz);
        }
        return clazz;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static Type processGenericTypeIfNeeded(Class<?> serviceCls, Class<?> paramCls, Type type) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.InjectionUtils", "processGenericTypeIfNeeded", new Object[]{serviceCls, paramCls, type});
        }
        if (type instanceof TypeVariable) {
            type = InjectionUtils.getSuperType(serviceCls, (TypeVariable)type);
        } else if (type instanceof ParameterizedType && ((ParameterizedType)type).getActualTypeArguments()[0] instanceof TypeVariable && InjectionUtils.isSupportedCollectionOrArray(InjectionUtils.getRawType(type))) {
            TypeVariable typeVar = (TypeVariable)((ParameterizedType)type).getActualTypeArguments()[0];
            Type theType = InjectionUtils.getSuperType(serviceCls, typeVar);
            Class<?> cls = theType instanceof Class ? (Class<?>)theType : InjectionUtils.getActualType(theType, 0);
            type = new ParameterizedCollectionType(cls);
        }
        if (type == null || type == Object.class) {
            type = paramCls;
        }
        ParameterizedCollectionType parameterizedCollectionType = type;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            parameterizedCollectionType = parameterizedCollectionType;
            LOG.exiting("org.apache.cxf.jaxrs.utils.InjectionUtils", "processGenericTypeIfNeeded", parameterizedCollectionType);
        }
        return parameterizedCollectionType;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static Object getEntity(Object o) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.InjectionUtils", "getEntity", new Object[]{o});
        }
        Object object = o instanceof GenericEntity ? ((GenericEntity)o).getEntity() : o;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            object = object;
            LOG.exiting("org.apache.cxf.jaxrs.utils.InjectionUtils", "getEntity", object);
        }
        return object;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static List<String> getJaxRsInjectionClasses(Container moduleContainer) {
        ArrayList<String> arrayList;
        block8: {
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.entering("org.apache.cxf.jaxrs.utils.InjectionUtils", "getJaxRsInjectionClasses", new Object[]{moduleContainer});
            }
            WebAnnotations webAnnotations = null;
            try {
                webAnnotations = (WebAnnotations)moduleContainer.adapt(WebAnnotations.class);
                webAnnotations.openInfoStore();
                AnnotationTargets_Targets annotationTargets = webAnnotations.getAnnotationTargets();
                HashSet allComponentsClassNames = new HashSet();
                allComponentsClassNames.addAll(annotationTargets.getAllInheritedAnnotatedClasses(Provider.class.getName(), AnnotationTargets_Targets.POLICY_SEED));
                allComponentsClassNames.addAll(annotationTargets.getAllInheritedAnnotatedClasses(Path.class.getName(), AnnotationTargets_Targets.POLICY_SEED));
                allComponentsClassNames.addAll(annotationTargets.getAllInheritedAnnotatedClasses(ApplicationPath.class.getName(), AnnotationTargets_Targets.POLICY_SEED));
                HashSet<String> allComponentsClassNamesFinal = new HashSet<String>();
                for (String str : JAXRS_COMPONENTS_INTERFACE) {
                    allComponentsClassNames.addAll(annotationTargets.getAllImplementorsOf(str));
                }
                for (String str : JAXRS_COMPONENTS_ABSTRACTCLASS) {
                    allComponentsClassNames.addAll(annotationTargets.getSubclassNames(str));
                }
                for (String str : allComponentsClassNames) {
                    ClassInfo targetClass = webAnnotations.getClassInfo(str);
                    Set impl = annotationTargets.getAllImplementorsOf(str);
                    if (!impl.isEmpty()) {
                        if (!InjectionUtils.shouldConsiderInjection(targetClass)) continue;
                        allComponentsClassNamesFinal.addAll(impl);
                        continue;
                    }
                    if (targetClass.isInterface() || !InjectionUtils.shouldConsiderInjection(targetClass)) continue;
                    allComponentsClassNamesFinal.add(str);
                }
                webAnnotations.closeInfoStore();
                arrayList = new ArrayList<String>(allComponentsClassNamesFinal);
                if (LOG == null || !LOG.isLoggable(Level.FINER)) break block8;
            }
            catch (Exception annotationTargets) {
                FFDCFilter.processException((Throwable)annotationTargets, (String)"org.apache.cxf.jaxrs.utils.InjectionUtils", (String)"1791", null, (Object[])new Object[]{moduleContainer});
                List<String> list = Collections.emptyList();
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    list = list;
                    LOG.exiting("org.apache.cxf.jaxrs.utils.InjectionUtils", "getJaxRsInjectionClasses", list);
                }
                return list;
            }
            arrayList = arrayList;
            LOG.exiting("org.apache.cxf.jaxrs.utils.InjectionUtils", "getJaxRsInjectionClasses", arrayList);
        }
        return arrayList;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static boolean shouldConsiderInjection(ClassInfo clazz) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.InjectionUtils", "shouldConsiderInjection", new Object[]{clazz});
        }
        if (clazz.isAnnotationPresent("javax.inject.Inject") && !clazz.isAnnotationWithin(explicitLifcycle)) {
            boolean bl = true;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                bl = bl;
                LOG.exiting("org.apache.cxf.jaxrs.utils.InjectionUtils", "shouldConsiderInjection", bl);
            }
            return bl;
        }
        List fields = clazz.getDeclaredFields();
        Iterator fieldToCheck = fields.iterator();
        while (fieldToCheck.hasNext()) {
            if (!((FieldInfo)fieldToCheck.next()).isAnnotationPresent("javax.inject.Inject")) continue;
            boolean bl = true;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                bl = bl;
                LOG.exiting("org.apache.cxf.jaxrs.utils.InjectionUtils", "shouldConsiderInjection", bl);
            }
            return bl;
        }
        List methods = clazz.getDeclaredMethods();
        Iterator methodToCheck = methods.iterator();
        while (methodToCheck.hasNext()) {
            if (!((MethodInfo)methodToCheck.next()).isAnnotationPresent("javax.inject.Inject")) continue;
            boolean bl = true;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                bl = bl;
                LOG.exiting("org.apache.cxf.jaxrs.utils.InjectionUtils", "shouldConsiderInjection", bl);
            }
            return bl;
        }
        List c = clazz.getDeclaredConstructors();
        Iterator constructorToCheck = c.iterator();
        while (constructorToCheck.hasNext()) {
            if (!((MethodInfo)constructorToCheck.next()).isAnnotationPresent("javax.inject.Inject")) continue;
            boolean bl = true;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                bl = bl;
                LOG.exiting("org.apache.cxf.jaxrs.utils.InjectionUtils", "shouldConsiderInjection", bl);
            }
            return bl;
        }
        ClassInfo cls = clazz.getSuperclass();
        if (cls != null) {
            boolean bl = InjectionUtils.shouldConsiderInjection(cls);
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                bl = bl;
                LOG.exiting("org.apache.cxf.jaxrs.utils.InjectionUtils", "shouldConsiderInjection", bl);
            }
            return bl;
        }
        boolean bl = false;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.jaxrs.utils.InjectionUtils", "shouldConsiderInjection", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    static {
        explicitLifcycle.add("javax.enterprise.context.RequestScoped");
        explicitLifcycle.add("javax.enterprise.context.ApplicationScoped");
        explicitLifcycle.add("javax.enterprise.context.SessionScoped");
        explicitLifcycle.add("javax.enterprise.context.Dependent");
        JAXRS_COMPONENTS_INTERFACE = new HashSet<String>();
        JAXRS_COMPONENTS_INTERFACE.add("javax.ws.rs.ext.MessageBodyWriter");
        JAXRS_COMPONENTS_INTERFACE.add("javax.ws.rs.ext.MessageBodyReader");
        JAXRS_COMPONENTS_INTERFACE.add("javax.ws.rs.ext.ExceptionMapper");
        JAXRS_COMPONENTS_INTERFACE.add("javax.ws.rs.ext.ContextResolver");
        JAXRS_COMPONENTS_INTERFACE.add("javax.ws.rs.ext.ReaderInterceptor");
        JAXRS_COMPONENTS_INTERFACE.add("javax.ws.rs.ext.WriterInterceptor");
        JAXRS_COMPONENTS_INTERFACE.add("javax.ws.rs.ext.ParamConverterProvider");
        JAXRS_COMPONENTS_INTERFACE.add("javax.ws.rs.container.ContainerRequestFilter");
        JAXRS_COMPONENTS_INTERFACE.add("javax.ws.rs.container.ContainerResponseFilter");
        JAXRS_COMPONENTS_INTERFACE.add("javax.ws.rs.container.DynamicFeature");
        JAXRS_COMPONENTS_INTERFACE.add("org.apache.cxf.jaxrs.ext.ContextResolver");
        JAXRS_COMPONENTS_INTERFACE.add("javax.ws.rs.core.Application");
        JAXRS_COMPONENTS_ABSTRACTCLASS = new HashSet<String>();
        JAXRS_COMPONENTS_ABSTRACTCLASS.add("javax.ws.rs.core.Application");
    }
}

