/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.lifecycle;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.jaxrs20.api.JaxRsFactoryBeanCustomizer;
import com.ibm.ws.jaxrs20.injection.InjectionRuntimeContextHelper;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Map;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Response;
import org.apache.cxf.Bus;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.jaxrs.lifecycle.ResourceProvider;
import org.apache.cxf.jaxrs.model.ProviderInfo;
import org.apache.cxf.jaxrs.utils.ExceptionUtils;
import org.apache.cxf.jaxrs.utils.InjectionUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.jaxrs.utils.ResourceUtils;
import org.apache.cxf.message.Message;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class PerRequestResourceProvider
implements ResourceProvider {
    private final Constructor<?> c;
    private final Method postConstructMethod;
    private final Method preDestroyMethod;
    private final Boolean released = false;
    static final long serialVersionUID = -5447418907485785135L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public PerRequestResourceProvider(Class<?> clazz) {
        this.c = ResourceUtils.findResourceConstructor(clazz, (boolean)true);
        if (this.c == null) {
            throw new RuntimeException("Resource class " + clazz + " has no valid constructor");
        }
        this.postConstructMethod = ResourceUtils.findPostConstructMethod(clazz);
        this.preDestroyMethod = ResourceUtils.findPreDestroyMethod(clazz);
    }

    public boolean isSingleton() {
        return false;
    }

    public Object getInstance(Message m) {
        return this.createInstance(m);
    }

    protected Object createInstance(Message m) {
        ProviderInfo application = (ProviderInfo)m.getExchange().getEndpoint().get((Object)Application.class.getName());
        Map mapValues = CastUtils.cast(application == null ? null : Collections.singletonMap(Application.class, application.getProvider()));
        Object[] values = ResourceUtils.createConstructorArguments(this.c, (Message)m, (boolean)true, (Map)mapValues);
        try {
            Object instance = values.length > 0 ? this.c.newInstance(values) : this.c.newInstance(new Object[0]);
            return instance;
        }
        catch (InstantiationException instance) {
            FFDCFilter.processException((Throwable)instance, (String)"org.apache.cxf.jaxrs.lifecycle.PerRequestResourceProvider", (String)"95", (Object)this, (Object[])new Object[]{m});
            String msg = "Resource class " + this.c.getDeclaringClass().getName() + " can not be instantiated";
            throw ExceptionUtils.toInternalServerErrorException(null, (Response)this.serverError(msg));
        }
        catch (IllegalAccessException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"org.apache.cxf.jaxrs.lifecycle.PerRequestResourceProvider", (String)"98", (Object)this, (Object[])new Object[]{m});
            String msg = "Resource class " + this.c.getDeclaringClass().getName() + " can not be instantiated" + " due to IllegalAccessException";
            throw ExceptionUtils.toInternalServerErrorException(null, (Response)this.serverError(msg));
        }
        catch (InvocationTargetException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"org.apache.cxf.jaxrs.lifecycle.PerRequestResourceProvider", (String)"102", (Object)this, (Object[])new Object[]{m});
            Response r = JAXRSUtils.convertFaultToResponse((Throwable)ex.getCause(), (Message)m);
            if (r != null) {
                m.getExchange().put(Response.class, (Object)r);
                throw new WebApplicationException();
            }
            String msg = "Resource class " + this.c.getDeclaringClass().getName() + " can not be instantiated" + " due to InvocationTargetException";
            throw ExceptionUtils.toInternalServerErrorException(null, (Response)this.serverError(msg));
        }
    }

    private Response serverError(String msg) {
        return JAXRSUtils.toResponseBuilder((int)500).entity((Object)msg).build();
    }

    public void releaseInstance(Message m, Object o) {
        JaxRsFactoryBeanCustomizer beanCustomizer = null;
        if (o != null) {
            Bus bus = m.getExchange().getBus();
            beanCustomizer = InjectionRuntimeContextHelper.findBeanCustomizer(o.getClass(), bus);
        }
        if (beanCustomizer == null) {
            InjectionUtils.invokeLifeCycleMethod(o, this.preDestroyMethod);
        }
    }

    public Class<?> getResourceClass() {
        return this.c.getDeclaringClass();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(PerRequestResourceProvider.class);
    }
}

