/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jaxrs20.component.injection;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.jaxrs20.injection.ApplicationInjectionProxy;
import com.ibm.ws.jaxrs20.injection.InjectionRuntimeContextHelper;
import com.ibm.ws.jaxrs20.injection.metadata.InjectionRuntimeContext;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import javax.ws.rs.core.Application;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(name="com.ibm.ws.jaxrs20.component.injection.ContextObjectFactory", service={ObjectFactory.class}, property={"service.vendor=IBM"})
public class ContextObjectFactory
implements ObjectFactory {
    private static final TraceComponent tc = Tr.register(ContextObjectFactory.class, (String)"JaxRsCommon", (String)"com.ibm.ws.jaxrs20.internal.resources.JaxRsCommonMessages");
    private Dictionary<String, Object> props = null;
    static final long serialVersionUID = -4601298228492010861L;

    @Override
    @ManualTrace
    public Object getObjectInstance(Object o, Name n, Context c, Hashtable<?, ?> envmt) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getObjectInstance: o=" + o + ",name=" + n + ",context=" + c + ",evnmt=" + envmt), (Object[])new Object[0]);
        }
        if (!(o instanceof Reference)) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("Object " + o + " is not an instance of javax.naming.Reference. Returning null."));
            }
            return null;
        }
        Reference ref = (Reference)o;
        final Class<?> contextClass = Class.forName(ref.getClassName());
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Creating a proxy for type {0}", (Object[])new Object[]{contextClass});
        }
        Object proxy = null;
        if (Application.class.equals(contextClass)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"This is an Application sub-class being injected. Injecting an instance of ApplicationInjectionProxy.", (Object[])new Object[0]);
            }
            proxy = new ApplicationInjectionProxy();
        } else {
            proxy = Proxy.newProxyInstance(ContextObjectFactory.class.getClassLoader(), new Class[]{contextClass}, new InvocationHandler(){
                static final long serialVersionUID = 3409154101640034648L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                @ManualTrace
                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    if (tc.isEntryEnabled()) {
                        Tr.entry((TraceComponent)tc, (String)"invoke", (Object[])new Object[0]);
                    }
                    Object result = null;
                    InjectionRuntimeContext runtimeContext = InjectionRuntimeContextHelper.getRuntimeContext();
                    if ("toString".equals(method.getName()) && method.getParameterTypes().length == 0) {
                        result = "Proxy for " + contextClass.getName();
                        if (tc.isEntryEnabled()) {
                            Tr.exit((TraceComponent)tc, (String)"invoke", (Object)result);
                        }
                        return result;
                    }
                    Object context = runtimeContext.getRuntimeCtxObject(contextClass.getName());
                    if (context != null) {
                        result = method.invoke(context, args);
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"invoke", (Object)result);
                    }
                    return result;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(1.class);
                }
            });
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getObjectInstance", (Object)proxy);
        }
        return proxy;
    }

    @Activate
    protected void activate(ComponentContext cc) {
        this.props = cc.getProperties();
    }

    @Modified
    protected void modified(Map<?, ?> newProperties) {
        this.props = newProperties instanceof Dictionary ? (Dictionary<Object, Object>)((Object)newProperties) : new Hashtable(newProperties);
    }
}

